/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceStructureBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.StatusText;
import icons.JavaScriptLanguageIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0015\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\rH\u0014J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0012\u0010 \u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\u0014\u0010#\u001a\u0004\u0018\u00010\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010$\u001a\u00020\u0014H\u0014J\b\u0010%\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager;", "Lcom/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mySettings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "myStructurePanel", "Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructureBuilder$StructurePanel;", "createConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "trimMessageToPrint", "", "s", "getConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "showStructure", "", "getErrorPanelRightActions", "all", "", "(Z)[Lcom/intellij/openapi/actionSystem/AnAction;", "setState", "state", "getProjectErrorsTitle", "updateCurrentErrorsEmptyText", "panel", "Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;", "needActivateProgressPanel", "initDefaultPanels", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getOrCreateStructurePanel", "createCurrentTreeViewPanel", "resetToolWindow", "intellij.javascript.impl"})
public final class TypeScriptLanguageServiceToolWindowManager
extends JSLanguageServiceToolWindowManager {
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @Nullable
    private volatile TypeScriptServiceStructureBuilder.StructurePanel myStructurePanel;

    public TypeScriptLanguageServiceToolWindowManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, (NotNullLazyValue<AnAction[]>)NotNullLazyValue.createValue(TypeScriptLanguageServiceToolWindowManager::_init_$lambda$0));
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        this.mySettings = TypeScriptCompilerSettings.Companion.getSettings(project2);
    }

    @Override
    @NotNull
    protected ConsoleViewImpl createConsole() {
        Project project = this.myProject;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
        return new ConsoleViewImpl(this, project, globalSearchScope){
            final /* synthetic */ TypeScriptLanguageServiceToolWindowManager this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                Intrinsics.checkNotNull((Object)$super_call_param$2);
                super($super_call_param$1, $super_call_param$2, true, false);
            }

            public void print(String text, ConsoleViewContentType contentType) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
                if (!TypeScriptLanguageServiceToolWindowManager.access$getMyProject$p$s834398477(this.this$0).isOpen() || TypeScriptLanguageServiceToolWindowManager.access$getMyProject$p$s834398477(this.this$0).isDisposed()) {
                    return;
                }
                String string = this.this$0.trimMessageToPrint(text);
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
                super.print(string, consoleViewContentType);
            }
        };
    }

    @NotNull
    public final String trimMessageToPrint(@NotNull String s) {
        int defaultLength;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object s2 = s;
        int n = defaultLength = JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled() ? 2000 : 150;
        if (((String)s2).length() > defaultLength) {
            s2 = StringsKt.take((String)s2, (int)defaultLength) + "...(truncated)\n";
        }
        return s2;
    }

    @Override
    @Nullable
    protected AnAction[] getConsoleActions() {
        AnAction[] anActionArray;
        Object[] actions = super.getConsoleActions();
        AnAction[] anActionArray2 = JavaScriptBundle.message("action.show.structure.text", new Object[0]);
        Icon icon = AllIcons.Actions.PreviewDetails;
        AnAction showStructure2 = new AnAction(this, (String)anActionArray2, icon){
            final /* synthetic */ TypeScriptLanguageServiceToolWindowManager this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.showStructure();
            }
        };
        if (actions == null) {
            anActionArray2 = new AnAction[]{showStructure2};
            anActionArray = anActionArray2;
        } else {
            anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)showStructure2);
        }
        return anActionArray;
    }

    public final void showStructure() {
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.getOrCreateStructurePanel(window);
        if (panel == null) {
            return;
        }
        ContentManager contentManager = window.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager manager = contentManager;
        for (Content content : manager.getContents()) {
            String name = panel.getName();
            if (!Intrinsics.areEqual((Object)name, (Object)content.getDisplayName())) continue;
            manager.setSelectedContent(content);
            panel.refresh();
            return;
        }
    }

    @Override
    @Nullable
    protected AnAction[] getErrorPanelRightActions(boolean all) {
        if (all) {
            return super.getErrorPanelRightActions(true);
        }
        String string = JavaScriptBundle.message("javascript.language.service.default.project.errors", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String showErrorsText = string;
        AnAction[] anActionArray = AllIcons.General.ProjectTab;
        ToggleAction showErrors2 = new ToggleAction(showErrorsText, this, (Icon)anActionArray){
            final /* synthetic */ TypeScriptLanguageServiceToolWindowManager this$0;
            {
                this.this$0 = $receiver;
                super($showErrorsText, $showErrorsText, $super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return TypeScriptLanguageServiceToolWindowManager.access$getMySettings$p(this.this$0).getShowAllProjectErrors();
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setState(state);
            }
        };
        anActionArray = new AnAction[]{showErrors2};
        return anActionArray;
    }

    public final void setState(boolean state) {
        this.mySettings.setShowAllProjectErrors(state);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        NewErrorTreeViewPanel panel = this.getCurrentErrorTreeViewPanel();
        if (panel != null) {
            this.updateCurrentErrorsEmptyText(panel);
        }
    }

    @Override
    @NotNull
    protected String getProjectErrorsTitle() {
        String string = JavaScriptBundle.message("tab.title.compile.errors", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        ThreadingAssertions.assertEventDispatchThread();
        StatusText text = panel.getEmptyText();
        if (!this.mySettings.getUseService()) {
            text.clear();
            text.setText(JavaScriptBundle.message("javascript.language.service.tracking.disabled", new Object[0]));
            return;
        }
        if (!this.mySettings.getShowAllProjectErrors() && this.hasActiveConsoles()) {
            text.clear();
            text.setText(JavaScriptBundle.message("status.text.no.errors.in.current.file", new Object[0]));
            text.appendText(JavaScriptBundle.message("status.text.javascript.language.service.default.project.errors", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
                final /* synthetic */ TypeScriptLanguageServiceToolWindowManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    ThreadingAssertions.assertEventDispatchThread();
                    this.this$0.setState(true);
                }
            });
            return;
        }
        super.updateCurrentErrorsEmptyText(panel);
    }

    @Override
    public boolean needActivateProgressPanel() {
        return true;
    }

    @Override
    protected void initDefaultPanels(@Nullable ToolWindow toolWindow) {
        super.initDefaultPanels(toolWindow);
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            this.getOrCreateStructurePanel(toolWindow);
        }
    }

    private final TypeScriptServiceStructureBuilder.StructurePanel getOrCreateStructurePanel(ToolWindow toolWindow) {
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.myStructurePanel;
        if (panel != null) {
            return panel;
        }
        if (toolWindow != null) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            String string = this.myHelpId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myHelpId");
            this.myStructurePanel = panel = TypeScriptServiceStructureBuilder.registerStructureContent(project, toolWindow, string);
        }
        return panel;
    }

    @Override
    protected void createCurrentTreeViewPanel() {
        if (TypeScriptCompilerSettings.Companion.getTypeScriptToolWindowEnabled()) {
            super.createCurrentTreeViewPanel();
        }
    }

    @Override
    public synchronized void resetToolWindow() {
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.myStructurePanel;
        if (panel != null) {
            Disposer.dispose((Disposable)panel);
            this.myStructurePanel = null;
        }
        super.resetToolWindow();
    }

    private static final AnAction[] _init_$lambda$0() {
        return AnAction.EMPTY_ARRAY;
    }

    public static final /* synthetic */ Project access$getMyProject$p$s834398477(TypeScriptLanguageServiceToolWindowManager $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ TypeScriptCompilerSettings access$getMySettings$p(TypeScriptLanguageServiceToolWindowManager $this) {
        return $this.mySettings;
    }
}

