/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtilKt;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.VirtualFileAndTypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoFetcherKt;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoFetcher;", "", "<init>", "()V", "requestElement", "Lcom/intellij/psi/PsiElement;", "future", "Ljava/util/concurrent/Future;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptQuickInfoResponse;", "getServiceResult", "", "element", "getParsedServiceInfo", "Lcom/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser$ParsedInfo;", "getServiceDocumentation", "requestServiceQuickInfo", "_element", "normalizeElement", "intellij.javascript.impl"})
public final class TypeScriptServiceQuickInfoFetcher {
    @Nullable
    private PsiElement requestElement;
    @Nullable
    private Future<TypeScriptQuickInfoResponse> future;

    @Nullable
    public final String getServiceResult(@NotNull PsiElement element2) {
        TypeScriptQuickInfoResponse response2;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse = response2 = this.requestServiceQuickInfo(element2);
        return typeScriptQuickInfoResponse != null ? typeScriptQuickInfoResponse.displayString : null;
    }

    @Nullable
    public final TypeScriptServiceQuickInfoParser.ParsedInfo getParsedServiceInfo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String string = this.getServiceResult(element2);
        if (string == null) {
            return null;
        }
        String serviceResult = string;
        return TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(serviceResult);
    }

    @Nullable
    public final String getServiceDocumentation(@NotNull PsiElement element2) {
        TypeScriptQuickInfoResponse response2;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse = response2 = this.requestServiceQuickInfo(element2);
        return typeScriptQuickInfoResponse != null ? typeScriptQuickInfoResponse.documentation : null;
    }

    private final TypeScriptQuickInfoResponse requestServiceQuickInfo(PsiElement _element) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        PsiElement element2 = this.normalizeElement(_element);
        if (this.future != null) {
            if (!Intrinsics.areEqual((Object)element2, (Object)this.requestElement)) {
                this.requestElement = null;
                this.future = null;
                return this.requestServiceQuickInfo(_element);
            }
            return JSLanguageServiceUtil.awaitFuture(this.future, TypeScriptServiceQuickInfoFetcherKt.getQuickInfoTimeout());
        }
        VirtualFileAndTypeScriptService fileAndService = TypeScriptServiceHolder.getForElement$default(element2, null, 2, null);
        if (fileAndService == null) {
            return null;
        }
        Future<TypeScriptQuickInfoResponse> responseFuture = fileAndService.getService().getQuickInfoAt(element2, fileAndService.getFile());
        if (responseFuture == null) {
            return null;
        }
        this.requestElement = element2;
        this.future = responseFuture;
        return JSLanguageServiceUtil.awaitFuture(responseFuture, TypeScriptServiceQuickInfoFetcherKt.getQuickInfoTimeout());
    }

    private final PsiElement normalizeElement(PsiElement element2) {
        return JSLanguageServiceUtilKt.adjustIntoIdentifier(element2);
    }
}

