/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.JSImportSimpleResolveContextImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptCompositeImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptImportsResolverProvider {
    public static final ExtensionPointName<TypeScriptImportsResolverProvider> EP = ExtensionPointName.create((String)"JavaScript.tsImportResolver");
    public static final ClearableLazyValue<String @NotNull []> FILE_EXTENSIONS = ExtensionPointUtil.dropLazyValueOnChange((ClearableLazyValue)ClearableLazyValue.createAtomic(() -> {
        ArrayList<String> resultWithDot = new ArrayList<String>();
        TypeScriptImportsResolverProvider.addFileExtensions(resultWithDot, TypeScriptUtil.TYPESCRIPT_AND_JS_EXTENSIONS, false);
        for (TypeScriptImportsResolverProvider el : EP.getExtensionList()) {
            TypeScriptImportsResolverProvider.addFileExtensions(resultWithDot, el.getExtensions(), false);
        }
        return ArrayUtil.toStringArray(resultWithDot);
    }), EP, null);

    @NotNull
    public static @NotNull String @NotNull [] getAllFileExtensionsWithDot() {
        String[] stringArray = (String[])FILE_EXTENSIONS.getValue();
        if (stringArray == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static void addFileExtensions(@NotNull Collection<String> result2, String @NotNull [] extensions, boolean trim) {
        if (result2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(1);
        }
        if (extensions == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(2);
        }
        for (String extension : extensions) {
            result2.add(trim ? StringUtil.trimStart((String)extension, (String)".") : extension);
        }
    }

    @Nullable
    default public TypeScriptFileImportsResolver contributeResolver(@NotNull Project project, @NotNull TypeScriptConfig config) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(3);
        }
        if (config == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    default public TypeScriptFileImportsResolver contributeResolver(@NotNull Project project, @NotNull TypeScriptImportResolveContext context2, @NotNull VirtualFile contextFile) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(6);
        }
        if (contextFile == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(7);
        }
        return null;
    }

    public String @NotNull [] getExtensions();

    @Deprecated
    default public boolean useExplicitExtension(@NotNull String ignored) {
        if (ignored == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(8);
        }
        return false;
    }

    @NotNull
    public static TypeScriptFileImportsResolver getResolver(@NotNull Project project, @NotNull TypeScriptConfig config) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(9);
        }
        if (config == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(10);
        }
        ArrayList<TypeScriptFileImportsResolver> contributedResolvers = new ArrayList<TypeScriptFileImportsResolver>();
        for (TypeScriptImportsResolverProvider provider : EP.getExtensionList()) {
            ContainerUtil.addIfNotNull(contributedResolvers, (Object)provider.contributeResolver(project, config));
        }
        contributedResolvers.add(TypeScriptImportsResolverProvider.getDefaultProvider(project, config));
        return TypeScriptImportsResolverProvider.flattenAndAppendResolvers(contributedResolvers);
    }

    @NotNull
    public static TypeScriptFileImportsResolver getResolver(@NotNull Project project, @NotNull JSImportResolveContext context2, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(13);
        }
        ArrayList<TypeScriptFileImportsResolver> contributedResolvers = new ArrayList<TypeScriptFileImportsResolver>();
        for (TypeScriptImportsResolverProvider provider : EP.getExtensionList()) {
            if (!(context2 instanceof TypeScriptImportResolveContext)) continue;
            ContainerUtil.addIfNotNull(contributedResolvers, (Object)provider.contributeResolver(project, (TypeScriptImportResolveContext)context2, file));
        }
        contributedResolvers.add(TypeScriptImportsResolverProvider.getDefaultProvider(project, context2));
        return TypeScriptImportsResolverProvider.flattenAndAppendResolvers(contributedResolvers);
    }

    default public boolean isImplicitTypeScriptFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(15);
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static TypeScriptFileImportsResolver getDefaultProvider(@NotNull Project project, @NotNull TypeScriptImportResolveContext context2, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(17);
        }
        if (file == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(18);
        }
        return new TypeScriptFileImportsResolverImpl(project, context2, TypeScriptUtil.TYPESCRIPT_EXTENSIONS, TypeScriptUtil.TYPESCRIPT_FILE_TYPES);
    }

    @NotNull
    public static TypeScriptFileImportsResolver getDefaultProvider(@NotNull Project project, @NotNull JSImportResolveContext context2) {
        boolean allowJs;
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(20);
        }
        if (context2 instanceof TypeScriptImportResolveContext) {
            TypeScriptImportResolveContext tsContext = (TypeScriptImportResolveContext)context2;
            v0 = tsContext.allowJs();
        } else {
            v0 = allowJs = context2 instanceof JSImportSimpleResolveContextImpl;
        }
        if (!allowJs) {
            return new TypeScriptFileImportsResolverImpl(project, context2, TypeScriptUtil.TYPESCRIPT_EXTENSIONS, TypeScriptUtil.TYPESCRIPT_FILE_TYPES);
        }
        List<TypeScriptFileImportsResolverImpl> resolvers = List.of(new TypeScriptFileImportsResolverImpl(project, context2, TypeScriptUtil.TYPESCRIPT_EXTENSIONS, TypeScriptUtil.TYPESCRIPT_FILE_TYPES), new TypeScriptFileImportsResolverImpl(project, context2, TypeScriptUtil.JAVASCRIPT_EXTENSIONS, DialectDetector.JAVASCRIPT_FILE_TYPES));
        return new TypeScriptCompositeImportsResolverImpl(resolvers);
    }

    @NotNull
    public static TypeScriptFileImportsResolver getDefaultProvider(@NotNull Project project, @NotNull TypeScriptConfig config) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(21);
        }
        if (config == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(22);
        }
        return TypeScriptImportsResolverProvider.getDefaultProvider(project, config.getResolveContext());
    }

    @NotNull
    public static TypeScriptFileImportsResolver flattenAndAppendResolvers(@NotNull List<? extends TypeScriptFileImportsResolver> resolvers) {
        if (resolvers == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(23);
        }
        if (resolvers.size() == 1) {
            TypeScriptFileImportsResolver typeScriptFileImportsResolver = resolvers.get(0);
            if (typeScriptFileImportsResolver == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(24);
            }
            return typeScriptFileImportsResolver;
        }
        ArrayList<TypeScriptFileImportsResolver> flatResolvers = new ArrayList<TypeScriptFileImportsResolver>();
        for (TypeScriptFileImportsResolver typeScriptFileImportsResolver : resolvers) {
            if (typeScriptFileImportsResolver instanceof TypeScriptCompositeImportsResolverImpl) {
                flatResolvers.addAll(((TypeScriptCompositeImportsResolverImpl)typeScriptFileImportsResolver).getResolvers());
                continue;
            }
            flatResolvers.add(typeScriptFileImportsResolver);
        }
        ContainerUtil.sort(flatResolvers, TypeScriptFileImportsResolver.RESOLVERS_ORDER);
        return new TypeScriptCompositeImportsResolverImpl(flatResolvers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptImportsResolverProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: 
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileExtensionsWithDot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptImportsResolverProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndAppendResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFileExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contributeResolver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "useExplicitExtension";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResolver";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitTypeScriptFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProvider";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndAppendResolvers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> new IllegalArgumentException(string);
        };
    }
}

