/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.Context$;
import com.intellij.kubernetes.api.KubeConfigEntity;
import com.intellij.kubernetes.api.KubeConfigUtilsKt;
import com.intellij.kubernetes.api.KubernetesApiProviderKt;
import com.intellij.kubernetes.api.KubernetesContextsConfigurationModelKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ?2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002>?BR\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000f\b\u0002\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\r\b\u0002\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\n\u0010\u000bBE\b\u0016\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012 \b\u0002\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\r\u00a2\u0006\u0004\b\n\u0010\u0011BM\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\n\u0010\u0016J\u0011\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010,\u001a\u00020-2\b\u0010+\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010.\u001a\u00020\u0013H\u0016J\u000e\u0010/\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u00100\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u0010\u00101\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u00102\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u00103\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003JX\u00104\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00062\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\t\u00105\u001a\u00020\u0003H\u00d6\u0001J%\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0001\u00a2\u0006\u0002\b=R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001d\u0010\u0007\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0018\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001f\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001eRV\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\r2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\r8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00048F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006@"}, d2={"Lcom/intellij/kubernetes/api/Context;", "", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "kubeConfigUrl", "Lorg/jetbrains/annotations/NonNls;", "originalNamespace", "clusterPath", "currentNamespace", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "definitions", "Ljava/util/EnumMap;", "Lcom/intellij/kubernetes/api/KubeConfigEntity;", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/EnumMap;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getName", "()Ljava/lang/String;", "getKubeConfigUrl", "getOriginalNamespace", "getClusterPath", "getCurrentNamespace", "setCurrentNamespace", "(Ljava/lang/String;)V", "value", "getDefinitions$annotations", "()V", "getDefinitions", "()Ljava/util/EnumMap;", "originalNamespaceOrDefault", "getOriginalNamespaceOrDefault", "kubeConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getKubeConfigFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "compareTo", "other", "equals", "", "hashCode", "component1", "component2", "component3", "component4", "component5", "copy", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_clouds_kubernetes", "$serializer", "Companion", "intellij.clouds.kubernetes"})
public final class Context
implements Comparable<Context> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String kubeConfigUrl;
    @VisibleForTesting
    @Nullable
    private final String originalNamespace;
    @Nullable
    private final String clusterPath;
    @NotNull
    private volatile String currentNamespace;
    @NotNull
    private EnumMap<KubeConfigEntity, Map<Object, Object>> definitions;

    public Context(@NotNull String name, @NotNull String kubeConfigUrl, @Nullable String originalNamespace, @Nullable String clusterPath, @NotNull String currentNamespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kubeConfigUrl, (String)"kubeConfigUrl");
        Intrinsics.checkNotNullParameter((Object)currentNamespace, (String)"currentNamespace");
        this.name = name;
        this.kubeConfigUrl = kubeConfigUrl;
        this.originalNamespace = originalNamespace;
        this.clusterPath = clusterPath;
        this.currentNamespace = currentNamespace;
        if (StringsKt.isBlank((CharSequence)this.kubeConfigUrl)) {
            throw new IllegalArgumentException("Illegal kubeconfig url in: " + this);
        }
        this.definitions = new EnumMap(KubeConfigEntity.class);
    }

    public /* synthetic */ Context(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            String string6 = string3;
            if (string6 == null) {
                string6 = "default";
            }
            string5 = string6;
        }
        this(string, string2, string3, string4, string5);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getKubeConfigUrl() {
        return this.kubeConfigUrl;
    }

    @Nullable
    public final String getOriginalNamespace() {
        return this.originalNamespace;
    }

    @Nullable
    public final String getClusterPath() {
        return this.clusterPath;
    }

    @NotNull
    public final String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public final void setCurrentNamespace(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.currentNamespace = string;
    }

    public Context(@NotNull String name, @NotNull String kubeConfigUrl, @NotNull EnumMap<KubeConfigEntity, Map<Object, Object>> definitions) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kubeConfigUrl, (String)"kubeConfigUrl");
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        Map<Object, Object> map2 = definitions.get((Object)KubeConfigEntity.Contexts);
        Intrinsics.checkNotNull(map2);
        this(name, kubeConfigUrl, KubeConfigUtilsKt.getAsNonBlankStringSafely(map2, "namespace"), (object = definitions.get((Object)KubeConfigEntity.Clusters)) != null && (object = KubeConfigUtilsKt.getAsNonBlankStringSafely(object, "server")) != null ? KubernetesApiProviderKt.toPath((String)object) : null, null, 16, null);
        this.definitions = definitions;
    }

    public /* synthetic */ Context(String string, String string2, EnumMap enumMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            enumMap = new EnumMap<KubeConfigEntity, Map<Object, Object>>(KubeConfigEntity.class);
        }
        this(string, string2, enumMap);
    }

    @NotNull
    public final EnumMap<KubeConfigEntity, Map<Object, Object>> getDefinitions() {
        return this.definitions;
    }

    @Transient
    public static /* synthetic */ void getDefinitions$annotations() {
    }

    @NotNull
    public final String getOriginalNamespaceOrDefault() {
        String string = this.originalNamespace;
        if (string == null) {
            string = "default";
        }
        return string;
    }

    @Nullable
    public final VirtualFile getKubeConfigFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.kubeConfigUrl);
    }

    @Override
    public int compareTo(@NotNull Context other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return KubernetesContextsConfigurationModelKt.access$getContextComparator$p().compare(this, other);
    }

    public boolean equals(@Nullable Object other) {
        Context context = other instanceof Context ? (Context)other : null;
        return context != null ? context.compareTo(this) == 0 : false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.name, this.kubeConfigUrl};
        return Objects.hash(objectArray);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.kubeConfigUrl;
    }

    @Nullable
    public final String component3() {
        return this.originalNamespace;
    }

    @Nullable
    public final String component4() {
        return this.clusterPath;
    }

    @NotNull
    public final String component5() {
        return this.currentNamespace;
    }

    @NotNull
    public final Context copy(@NotNull String name, @NotNull String kubeConfigUrl, @Nullable String originalNamespace, @Nullable String clusterPath, @NotNull String currentNamespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kubeConfigUrl, (String)"kubeConfigUrl");
        Intrinsics.checkNotNullParameter((Object)currentNamespace, (String)"currentNamespace");
        return new Context(name, kubeConfigUrl, originalNamespace, clusterPath, currentNamespace);
    }

    public static /* synthetic */ Context copy$default(Context context, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = context.name;
        }
        if ((n & 2) != 0) {
            string2 = context.kubeConfigUrl;
        }
        if ((n & 4) != 0) {
            string3 = context.originalNamespace;
        }
        if ((n & 8) != 0) {
            string4 = context.clusterPath;
        }
        if ((n & 0x10) != 0) {
            string5 = context.currentNamespace;
        }
        return context.copy(string, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "Context(name=" + this.name + ", kubeConfigUrl=" + this.kubeConfigUrl + ", originalNamespace=" + this.originalNamespace + ", clusterPath=" + this.clusterPath + ", currentNamespace=" + this.currentNamespace + ")";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_clouds_kubernetes(Context self, CompositeEncoder output, SerialDescriptor serialDesc) {
        boolean bl;
        output.encodeStringElement(serialDesc, 0, self.name);
        output.encodeStringElement(serialDesc, 1, self.kubeConfigUrl);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.originalNamespace != null) {
            output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.originalNamespace);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.clusterPath != null) {
            output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.clusterPath);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4)) {
            bl = true;
        } else {
            String string = self.currentNamespace;
            String string2 = self.originalNamespace;
            if (string2 == null) {
                string2 = "default";
            }
            bl = !Intrinsics.areEqual((Object)string, (Object)string2);
        }
        if (bl) {
            output.encodeStringElement(serialDesc, 4, self.currentNamespace);
        }
    }

    public /* synthetic */ Context(int seen0, String name, String kubeConfigUrl, String originalNamespace, String clusterPath, String currentNamespace, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.name = name;
        this.kubeConfigUrl = kubeConfigUrl;
        this.originalNamespace = (seen0 & 4) == 0 ? null : originalNamespace;
        this.clusterPath = (seen0 & 8) == 0 ? null : clusterPath;
        if ((seen0 & 0x10) == 0) {
            String string = this.originalNamespace;
            if (string == null) {
                string = "default";
            }
            this.currentNamespace = string;
        } else {
            this.currentNamespace = currentNamespace;
        }
        if (StringsKt.isBlank((CharSequence)this.kubeConfigUrl)) {
            throw new IllegalArgumentException("Illegal kubeconfig url in: " + this);
        }
        this.definitions = new EnumMap(KubeConfigEntity.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/api/Context$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/kubernetes/api/Context;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Context> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

