/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.pattern.matching;

import com.intellij.kubernetes.logs.pattern.matching.InternalLogClusterKt;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import com.intellij.kubernetes.logs.pattern.matching.Tokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0013\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kubernetes/logs/pattern/matching/InternalLogCluster;", "Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;", "logTemplateTokens", "", "", "tokenizer", "Lcom/intellij/kubernetes/logs/pattern/matching/Tokenizer;", "<init>", "(Ljava/util/List;Lcom/intellij/kubernetes/logs/pattern/matching/Tokenizer;)V", "sightings", "", "fitsCluster", "", "text", "internalTokens", "tokens", "", "updateTokens", "", "newTemplateTokens", "newSighting", "contentTokens", "generateNewTemplate", "templateTokens", "toString", "toStringWithCounts", "equals", "other", "", "hashCode", "toHTML", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nInternalLogCluster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalLogCluster.kt\ncom/intellij/kubernetes/logs/pattern/matching/InternalLogCluster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1740#2,3:144\n1573#2:147\n1604#2,4:148\n*S KotlinDebug\n*F\n+ 1 InternalLogCluster.kt\ncom/intellij/kubernetes/logs/pattern/matching/InternalLogCluster\n*L\n75#1:144,3\n103#1:147\n103#1:148,4\n*E\n"})
public final class InternalLogCluster
implements LogCluster {
    private int sightings;
    @NotNull
    private List<String> logTemplateTokens;
    @NotNull
    private final Tokenizer tokenizer;

    public InternalLogCluster(@NotNull List<String> logTemplateTokens, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter(logTemplateTokens, (String)"logTemplateTokens");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.logTemplateTokens = logTemplateTokens;
        this.sightings = 1;
        this.tokenizer = tokenizer;
    }

    @Override
    public boolean fitsCluster(@NotNull String text) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            List<String> tokens = this.tokenizer.tokenize(text);
            if (tokens.size() != this.logTemplateTokens.size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)tokens, (Iterable)this.logTemplateTokens);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    String token = (String)pair.component1();
                    String templateToken = (String)pair.component2();
                    String string = templateToken.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    String string2 = token.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string, (Object)string2) || Intrinsics.areEqual((Object)templateToken, (Object)"<*>")) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final List<String> internalTokens() {
        return this.logTemplateTokens;
    }

    @Override
    @NotNull
    public List<String> tokens() {
        return CollectionsKt.toList((Iterable)this.logTemplateTokens);
    }

    public final void updateTokens(@NotNull List<String> newTemplateTokens) {
        Intrinsics.checkNotNullParameter(newTemplateTokens, (String)"newTemplateTokens");
        this.logTemplateTokens = newTemplateTokens;
    }

    public final void newSighting(@NotNull List<String> contentTokens) {
        Intrinsics.checkNotNullParameter(contentTokens, (String)"contentTokens");
        List<String> newTemplateTokens = this.generateNewTemplate(contentTokens, this.logTemplateTokens);
        if (!Intrinsics.areEqual(newTemplateTokens, this.logTemplateTokens)) {
            this.updateTokens(newTemplateTokens);
        }
        int n = this.sightings;
        this.sightings = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateNewTemplate(List<String> contentTokens, List<String> templateTokens) {
        void $this$mapIndexedTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = contentTokens.size() == templateTokens.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$mapIndexed$iv = contentTokens;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void contentToken;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(Intrinsics.areEqual((Object)contentToken, (Object)templateTokens.get((int)index)) ? contentToken : "<*>");
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @Override
    public int sightings() {
        return this.sightings;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.logTemplateTokens, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public String toStringWithCounts() {
        return "(size " + this.sightings + "): " + CollectionsKt.joinToString$default((Iterable)this.logTemplateTokens, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        InternalLogCluster that = (InternalLogCluster)other;
        return this.sightings == that.sightings && Intrinsics.areEqual(this.logTemplateTokens, that.logTemplateTokens);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.sightings, this.logTemplateTokens};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String toHTML() {
        return CollectionsKt.joinToString$default((Iterable)this.logTemplateTokens, (CharSequence)" ", null, null, (int)0, null, InternalLogCluster::toHTML$lambda$2, (int)30, null);
    }

    private static final CharSequence toHTML$lambda$2(String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return Intrinsics.areEqual((Object)token, (Object)"<*>") ? (CharSequence)("<font color=\"gray\">" + InternalLogClusterKt.access$escapeHTML(token) + "</font>") : (CharSequence)InternalLogClusterKt.access$escapeHTML(token);
    }
}

