/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.Period;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u001b\u0010\u001a\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0014\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0014\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0014\u001a\u0004\b'\u0010$R\u001b\u0010)\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0014\u001a\u0004\b+\u0010,R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b3\u00101\u00a8\u00064"}, d2={"Lcom/intellij/kubernetes/view/ui/MomentJSLikeDuration;", "", "start", "Ljava/time/OffsetDateTime;", "end", "originalDuration", "Ljava/time/Duration;", "<init>", "(Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/Duration;)V", "(Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;)V", "negative", "", "getNegative", "()Z", "duration", "seconds", "", "getSeconds", "()J", "seconds$delegate", "Lkotlin/Lazy;", "fullMinutes", "getFullMinutes", "fullMinutes$delegate", "minutes", "getMinutes", "fullHours", "getFullHours", "fullHours$delegate", "hours", "getHours", "days", "getDays", "absoluteStart", "Ljava/time/LocalDate;", "getAbsoluteStart", "()Ljava/time/LocalDate;", "absoluteStart$delegate", "absoluteEnd", "getAbsoluteEnd", "absoluteEnd$delegate", "period", "Ljava/time/Period;", "getPeriod", "()Ljava/time/Period;", "period$delegate", "months", "", "getMonths", "()I", "years", "getYears", "intellij.clouds.kubernetes"})
final class MomentJSLikeDuration {
    @NotNull
    private final OffsetDateTime start;
    @NotNull
    private final OffsetDateTime end;
    private final boolean negative;
    @NotNull
    private final Duration duration;
    @NotNull
    private final Lazy seconds$delegate;
    @NotNull
    private final Lazy fullMinutes$delegate;
    @NotNull
    private final Lazy fullHours$delegate;
    @NotNull
    private final Lazy absoluteStart$delegate;
    @NotNull
    private final Lazy absoluteEnd$delegate;
    @NotNull
    private final Lazy period$delegate;

    private MomentJSLikeDuration(OffsetDateTime start, OffsetDateTime end, Duration originalDuration) {
        Duration duration;
        this.start = start;
        this.end = end;
        this.negative = originalDuration.isNegative();
        if (this.negative) {
            Duration duration2 = originalDuration.negated();
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"negated(...)");
        } else {
            duration = originalDuration;
        }
        this.duration = duration;
        this.seconds$delegate = LazyKt.lazy(() -> MomentJSLikeDuration.seconds_delegate$lambda$0(this));
        this.fullMinutes$delegate = LazyKt.lazy(() -> MomentJSLikeDuration.fullMinutes_delegate$lambda$1(this));
        this.fullHours$delegate = LazyKt.lazy(() -> MomentJSLikeDuration.fullHours_delegate$lambda$2(this));
        this.absoluteStart$delegate = LazyKt.lazy(() -> MomentJSLikeDuration.absoluteStart_delegate$lambda$3(this));
        this.absoluteEnd$delegate = LazyKt.lazy(() -> MomentJSLikeDuration.absoluteEnd_delegate$lambda$4(this));
        this.period$delegate = LazyKt.lazy(() -> MomentJSLikeDuration.period_delegate$lambda$5(this));
    }

    public MomentJSLikeDuration(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Duration duration = Duration.between(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        this(start, end, duration);
    }

    public final boolean getNegative() {
        return this.negative;
    }

    public final long getSeconds() {
        Lazy lazy = this.seconds$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    private final long getFullMinutes() {
        Lazy lazy = this.fullMinutes$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getMinutes() {
        return this.getFullMinutes() + (long)(this.getSeconds() % (long)60 < 30L ? 0 : 1);
    }

    private final long getFullHours() {
        Lazy lazy = this.fullHours$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getHours() {
        return this.getFullHours() + (long)(this.getFullMinutes() % (long)60 < 30L ? 0 : 1);
    }

    public final long getDays() {
        return this.duration.toDays() + (long)(this.getFullHours() % (long)24 < 12L ? 0 : 1);
    }

    private final LocalDate getAbsoluteStart() {
        Lazy lazy = this.absoluteStart$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LocalDate)object;
    }

    private final LocalDate getAbsoluteEnd() {
        Lazy lazy = this.absoluteEnd$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LocalDate)object;
    }

    private final Period getPeriod() {
        Lazy lazy = this.period$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Period)object;
    }

    public final int getMonths() {
        Period nextFullMonthLackingPeriod;
        int fullAdditionalDays = this.getPeriod().getDays();
        int fullMonths = this.getPeriod().getMonths() + 12 * this.getPeriod().getYears();
        return fullMonths + (fullAdditionalDays < 14 ? 0 : ((nextFullMonthLackingPeriod = Period.between(this.getAbsoluteEnd(), this.getAbsoluteStart().plusMonths((long)fullMonths + 1L))).getDays() > fullAdditionalDays ? 0 : 1));
    }

    public final int getYears() {
        return this.getPeriod().getYears() + (this.getPeriod().getMonths() < 6 ? 0 : 1);
    }

    private static final long seconds_delegate$lambda$0(MomentJSLikeDuration this$0) {
        return this$0.duration.toSeconds();
    }

    private static final long fullMinutes_delegate$lambda$1(MomentJSLikeDuration this$0) {
        return this$0.duration.toMinutes();
    }

    private static final long fullHours_delegate$lambda$2(MomentJSLikeDuration this$0) {
        return this$0.duration.toHours();
    }

    private static final LocalDate absoluteStart_delegate$lambda$3(MomentJSLikeDuration this$0) {
        return (this$0.negative ? this$0.end : this$0.start).toLocalDate();
    }

    private static final LocalDate absoluteEnd_delegate$lambda$4(MomentJSLikeDuration this$0) {
        return (this$0.negative ? this$0.start : this$0.end).toLocalDate();
    }

    private static final Period period_delegate$lambda$5(MomentJSLikeDuration this$0) {
        return Period.between(this$0.getAbsoluteStart(), this$0.getAbsoluteEnd());
    }
}

