/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingService;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingServiceKt;
import com.intellij.kubernetes.view.execution.PortForwarding;
import com.intellij.kubernetes.view.execution.PortForwardingProcess;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesPortForwardingNotificationService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsRestartAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareAction;", "<init>", "()V", "update", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodForwardPortsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsRestartAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,406:1\n1761#2,3:407\n30#3,2:410\n*S KotlinDebug\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsRestartAction\n*L\n95#1:407,3\n107#1:410,2\n*E\n"})
public final class KubernetesPodForwardPortsRestartAction
extends KubernetesModelBasedDumbAwareAction {
    @Override
    protected void update(@NotNull KubernetesApiModelInterface apiModel, @NotNull AnActionEvent event) {
        boolean bl;
        Presentation presentation;
        block5: {
            Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            KubernetesPodForwardPortsRestartAction kubernetesPodForwardPortsRestartAction = this;
            presentation = event.getPresentation();
            boolean bl2 = false;
            List list2 = (List)event.getData(KubernetesPortForwardingServiceKt.getPORT_FORWARDINGS());
            if (list2 == null) {
                bl = false;
            } else {
                List forwardings = list2;
                Iterable $this$any$iv = forwardings;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PortForwarding forwarding = (PortForwarding)element$iv;
                        boolean bl3 = false;
                        PortForwardingProcess portForwardingProcess2 = KubernetesPortForwardingService.Companion.getInstance().getPortForwardingProcess(apiModel, forwarding);
                        boolean bl4 = portForwardingProcess2 != null ? portForwardingProcess2.isActive() : false;
                        if (!(!bl4)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        boolean bl5 = bl;
        presentation.setEnabled(bl5);
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModelInterface apiModel, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(KubernetesPortForwardingServiceKt.getPORT_FORWARDINGS());
        Intrinsics.checkNotNull((Object)object);
        List forwardings = (List)object;
        ComponentManager $this$service$iv = (ComponentManager)apiModel.getProject();
        boolean $i$f$service = false;
        Class<KubernetesPortForwardingNotificationService> serviceClass$iv = KubernetesPortForwardingNotificationService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        KubernetesPortForwardingNotificationService notificationService = (KubernetesPortForwardingNotificationService)object2;
        ActionsKt.runWriteAction(() -> KubernetesPodForwardPortsRestartAction.actionPerformed$lambda$2(forwardings, apiModel, notificationService));
    }

    private static final Unit actionPerformed$lambda$2(List $forwardings, KubernetesApiModelInterface $apiModel, KubernetesPortForwardingNotificationService $notificationService) {
        for (PortForwarding forwarding : $forwardings) {
            PortForwardingProcess process = KubernetesPortForwardingService.Companion.getInstance().getOrCreatePortForwarding($apiModel, forwarding, true);
            KubernetesPortForwardingNotificationService.subscribeOnProcessAndNotifyErrors$default($notificationService, process, false, 2, null);
        }
        return Unit.INSTANCE;
    }
}

