/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JTableHeaderLocation;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.PatternTextMatcher;
import org.assertj.swing.util.StringTextMatcher;
import org.assertj.swing.util.TextMatcher;

@InternalApi
public class JTableHeaderDriver
extends JComponentDriver {
    private final JTableHeaderLocation location = new JTableHeaderLocation();

    public JTableHeaderDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, int columnIndex) {
        this.clickColumn(tableHeader, columnIndex, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, int columnIndex, @Nonnull MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location);
        this.robot.click(tableHeader, p, button, times);
        Pause.pause(300L);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nullable String columnName) {
        this.clickColumn(tableHeader, columnName, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull Pattern columnNamePattern) {
        this.clickColumn(tableHeader, columnNamePattern, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nullable String columnName, @Nonnull MouseButton button, int times) {
        this.clickColumn(tableHeader, new StringTextMatcher(columnName), button, times);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull Pattern columnNamePattern, @Nonnull MouseButton button, int times) {
        this.clickColumn(tableHeader, new PatternTextMatcher(columnNamePattern), button, times);
    }

    @RunsInEDT
    private void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher, @Nonnull MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtName(tableHeader, matcher, this.location());
        this.robot.click(tableHeader, p, button, times);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, int columnIndex) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location));
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtIndex(@Nonnull JTableHeader tableHeader, int columnIndex, JTableHeaderLocation location) {
        Point result = GuiActionRunner.execute(() -> {
            Point p = location.pointAt(tableHeader, columnIndex);
            ComponentPreconditions.checkEnabledAndShowing(tableHeader);
            tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect(columnIndex));
            return p;
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, @Nullable String columnName) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new StringTextMatcher(columnName), this.location()));
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, @Nonnull Pattern pattern) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new PatternTextMatcher(pattern), this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtName(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher, @Nonnull JTableHeaderLocation location) {
        Point result = GuiActionRunner.execute(() -> {
            Pair<Integer, Point> indexAndLocation = location.pointAt(tableHeader, matcher);
            ComponentPreconditions.checkEnabledAndShowing(tableHeader);
            tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect((Integer)indexAndLocation.first));
            return (Point)indexAndLocation.second;
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private JTableHeaderLocation location() {
        return this.location;
    }
}

