/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.ide.highlighter.PbSyntaxHighlighter;
import com.intellij.protobuf.ide.highlighter.PbTextSyntaxHighlighter;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbTextIdentifierValue;
import com.intellij.protobuf.lang.psi.PbTextNumberValue;
import com.intellij.protobuf.lang.psi.PbTextVisitor;
import com.intellij.protobuf.lang.psi.ProtoNumberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public final class PbTextHighlightingAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        if (element == null) {
            PbTextHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PbTextHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new PbTextVisitor(){

            @Override
            public void visitIdentifierValue(@NotNull PbTextIdentifierValue identifier) {
                PsiReference ref;
                if (identifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((ref = identifier.getReference()) != null) {
                    if (!DumbService.isDumb((Project)identifier.getProject()) && ref.resolve() != null) {
                        PbTextHighlightingAnnotator.setHighlighting(identifier, holder, PbTextHighlightingAnnotator.getEnumValueKey(identifier));
                    }
                } else {
                    ProtoNumberValue numberValue = identifier.getAsNumber();
                    if (numberValue != null) {
                        this.visitNumberValue(numberValue);
                    } else if (identifier.getBooleanValue() != null) {
                        PbTextHighlightingAnnotator.setHighlighting(identifier, holder, PbTextHighlightingAnnotator.getKeywordKey(identifier));
                    }
                }
            }

            @Override
            public void visitNumberValue(@NotNull PbTextNumberValue number) {
                if (number == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitNumberValue((ProtoNumberValue)number);
            }

            void visitNumberValue(@NotNull ProtoNumberValue number) {
                PsiElement numberElement;
                ProtoNumberValue.SourceType sourceType;
                if (number == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (((sourceType = number.getSourceType()) == ProtoNumberValue.SourceType.INF || sourceType == ProtoNumberValue.SourceType.NAN) && (numberElement = number.getNumberElement()) != null) {
                    PbTextHighlightingAnnotator.setHighlighting(numberElement, holder, PbTextHighlightingAnnotator.getKeywordKey(number));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "identifier";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "number";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/ide/highlighter/PbTextHighlightingAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIdentifierValue";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNumberValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static TextAttributesKey getKeywordKey(PsiElement element) {
        if (element.getContainingFile() instanceof PbFile) {
            return PbSyntaxHighlighter.KEYWORD;
        }
        return PbTextSyntaxHighlighter.KEYWORD;
    }

    private static TextAttributesKey getEnumValueKey(PsiElement element) {
        if (element.getContainingFile() instanceof PbFile) {
            return PbSyntaxHighlighter.ENUM_VALUE;
        }
        return PbTextSyntaxHighlighter.ENUM_VALUE;
    }

    private static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (element == null) {
            PbTextHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PbTextHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PbTextHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(element.getTextRange()).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/ide/highlighter/PbTextHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

