/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbSyntaxStatement;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class EditionsAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        PbElement pbElement;
        if (element == null) {
            EditionsAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            EditionsAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PbElement) || !((pbElement = (PbElement)element).getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition)) {
            return;
        }
        element.accept((PsiElementVisitor)new PbVisitor(){

            @Override
            public void visitSyntaxStatement(@NotNull PbSyntaxStatement syntax) {
                if (syntax == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditionsAnnotator.annotateEdition(syntax, holder);
            }

            @Override
            public void visitField(@NotNull PbField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditionsAnnotator.annotateField(field, holder);
            }

            @Override
            public void visitGroupDefinition(@NotNull PbGroupDefinition group) {
                if (group == null) {
                    1.$$$reportNull$$$0(2);
                }
                EditionsAnnotator.annotateGroupDefinition(group, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "syntax";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/EditionsAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSyntaxStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitGroupDefinition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void annotateEdition(PbSyntaxStatement syntax, AnnotationHolder holder) {
        String effectiveSyntaxVersion;
        SyntaxLevel syntaxLevel = syntax.getSyntaxLevel();
        String string = effectiveSyntaxVersion = syntaxLevel == null ? "" : syntaxLevel.getVersion();
        if (!effectiveSyntaxVersion.equals("2023") && !effectiveSyntaxVersion.equals("2024")) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.unsupported", effectiveSyntaxVersion)).range((PsiElement)syntax).create();
        }
    }

    private static void annotateField(PbField field, AnnotationHolder holder) {
        if (field instanceof PbMapField) {
            return;
        }
        PbFieldLabel label = field.getDeclaredLabel();
        if (label != null && !label.getText().equals("repeated")) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.field.label." + label.getText(), new Object[0])).range((PsiElement)label).create();
        }
    }

    private static void annotateGroupDefinition(PbGroupDefinition group, AnnotationHolder holder) {
        holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.group.invalid", new Object[0])).range((PsiElement)group).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/annotation/EditionsAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

