/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.mcpserver.McpServerBundle;
import com.intellij.mcpserver.clientConfiguration.McpClient;
import com.intellij.mcpserver.impl.McpClientDetectionSettings;
import com.intellij.mcpserver.impl.McpClientDetector;
import com.intellij.mcpserver.settings.McpServerSettings;
import com.intellij.mcpserver.settings.McpServerSettingsConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/mcpserver/impl/McpClientDetectionActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestToChangePortIfNeeded", "detectedClients", "", "Lcom/intellij/mcpserver/clientConfiguration/McpClient;", "showUnconfiguredNotificationIfNeeded", "showMcpServerAutomaticConfigurationNotification", "unconfiguredClients", "showMcpServerEnablingSuggestionNotification", "ShowSettingsAction", "AutoconfigureAction", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpClientDetectionActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientDetectionActivity.kt\ncom/intellij/mcpserver/impl/McpClientDetectionActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n30#2,2:176\n30#2,2:184\n30#2,2:190\n30#2,2:192\n30#2,2:203\n30#2,2:209\n30#2,2:211\n774#3:178\n865#3,2:179\n827#3:181\n855#3,2:182\n1563#3:186\n1634#3,3:187\n774#3:194\n865#3,2:195\n774#3:197\n865#3,2:198\n827#3:200\n855#3,2:201\n1563#3:205\n1634#3,3:206\n774#3:213\n865#3,2:214\n*S KotlinDebug\n*F\n+ 1 McpClientDetectionActivity.kt\ncom/intellij/mcpserver/impl/McpClientDetectionActivity\n*L\n36#1:176,2\n80#1:184,2\n84#1:190,2\n85#1:192,2\n144#1:203,2\n149#1:209,2\n150#1:211,2\n56#1:178\n56#1:179,2\n56#1:181\n56#1:182,2\n81#1:186\n81#1:187,3\n87#1:194\n87#1:195,2\n88#1:197\n88#1:198,2\n88#1:200\n88#1:201,2\n145#1:205\n145#1:206,3\n152#1:213\n152#1:214,2\n*E\n"})
public final class McpClientDetectionActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        List<McpClient> detectedClients = McpClientDetector.INSTANCE.detectMcpClients(project);
        this.suggestToChangePortIfNeeded(detectedClients, project);
        if (Registry.Companion.is("mcp.server.detect.mcp.clients")) {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<McpClientDetectionSettings> serviceClass$iv = McpClientDetectionSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            McpClientDetectionSettings mcpClientDetectionSettings = (McpClientDetectionSettings)((Object)object);
            if (((McpServerSettings.MyState)McpServerSettings.Companion.getInstance().getState()).getEnableMcpServer()) {
                this.showUnconfiguredNotificationIfNeeded(detectedClients, project);
                return Unit.INSTANCE;
            }
            boolean doNotShowServerDisabled = ((McpClientDetectionSettings.MyState)mcpClientDetectionSettings.getState()).getDoNotShowServerDisabledAgain();
            if (doNotShowServerDisabled) {
                return Unit.INSTANCE;
            }
            if (!((Collection)detectedClients).isEmpty()) {
                this.showMcpServerEnablingSuggestionNotification(project, detectedClients);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void suggestToChangePortIfNeeded(List<? extends McpClient> detectedClients, Project project) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        McpClient it;
        void $this$filterTo$iv$iv;
        Object[] $this$filter$iv = (Object[])detectedClients;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (McpClient)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = it.isConfigured();
            if (!(bl2 != null ? bl2 : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (McpClient)element$iv$iv;
            boolean bl = false;
            if (it.isPortCorrect()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notMatchingPort = (List)destination$iv$iv;
        if (!((Collection)notMatchingPort).isEmpty()) {
            objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)notMatchingPort, (CharSequence)", ", null, null, (int)0, null, McpClientDetectionActivity::suggestToChangePortIfNeeded$lambda$2, (int)30, null)};
            Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("MCP Server").createNotification(McpServerBundle.INSTANCE.message("mcp.clients.with.wrong.port.detected.notification.title", new Object[0]), McpServerBundle.INSTANCE.message("mcp.clients.with.wrong.port.detected.notification.message", objectArray), NotificationType.INFORMATION).setSuggestionType(true).setImportant(false);
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setImportant(...)");
            Notification notification2 = notification;
            notification2.setSuppressShowingPopup(true);
            notification2.addAction((AnAction)new AutoconfigureAction(project, notMatchingPort, notification2)).addAction((AnAction)new ShowSettingsAction(project, null, 2, null)).notify(project);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showUnconfiguredNotificationIfNeeded(List<? extends McpClient> detectedClients, Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service22 = false;
        Class<McpClientDetectionSettings> serviceClass$iv = McpClientDetectionSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Set currentProcessedClients = CollectionsKt.toMutableSet((Iterable)((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object)).getState()).getProcessedClients());
        Iterable $i$f$service22 = detectedClients;
        Set set = currentProcessedClients;
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Iterator iterator = (McpClient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().getDisplayName());
        }
        Set newProcessedClients = CollectionsKt.toMutableSet((Iterable)SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv)));
        if (!Intrinsics.areEqual((Object)currentProcessedClients, (Object)newProcessedClients)) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            ComponentManager $this$service$iv2 = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<McpClientDetectionSettings> serviceClass$iv2 = McpClientDetectionSettings.class;
            Object object2 = $this$service$iv2.getService(serviceClass$iv2);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
            }
            ((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object2)).getState()).setProcessedClients(newProcessedClients);
            $this$service$iv2 = (ComponentManager)ApplicationKt.getApplication();
            $i$f$service = false;
            serviceClass$iv2 = McpClientDetectionSettings.class;
            Object object3 = $this$service$iv2.getService(serviceClass$iv2);
            if (object3 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
            }
            ((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object3)).getState()).intIncrementModificationCount();
            Iterable $this$filter$iv = newProcessedClients;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!currentProcessedClients.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List newClients = (List)destination$iv$iv2;
            Iterable $this$filter$iv2 = detectedClients;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                McpClient it = (McpClient)element$iv$iv;
                boolean bl = false;
                if (!newClients.contains(it.getName().getDisplayName())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                McpClient it = (McpClient)element$iv$iv;
                boolean bl = false;
                Boolean bl2 = it.isConfigured();
                if (bl2 != null ? bl2 : false) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List unconfiguredNewClients = (List)destination$iv$iv3;
            if (!((Collection)unconfiguredNewClients).isEmpty()) {
                this.showMcpServerAutomaticConfigurationNotification(project, unconfiguredNewClients);
            }
        }
    }

    private final void showMcpServerAutomaticConfigurationNotification(Project project, List<? extends McpClient> unconfiguredClients) {
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)unconfiguredClients, (CharSequence)", ", null, null, (int)0, null, McpClientDetectionActivity::showMcpServerAutomaticConfigurationNotification$lambda$7, (int)30, null)};
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("MCP Server").createNotification(McpServerBundle.INSTANCE.message("mcp.unconfigured.clients.detected.notification.title", new Object[0]), McpServerBundle.INSTANCE.message("mcp.unconfigured.clients.detected.notification.message", objectArray), NotificationType.INFORMATION);
        notification.addAction((AnAction)new AutoconfigureAction(project, unconfiguredClients, notification)).addAction((AnAction)new ShowSettingsAction(project, null, 2, null)).notify(project);
    }

    /*
     * WARNING - void declaration
     */
    private final void showMcpServerEnablingSuggestionNotification(Project project, List<? extends McpClient> detectedClients) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service22 = false;
        Class<McpClientDetectionSettings> serviceClass$iv = McpClientDetectionSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Set currentProcessedClients = CollectionsKt.toMutableSet((Iterable)((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object)).getState()).getProcessedClients());
        Iterable $i$f$service22 = detectedClients;
        Set set = currentProcessedClients;
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            McpClient mcpClient = (McpClient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().getDisplayName());
        }
        Set newProcessedClients = CollectionsKt.toMutableSet((Iterable)SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv)));
        if (Intrinsics.areEqual((Object)currentProcessedClients, (Object)newProcessedClients)) {
            return;
        }
        ComponentManager $this$service$iv2 = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<McpClientDetectionSettings> serviceClass$iv2 = McpClientDetectionSettings.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        ((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object2)).getState()).setProcessedClients(newProcessedClients);
        $this$service$iv2 = (ComponentManager)ApplicationKt.getApplication();
        $i$f$service = false;
        serviceClass$iv2 = McpClientDetectionSettings.class;
        Object object3 = $this$service$iv2.getService(serviceClass$iv2);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        ((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object3)).getState()).intIncrementModificationCount();
        Iterable $this$filter$iv = newProcessedClients;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!currentProcessedClients.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newClients = (List)destination$iv$iv2;
        String clientNames = CollectionsKt.joinToString$default((Iterable)newClients, (CharSequence)", ", null, null, (int)0, null, McpClientDetectionActivity::showMcpServerEnablingSuggestionNotification$lambda$10, (int)30, null);
        Object object4 = new Object[]{clientNames};
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("MCP Server").createNotification(McpServerBundle.INSTANCE.message("mcp.clients.detected.notification.title", new Object[0]), McpServerBundle.INSTANCE.message("mcp.clients.detected.notification.message", object4), NotificationType.INFORMATION).addAction((AnAction)new ShowSettingsAction(project, McpServerBundle.INSTANCE.message("mcp.clients.detected.action.enable", new Object[0])));
        object4 = McpServerBundle.INSTANCE.message("mcp.clients.detected.action.show.help", new Object[0]);
        AnAction anAction = new AnAction((String)object4){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.open((String)"https://modelcontextprotocol.io/introduction");
            }
        };
        object4 = McpServerBundle.INSTANCE.message("mcp.clients.detected.action.dont.show", new Object[0]);
        notification.addAction(anAction).addAction(new AnAction((String)object4){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
                boolean $i$f$service = false;
                Class<McpClientDetectionSettings> serviceClass$iv = McpClientDetectionSettings.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((McpClientDetectionSettings.MyState)((McpClientDetectionSettings)((Object)object)).getState()).setDoNotShowServerDisabledAgain(true);
            }
        }).notify(project);
    }

    private static final CharSequence suggestToChangePortIfNeeded$lambda$2(McpClient it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName().getDisplayName();
    }

    private static final CharSequence showMcpServerAutomaticConfigurationNotification$lambda$7(McpClient it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName().getDisplayName();
    }

    private static final CharSequence showMcpServerEnablingSuggestionNotification$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/mcpserver/impl/McpClientDetectionActivity$AutoconfigureAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "unconfiguredClients", "", "Lcom/intellij/mcpserver/clientConfiguration/McpClient;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/notification/Notification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.mcpserver"})
    @SourceDebugExtension(value={"SMAP\nMcpClientDetectionActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientDetectionActivity.kt\ncom/intellij/mcpserver/impl/McpClientDetectionActivity$AutoconfigureAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,175:1\n1869#2:176\n1870#2:179\n774#2:180\n865#2,2:181\n1#3:177\n24#4:178\n*S KotlinDebug\n*F\n+ 1 McpClientDetectionActivity.kt\ncom/intellij/mcpserver/impl/McpClientDetectionActivity$AutoconfigureAction\n*L\n104#1:176\n104#1:179\n110#1:180\n110#1:181,2\n106#1:178\n*E\n"})
    private static final class AutoconfigureAction
    extends AnAction {
        @NotNull
        private final Project project;
        @NotNull
        private final List<McpClient> unconfiguredClients;
        @NotNull
        private final Notification notification;

        public AutoconfigureAction(@NotNull Project project, @NotNull List<? extends McpClient> unconfiguredClients, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(unconfiguredClients, (String)"unconfiguredClients");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            super(McpServerBundle.INSTANCE.message("mcp.unconfigured.clients.detected.configure.json", new Object[0]));
            this.project = project;
            this.unconfiguredClients = unconfiguredClients;
            this.notification = notification;
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Object[] objectArray;
            void $this$filterTo$iv$iv;
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Set clientsWithErrorDuringConfiguration = new LinkedHashSet();
            Iterable $this$forEach$iv = this.unconfiguredClients;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Object $this$actionPerformed_u24lambda_u242_u24lambda_u240;
                McpClient client = (McpClient)element$iv2;
                boolean bl = false;
                Object object = this;
                try {
                    $this$actionPerformed_u24lambda_u242_u24lambda_u240 = object;
                    boolean bl2 = false;
                    client.configure();
                    $this$actionPerformed_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    $this$actionPerformed_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object = $this$actionPerformed_u24lambda_u242_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) continue;
                Object it = $this$actionPerformed_u24lambda_u242_u24lambda_u240 = throwable;
                boolean bl3 = false;
                AutoconfigureAction $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AutoconfigureAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info((Throwable)it);
                clientsWithErrorDuringConfiguration.add(client);
            }
            Iterable $this$filter$iv = this.unconfiguredClients;
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                McpClient it = (McpClient)element$iv$iv;
                boolean bl = false;
                if (!(!clientsWithErrorDuringConfiguration.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List configuredClients = (List)destination$iv$iv;
            if (!((Collection)configuredClients).isEmpty()) {
                objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)configuredClients, (CharSequence)", ", null, null, (int)0, null, AutoconfigureAction::actionPerformed$lambda$4, (int)30, null)};
                Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("MCP Server").createNotification(McpServerBundle.INSTANCE.message("mcp.client.autoconfigured", new Object[0]), McpServerBundle.INSTANCE.message("mcp.server.client.restart.info", objectArray), NotificationType.INFORMATION).setImportant(false);
                Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setImportant(...)");
                Notification doneNotification = notification;
                doneNotification.notify(this.project);
            }
            if (!((Collection)clientsWithErrorDuringConfiguration).isEmpty()) {
                objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)clientsWithErrorDuringConfiguration, (CharSequence)", ", null, null, (int)0, null, AutoconfigureAction::actionPerformed$lambda$5, (int)30, null)};
                Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("MCP Server").createNotification(McpServerBundle.INSTANCE.message("mcp.client.error.autoconfigured", new Object[0]), McpServerBundle.INSTANCE.message("mcp.server.error.autoconfigured.info", objectArray), NotificationType.WARNING).setImportant(false);
                Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setImportant(...)");
                Notification errorNotification = notification;
                errorNotification.notify(this.project);
            }
            this.notification.expire();
        }

        private static final CharSequence actionPerformed$lambda$4(McpClient it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName().getDisplayName();
        }

        private static final CharSequence actionPerformed$lambda$5(McpClient it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName().getDisplayName();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/mcpserver/impl/McpClientDetectionActivity$ShowSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.mcpserver"})
    private static final class ShowSettingsAction
    extends AnAction {
        @NotNull
        private final Project project;

        public ShowSettingsAction(@NotNull Project project, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
            this.project = project;
        }

        public /* synthetic */ ShowSettingsAction(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = McpServerBundle.INSTANCE.message("mcp.unconfigured.clients.detected.configure.settings.json", new Object[0]);
            }
            this(project, string);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShowSettingsUtil.getInstance().showSettingsDialog(this.project, McpServerSettingsConfigurable.class);
        }
    }
}

