/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 26541129605355L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1768265370 + -20000, -1768265370 + -388, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1768265370 + -19999, 1768265370 + 2150, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 36069048781518L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.M();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-86506200 + -((char)-11321), -86506200 + -((char)-3059), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-86506200 + -((char)-11320), 86506200 + (char)-3662, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-86506200 + -((char)-11327), 86506200 + (char)-4032, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 3214719497668L;
                Object object = this.lock;
                String string = SshAgentIpcService.M();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2724, 2084013000 - (char)-4181, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2727, 2084013000 - (char)-15912, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2726, 2084013000 - (char)-25244, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2713, -2084013000 - -((char)-24200), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2712, -2084013000 - -((char)-30219), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2715, 2084013000 - (char)-424, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2713, -2084013000 - -((char)-24200), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2084013000 - (char)-2714, 2084013000 - (char)-17704, (int)l2));
            if (ActionTimestamp.M() != 0) {
                SshAgentIpcService.M("Krnm4b");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 85438568418417L;
                    string = SshAgentIpcService.M();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 86796526991811L;
                String string2 = SshAgentIpcService.M();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            string = string2;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string == null) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-467133480 - -26250, -467133480 - -((char)-31876), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26251, 467133480 - (char)-26192, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26248, 467133480 - (char)-22120, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-467133480 - -26250, -467133480 - -((char)-31876), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26249, -467133480 - -((char)-25226), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string == null) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-467133480 - -26250, -467133480 - -((char)-31876), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26278, -467133480 - -((char)-17420), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26279, 467133480 - 32424, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string == null) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26248, 467133480 - (char)-22120, (int)l2) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-467133480 - -26250, -467133480 - -((char)-31876), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-467133480 - -26254, 467133480 - (char)-11663, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-467133480 - -26276, 467133480 - (char)-8235, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 86372953818912L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1161542340 - 24105, -1161542340 - -((char)-26853), (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 127859574682815L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1601675400 + -28787, 1601675400 + 32503, (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "\u001d\u00eaJ\u008f(\u00c23\u00can\u00ea\u00d4T\u00e4\u00cea\u00b7\u0012a\u0016\u0014O7\u00002z\u00b7\u0004\u00e1\n\u0089\u009d\u00ec\u000f \u00dd\u00e1hm^L";
                    var4_3 = "\u001d\u00eaJ\u008f(\u00c23\u00can\u00ea\u00d4T\u00e4\u00cea\u00b7\u0012a\u0016\u0014O7\u00002z\u00b7\u0004\u00e1\n\u0089\u009d\u00ec\u000f \u00dd\u00e1hm^L".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 11;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 26;
                                    break;
                                }
                                case 1: {
                                    v11 = 66;
                                    break;
                                }
                                case 2: {
                                    v11 = 20;
                                    break;
                                }
                                case 3: {
                                    v11 = 112;
                                    break;
                                }
                                case 4: {
                                    v11 = 126;
                                    break;
                                }
                                case 5: {
                                    v11 = 71;
                                    break;
                                }
                                default: {
                                    v11 = 69;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0x5BBB) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 182;
                        case 1 -> 96;
                        case 2 -> 31;
                        case 3 -> 192;
                        case 4 -> 56;
                        case 5 -> 137;
                        case 6 -> 42;
                        case 7 -> 41;
                        case 8 -> 244;
                        case 9 -> 213;
                        case 10 -> 228;
                        case 11 -> 252;
                        case 12 -> 21;
                        case 13 -> 11;
                        case 14 -> 141;
                        case 15 -> 75;
                        case 16 -> 19;
                        case 17 -> 226;
                        case 18 -> 93;
                        case 19 -> 85;
                        case 20 -> 64;
                        case 21 -> 10;
                        case 22 -> 117;
                        case 23 -> 33;
                        case 24 -> 200;
                        case 25 -> 29;
                        case 26 -> 171;
                        case 27 -> 159;
                        case 28 -> 69;
                        case 29 -> 241;
                        case 30 -> 127;
                        case 31 -> 205;
                        case 32 -> 255;
                        case 33 -> 1;
                        case 34 -> 125;
                        case 35 -> 202;
                        case 36 -> 165;
                        case 37 -> 118;
                        case 38 -> 80;
                        case 39 -> 104;
                        case 40 -> 58;
                        case 41 -> 12;
                        case 42 -> 25;
                        case 43 -> 4;
                        case 44 -> 23;
                        case 45 -> 52;
                        case 46 -> 18;
                        case 47 -> 155;
                        case 48 -> 83;
                        case 49 -> 60;
                        case 50 -> 161;
                        case 51 -> 86;
                        case 52 -> 8;
                        case 53 -> 196;
                        case 54 -> 81;
                        case 55 -> 95;
                        case 56 -> 39;
                        case 57 -> 209;
                        case 58 -> 215;
                        case 59 -> 164;
                        case 60 -> 254;
                        case 61 -> 61;
                        case 62 -> 234;
                        case 63 -> 128;
                        case 64 -> 13;
                        case 65 -> 243;
                        case 66 -> 253;
                        case 67 -> 210;
                        case 68 -> 204;
                        case 69 -> 178;
                        case 70 -> 181;
                        case 71 -> 239;
                        case 72 -> 45;
                        case 73 -> 189;
                        case 74 -> 74;
                        case 75 -> 32;
                        case 76 -> 212;
                        case 77 -> 91;
                        case 78 -> 38;
                        case 79 -> 17;
                        case 80 -> 150;
                        case 81 -> 190;
                        case 82 -> 90;
                        case 83 -> 44;
                        case 84 -> 106;
                        case 85 -> 110;
                        case 86 -> 217;
                        case 87 -> 37;
                        case 88 -> 2;
                        case 89 -> 153;
                        case 90 -> 22;
                        case 91 -> 102;
                        case 92 -> 184;
                        case 93 -> 130;
                        case 94 -> 144;
                        case 95 -> 169;
                        case 96 -> 216;
                        case 97 -> 224;
                        case 98 -> 77;
                        case 99 -> 121;
                        case 100 -> 24;
                        case 101 -> 149;
                        case 102 -> 89;
                        case 103 -> 48;
                        case 104 -> 131;
                        case 105 -> 88;
                        case 106 -> 114;
                        case 107 -> 35;
                        case 108 -> 14;
                        case 109 -> 112;
                        case 110 -> 70;
                        case 111 -> 87;
                        case 112 -> 170;
                        case 113 -> 5;
                        case 114 -> 78;
                        case 115 -> 116;
                        case 116 -> 172;
                        case 117 -> 183;
                        case 118 -> 220;
                        case 119 -> 43;
                        case 120 -> 40;
                        case 121 -> 115;
                        case 122 -> 103;
                        case 123 -> 208;
                        case 124 -> 237;
                        case 125 -> 199;
                        case 126 -> 146;
                        case 127 -> 100;
                        case 128 -> 65;
                        case 129 -> 145;
                        case 130 -> 133;
                        case 131 -> 222;
                        case 132 -> 152;
                        case 133 -> 28;
                        case 134 -> 206;
                        case 135 -> 71;
                        case 136 -> 3;
                        case 137 -> 34;
                        case 138 -> 225;
                        case 139 -> 105;
                        case 140 -> 109;
                        case 141 -> 247;
                        case 142 -> 176;
                        case 143 -> 229;
                        case 144 -> 179;
                        case 145 -> 15;
                        case 146 -> 84;
                        case 147 -> 177;
                        case 148 -> 198;
                        case 149 -> 136;
                        case 150 -> 191;
                        case 151 -> 66;
                        case 152 -> 122;
                        case 153 -> 154;
                        case 154 -> 156;
                        case 155 -> 235;
                        case 156 -> 62;
                        case 157 -> 249;
                        case 158 -> 107;
                        case 159 -> 53;
                        case 160 -> 163;
                        case 161 -> 6;
                        case 162 -> 218;
                        case 163 -> 129;
                        case 164 -> 26;
                        case 165 -> 30;
                        case 166 -> 50;
                        case 167 -> 158;
                        case 168 -> 111;
                        case 169 -> 173;
                        case 170 -> 120;
                        case 171 -> 151;
                        case 172 -> 148;
                        case 173 -> 124;
                        case 174 -> 94;
                        case 175 -> 54;
                        case 176 -> 36;
                        case 177 -> 68;
                        case 178 -> 194;
                        case 179 -> 246;
                        case 180 -> 138;
                        case 181 -> 236;
                        case 182 -> 187;
                        case 183 -> 55;
                        case 184 -> 245;
                        case 185 -> 251;
                        case 186 -> 139;
                        case 187 -> 238;
                        case 188 -> 134;
                        case 189 -> 97;
                        case 190 -> 27;
                        case 191 -> 126;
                        case 192 -> 51;
                        case 193 -> 195;
                        case 194 -> 211;
                        case 195 -> 232;
                        case 196 -> 174;
                        case 197 -> 7;
                        case 198 -> 123;
                        case 199 -> 185;
                        case 200 -> 231;
                        case 201 -> 219;
                        case 202 -> 142;
                        case 203 -> 250;
                        case 204 -> 0;
                        case 205 -> 242;
                        case 206 -> 135;
                        case 207 -> 73;
                        case 208 -> 47;
                        case 209 -> 157;
                        case 210 -> 186;
                        case 211 -> 233;
                        case 212 -> 175;
                        case 213 -> 82;
                        case 214 -> 193;
                        case 215 -> 143;
                        case 216 -> 230;
                        case 217 -> 160;
                        case 218 -> 76;
                        case 219 -> 63;
                        case 220 -> 49;
                        case 221 -> 57;
                        case 222 -> 201;
                        case 223 -> 113;
                        case 224 -> 16;
                        case 225 -> 248;
                        case 226 -> 140;
                        case 227 -> 197;
                        case 228 -> 99;
                        case 229 -> 168;
                        case 230 -> 79;
                        case 231 -> 180;
                        case 232 -> 119;
                        case 233 -> 67;
                        case 234 -> 46;
                        case 235 -> 101;
                        case 236 -> 9;
                        case 237 -> 98;
                        case 238 -> 221;
                        case 239 -> 162;
                        case 240 -> 59;
                        case 241 -> 240;
                        case 242 -> 227;
                        case 243 -> 188;
                        case 244 -> 147;
                        case 245 -> 207;
                        case 246 -> 72;
                        case 247 -> 108;
                        case 248 -> 203;
                        case 249 -> 223;
                        case 250 -> 20;
                        case 251 -> 214;
                        case 252 -> 92;
                        case 253 -> 132;
                        case 254 -> 167;
                        default -> 166;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (string == null) {
            int n3 = ActionTimestamp.p();
            ActionTimestamp.M(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 57637274748281L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.M();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1186314570 + -((char)-30754), -1186314570 + -((char)-23864), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1186314570 + -((char)-30758), 1186314570 + 29635, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1186314570 + -((char)-30737), -1186314570 + -((char)-22299), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1186314570 + -((char)-30754), -1186314570 + -((char)-23864), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1186314570 + -((char)-30758), 1186314570 + 29635, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1186314570 + -((char)-30730), 1186314570 + (char)-22248, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 140016136051737L;
                        String string3 = SshAgentIpcService.M();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(202241010 - (char)-29615, -202241010 - -((char)-9862), (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(202241010 - (char)-29616, -202241010 - -((char)-28606), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 121842311175913L;
                String string2 = SshAgentIpcService.M();
                this.assertConnectionThread();
                string = string2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15116), -1616093100 - -((char)-10198), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15112), 1616093100 - (char)-5873, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15105), -1616093100 - -((char)-2085), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15112), 1616093100 - (char)-5873, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15114), 1615962030 + (char)-500, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15116), -1616093100 - -((char)-10198), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15112), 1616093100 - (char)-5873, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15096), 1616093100 - (char)-4425, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15116), -1616093100 - -((char)-10198), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15112), 1616093100 - (char)-5873, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15095), -1616093100 - -((char)-9159), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15116), -1616093100 - -((char)-10198), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15112), 1616093100 - (char)-5873, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1616093100 - -((char)-15094), 1616093100 - (char)-17541, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 84910668119407L;
                    Object object = this.lock;
                    string = SshAgentIpcService.M();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-835309110 + -27388, -835309110 + -21970, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-835309110 + -27392, 835309110 + (char)-31003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-835309110 + -27377, 835309110 + 13629, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-835309110 + -27372, -835309110 + -23131, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-835309110 + -27388, -835309110 + -21970, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-835309110 + -27392, 835309110 + (char)-31003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-835309110 + -27371, 835309110 + 29690, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-835309110 + -27388, -835309110 + -21970, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-835309110 + -27392, 835309110 + (char)-31003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-835309110 + -27374, -835309110 + -28922, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-835309110 + -27388, -835309110 + -21970, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-835309110 + -27392, 835309110 + (char)-31003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-835309110 + -27373, -835309110 + -18956, (int)l2));
                    if (string == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-835309110 + -27388, -835309110 + -21970, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-835309110 + -27392, 835309110 + (char)-31003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-835309110 + -27368, -835309110 + -20276, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-835309110 + -27367, -835309110 + -((char)-32018), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0096\u00c0\u0095\u0096\u00fc\u00dba\u00a7\u0014P\u000eu\u00a8\u001e\u0094\u0092T(6\u00a5\u008b\u00de(\u00b8@\u00abw)\u00cf\u0006v\u0098\u0089\u009d\u0015\u00fb\u0018d\u009c\u0093\u00ca@\u001d[\u00a5\u00d9u\u0094\u0093\u009e\u00d4\u00e2]I\u00bd[\u000b\u0006\u00f2\u00a0\u00e3\t\u00e7\u00e9}\u00d5\u00f6a\u0095b<\u0005&j\u0083\u00c3N\b?\u00e8\u00a0\u00e2\bs\u00f9P\u0014\u00aaERZ\u0097\u00c2\u0096\t\u00c6@\u00d3\u00f1Z\u00c4\u00930\u00dc\u00aa>6\u0005d\u00bc\u00cb\u0019G\u001e\u0007Z\u00b2\u00a1\u00f5\u00b4O\u00ea\u00fe\u0088;\u00ab'\u00f3w\u00dd\u001a<\u00e3\u00cf\u00bdE\u00db\u00d8\u008c\u00f3\u00af\u00fdB\u00fe\u0010\u00ddn\r\u00e2U\u00ee\u00adX\u00dfl\u0092\u00ca\u0014\u008a\u00bem\t3\u00ed1D,t\u00e8_}\u0010{\u00e5\u00d9\u0093\u00cf\u00c0\u00fe\u009d\u00b5\u00d4\u00df\u00dd\u00bdh\u008b1?\u00bea\u008d\u00c6\u001fQ\u0097:\u0094C3)\u0099U\u009d0\u0082\u00e4\u008d\u0011\u00fe\u00cc\u00c8\u008f\u00fe\u00f1\u00ec\t\u001d6m?o\u0019u\u00ba\u00c2\u00f5\u0084\u00fd\u00be\u00c4\u00e4#\u00b4\u00e8:k5\u000f\u001f\u0086&\u00cf\u00d8y8I\u001e\u00fa-\u00d6\u00b2\bJ-\u000eZ\u00dddC\u00b2\f\u00e8\u008aJ\u00b5H\u00fb\u001fF\u00a0\u00e7/\u00bfF\u0003\u00cb7\u009d\u00e7\u00fe\u00ea\u00e6\u001e\u00ff\u00f2x7wWR'\u00cf9\u00dbz\u00c7[\u00dc\u00ba\u00b0\u0097*\u00cd{M\u00aaW\u001d\u00b0\u001b\u00a0\u008cc\u0016\u00d1\u00ac\u0082\u00d5\u00a6\u00b3,}\u00105\u00ddk\u0091\u00e48\u0007\u00bb\u00f2\u00f81\u00c2\u00c6\u0013\u00cb\u00b4\u0094\u00a0s\u009f\u009f\u001f\u0015{\u00f0\u0085\u00bd0Fz\u00df\u009a\u001f\u00e9\u00a3\u00a6\u00ec\u00c6\u0012\u00b7\u009ft\u00f9\u00b2\u0084\u008d\u0006\u0089\u00e9~\u0097\u007f\u0004\u000b\u0019\u00d3t\u009e\u008f\u009e\u00e7\u00ea\u00bf~\u00c6\u0015\u00bf8\u00a0\u00e0\u00129\u00b8cj\u00af\u00b4\u0084h\u00a7\u0088\u00b0e\u00ed\u00acF\u00a9)!zv\u00a5m4\\\u00fa\u009c\u008aw\u00eb\u00aa\u00ecS\u008a\u00ba\u00b6Q\u00f3\u00d0:g\u0084\u0015\u00e1\\\u000b\u000e%\u00b5_\u00b6\u0006\u00ea\u00f5\u00f5LB\u00a7V\u0007\u009e\u00f9\u008b\u00cf\u00f6$\u00b4\u0007\u00b73\u00ca\u00fa9m[(~\u00ba\u00d1\u009c)y\"t#\u008c\u00aa\u001d2\u00b3\u0002\u00e2\u0097\u0016Z\u00a4\u00d0\u00ee\b\u00d5hwE\u00a2\u001ap\u00ec\u00ecf\u001bn\u00fb\u00df\u00f0\u0094\u00c3\u000f\u001a\u007f\u0013\r\u0099'\u0091| \u0000k\u00dd\u00aa\u00ff\u008f\"%p\u00f6\u00e4}\u001c^\u00ff\u00dc*\u007f\u00ff\u00a8bw\u0095\u00d5|6\u00e8\u00d6Y\u0007\u00b8\u008a2b\u00af\u00ed\u0083k\u008cC\u008f\u000e\u00e9\u00d8m\u00f9V\u00b9h\u00af\u001fz\u008c\u0092Z\u001c\u001bZo\u001c\n\u0083rG\u008a\u00adYW\u00f7q\u0086j\u001f\u00de\u0087\u00ea\u000bv\u0011`\u0017-\u00aa\u00c3\n/\u00f0v\u00fe\u00da\b\u00bf\u00ef\u0019\u0097\u0018:\u00cd\u0010S\u0003\u00e5v&\u0095\u0005\u0092\u00e3pW\u00b6\u00042\u00e5\u00a0>G\u00fc\u001d\u00f9)\u00a05FLk\t\u009c]\u0084~tu\u00ce6@\u00aa\u00a6\u00c7\r\u0018aW\u0018%\u008fG\u00923\u0084~_\u00a5\u00ce\u00870Qp\u00fc\u00f2\u00b1@\t\u00f2\u00ae\t2!u\u001f$>";
                var4_3 = "\u0096\u00c0\u0095\u0096\u00fc\u00dba\u00a7\u0014P\u000eu\u00a8\u001e\u0094\u0092T(6\u00a5\u008b\u00de(\u00b8@\u00abw)\u00cf\u0006v\u0098\u0089\u009d\u0015\u00fb\u0018d\u009c\u0093\u00ca@\u001d[\u00a5\u00d9u\u0094\u0093\u009e\u00d4\u00e2]I\u00bd[\u000b\u0006\u00f2\u00a0\u00e3\t\u00e7\u00e9}\u00d5\u00f6a\u0095b<\u0005&j\u0083\u00c3N\b?\u00e8\u00a0\u00e2\bs\u00f9P\u0014\u00aaERZ\u0097\u00c2\u0096\t\u00c6@\u00d3\u00f1Z\u00c4\u00930\u00dc\u00aa>6\u0005d\u00bc\u00cb\u0019G\u001e\u0007Z\u00b2\u00a1\u00f5\u00b4O\u00ea\u00fe\u0088;\u00ab'\u00f3w\u00dd\u001a<\u00e3\u00cf\u00bdE\u00db\u00d8\u008c\u00f3\u00af\u00fdB\u00fe\u0010\u00ddn\r\u00e2U\u00ee\u00adX\u00dfl\u0092\u00ca\u0014\u008a\u00bem\t3\u00ed1D,t\u00e8_}\u0010{\u00e5\u00d9\u0093\u00cf\u00c0\u00fe\u009d\u00b5\u00d4\u00df\u00dd\u00bdh\u008b1?\u00bea\u008d\u00c6\u001fQ\u0097:\u0094C3)\u0099U\u009d0\u0082\u00e4\u008d\u0011\u00fe\u00cc\u00c8\u008f\u00fe\u00f1\u00ec\t\u001d6m?o\u0019u\u00ba\u00c2\u00f5\u0084\u00fd\u00be\u00c4\u00e4#\u00b4\u00e8:k5\u000f\u001f\u0086&\u00cf\u00d8y8I\u001e\u00fa-\u00d6\u00b2\bJ-\u000eZ\u00dddC\u00b2\f\u00e8\u008aJ\u00b5H\u00fb\u001fF\u00a0\u00e7/\u00bfF\u0003\u00cb7\u009d\u00e7\u00fe\u00ea\u00e6\u001e\u00ff\u00f2x7wWR'\u00cf9\u00dbz\u00c7[\u00dc\u00ba\u00b0\u0097*\u00cd{M\u00aaW\u001d\u00b0\u001b\u00a0\u008cc\u0016\u00d1\u00ac\u0082\u00d5\u00a6\u00b3,}\u00105\u00ddk\u0091\u00e48\u0007\u00bb\u00f2\u00f81\u00c2\u00c6\u0013\u00cb\u00b4\u0094\u00a0s\u009f\u009f\u001f\u0015{\u00f0\u0085\u00bd0Fz\u00df\u009a\u001f\u00e9\u00a3\u00a6\u00ec\u00c6\u0012\u00b7\u009ft\u00f9\u00b2\u0084\u008d\u0006\u0089\u00e9~\u0097\u007f\u0004\u000b\u0019\u00d3t\u009e\u008f\u009e\u00e7\u00ea\u00bf~\u00c6\u0015\u00bf8\u00a0\u00e0\u00129\u00b8cj\u00af\u00b4\u0084h\u00a7\u0088\u00b0e\u00ed\u00acF\u00a9)!zv\u00a5m4\\\u00fa\u009c\u008aw\u00eb\u00aa\u00ecS\u008a\u00ba\u00b6Q\u00f3\u00d0:g\u0084\u0015\u00e1\\\u000b\u000e%\u00b5_\u00b6\u0006\u00ea\u00f5\u00f5LB\u00a7V\u0007\u009e\u00f9\u008b\u00cf\u00f6$\u00b4\u0007\u00b73\u00ca\u00fa9m[(~\u00ba\u00d1\u009c)y\"t#\u008c\u00aa\u001d2\u00b3\u0002\u00e2\u0097\u0016Z\u00a4\u00d0\u00ee\b\u00d5hwE\u00a2\u001ap\u00ec\u00ecf\u001bn\u00fb\u00df\u00f0\u0094\u00c3\u000f\u001a\u007f\u0013\r\u0099'\u0091| \u0000k\u00dd\u00aa\u00ff\u008f\"%p\u00f6\u00e4}\u001c^\u00ff\u00dc*\u007f\u00ff\u00a8bw\u0095\u00d5|6\u00e8\u00d6Y\u0007\u00b8\u008a2b\u00af\u00ed\u0083k\u008cC\u008f\u000e\u00e9\u00d8m\u00f9V\u00b9h\u00af\u001fz\u008c\u0092Z\u001c\u001bZo\u001c\n\u0083rG\u008a\u00adYW\u00f7q\u0086j\u001f\u00de\u0087\u00ea\u000bv\u0011`\u0017-\u00aa\u00c3\n/\u00f0v\u00fe\u00da\b\u00bf\u00ef\u0019\u0097\u0018:\u00cd\u0010S\u0003\u00e5v&\u0095\u0005\u0092\u00e3pW\u00b6\u00042\u00e5\u00a0>G\u00fc\u001d\u00f9)\u00a05FLk\t\u009c]\u0084~tu\u00ce6@\u00aa\u00a6\u00c7\r\u0018aW\u0018%\u008fG\u00923\u0084~_\u00a5\u00ce\u00870Qp\u00fc\u00f2\u00b1@\t\u00f2\u00ae\t2!u\u001f$>".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 23;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b2\u008b\u0092\rg\u00b7\u008b\u001c\u00f0\u00c0l4[\u0088d\u00eb\u00b4u\u0089\\2v\u0017IS@\u000e\u0000\u0011\u0014\u00f7\u009d\u0017L\u00c4\u009e_\u0083\u0007Z\u00d6\u0090&\u00dd1h\f\u00e4K+";
                    var4_3 = "\u00b2\u008b\u0092\rg\u00b7\u008b\u001c\u00f0\u00c0l4[\u0088d\u00eb\u00b4u\u0089\\2v\u0017IS@\u000e\u0000\u0011\u0014\u00f7\u009d\u0017L\u00c4\u009e_\u0083\u0007Z\u00d6\u0090&\u00dd1h\f\u00e4K+".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 3;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 78;
                            break;
                        }
                        case 1: {
                            v15 = 67;
                            break;
                        }
                        case 2: {
                            v15 = 117;
                            break;
                        }
                        case 3: {
                            v15 = 50;
                            break;
                        }
                        case 4: {
                            v15 = 59;
                            break;
                        }
                        case 5: {
                            v15 = 18;
                            break;
                        }
                        default: {
                            v15 = 66;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3BAD) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 224;
                case 1 -> 126;
                case 2 -> 62;
                case 3 -> 227;
                case 4 -> 112;
                case 5 -> 51;
                case 6 -> 24;
                case 7 -> 134;
                case 8 -> 47;
                case 9 -> 171;
                case 10 -> 189;
                case 11 -> 31;
                case 12 -> 250;
                case 13 -> 127;
                case 14 -> 99;
                case 15 -> 84;
                case 16 -> 237;
                case 17 -> 79;
                case 18 -> 232;
                case 19 -> 42;
                case 20 -> 221;
                case 21 -> 93;
                case 22 -> 4;
                case 23 -> 130;
                case 24 -> 208;
                case 25 -> 213;
                case 26 -> 85;
                case 27 -> 164;
                case 28 -> 219;
                case 29 -> 196;
                case 30 -> 108;
                case 31 -> 80;
                case 32 -> 14;
                case 33 -> 173;
                case 34 -> 82;
                case 35 -> 60;
                case 36 -> 139;
                case 37 -> 58;
                case 38 -> 235;
                case 39 -> 191;
                case 40 -> 122;
                case 41 -> 215;
                case 42 -> 70;
                case 43 -> 48;
                case 44 -> 141;
                case 45 -> 45;
                case 46 -> 225;
                case 47 -> 118;
                case 48 -> 75;
                case 49 -> 76;
                case 50 -> 169;
                case 51 -> 251;
                case 52 -> 109;
                case 53 -> 143;
                case 54 -> 8;
                case 55 -> 25;
                case 56 -> 121;
                case 57 -> 53;
                case 58 -> 71;
                case 59 -> 34;
                case 60 -> 54;
                case 61 -> 39;
                case 62 -> 207;
                case 63 -> 36;
                case 64 -> 22;
                case 65 -> 5;
                case 66 -> 88;
                case 67 -> 163;
                case 68 -> 26;
                case 69 -> 56;
                case 70 -> 37;
                case 71 -> 153;
                case 72 -> 140;
                case 73 -> 145;
                case 74 -> 137;
                case 75 -> 11;
                case 76 -> 205;
                case 77 -> 234;
                case 78 -> 16;
                case 79 -> 103;
                case 80 -> 123;
                case 81 -> 220;
                case 82 -> 116;
                case 83 -> 15;
                case 84 -> 241;
                case 85 -> 149;
                case 86 -> 183;
                case 87 -> 236;
                case 88 -> 186;
                case 89 -> 105;
                case 90 -> 175;
                case 91 -> 124;
                case 92 -> 161;
                case 93 -> 92;
                case 94 -> 133;
                case 95 -> 154;
                case 96 -> 18;
                case 97 -> 107;
                case 98 -> 200;
                case 99 -> 6;
                case 100 -> 119;
                case 101 -> 174;
                case 102 -> 216;
                case 103 -> 86;
                case 104 -> 242;
                case 105 -> 211;
                case 106 -> 228;
                case 107 -> 136;
                case 108 -> 83;
                case 109 -> 65;
                case 110 -> 3;
                case 111 -> 73;
                case 112 -> 197;
                case 113 -> 113;
                case 114 -> 152;
                case 115 -> 179;
                case 116 -> 233;
                case 117 -> 117;
                case 118 -> 166;
                case 119 -> 203;
                case 120 -> 217;
                case 121 -> 38;
                case 122 -> 206;
                case 123 -> 160;
                case 124 -> 30;
                case 125 -> 21;
                case 126 -> 187;
                case 127 -> 202;
                case 128 -> 96;
                case 129 -> 148;
                case 130 -> 244;
                case 131 -> 151;
                case 132 -> 209;
                case 133 -> 9;
                case 134 -> 100;
                case 135 -> 254;
                case 136 -> 17;
                case 137 -> 231;
                case 138 -> 245;
                case 139 -> 255;
                case 140 -> 182;
                case 141 -> 249;
                case 142 -> 87;
                case 143 -> 81;
                case 144 -> 66;
                case 145 -> 129;
                case 146 -> 138;
                case 147 -> 178;
                case 148 -> 194;
                case 149 -> 214;
                case 150 -> 223;
                case 151 -> 180;
                case 152 -> 35;
                case 153 -> 212;
                case 154 -> 12;
                case 155 -> 170;
                case 156 -> 10;
                case 157 -> 195;
                case 158 -> 132;
                case 159 -> 230;
                case 160 -> 33;
                case 161 -> 131;
                case 162 -> 46;
                case 163 -> 106;
                case 164 -> 198;
                case 165 -> 61;
                case 166 -> 89;
                case 167 -> 111;
                case 168 -> 155;
                case 169 -> 150;
                case 170 -> 7;
                case 171 -> 64;
                case 172 -> 243;
                case 173 -> 29;
                case 174 -> 226;
                case 175 -> 72;
                case 176 -> 78;
                case 177 -> 2;
                case 178 -> 248;
                case 179 -> 147;
                case 180 -> 57;
                case 181 -> 246;
                case 182 -> 158;
                case 183 -> 114;
                case 184 -> 28;
                case 185 -> 146;
                case 186 -> 192;
                case 187 -> 190;
                case 188 -> 176;
                case 189 -> 157;
                case 190 -> 68;
                case 191 -> 27;
                case 192 -> 167;
                case 193 -> 229;
                case 194 -> 144;
                case 195 -> 97;
                case 196 -> 110;
                case 197 -> 104;
                case 198 -> 69;
                case 199 -> 218;
                case 200 -> 188;
                case 201 -> 63;
                case 202 -> 95;
                case 203 -> 98;
                case 204 -> 0;
                case 205 -> 23;
                case 206 -> 193;
                case 207 -> 74;
                case 208 -> 181;
                case 209 -> 19;
                case 210 -> 156;
                case 211 -> 253;
                case 212 -> 43;
                case 213 -> 239;
                case 214 -> 40;
                case 215 -> 120;
                case 216 -> 59;
                case 217 -> 247;
                case 218 -> 77;
                case 219 -> 1;
                case 220 -> 165;
                case 221 -> 115;
                case 222 -> 159;
                case 223 -> 199;
                case 224 -> 55;
                case 225 -> 128;
                case 226 -> 162;
                case 227 -> 102;
                case 228 -> 91;
                case 229 -> 90;
                case 230 -> 204;
                case 231 -> 222;
                case 232 -> 185;
                case 233 -> 125;
                case 234 -> 177;
                case 235 -> 44;
                case 236 -> 94;
                case 237 -> 13;
                case 238 -> 172;
                case 239 -> 50;
                case 240 -> 49;
                case 241 -> 142;
                case 242 -> 41;
                case 243 -> 240;
                case 244 -> 238;
                case 245 -> 101;
                case 246 -> 135;
                case 247 -> 184;
                case 248 -> 201;
                case 249 -> 252;
                case 250 -> 67;
                case 251 -> 168;
                case 252 -> 210;
                case 253 -> 20;
                case 254 -> 32;
                default -> 52;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 71183481167727L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1306767900 + (char)-19040, -1306767900 + -((char)-16253), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 12156918093076L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.M();
                            try {
                                hANDLE2 = hANDLE;
                                if (string == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2134343880 - 4866, 2134343880 - 3997, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2134343880 - 4867, 2134343880 - 15108, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2134343880 - 4868, 2134343880 - 29092, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00aey\u0095k\u00cb\u00a7\u0003\u00b7\u0010\u00ffTNo\n\u009c\u00c2\u0089\u00a7QWZo\u001cN*";
                    var4_3 = "\u00aey\u0095k\u00cb\u00a7\u0003\u00b7\u0010\u00ffTNo\n\u009c\u00c2\u0089\u00a7QWZo\u001cN*".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 54;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "u.i\u0006\u00a35\u00bf\u00cd'\u0016\u00b8\r\u000b\u0097n\u00ae{\u00e2\u009afrh\u00e1k\u00c65\u0088\u00d5\u00b8x\u00dc\u0010\u00f3\u001cv\u00b6Q%\u00a4\u00a2\u000b\u0094\u00da\u009a\u008e\u00cb\u000b.\u00dd\u0084F\u00ba&\u00f7\u0001r\u0098\u008c\u00de";
                        var4_3 = "u.i\u0006\u00a35\u00bf\u00cd'\u0016\u00b8\r\u000b\u0097n\u00ae{\u00e2\u009afrh\u00e1k\u00c65\u0088\u00d5\u00b8x\u00dc\u0010\u00f3\u001cv\u00b6Q%\u00a4\u00a2\u000b\u0094\u00da\u009a\u008e\u00cb\u000b.\u00dd\u0084F\u00ba&\u00f7\u0001r\u0098\u008c\u00de".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 120;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 29;
                                break;
                            }
                            case 1: {
                                v15 = 31;
                                break;
                            }
                            case 2: {
                                v15 = 29;
                                break;
                            }
                            case 3: {
                                v15 = 118;
                                break;
                            }
                            case 4: {
                                v15 = 4;
                                break;
                            }
                            case 5: {
                                v15 = 92;
                                break;
                            }
                            default: {
                                v15 = 36;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB8D3) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 97;
                    case 1 -> 159;
                    case 2 -> 188;
                    case 3 -> 106;
                    case 4 -> 235;
                    case 5 -> 138;
                    case 6 -> 245;
                    case 7 -> 238;
                    case 8 -> 6;
                    case 9 -> 132;
                    case 10 -> 178;
                    case 11 -> 117;
                    case 12 -> 9;
                    case 13 -> 252;
                    case 14 -> 61;
                    case 15 -> 171;
                    case 16 -> 112;
                    case 17 -> 175;
                    case 18 -> 170;
                    case 19 -> 48;
                    case 20 -> 166;
                    case 21 -> 130;
                    case 22 -> 76;
                    case 23 -> 145;
                    case 24 -> 250;
                    case 25 -> 205;
                    case 26 -> 223;
                    case 27 -> 184;
                    case 28 -> 91;
                    case 29 -> 151;
                    case 30 -> 226;
                    case 31 -> 77;
                    case 32 -> 87;
                    case 33 -> 83;
                    case 34 -> 101;
                    case 35 -> 191;
                    case 36 -> 208;
                    case 37 -> 64;
                    case 38 -> 194;
                    case 39 -> 152;
                    case 40 -> 214;
                    case 41 -> 201;
                    case 42 -> 93;
                    case 43 -> 128;
                    case 44 -> 176;
                    case 45 -> 72;
                    case 46 -> 237;
                    case 47 -> 197;
                    case 48 -> 18;
                    case 49 -> 203;
                    case 50 -> 141;
                    case 51 -> 3;
                    case 52 -> 161;
                    case 53 -> 109;
                    case 54 -> 163;
                    case 55 -> 224;
                    case 56 -> 14;
                    case 57 -> 155;
                    case 58 -> 94;
                    case 59 -> 100;
                    case 60 -> 158;
                    case 61 -> 105;
                    case 62 -> 209;
                    case 63 -> 173;
                    case 64 -> 220;
                    case 65 -> 82;
                    case 66 -> 86;
                    case 67 -> 51;
                    case 68 -> 79;
                    case 69 -> 222;
                    case 70 -> 119;
                    case 71 -> 47;
                    case 72 -> 136;
                    case 73 -> 144;
                    case 74 -> 168;
                    case 75 -> 75;
                    case 76 -> 17;
                    case 77 -> 69;
                    case 78 -> 185;
                    case 79 -> 121;
                    case 80 -> 23;
                    case 81 -> 179;
                    case 82 -> 67;
                    case 83 -> 207;
                    case 84 -> 199;
                    case 85 -> 187;
                    case 86 -> 22;
                    case 87 -> 123;
                    case 88 -> 181;
                    case 89 -> 137;
                    case 90 -> 41;
                    case 91 -> 49;
                    case 92 -> 12;
                    case 93 -> 37;
                    case 94 -> 114;
                    case 95 -> 88;
                    case 96 -> 32;
                    case 97 -> 19;
                    case 98 -> 193;
                    case 99 -> 153;
                    case 100 -> 213;
                    case 101 -> 71;
                    case 102 -> 31;
                    case 103 -> 195;
                    case 104 -> 103;
                    case 105 -> 156;
                    case 106 -> 162;
                    case 107 -> 34;
                    case 108 -> 192;
                    case 109 -> 40;
                    case 110 -> 229;
                    case 111 -> 253;
                    case 112 -> 215;
                    case 113 -> 20;
                    case 114 -> 129;
                    case 115 -> 247;
                    case 116 -> 160;
                    case 117 -> 118;
                    case 118 -> 11;
                    case 119 -> 115;
                    case 120 -> 216;
                    case 121 -> 186;
                    case 122 -> 99;
                    case 123 -> 139;
                    case 124 -> 233;
                    case 125 -> 107;
                    case 126 -> 58;
                    case 127 -> 81;
                    case 128 -> 133;
                    case 129 -> 43;
                    case 130 -> 52;
                    case 131 -> 50;
                    case 132 -> 30;
                    case 133 -> 25;
                    case 134 -> 60;
                    case 135 -> 120;
                    case 136 -> 234;
                    case 137 -> 251;
                    case 138 -> 16;
                    case 139 -> 8;
                    case 140 -> 68;
                    case 141 -> 113;
                    case 142 -> 44;
                    case 143 -> 189;
                    case 144 -> 54;
                    case 145 -> 217;
                    case 146 -> 42;
                    case 147 -> 56;
                    case 148 -> 95;
                    case 149 -> 240;
                    case 150 -> 230;
                    case 151 -> 92;
                    case 152 -> 110;
                    case 153 -> 89;
                    case 154 -> 157;
                    case 155 -> 116;
                    case 156 -> 183;
                    case 157 -> 126;
                    case 158 -> 147;
                    case 159 -> 135;
                    case 160 -> 241;
                    case 161 -> 164;
                    case 162 -> 46;
                    case 163 -> 196;
                    case 164 -> 122;
                    case 165 -> 246;
                    case 166 -> 33;
                    case 167 -> 204;
                    case 168 -> 2;
                    case 169 -> 38;
                    case 170 -> 66;
                    case 171 -> 125;
                    case 172 -> 65;
                    case 173 -> 142;
                    case 174 -> 218;
                    case 175 -> 148;
                    case 176 -> 78;
                    case 177 -> 62;
                    case 178 -> 1;
                    case 179 -> 70;
                    case 180 -> 255;
                    case 181 -> 254;
                    case 182 -> 59;
                    case 183 -> 169;
                    case 184 -> 104;
                    case 185 -> 143;
                    case 186 -> 146;
                    case 187 -> 124;
                    case 188 -> 7;
                    case 189 -> 190;
                    case 190 -> 98;
                    case 191 -> 225;
                    case 192 -> 212;
                    case 193 -> 57;
                    case 194 -> 198;
                    case 195 -> 239;
                    case 196 -> 165;
                    case 197 -> 73;
                    case 198 -> 244;
                    case 199 -> 172;
                    case 200 -> 21;
                    case 201 -> 248;
                    case 202 -> 35;
                    case 203 -> 228;
                    case 204 -> 134;
                    case 205 -> 167;
                    case 206 -> 108;
                    case 207 -> 236;
                    case 208 -> 242;
                    case 209 -> 154;
                    case 210 -> 182;
                    case 211 -> 27;
                    case 212 -> 140;
                    case 213 -> 232;
                    case 214 -> 219;
                    case 215 -> 13;
                    case 216 -> 102;
                    case 217 -> 111;
                    case 218 -> 80;
                    case 219 -> 45;
                    case 220 -> 28;
                    case 221 -> 63;
                    case 222 -> 39;
                    case 223 -> 174;
                    case 224 -> 231;
                    case 225 -> 150;
                    case 226 -> 10;
                    case 227 -> 211;
                    case 228 -> 84;
                    case 229 -> 149;
                    case 230 -> 210;
                    case 231 -> 0;
                    case 232 -> 243;
                    case 233 -> 249;
                    case 234 -> 53;
                    case 235 -> 5;
                    case 236 -> 26;
                    case 237 -> 206;
                    case 238 -> 29;
                    case 239 -> 15;
                    case 240 -> 127;
                    case 241 -> 200;
                    case 242 -> 55;
                    case 243 -> 177;
                    case 244 -> 4;
                    case 245 -> 90;
                    case 246 -> 221;
                    case 247 -> 131;
                    case 248 -> 36;
                    case 249 -> 202;
                    case 250 -> 180;
                    case 251 -> 74;
                    case 252 -> 96;
                    case 253 -> 24;
                    case 254 -> 85;
                    default -> 227;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 116287434334178L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "1g\u007fh9a\u0013h\t6mlbt#\u000et+";
                    var5_4 = "1g\u007fh9a\u0013h\t6mlbt#\u000et+".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 74;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 16;
                                    break;
                                }
                                case 1: {
                                    v11 = 72;
                                    break;
                                }
                                case 2: {
                                    v11 = 71;
                                    break;
                                }
                                case 3: {
                                    v11 = 76;
                                    break;
                                }
                                case 4: {
                                    v11 = 22;
                                    break;
                                }
                                case 5: {
                                    v11 = 71;
                                    break;
                                }
                                default: {
                                    v11 = 106;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 28591458076934L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "40L >\u0011\t\u00042.@:\n>1K:2\u0013\u0011\u00140B\t>1K:2\u0013\u0011\u0018:\r97V78\u001e\u000b\u0018=Q=9\u0017";
                    var5_4 = "40L >\u0011\t\u00042.@:\n>1K:2\u0013\u0011\u00140B\t>1K:2\u0013\u0011\u0018:\r97V78\u001e\u000b\u0018=Q=9\u0017".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 1;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "YU-@Yye\u0006YU-@Us";
                        var5_4 = "YU-@Yye\u0006YU-@Us".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 102;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 95;
                                break;
                            }
                            case 2: {
                                v15 = 36;
                                break;
                            }
                            case 3: {
                                v15 = 85;
                                break;
                            }
                            case 4: {
                                v15 = 86;
                                break;
                            }
                            case 5: {
                                v15 = 113;
                                break;
                            }
                            default: {
                                v15 = 100;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 105809592094356L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1222227750 - -((char)-19286), 1222227750 - 25109, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 100264873696855L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00bc4\u00e3a)\u0003\u00fe\u0017\u001f\u0005\u00a15f\u0085z\r\u00a7\u00b9\u0090^QV`]\u00d2]})\u00b5\u0010\u009eJp\u00cbrq/\u0084\u00f2\u00e2\u009a\u0093\u00af\u00c7\u00e6\u00b9\u0005\u00d2\u0094\b\u00b1\u00b73\u0015~\u00e1\u009b\u0095?\u00e3Y\u0016\u00a4\u008dr\u008b\u00aaN\u000b\u00c3\u00fc\u00cd9+e\u00c5sX\u00d6t\u00f7\u000f\u0010\u00d4L\u00ed\u00d7\u00a7f\u00da\u0013\u00de\u00c8bq\u00d62\u00c3\u00fe\u00c0\u00ab1\u00fe\u0001";
                    var4_3 = "\u00bc4\u00e3a)\u0003\u00fe\u0017\u001f\u0005\u00a15f\u0085z\r\u00a7\u00b9\u0090^QV`]\u00d2]})\u00b5\u0010\u009eJp\u00cbrq/\u0084\u00f2\u00e2\u009a\u0093\u00af\u00c7\u00e6\u00b9\u0005\u00d2\u0094\b\u00b1\u00b73\u0015~\u00e1\u009b\u0095?\u00e3Y\u0016\u00a4\u008dr\u008b\u00aaN\u000b\u00c3\u00fc\u00cd9+e\u00c5sX\u00d6t\u00f7\u000f\u0010\u00d4L\u00ed\u00d7\u00a7f\u00da\u0013\u00de\u00c8bq\u00d62\u00c3\u00fe\u00c0\u00ab1\u00fe\u0001".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0012T\u00c5,\u00e0\u00a9Y\u00bb\u0018!\u00e3\u00cf\u00a4h\u00a3hLdz\u00fc#\u00ed\u0080\u0096\u00f0h\u00dbA)\u00fe:{[D\u0003\u00e6\u0014\u0002\u0080\u00eeI:^9\u0004x\u0003\u00f1e}8\u00e0\u00a3$Q\u001f\u00c2H\u00e9xx'M\u00b3\u00c1\u0089\u00a3\u00da\u00938\u0018z3c\u008d\u008b\u00d2\u00075\u001d\u00cbY\u00a5n\u0098q\u00f7\u00dc2_\u0011\u0088\u00c1";
                        var4_3 = "\u0012T\u00c5,\u00e0\u00a9Y\u00bb\u0018!\u00e3\u00cf\u00a4h\u00a3hLdz\u00fc#\u00ed\u0080\u0096\u00f0h\u00dbA)\u00fe:{[D\u0003\u00e6\u0014\u0002\u0080\u00eeI:^9\u0004x\u0003\u00f1e}8\u00e0\u00a3$Q\u001f\u00c2H\u00e9xx'M\u00b3\u00c1\u0089\u00a3\u00da\u00938\u0018z3c\u008d\u008b\u00d2\u00075\u001d\u00cbY\u00a5n\u0098q\u00f7\u00dc2_\u0011\u0088\u00c1".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 65;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 120;
                                break;
                            }
                            case 1: {
                                v15 = 40;
                                break;
                            }
                            case 2: {
                                v15 = 30;
                                break;
                            }
                            case 3: {
                                v15 = 74;
                                break;
                            }
                            case 4: {
                                v15 = 102;
                                break;
                            }
                            case 5: {
                                v15 = 31;
                                break;
                            }
                            default: {
                                v15 = 55;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7310) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 78;
                    case 1 -> 209;
                    case 2 -> 92;
                    case 3 -> 22;
                    case 4 -> 59;
                    case 5 -> 83;
                    case 6 -> 5;
                    case 7 -> 152;
                    case 8 -> 243;
                    case 9 -> 236;
                    case 10 -> 86;
                    case 11 -> 69;
                    case 12 -> 175;
                    case 13 -> 98;
                    case 14 -> 178;
                    case 15 -> 148;
                    case 16 -> 91;
                    case 17 -> 241;
                    case 18 -> 4;
                    case 19 -> 251;
                    case 20 -> 190;
                    case 21 -> 248;
                    case 22 -> 226;
                    case 23 -> 54;
                    case 24 -> 116;
                    case 25 -> 155;
                    case 26 -> 32;
                    case 27 -> 189;
                    case 28 -> 111;
                    case 29 -> 150;
                    case 30 -> 30;
                    case 31 -> 179;
                    case 32 -> 105;
                    case 33 -> 16;
                    case 34 -> 123;
                    case 35 -> 115;
                    case 36 -> 253;
                    case 37 -> 74;
                    case 38 -> 234;
                    case 39 -> 219;
                    case 40 -> 224;
                    case 41 -> 124;
                    case 42 -> 48;
                    case 43 -> 186;
                    case 44 -> 113;
                    case 45 -> 141;
                    case 46 -> 138;
                    case 47 -> 119;
                    case 48 -> 104;
                    case 49 -> 102;
                    case 50 -> 191;
                    case 51 -> 38;
                    case 52 -> 7;
                    case 53 -> 42;
                    case 54 -> 149;
                    case 55 -> 205;
                    case 56 -> 180;
                    case 57 -> 65;
                    case 58 -> 26;
                    case 59 -> 84;
                    case 60 -> 249;
                    case 61 -> 93;
                    case 62 -> 161;
                    case 63 -> 194;
                    case 64 -> 214;
                    case 65 -> 108;
                    case 66 -> 140;
                    case 67 -> 173;
                    case 68 -> 198;
                    case 69 -> 8;
                    case 70 -> 122;
                    case 71 -> 211;
                    case 72 -> 82;
                    case 73 -> 34;
                    case 74 -> 56;
                    case 75 -> 66;
                    case 76 -> 29;
                    case 77 -> 229;
                    case 78 -> 73;
                    case 79 -> 130;
                    case 80 -> 208;
                    case 81 -> 165;
                    case 82 -> 145;
                    case 83 -> 213;
                    case 84 -> 13;
                    case 85 -> 125;
                    case 86 -> 252;
                    case 87 -> 24;
                    case 88 -> 244;
                    case 89 -> 95;
                    case 90 -> 195;
                    case 91 -> 127;
                    case 92 -> 246;
                    case 93 -> 156;
                    case 94 -> 231;
                    case 95 -> 221;
                    case 96 -> 51;
                    case 97 -> 96;
                    case 98 -> 63;
                    case 99 -> 37;
                    case 100 -> 110;
                    case 101 -> 88;
                    case 102 -> 167;
                    case 103 -> 230;
                    case 104 -> 164;
                    case 105 -> 176;
                    case 106 -> 187;
                    case 107 -> 9;
                    case 108 -> 182;
                    case 109 -> 177;
                    case 110 -> 27;
                    case 111 -> 71;
                    case 112 -> 77;
                    case 113 -> 159;
                    case 114 -> 222;
                    case 115 -> 52;
                    case 116 -> 185;
                    case 117 -> 227;
                    case 118 -> 15;
                    case 119 -> 233;
                    case 120 -> 240;
                    case 121 -> 184;
                    case 122 -> 225;
                    case 123 -> 121;
                    case 124 -> 55;
                    case 125 -> 79;
                    case 126 -> 6;
                    case 127 -> 90;
                    case 128 -> 158;
                    case 129 -> 103;
                    case 130 -> 207;
                    case 131 -> 109;
                    case 132 -> 99;
                    case 133 -> 147;
                    case 134 -> 170;
                    case 135 -> 216;
                    case 136 -> 232;
                    case 137 -> 21;
                    case 138 -> 162;
                    case 139 -> 107;
                    case 140 -> 201;
                    case 141 -> 157;
                    case 142 -> 97;
                    case 143 -> 255;
                    case 144 -> 188;
                    case 145 -> 17;
                    case 146 -> 114;
                    case 147 -> 250;
                    case 148 -> 58;
                    case 149 -> 43;
                    case 150 -> 172;
                    case 151 -> 206;
                    case 152 -> 36;
                    case 153 -> 23;
                    case 154 -> 94;
                    case 155 -> 61;
                    case 156 -> 163;
                    case 157 -> 75;
                    case 158 -> 192;
                    case 159 -> 31;
                    case 160 -> 168;
                    case 161 -> 210;
                    case 162 -> 239;
                    case 163 -> 254;
                    case 164 -> 47;
                    case 165 -> 193;
                    case 166 -> 212;
                    case 167 -> 3;
                    case 168 -> 46;
                    case 169 -> 174;
                    case 170 -> 118;
                    case 171 -> 25;
                    case 172 -> 14;
                    case 173 -> 85;
                    case 174 -> 62;
                    case 175 -> 242;
                    case 176 -> 19;
                    case 177 -> 0;
                    case 178 -> 144;
                    case 179 -> 215;
                    case 180 -> 68;
                    case 181 -> 45;
                    case 182 -> 202;
                    case 183 -> 28;
                    case 184 -> 101;
                    case 185 -> 126;
                    case 186 -> 204;
                    case 187 -> 11;
                    case 188 -> 171;
                    case 189 -> 117;
                    case 190 -> 44;
                    case 191 -> 106;
                    case 192 -> 35;
                    case 193 -> 1;
                    case 194 -> 131;
                    case 195 -> 247;
                    case 196 -> 160;
                    case 197 -> 151;
                    case 198 -> 70;
                    case 199 -> 57;
                    case 200 -> 76;
                    case 201 -> 183;
                    case 202 -> 203;
                    case 203 -> 166;
                    case 204 -> 80;
                    case 205 -> 197;
                    case 206 -> 134;
                    case 207 -> 199;
                    case 208 -> 129;
                    case 209 -> 153;
                    case 210 -> 49;
                    case 211 -> 39;
                    case 212 -> 132;
                    case 213 -> 218;
                    case 214 -> 72;
                    case 215 -> 181;
                    case 216 -> 237;
                    case 217 -> 133;
                    case 218 -> 245;
                    case 219 -> 235;
                    case 220 -> 81;
                    case 221 -> 238;
                    case 222 -> 169;
                    case 223 -> 12;
                    case 224 -> 33;
                    case 225 -> 135;
                    case 226 -> 136;
                    case 227 -> 228;
                    case 228 -> 217;
                    case 229 -> 64;
                    case 230 -> 143;
                    case 231 -> 89;
                    case 232 -> 67;
                    case 233 -> 41;
                    case 234 -> 220;
                    case 235 -> 139;
                    case 236 -> 40;
                    case 237 -> 200;
                    case 238 -> 146;
                    case 239 -> 50;
                    case 240 -> 20;
                    case 241 -> 223;
                    case 242 -> 10;
                    case 243 -> 100;
                    case 244 -> 60;
                    case 245 -> 18;
                    case 246 -> 53;
                    case 247 -> 87;
                    case 248 -> 112;
                    case 249 -> 154;
                    case 250 -> 137;
                    case 251 -> 120;
                    case 252 -> 2;
                    case 253 -> 128;
                    case 254 -> 142;
                    default -> 196;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 98432055892300L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(4587450 + 5044, -4587450 + -7332, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 106496882678528L;
                    String string = SshAgentIpcService.M();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1126415580 - 27577, 1126415580 - 30683, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 69739401939413L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "}<[\u00e0'\u0003\u00a0\u00cf\u00b6";
                var4_3 = "}<[\u00e0'\u0003\u00a0\u00cf\u00b6".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 116;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 105;
                                break;
                            }
                            case 1: {
                                v11 = 98;
                                break;
                            }
                            case 2: {
                                v11 = 11;
                                break;
                            }
                            case 3: {
                                v11 = 52;
                                break;
                            }
                            case 4: {
                                v11 = 106;
                                break;
                            }
                            case 5: {
                                v11 = 75;
                                break;
                            }
                            default: {
                                v11 = 3;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCA22) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 149;
                    case 1 -> 100;
                    case 2 -> 115;
                    case 3 -> 12;
                    case 4 -> 18;
                    case 5 -> 72;
                    case 6 -> 240;
                    case 7 -> 3;
                    case 8 -> 249;
                    case 9 -> 41;
                    case 10 -> 94;
                    case 11 -> 59;
                    case 12 -> 32;
                    case 13 -> 116;
                    case 14 -> 168;
                    case 15 -> 218;
                    case 16 -> 113;
                    case 17 -> 55;
                    case 18 -> 238;
                    case 19 -> 58;
                    case 20 -> 75;
                    case 21 -> 184;
                    case 22 -> 220;
                    case 23 -> 25;
                    case 24 -> 114;
                    case 25 -> 28;
                    case 26 -> 40;
                    case 27 -> 81;
                    case 28 -> 246;
                    case 29 -> 176;
                    case 30 -> 9;
                    case 31 -> 244;
                    case 32 -> 78;
                    case 33 -> 104;
                    case 34 -> 155;
                    case 35 -> 83;
                    case 36 -> 120;
                    case 37 -> 201;
                    case 38 -> 170;
                    case 39 -> 231;
                    case 40 -> 232;
                    case 41 -> 160;
                    case 42 -> 208;
                    case 43 -> 174;
                    case 44 -> 30;
                    case 45 -> 162;
                    case 46 -> 179;
                    case 47 -> 88;
                    case 48 -> 225;
                    case 49 -> 152;
                    case 50 -> 135;
                    case 51 -> 182;
                    case 52 -> 139;
                    case 53 -> 106;
                    case 54 -> 93;
                    case 55 -> 230;
                    case 56 -> 159;
                    case 57 -> 243;
                    case 58 -> 214;
                    case 59 -> 254;
                    case 60 -> 67;
                    case 61 -> 194;
                    case 62 -> 47;
                    case 63 -> 57;
                    case 64 -> 24;
                    case 65 -> 99;
                    case 66 -> 62;
                    case 67 -> 148;
                    case 68 -> 124;
                    case 69 -> 71;
                    case 70 -> 20;
                    case 71 -> 169;
                    case 72 -> 74;
                    case 73 -> 33;
                    case 74 -> 216;
                    case 75 -> 118;
                    case 76 -> 92;
                    case 77 -> 31;
                    case 78 -> 138;
                    case 79 -> 95;
                    case 80 -> 8;
                    case 81 -> 228;
                    case 82 -> 61;
                    case 83 -> 171;
                    case 84 -> 87;
                    case 85 -> 101;
                    case 86 -> 163;
                    case 87 -> 227;
                    case 88 -> 200;
                    case 89 -> 10;
                    case 90 -> 241;
                    case 91 -> 219;
                    case 92 -> 177;
                    case 93 -> 49;
                    case 94 -> 140;
                    case 95 -> 199;
                    case 96 -> 237;
                    case 97 -> 186;
                    case 98 -> 247;
                    case 99 -> 251;
                    case 100 -> 207;
                    case 101 -> 202;
                    case 102 -> 27;
                    case 103 -> 245;
                    case 104 -> 54;
                    case 105 -> 91;
                    case 106 -> 69;
                    case 107 -> 127;
                    case 108 -> 26;
                    case 109 -> 60;
                    case 110 -> 156;
                    case 111 -> 35;
                    case 112 -> 82;
                    case 113 -> 213;
                    case 114 -> 224;
                    case 115 -> 195;
                    case 116 -> 211;
                    case 117 -> 242;
                    case 118 -> 37;
                    case 119 -> 131;
                    case 120 -> 252;
                    case 121 -> 68;
                    case 122 -> 161;
                    case 123 -> 96;
                    case 124 -> 203;
                    case 125 -> 248;
                    case 126 -> 98;
                    case 127 -> 198;
                    case 128 -> 52;
                    case 129 -> 187;
                    case 130 -> 178;
                    case 131 -> 189;
                    case 132 -> 73;
                    case 133 -> 133;
                    case 134 -> 76;
                    case 135 -> 19;
                    case 136 -> 165;
                    case 137 -> 0;
                    case 138 -> 117;
                    case 139 -> 97;
                    case 140 -> 65;
                    case 141 -> 129;
                    case 142 -> 253;
                    case 143 -> 144;
                    case 144 -> 48;
                    case 145 -> 125;
                    case 146 -> 235;
                    case 147 -> 110;
                    case 148 -> 132;
                    case 149 -> 86;
                    case 150 -> 77;
                    case 151 -> 44;
                    case 152 -> 158;
                    case 153 -> 17;
                    case 154 -> 233;
                    case 155 -> 215;
                    case 156 -> 34;
                    case 157 -> 79;
                    case 158 -> 234;
                    case 159 -> 217;
                    case 160 -> 45;
                    case 161 -> 21;
                    case 162 -> 39;
                    case 163 -> 167;
                    case 164 -> 29;
                    case 165 -> 23;
                    case 166 -> 85;
                    case 167 -> 56;
                    case 168 -> 64;
                    case 169 -> 105;
                    case 170 -> 229;
                    case 171 -> 111;
                    case 172 -> 188;
                    case 173 -> 212;
                    case 174 -> 222;
                    case 175 -> 185;
                    case 176 -> 36;
                    case 177 -> 239;
                    case 178 -> 53;
                    case 179 -> 50;
                    case 180 -> 153;
                    case 181 -> 192;
                    case 182 -> 128;
                    case 183 -> 190;
                    case 184 -> 63;
                    case 185 -> 4;
                    case 186 -> 7;
                    case 187 -> 147;
                    case 188 -> 143;
                    case 189 -> 51;
                    case 190 -> 226;
                    case 191 -> 130;
                    case 192 -> 196;
                    case 193 -> 121;
                    case 194 -> 16;
                    case 195 -> 14;
                    case 196 -> 136;
                    case 197 -> 46;
                    case 198 -> 210;
                    case 199 -> 250;
                    case 200 -> 164;
                    case 201 -> 108;
                    case 202 -> 6;
                    case 203 -> 38;
                    case 204 -> 193;
                    case 205 -> 145;
                    case 206 -> 2;
                    case 207 -> 122;
                    case 208 -> 157;
                    case 209 -> 123;
                    case 210 -> 80;
                    case 211 -> 22;
                    case 212 -> 89;
                    case 213 -> 204;
                    case 214 -> 175;
                    case 215 -> 112;
                    case 216 -> 84;
                    case 217 -> 197;
                    case 218 -> 13;
                    case 219 -> 236;
                    case 220 -> 154;
                    case 221 -> 11;
                    case 222 -> 150;
                    case 223 -> 126;
                    case 224 -> 1;
                    case 225 -> 172;
                    case 226 -> 119;
                    case 227 -> 15;
                    case 228 -> 107;
                    case 229 -> 183;
                    case 230 -> 103;
                    case 231 -> 173;
                    case 232 -> 141;
                    case 233 -> 209;
                    case 234 -> 181;
                    case 235 -> 70;
                    case 236 -> 137;
                    case 237 -> 221;
                    case 238 -> 151;
                    case 239 -> 191;
                    case 240 -> 66;
                    case 241 -> 205;
                    case 242 -> 134;
                    case 243 -> 42;
                    case 244 -> 166;
                    case 245 -> 90;
                    case 246 -> 102;
                    case 247 -> 43;
                    case 248 -> 146;
                    case 249 -> 206;
                    case 250 -> 180;
                    case 251 -> 142;
                    case 252 -> 109;
                    case 253 -> 5;
                    case 254 -> 255;
                    default -> 223;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

