/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.GoParserDefinition;
import com.goide.comments.GoCommentLine;
import com.goide.comments.GoCommentListItemType;
import com.goide.comments.GoCommentParser;
import com.goide.comments.GoCommentSpan;
import com.goide.comments.GoCommentSpanType;
import com.goide.comments.GoLinkDefinition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCommentBlock {
    private static final TextRange SYNTHETIC_COMMENT_RANGE = TextRange.create((int)0, (int)2);
    private final List<GoCommentSpan> mySpans;
    private final int myMinCommonIndent;
    private final Map<String, GoLinkDefinition> myLinks;

    public GoCommentBlock(@NotNull List<GoCommentSpan> spans, int minCommonIndent, @NotNull Map<String, GoLinkDefinition> links) {
        if (spans == null) {
            GoCommentBlock.$$$reportNull$$$0(0);
        }
        if (links == null) {
            GoCommentBlock.$$$reportNull$$$0(1);
        }
        this.mySpans = spans;
        this.myMinCommonIndent = minCommonIndent;
        this.myLinks = links;
    }

    public int getMinCommonIndent() {
        return this.myMinCommonIndent;
    }

    public boolean isIndented(@NotNull GoCommentSpan span) {
        if (span == null) {
            GoCommentBlock.$$$reportNull$$$0(2);
        }
        if (span.getMinCommonIndent() > this.myMinCommonIndent) {
            return true;
        }
        if (span.isIndentedWithTab()) {
            for (GoCommentSpan s : this.mySpans) {
                if (s.isIndentedWithTab() || s.isBlank()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public GoCommentSpanType getSpanType(int offsetInDocument) {
        for (GoCommentSpan s : this.mySpans) {
            if (!s.getRangeInDocument().contains(offsetInDocument)) continue;
            return s.getType();
        }
        return null;
    }

    @NotNull
    public List<GoCommentSpan> getSpans() {
        List<GoCommentSpan> list = this.mySpans;
        if (list == null) {
            GoCommentBlock.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Map<String, GoLinkDefinition> getLinks() {
        Map<String, GoLinkDefinition> map = this.myLinks;
        if (map == null) {
            GoCommentBlock.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public static GoCommentBlock parse(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoCommentBlock.$$$reportNull$$$0(5);
        }
        if (comments.isEmpty()) {
            return new GoCommentBlock(Collections.emptyList(), 0, Collections.emptyMap());
        }
        GoCommentBlock initial = GoCommentBlock.getInitialSpans(comments);
        GoCommentBlock split = GoCommentBlock.splitOnIncreasedIndentBoundaries(initial);
        GoCommentBlock merged = GoCommentBlock.mergeIndentedBlocks(split);
        return GoCommentBlock.detectLinksAndSpanTypes(merged);
    }

    @NotNull
    private static GoCommentBlock splitOnIncreasedIndentBoundaries(@NotNull GoCommentBlock block) {
        if (block == null) {
            GoCommentBlock.$$$reportNull$$$0(6);
        }
        ArrayList<GoCommentSpan> splitSpans = new ArrayList<GoCommentSpan>();
        for (GoCommentSpan span : block.getSpans()) {
            if (!block.isIndented(span) && span.hasLinesWithIncreasedIndent()) {
                int spanIndent = span.getMinCommonIndent();
                GoCommentSpan subSpan = null;
                for (GoCommentLine line : span.getLines()) {
                    boolean inIndentedSubSpan;
                    boolean inUnindentedSubSpan = subSpan != null && subSpan.getMinCommonIndent() == spanIndent;
                    boolean bl = inIndentedSubSpan = subSpan != null && subSpan.getMinCommonIndent() > spanIndent;
                    if (subSpan == null || inUnindentedSubSpan && line.getIndent() > spanIndent || inIndentedSubSpan && line.getIndent() == spanIndent) {
                        subSpan = new GoCommentSpan();
                        splitSpans.add(subSpan);
                    }
                    subSpan.addLine(line);
                }
                continue;
            }
            splitSpans.add(span);
        }
        return new GoCommentBlock(splitSpans, block.getMinCommonIndent(), block.getLinks());
    }

    @NotNull
    private static GoCommentBlock detectLinksAndSpanTypes(@NotNull GoCommentBlock block) {
        if (block == null) {
            GoCommentBlock.$$$reportNull$$$0(7);
        }
        List<GoCommentSpan> spans = block.getSpans();
        boolean treatTabAsIndent = ContainerUtil.exists(spans, it -> !it.isIndentedWithTab());
        HashMap<String, GoLinkDefinition> links = new HashMap<String, GoLinkDefinition>();
        for (GoCommentSpan p : spans) {
            HashMap<String, GoLinkDefinition> spanLinks = new HashMap<String, GoLinkDefinition>();
            for (GoCommentLine line : p.getLines()) {
                if (GoCommentBlock.parseLinkDef(line, spanLinks, block.getMinCommonIndent())) continue;
                spanLinks.clear();
                break;
            }
            if (spanLinks.isEmpty()) {
                p.setType(GoCommentBlock.getSpanType(p, block.getMinCommonIndent(), treatTabAsIndent));
                continue;
            }
            p.setType(GoCommentSpanType.LINKS);
            links.putAll(spanLinks);
        }
        return new GoCommentBlock(spans, block.getMinCommonIndent(), links);
    }

    @NotNull
    private static GoCommentBlock mergeIndentedBlocks(@NotNull GoCommentBlock block) {
        if (block == null) {
            GoCommentBlock.$$$reportNull$$$0(8);
        }
        List<GoCommentSpan> blockSpans = block.getSpans();
        ArrayList<GoCommentSpan> mergedSpans = new ArrayList<GoCommentSpan>();
        for (int i = 0; i < blockSpans.size(); ++i) {
            GoCommentSpan span = blockSpans.get(i);
            if (span.isBlank()) continue;
            if (block.isIndented(span)) {
                while (i < blockSpans.size() - 2) {
                    GoCommentSpan next1 = blockSpans.get(i + 1);
                    GoCommentSpan next2 = blockSpans.get(i + 2);
                    if (!next1.isBlank() || !block.isIndented(next2)) break;
                    for (GoCommentLine line : next1.getLines()) {
                        span.addLine(line);
                    }
                    for (GoCommentLine line : next2.getLines()) {
                        span.addLine(line);
                    }
                    i += 2;
                }
                mergedSpans.add(span);
                continue;
            }
            mergedSpans.add(span);
        }
        return new GoCommentBlock(mergedSpans, block.getMinCommonIndent(), block.getLinks());
    }

    @NotNull
    private static GoCommentBlock getInitialSpans(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoCommentBlock.$$$reportNull$$$0(9);
        }
        ArrayList<GoCommentSpan> spans = new ArrayList<GoCommentSpan>();
        GoCommentSpan currentSpan = null;
        int minCommonIndent = Integer.MAX_VALUE;
        List<GoCommentLine> lines = GoCommentBlock.getCommentLines(comments);
        for (GoCommentLine line : lines) {
            boolean isSyntheticSeparatorComment;
            boolean bl = isSyntheticSeparatorComment = !line.getComment().isPhysical() && line.getRangeInDocument().equals((Object)SYNTHETIC_COMMENT_RANGE);
            if (currentSpan == null || currentSpan.isBlank() != line.isBlank() || isSyntheticSeparatorComment) {
                currentSpan = new GoCommentSpan();
                spans.add(currentSpan);
            }
            if (!isSyntheticSeparatorComment) {
                currentSpan.addLine(line);
            }
            if (line.isBlank()) continue;
            minCommonIndent = Math.min(minCommonIndent, line.getIndent());
        }
        return new GoCommentBlock(spans, minCommonIndent, Collections.emptyMap());
    }

    @NotNull
    private static List<GoCommentLine> getCommentLines(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoCommentBlock.$$$reportNull$$$0(10);
        }
        ArrayList<GoCommentLine> result = new ArrayList<GoCommentLine>();
        for (PsiComment c : comments) {
            String commentText = c.getText();
            if (c.getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT) {
                result.add(new GoCommentLine(c, 0, commentText.length()));
                continue;
            }
            int lineStartOffset = 0;
            for (String line : commentText.lines().toList()) {
                result.add(new GoCommentLine(c, lineStartOffset, lineStartOffset + line.length()));
                lineStartOffset += line.length() + 1;
            }
        }
        ArrayList<GoCommentLine> arrayList = result;
        if (arrayList == null) {
            GoCommentBlock.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static GoCommentSpanType getSpanType(@NotNull GoCommentSpan span, int minCommonIndent, boolean treatTabAsIndent) {
        String loneLineText;
        if (span == null) {
            GoCommentBlock.$$$reportNull$$$0(12);
        }
        if (span.isIndented(minCommonIndent) || treatTabAsIndent && span.isIndentedWithTab()) {
            GoCommentLine firstLine = (GoCommentLine)ContainerUtil.getFirstItem(span.getLines());
            GoCommentListItemType listItemType = firstLine != null ? firstLine.getListItemType() : null;
            GoCommentSpanType goCommentSpanType = listItemType != null ? GoCommentSpanType.LIST : GoCommentSpanType.CODE;
            if (goCommentSpanType == null) {
                GoCommentBlock.$$$reportNull$$$0(13);
            }
            return goCommentSpanType;
        }
        GoCommentLine loneLine = (GoCommentLine)ContainerUtil.getOnlyItem(span.getLines());
        String string = loneLineText = loneLine != null ? StringUtil.trim((String)loneLine.getLineText()) : null;
        if (loneLineText != null && loneLineText.startsWith("# ")) {
            GoCommentSpanType goCommentSpanType = GoCommentSpanType.HEADING;
            if (goCommentSpanType == null) {
                GoCommentBlock.$$$reportNull$$$0(14);
            }
            return goCommentSpanType;
        }
        GoCommentSpanType goCommentSpanType = GoCommentSpanType.TEXT;
        if (goCommentSpanType == null) {
            GoCommentBlock.$$$reportNull$$$0(15);
        }
        return goCommentSpanType;
    }

    private static boolean parseLinkDef(@NotNull GoCommentLine commentLine, @NotNull Map<String, GoLinkDefinition> linkDefs, int indent) {
        String line;
        if (commentLine == null) {
            GoCommentBlock.$$$reportNull$$$0(16);
        }
        if (linkDefs == null) {
            GoCommentBlock.$$$reportNull$$$0(17);
        }
        if ((line = commentLine.getLineText()).isEmpty() || line.length() < indent) {
            return false;
        }
        if ((line = line.substring(indent)).charAt(0) != '[') {
            return false;
        }
        int rbrack = line.indexOf("]:");
        if (rbrack == -1 || rbrack + 3 > line.length() || line.charAt(rbrack + 2) != ' ' && line.charAt(rbrack + 2) != '\t') {
            return false;
        }
        String url = line.substring(rbrack + 3).trim();
        int schemeEnd = url.indexOf("://");
        if (schemeEnd == -1) {
            return false;
        }
        if (!GoCommentParser.URL_PREFIXES.contains(url.substring(0, schemeEnd))) {
            return false;
        }
        String linkText = line.substring(1, rbrack);
        linkDefs.put(linkText, new GoLinkDefinition(commentLine.getComment(), commentLine.getLineTextStartOffset() + indent + 1, linkText, url));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 11, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spans";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoCommentBlock";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkDefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoCommentBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpans";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinks";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentLines";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpanType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIndented";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitOnIncreasedIndentBoundaries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectLinksAndSpanTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeIndentedBlocks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSpans";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommentLines";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSpanType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseLinkDef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 11, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

