/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.comments.GoCommentBlock;
import com.goide.comments.GoCommentDocLinkReference;
import com.goide.comments.GoCommentParser;
import com.goide.comments.GoCommentReferenceResolveContext;
import com.goide.comments.GoCommentReferenceResolver;
import com.goide.comments.GoCommentSpanType;
import com.goide.comments.GoCommentTextLinkReference;
import com.goide.comments.GoCommentToken;
import com.goide.comments.GoCommentWordChainReference;
import com.goide.comments.GoCommentWordReference;
import com.goide.comments.GoDocLinkToken;
import com.goide.comments.GoTextLinkToken;
import com.goide.comments.GoWordChainCommentToken;
import com.goide.directiveComment.GoDirectiveCommentArgument;
import com.goide.directiveComment.GoEmbedComment;
import com.goide.documentation.GoDocUtil;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCommentReferenceContributor
extends PsiReferenceContributor {
    private static final Key<CachedValue<Ref<CommentedElementInfo>>> COMMENTED_ELEMENT = Key.create((String)"go.commented.element");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            GoCommentReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(GoFile.class)), (PsiReferenceProvider)new GoCommentReferenceProvider());
    }

    private static boolean shouldAddReferencesForCommentedElement(@Nullable PsiElement commentedElement) {
        if (commentedElement instanceof GoMethodSpec || commentedElement instanceof GoFieldDeclaration) {
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)commentedElement, GoTypeSpec.class);
            return GoPsiUtil.isTopLevelDeclaration(typeSpec);
        }
        return GoPsiUtil.isTopLevelDeclaration(commentedElement);
    }

    @NotNull
    private static CommentedElementInfo findCommentedElement(@NotNull GoFile file, @NotNull PsiComment comment) {
        Ref cached;
        CommentedElementInfo info;
        if (file == null) {
            GoCommentReferenceContributor.$$$reportNull$$$0(1);
        }
        if (comment == null) {
            GoCommentReferenceContributor.$$$reportNull$$$0(2);
        }
        if ((info = (CommentedElementInfo)(cached = (Ref)CachedValuesManager.getCachedValue((PsiElement)file, COMMENTED_ELEMENT, () -> CachedValueProvider.Result.create((Object)Ref.create(), (Object[])new Object[]{file}))).get()) != null && info.contains(comment)) {
            CommentedElementInfo commentedElementInfo = info;
            if (commentedElementInfo == null) {
                GoCommentReferenceContributor.$$$reportNull$$$0(3);
            }
            return commentedElementInfo;
        }
        Ref lastVisitedCommentRef = Ref.create();
        PsiElement element = GoDocUtil.findCommentedElement(comment, (Ref<PsiComment>)lastVisitedCommentRef);
        if (element == null) {
            PsiComment lastVisited = (PsiComment)lastVisitedCommentRef.get();
            int rangeStart = comment.getTextRange().getStartOffset();
            int rangeEnd = lastVisited != null ? lastVisited.getTextRange().getEndOffset() : comment.getTextRange().getEndOffset();
            TextRange range = TextRange.create((int)rangeStart, (int)rangeEnd);
            info = new CommentedElementInfo(range, null, new GoCommentBlock(Collections.emptyList(), 0, Collections.emptyMap()));
            cached.set((Object)info);
            CommentedElementInfo commentedElementInfo = info;
            if (commentedElementInfo == null) {
                GoCommentReferenceContributor.$$$reportNull$$$0(4);
            }
            return commentedElementInfo;
        }
        List<PsiComment> comments = element.getTextRange().getStartOffset() > comment.getTextRange().getEndOffset() ? GoDocumentationProvider.getUpperComments(element) : GoDocumentationProvider.getAfterComments(element);
        PsiComment first = (PsiComment)ContainerUtil.getFirstItem(comments);
        PsiComment last = (PsiComment)ContainerUtil.getLastItem(comments);
        TextRange commentsRange = first != null && last != null ? TextRange.create((int)first.getTextRange().getStartOffset(), (int)last.getTextRange().getStartOffset()) : TextRange.EMPTY_RANGE;
        info = new CommentedElementInfo(commentsRange, element, GoCommentBlock.parse(comments));
        cached.set((Object)info);
        CommentedElementInfo commentedElementInfo = info;
        if (commentedElementInfo == null) {
            GoCommentReferenceContributor.$$$reportNull$$$0(5);
        }
        return commentedElementInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoCommentReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoCommentReferenceContributor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCommentedElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static final class GoCommentReferenceProvider
    extends PsiReferenceProvider {
        public boolean acceptsHints(@NotNull PsiElement element, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull PsiReferenceService.Hints hints) {
            if (element == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(0);
            }
            if (hints == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(1);
            }
            if (hints instanceof DisableCommentRefs) {
                return false;
            }
            return super.acceptsHints(element, hints);
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(2);
            }
            if (context == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(3);
            }
            PsiReference[] psiReferenceArray = GoCommentReferenceProvider.getReferences(element).toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }

        @NotNull
        public static List<PsiReference> getReferences(@NotNull PsiElement element) {
            PsiComment comment;
            if (element == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(5);
            }
            if ((comment = (PsiComment)ObjectUtils.tryCast((Object)element, PsiComment.class)) == null) {
                List<PsiReference> list = Collections.emptyList();
                if (list == null) {
                    GoCommentReferenceProvider.$$$reportNull$$$0(6);
                }
                return list;
            }
            GoEmbedComment embedComment = GoEmbedComment.embedCommentFrom(comment);
            if (embedComment != null) {
                return GoCommentReferenceProvider.getEmbedFileReferences(comment, embedComment);
            }
            return GoCommentReferenceProvider.getNamedElementReferences(comment);
        }

        @NotNull
        private static List<PsiReference> getEmbedFileReferences(@NotNull PsiComment comment, @NotNull GoEmbedComment embedComment) {
            if (comment == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(7);
            }
            if (embedComment == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(8);
            }
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            for (GoDirectiveCommentArgument argument : embedComment.getArguments()) {
                ContainerUtil.addAll(result, GoEmbedComment.getReferences(comment, argument));
            }
            ArrayList<PsiReference> arrayList = result;
            if (arrayList == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        private static List<PsiReference> getNamedElementReferences(@NotNull PsiComment comment) {
            GoCommentToken token;
            if (comment == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(10);
            }
            if (!Registry.is((String)"go.comment.references.enabled")) {
                List<PsiReference> list = Collections.emptyList();
                if (list == null) {
                    GoCommentReferenceProvider.$$$reportNull$$$0(11);
                }
                return list;
            }
            GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)comment.getContainingFile(), GoFile.class));
            if (file == null) {
                List<PsiReference> list = Collections.emptyList();
                if (list == null) {
                    GoCommentReferenceProvider.$$$reportNull$$$0(12);
                }
                return list;
            }
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            CommentedElementInfo commentedElementInfo = GoCommentReferenceContributor.findCommentedElement(file, comment);
            PsiElement commentedElement = commentedElementInfo.getCommentedElement();
            if (!GoCommentReferenceContributor.shouldAddReferencesForCommentedElement(commentedElement)) {
                List<PsiReference> list = Collections.emptyList();
                if (list == null) {
                    GoCommentReferenceProvider.$$$reportNull$$$0(13);
                }
                return list;
            }
            GoCommentReferenceResolver resolver = GoCommentReferenceResolver.getResolver((PsiElement)file);
            if (resolver == null) {
                List<PsiReference> list = Collections.emptyList();
                if (list == null) {
                    GoCommentReferenceProvider.$$$reportNull$$$0(14);
                }
                return list;
            }
            GoCommentReferenceResolveContext resolveContext = GoCommentReferenceResolver.createResolveContext(commentedElement);
            String commentText = comment.getText();
            GoCommentParser parser = new GoCommentParser(commentText, commentedElementInfo.myBlock.getLinks());
            GoCommentToken prevToken = null;
            int commentStartOffset = comment.getTextRange().getStartOffset();
            while ((token = parser.getNext()) != null) {
                TextRange tokenRangeInComment = token.getRange();
                GoCommentSpanType type = commentedElementInfo.myBlock.getSpanType(commentStartOffset + tokenRangeInComment.getStartOffset());
                if (type != GoCommentSpanType.TEXT && type != GoCommentSpanType.LIST) continue;
                switch (token.getType()) {
                    case WORD: {
                        if (parser.isLeftBracket(prevToken) || !parser.isStrongWordBoundary(prevToken) || resolver.resolveWord(resolveContext, token.getRange().substring(commentText)) == null) break;
                        result.add((PsiReference)new GoCommentWordReference(comment, tokenRangeInComment));
                        break;
                    }
                    case WORD_CHAIN: {
                        assert (token instanceof GoWordChainCommentToken);
                        if (parser.isLeftBracket(prevToken)) break;
                        List<TextRange> wordRanges = ((GoWordChainCommentToken)token).getWordRanges();
                        List<PsiElement> elements2 = resolver.resolveWordChain(resolveContext, commentText, token.getRange(), wordRanges);
                        if (elements2.isEmpty() || elements2.size() != wordRanges.size()) break;
                        for (int i = 0; i < wordRanges.size(); ++i) {
                            if (elements2.get(i) == null) continue;
                            TextRange wordRangeInChain = wordRanges.get(i);
                            TextRange wordRangeInComment = wordRangeInChain.shiftRight(tokenRangeInComment.getStartOffset());
                            result.add((PsiReference)new GoCommentWordChainReference(comment, wordRangeInComment, tokenRangeInComment, i));
                        }
                        break;
                    }
                    case TEXT_LINK: {
                        assert (token instanceof GoTextLinkToken);
                        TextRange betweenBraces = TextRange.create((int)(tokenRangeInComment.getStartOffset() + 1), (int)(tokenRangeInComment.getEndOffset() - 1));
                        result.add((PsiReference)new GoCommentTextLinkReference(comment, betweenBraces, ((GoTextLinkToken)token).getLinkDefinition()));
                        break;
                    }
                    case DOC_LINK: {
                        assert (token instanceof GoDocLinkToken);
                        List<Pair<TextRange, PsiElement>> resolveRanges = resolver.resolveDocLink(resolveContext, (GoDocLinkToken)token);
                        for (Pair<TextRange, PsiElement> resolveRange : resolveRanges) {
                            TextRange linkRange = ((TextRange)resolveRange.first).shiftRight(tokenRangeInComment.getStartOffset());
                            result.add((PsiReference)new GoCommentDocLinkReference(comment, linkRange, (PsiElement)resolveRange.second));
                        }
                        break;
                    }
                }
                prevToken = token;
            }
            ArrayList<PsiReference> arrayList = result;
            if (arrayList == null) {
                GoCommentReferenceProvider.$$$reportNull$$$0(15);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6, 9, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hints";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/comments/GoCommentReferenceContributor$GoCommentReferenceProvider";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "embedComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/comments/GoCommentReferenceContributor$GoCommentReferenceProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmbedFileReferences";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamedElementReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptsHints";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferences";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmbedFileReferences";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getNamedElementReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6, 9, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CommentedElementInfo {
        private final TextRange myCommentsRange;
        private final PsiElement myCommentedElement;
        private final GoCommentBlock myBlock;

        private CommentedElementInfo(@NotNull TextRange commentsRange, @Nullable PsiElement commentedElement, @NotNull GoCommentBlock block) {
            if (commentsRange == null) {
                CommentedElementInfo.$$$reportNull$$$0(0);
            }
            if (block == null) {
                CommentedElementInfo.$$$reportNull$$$0(1);
            }
            this.myCommentsRange = commentsRange;
            this.myCommentedElement = commentedElement;
            this.myBlock = block;
        }

        boolean contains(@NotNull PsiComment comment) {
            if (comment == null) {
                CommentedElementInfo.$$$reportNull$$$0(2);
            }
            return this.myCommentsRange.contains(comment.getTextRange());
        }

        @Nullable
        private PsiElement getCommentedElement() {
            return this.myCommentedElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentsRange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/goide/comments/GoCommentReferenceContributor$CommentedElementInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisableCommentRefs
    extends PsiReferenceService.Hints {
        public DisableCommentRefs(@Nullable PsiElement target, @Nullable Integer offsetInElement) {
            super(target, offsetInElement);
        }
    }
}

