/*
 * Decompiled with CFR 0.152.
 */
package com.goide.configuration;

import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.project.GoModuleSettings;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.combobox.GoBasedSdkChooserCombo;
import com.goide.sdk.combobox.GoSdkChooserCombo;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoSdkSettingUI
implements ConfigurableUi<GoSdkService>,
Disposable {
    @NotNull
    private final Project myProject;
    private final boolean myDialogMode;
    @Nullable
    private GoSdkChooserCombo mySdkCombo;
    @Nullable
    private CheckBoxList<Module> myModulesList;

    GoSdkSettingUI(@NotNull Project project, boolean dialogMode) {
        if (project == null) {
            GoSdkSettingUI.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDialogMode = dialogMode;
    }

    public void reset(@NotNull GoSdkService sdkService) {
        if (sdkService == null) {
            GoSdkSettingUI.$$$reportNull$$$0(1);
        }
        if (this.mySdkCombo != null) {
            this.mySdkCombo.selectSdkByUrl(sdkService.getSdk(null).getHomeUrl());
            if (this.myDialogMode && this.mySdkCombo.getSdk() == GoSdk.NULL) {
                this.mySdkCombo.selectFirstNotNullSdk();
            }
        }
        if (this.myModulesList != null) {
            this.myModulesList.clear();
            for (Module module : (StreamEx)StreamEx.of((Object[])ModuleManager.getInstance((Project)this.myProject).getModules()).sortedBy(Module::getName)) {
                this.myModulesList.addItem((Object)module, module.getName(), GoModuleSettings.getInstance(module).isGoSupportEnabled());
            }
            this.myModulesList.setEnabled(this.mySdkCombo == null || this.mySdkCombo.getSdk() != GoSdk.NULL);
        }
    }

    public boolean isModified(@NotNull GoSdkService sdkService) {
        String url;
        String currentUrl;
        if (sdkService == null) {
            GoSdkSettingUI.$$$reportNull$$$0(2);
        }
        if (this.mySdkCombo != null && !(currentUrl = sdkService.getSdk(null).getHomeUrl()).equals(url = ((GoSdk)this.mySdkCombo.getSdk()).getHomeUrl())) {
            return true;
        }
        if (this.myModulesList != null && ModuleManager.getInstance((Project)this.myProject).getModules().length > 1) {
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (this.myModulesList.isItemSelected((Object)module) == GoModuleSettings.getInstance(module).isGoSupportEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public void apply(@NotNull GoSdkService sdkService) {
        if (sdkService == null) {
            GoSdkSettingUI.$$$reportNull$$$0(3);
        }
        if (this.mySdkCombo != null) {
            GoSdkService.getInstance(this.myProject).setSdk((GoSdk)this.mySdkCombo.getSdk());
        }
        if (this.myModulesList != null) {
            for (int i = 0; i < this.myModulesList.getItemsCount(); ++i) {
                Module module = (Module)this.myModulesList.getItemAt(i);
                if (module == null) continue;
                GoModuleSettings.getInstance(module).setGoSupportEnabled(this.myModulesList.isItemSelected(i));
            }
        }
    }

    @NotNull
    public JComponent getComponent() {
        GoBasedSdkChooserCombo.Validator<GoSdk> wslValidator = GoSdkSettingUI.createWslSdkValidator(() -> this.myProject.getBasePath());
        this.mySdkCombo = new GoSdkChooserCombo(() -> this.myProject.getBasePath(), sdk -> wslValidator.validate((GoSdk)sdk).isOk(), wslValidator, this.myProject, GoSdkService.getInstance(this.myProject).getSdk(null));
        if (this.myDialogMode) {
            this.mySdkCombo.showComboBox();
        }
        Disposer.register((Disposable)this, (Disposable)this.mySdkCombo);
        this.mySdkCombo.addChangedListener(e -> {
            if (this.myModulesList != null) {
                this.myModulesList.setEnabled(this.mySdkCombo == null || this.mySdkCombo.getSdk() != GoSdk.NULL);
            }
        });
        FormBuilder builder = FormBuilder.createFormBuilder().setVertical(true).setVerticalGap(1).addComponent((JComponent)((Object)this.mySdkCombo));
        JComponent modulesPanel = this.createModulesPanel();
        if (modulesPanel != null) {
            builder.addLabeledComponent(GoBundle.message((String)"go.settings.sdk.enable.integration.label", (Object[])new Object[0]), modulesPanel, 12);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)builder.getPanel(), "North");
        if (this.myDialogMode) {
            panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)-1));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            GoSdkSettingUI.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private JComponent createModulesPanel() {
        if (ModuleManager.getInstance((Project)this.myProject).getModules().length > 1) {
            this.myModulesList = new CheckBoxList<Module>(){

                protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
                    checkBox.setText("");
                    Module module = (Module)this.getItemAt(index);
                    Icon icon = module != null ? ModuleType.get((Module)module).getIcon() : null;
                    String text = module != null ? module.getName() : "";
                    checkBox.setName(text);
                    JLabel label = new JLabel(text, (Icon)ObjectUtils.notNull((Object)icon, (Object)EmptyIcon.ICON_16), 2);
                    label.setOpaque(true);
                    label.setBackground(checkBox.getBackground());
                    label.setForeground(checkBox.getForeground());
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.setBorder(BorderFactory.createEmptyBorder());
                    panel2.add((Component)checkBox, "Before");
                    panel2.add((Component)label, "Center");
                    panel2.setBackground(checkBox.getBackground());
                    return panel2;
                }
            };
            this.myModulesList.setSelectionMode(2);
            ListSpeedSearch.installOn(this.myModulesList, Component::getName);
            return new JBScrollPane(this.myModulesList);
        }
        return null;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySdkCombo;
    }

    public void dispose() {
        this.mySdkCombo = null;
        this.myModulesList = null;
    }

    @NotNull
    public static GoBasedSdkChooserCombo.Validator<GoSdk> createWslSdkValidator(@NotNull Supplier<String> projectPath) {
        if (projectPath == null) {
            GoSdkSettingUI.$$$reportNull$$$0(5);
        }
        GoBasedSdkChooserCombo.Validator<GoSdk> validator = sdk -> {
            String error = GoWslUtil.getWslValidationError(sdk, (String)projectPath.get());
            return error != null ? new ValidationResult(error) : ValidationResult.OK;
        };
        if (validator == null) {
            GoSdkSettingUI.$$$reportNull$$$0(6);
        }
        return validator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkService";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/configuration/GoSdkSettingUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/configuration/GoSdkSettingUI";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslSdkValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createWslSdkValidator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

