/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.symbolicExecution.summaries.id;

import com.goide.dfa.symbolicExecution.common.UtilsKt;
import com.goide.dfa.symbolicExecution.metrics.GoDfaOtlMetrics;
import com.goide.dfa.symbolicExecution.summaries.id.GoCallableIdKt;
import com.goide.dfa.symbolicExecution.summaries.id.GoDeferredCallableId;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0007H\u0002\u001a@\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a8\u0006\u001a"}, d2={"warnResolveIssue", "", "msg", "", "createResolveState", "Lcom/intellij/psi/ResolveState;", "call", "Lcom/goide/psi/GoCallExpr;", "file", "Lcom/goide/psi/GoFile;", "getCallableId", "Lcom/goide/dfa/symbolicExecution/summaries/id/GoDeferredCallableId;", "createFunctionOrMethodDeclarationAndRange", "Lkotlin/Pair;", "Lcom/goide/psi/GoFunctionOrMethodDeclaration;", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "text", "originalVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "originalFile", "context", "Lcom/intellij/psi/PsiElement;", "getDeferredCallableId", "callExpr", "intellij.go.dfa"})
public final class GoDeferredCallableIdKt {
    private static final void warnResolveIssue(String msg) {
        GoCallableIdKt.getLOG().warn("RESOLVE_ISSUE: " + msg);
        GoDfaOtlMetrics.Companion.getResolveIssueCount().incrementAndGet();
    }

    private static final ResolveState createResolveState(GoCallExpr call, GoFile file) {
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(call);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"createContextOnElement(...)");
        return resolveState;
    }

    private static final GoDeferredCallableId getCallableId(GoCallExpr $this$getCallableId) {
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement($this$getCallableId);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"createContextOnElement(...)");
        ResolveState state = resolveState;
        PsiFile psiFile = $this$getCallableId.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Integer n = UtilsKt.getId(psiFile);
        if (n == null) {
            return null;
        }
        int fileId = n;
        GoExpression goExpression = $this$getCallableId.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)goExpression, (String)"getExpression(...)");
        GoExpression callableExpr = goExpression;
        if (callableExpr instanceof GoReferenceExpression) {
            String identifier = ((GoReferenceExpression)callableExpr).getIdentifier().getText();
            GoQualifier qualifier = ((GoReferenceExpression)callableExpr).getQualifier();
            if (qualifier == null) {
                Intrinsics.checkNotNull((Object)identifier);
                return new GoDeferredCallableId.Function(identifier, (String)((Object)qualifier), fileId);
            }
            if (qualifier instanceof GoReferenceExpression) {
                PsiElement resolved = ((GoReferenceExpression)qualifier).resolve(state);
                PsiElement psiElement = resolved;
                if (psiElement instanceof PomTargetPsiElement || psiElement instanceof GoImportSpec) {
                    Intrinsics.checkNotNull((Object)identifier);
                    return new GoDeferredCallableId.Function(identifier, ((GoReferenceExpression)qualifier).getText(), fileId);
                }
                if (psiElement instanceof GoTypeOwner) {
                    return GoDeferredCallableIdKt.getDeferredCallableId($this$getCallableId);
                }
                GoCallableIdKt.getLOG().warn("Unexpected qualifier of function call");
                return null;
            }
            return GoDeferredCallableIdKt.getDeferredCallableId($this$getCallableId);
        }
        return GoDeferredCallableIdKt.getDeferredCallableId($this$getCallableId);
    }

    private static final Pair<GoFunctionOrMethodDeclaration, TextRange> createFunctionOrMethodDeclarationAndRange(Project project, @NonNls String text, VirtualFile originalVirtualFile, GoFile originalFile, PsiElement context) {
        String packagePrefix = "package a; ";
        GoFile goFile = GoElementFactory.createFileFromText(project, "elementFactory.go", packagePrefix + text, false, context, originalVirtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goFile), (String)"createFileFromText(...)");
        GoFile file = goFile;
        file.setOriginalFile((PsiFile)originalFile);
        TextRange declRange = new TextRange(packagePrefix.length(), packagePrefix.length() + text.length());
        GoFunctionOrMethodDeclaration goFunctionOrMethodDeclaration = (GoFunctionOrMethodDeclaration)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)file), GoFunctionOrMethodDeclaration.class);
        if (goFunctionOrMethodDeclaration == null) {
            return null;
        }
        GoFunctionOrMethodDeclaration decl = goFunctionOrMethodDeclaration;
        return TuplesKt.to((Object)decl, (Object)declRange);
    }

    private static final GoDeferredCallableId getDeferredCallableId(GoCallExpr callExpr) {
        GoFunctionOrMethodDeclaration enclosingDeclaration = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)callExpr, GoFunctionOrMethodDeclaration.class);
        if (enclosingDeclaration == null) {
            GoCallableIdKt.getLOG().warn("Cannot find enclosing declaration for call expression");
            return null;
        }
        PsiFile psiFile = callExpr.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Integer n = UtilsKt.getId(psiFile);
        if (n == null) {
            return null;
        }
        int fileId = n;
        TextRange enclosingDeclarationRange = enclosingDeclaration.getTextRange();
        TextRange callRange = new TextRange(callExpr.getTextRange().getStartOffset() - enclosingDeclarationRange.getStartOffset(), callExpr.getTextRange().getEndOffset() - enclosingDeclarationRange.getStartOffset());
        Intrinsics.checkNotNull((Object)enclosingDeclarationRange);
        return new GoDeferredCallableId.Deferred(callRange, enclosingDeclarationRange, fileId, callExpr.getExpression().getText());
    }

    public static final /* synthetic */ void access$warnResolveIssue(String msg) {
        GoDeferredCallableIdKt.warnResolveIssue(msg);
    }

    public static final /* synthetic */ ResolveState access$createResolveState(GoCallExpr call, GoFile file) {
        return GoDeferredCallableIdKt.createResolveState(call, file);
    }

    public static final /* synthetic */ Pair access$createFunctionOrMethodDeclarationAndRange(Project project, String text, VirtualFile originalVirtualFile, GoFile originalFile, PsiElement context) {
        return GoDeferredCallableIdKt.createFunctionOrMethodDeclarationAndRange(project, text, originalVirtualFile, originalFile, context);
    }

    public static final /* synthetic */ GoDeferredCallableId access$getCallableId(GoCallExpr $receiver) {
        return GoDeferredCallableIdKt.getCallableId($receiver);
    }
}

