/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.GoOsManager;
import com.goide.dlv.DlvBreakpointReachedCallback;
import com.goide.dlv.DlvCommandProcessor;
import com.goide.dlv.DlvDisconnectOption;
import com.goide.dlv.DlvEditorsProvider;
import com.goide.dlv.DlvExpressionEvaluator;
import com.goide.dlv.DlvGoVersion;
import com.goide.dlv.DlvSmartStepInto;
import com.goide.dlv.DlvSmartStepIntoHandler;
import com.goide.dlv.DlvStackFrame;
import com.goide.dlv.DlvStackFuncName;
import com.goide.dlv.DlvSuspendContext;
import com.goide.dlv.DlvSymbolPrettier;
import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvVm;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.attach.GoLocalAttachDebuggerRunner;
import com.goide.dlv.breakpoint.DlvBreakpointProperties;
import com.goide.dlv.breakpoint.DlvBreakpointType;
import com.goide.dlv.breakpoint.DlvErrorBreakpointType;
import com.goide.dlv.dump.DlvThreadDump;
import com.goide.dlv.location.DlvPositionConverter;
import com.goide.dlv.location.DlvPositionConverterFactory;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.dlv.renderer.DlvValueRenderers;
import com.goide.dlv.replay.DlvRecordAndReplayRunner;
import com.goide.execution.DlvRemoteDebugDisconnectOption;
import com.goide.execution.GoRemoteDebugConfigurationType;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.statistics.GoDebuggerUsageCollector;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ProcessHandlerWrapper;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.ScriptExecutionStack;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;

public final class DlvDebugProcess
extends XDebugProcess
implements Disposable {
    public static final String MIN_SUPPORTED_GO_VERSION = "1.18";
    public static final Key<String> CUSTOM_DELVE_PATH_KEY = Key.create((String)"go.debugger.custom.delve.path");
    private static final DlvGoVersion MIN_SUPPORTED_GO_VERSION_GOLAND = Objects.requireNonNull(DlvGoVersion.parse("1.18"));
    @NonNls
    private static final String STOP_RECORDING_HREF = "#stoprecording";
    private static final long KILL_DELAY_MS = 3000L;
    private static final String NIL_DEREFERENCE_ERROR = "bad access: nil dereference";
    static final int DEFAULT_GOROUTINE_PACK_SIZE = 10000;
    private static final int GOROUTINES_WITH_STACK_PACK_SIZE = 1000;
    private final DlvEditorsProvider myEditorsProvider;
    private final VmConnection<?> myConnection;
    @Nullable
    private final ExecutionResult myExecutionResult;
    private final DlvSmartStepIntoHandler mySmartStepIntoHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final AtomicBoolean myBreakpointsInitiated;
    private final AtomicBoolean myBreakpointsInitFinished;
    private final AtomicBoolean myComplexCommandIsInProcess;
    private final AtomicBoolean myConsumingState;
    private final AtomicReference<Promise<?>> myCommandInProgress;
    private final Map<XBreakpoint<DlvBreakpointProperties>, Integer> myBreakpoints;
    private final AtomicBoolean myShutdownStarted;
    private final boolean myRemote;
    private final Semaphore myThreadDumpSemaphore;
    private final AtomicInteger myThreadDumpCount;
    private final String myUnknownFunctionName;
    private final AtomicReference<DlvThreadDump> myLastDump;
    private final AtomicReference<DlvThreadDump> myLastSelectedDump;
    private volatile boolean myRecorded;
    private volatile boolean mySupportReverseExecution;
    private volatile boolean myMultiClient;
    private volatile boolean myAttachedToExistingProcess;
    private volatile DlvPositionConverter myPositionConverter;
    private volatile DlvApi.Location myMainFileLocation;
    private final DlvValueRenderers myRenderers;
    private volatile boolean myShowThreads;
    private volatile boolean myProcessExited;
    private volatile DlvBreakpointReachedCallback myBreakpointReachedCallback;
    private volatile boolean myRecordingInProgress;
    private volatile InetSocketAddress myAddress;
    private volatile int myGoroutineWithStackPackSize;
    private final DlvSymbolPrettier mySymbolPrettier;
    private volatile DlvSuspendContext.DlvExecutionStack myStackSelectedInUi;
    private volatile int myPid;
    @NotNull
    private final Function<DlvApi.DebuggerState, Promise<Void>> myStateConsumer;

    public DlvDebugProcess(@NotNull XDebugSession session, @NotNull VmConnection<?> connection, @Nullable ExecutionResult er, boolean remote) {
        ExecutionEnvironment env;
        if (session == null) {
            DlvDebugProcess.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            DlvDebugProcess.$$$reportNull$$$0(1);
        }
        super(session);
        this.myEditorsProvider = new DlvEditorsProvider();
        this.myBreakpointHandlers = new XBreakpointHandler[]{new MyBreakpointHandler()};
        this.myBreakpointsInitiated = new AtomicBoolean();
        this.myBreakpointsInitFinished = new AtomicBoolean();
        this.myComplexCommandIsInProcess = new AtomicBoolean();
        this.myConsumingState = new AtomicBoolean();
        this.myCommandInProgress = new AtomicReference<Promise>(Promises.resolvedPromise());
        this.myBreakpoints = new ConcurrentHashMap<XBreakpoint<DlvBreakpointProperties>, Integer>();
        this.myShutdownStarted = new AtomicBoolean();
        this.myThreadDumpSemaphore = new Semaphore(1);
        this.myThreadDumpCount = new AtomicInteger();
        this.myLastDump = new AtomicReference();
        this.myLastSelectedDump = new AtomicReference();
        this.myRenderers = new DlvValueRenderers();
        this.myGoroutineWithStackPackSize = -1;
        this.myStackSelectedInUi = null;
        this.myPid = 0;
        this.myStateConsumer = ClientId.decorateFunction((Function)new Function<DlvApi.DebuggerState, Promise<Void>>(){

            @Override
            public Promise<Void> apply(DlvApi.DebuggerState o) {
                if (DlvDebugProcess.this.myComplexCommandIsInProcess.get()) {
                    return Promises.resolvedPromise();
                }
                try {
                    DlvDebugProcess.this.myConsumingState.set(true);
                    if (DlvDebugProcess.this.myRecordingInProgress) {
                        DlvDebugProcess.this.myRecordingInProgress = false;
                    }
                    if (o.exited) {
                        DlvDebugProcess.this.myProcessExited = true;
                        DlvDebugProcess.this.getSession().stop();
                        return Promises.resolvedPromise();
                    }
                    if (o.nextInProgress && o.err == null) {
                        DlvDebugProcess.this.myConsumingState.set(false);
                        return DlvDebugProcess.this.command("continue").thenAsync(__ -> Promises.resolvedPromise());
                    }
                    DlvApi.Thread currentThread = o.currentThread;
                    if (currentThread == null) {
                        DlvVm.LOG.error("currentThread is null");
                        DlvDebugProcess.this.myConsumingState.set(false);
                        return Promises.resolvedPromise();
                    }
                    return this.createSuspendContext(o).thenAsync(context -> {
                        XBreakpoint<? extends XBreakpointProperties<?>> breakpoint = this.findBreak(currentThread.breakPoint, o.err);
                        XDebugSession session = DlvDebugProcess.this.getSession();
                        if (breakpoint == null) {
                            session.positionReached((XSuspendContext)context);
                        } else {
                            String logExpression;
                            XExpression logExpressionObject = breakpoint.getLogExpressionObject();
                            String string = logExpression = logExpressionObject != null ? logExpressionObject.getExpression() : null;
                            if (logExpression != null) {
                                DlvApi.Goroutine goroutine = o.currentGoroutine;
                                if (goroutine != null) {
                                    this.evaluateExpression((DlvSuspendContext)((Object)context), breakpoint, logExpression, goroutine);
                                } else {
                                    String message = GoBundle.message((String)"go.debugger.cannot.evaluate.expression", (Object[])new Object[]{logExpression, GoBundle.message((String)"go.debugger.cannot.get.current.goroutine", (Object[])new Object[0])});
                                    this.breakpointReached(breakpoint, message, (DlvSuspendContext)((Object)context));
                                }
                            } else {
                                this.breakpointReached(breakpoint, null, (DlvSuspendContext)((Object)context));
                            }
                        }
                        return Promises.resolvedPromise();
                    }).onProcessed(__ -> DlvDebugProcess.this.myConsumingState.set(false)).onError(arg_0 -> ((Logger)DlvVm.LOG).info(arg_0));
                }
                catch (Throwable t) {
                    DlvVm.LOG.error("Error while processing debugger state", t);
                    DlvDebugProcess.this.myConsumingState.set(false);
                    return Promises.resolvedPromise();
                }
            }

            @NotNull
            private Promise<DlvSuspendContext> createSuspendContext(@NotNull DlvApi.DebuggerState state) {
                if (state == null) {
                    3.$$$reportNull$$$0(0);
                }
                DlvApi.Thread currentThread = state.currentThread;
                assert (currentThread != null);
                if (DlvDebugProcess.this.myShowThreads) {
                    Promise<DlvSuspendContext> promise = DlvSuspendContext.create(DlvDebugProcess.this, currentThread, state.err);
                    if (promise == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return promise;
                }
                if (state.currentGoroutine != null) {
                    if (SystemInfo.isMac && DlvDebugProcess.NIL_DEREFERENCE_ERROR.equals(state.err)) {
                        Promise promise = DlvDebugProcess.this.findGoroutine(state.currentGoroutine.id).thenAsync(g -> DlvSuspendContext.create(DlvDebugProcess.this, g, state.err));
                        if (promise == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        return promise;
                    }
                    Promise<DlvSuspendContext> promise = DlvSuspendContext.create(DlvDebugProcess.this, state.currentGoroutine, state.err);
                    if (promise == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return promise;
                }
                if (currentThread.goroutineID == 0L) {
                    Promise promise = DlvDebugProcess.this.findAnyGoroutine().thenAsync(g -> DlvSuspendContext.create(DlvDebugProcess.this, g, state.err));
                    if (promise == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return promise;
                }
                Promise promise = DlvDebugProcess.this.findGoroutine(currentThread.goroutineID).thenAsync(g -> DlvSuspendContext.create(DlvDebugProcess.this, g, state.err));
                if (promise == null) {
                    3.$$$reportNull$$$0(5);
                }
                return promise;
            }

            private void evaluateExpression(final DlvSuspendContext context, final XBreakpoint<? extends XBreakpointProperties<?>> breakpoint, final String logExpression, DlvApi.Goroutine goroutine) {
                new DlvExpressionEvaluator(DlvDebugProcess.this, goroutine.currentLoc, 0, goroutine.id).evaluate(logExpression, new XDebuggerEvaluator.XEvaluationCallback(){

                    public void evaluated(@NotNull XValue result) {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String evaluatedExpression = result instanceof DlvXValue ? 3.getEvaluatedExpression((DlvXValue)result) : null;
                        this.breakpointReached(breakpoint, evaluatedExpression, context);
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        String message = GoBundle.message((String)"go.debugger.cannot.evaluate.expression", (Object[])new Object[]{logExpression, errorMessage});
                        this.breakpointReached(breakpoint, message, context);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/goide/dlv/DlvDebugProcess$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "evaluated";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "errorOccurred";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, null);
            }

            @Nullable
            private static String getEvaluatedExpression(@NotNull DlvXValue result) {
                if (result == null) {
                    3.$$$reportNull$$$0(6);
                }
                int count2 = result.getCallResultCount();
                return switch (count2) {
                    case -1, 0, 1 -> result.getVariable().value;
                    default -> Arrays.stream(result.getVariable().children).map(it -> it.value).collect(Collectors.joining(", ", "(", ")"));
                };
            }

            void breakpointReached(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint, @Nullable String evaluatedLogExpression, @NotNull DlvSuspendContext context) {
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(7);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(8);
                }
                if (DlvDebugProcess.this.myBreakpointReachedCallback != null) {
                    DlvDebugProcess.this.myBreakpointReachedCallback.breakpointReached(breakpoint, evaluatedLogExpression, context);
                }
                if (breakpoint.getType() instanceof DlvErrorBreakpointType) {
                    if (SystemInfo.isMac) {
                        DlvDebugProcess.this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, (XSuspendContext)context);
                    } else if (!breakpoint.isEnabled() || !DlvDebugProcess.this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, (XSuspendContext)context)) {
                        DlvDebugProcess.this.resume(context);
                    }
                } else if (!DlvDebugProcess.this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, (XSuspendContext)context)) {
                    DlvDebugProcess.this.resume(context);
                }
            }

            @Nullable
            private XBreakpoint<? extends XBreakpointProperties<?>> findBreak(@Nullable DlvApi.Breakpoint point, @Nullable String error) {
                if (point != null) {
                    for (Map.Entry<XBreakpoint<DlvBreakpointProperties>, Integer> entry : DlvDebugProcess.this.myBreakpoints.entrySet()) {
                        if (entry.getValue() != point.id) continue;
                        return entry.getKey();
                    }
                }
                return DlvDebugProcess.isErrorBreakpoint(point, error) ? DlvErrorBreakpointType.findDefaultErrorBreakpoint(DlvDebugProcess.this.getSession().getProject()) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/dlv/DlvDebugProcess$3";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "breakpoint";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/dlv/DlvDebugProcess$3";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSuspendContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createSuspendContext";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getEvaluatedExpression";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "breakpointReached";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        });
        this.myConnection = connection;
        this.myExecutionResult = er;
        this.mySmartStepIntoHandler = new DlvSmartStepIntoHandler(session);
        this.myRemote = remote;
        session.addSessionListener(new XDebugSessionListener(){

            public void beforeSessionResume() {
                DlvDebugProcess.this.saveStackSelectedInUi();
            }
        });
        if (session instanceof XDebugSessionImpl && (env = session.getExecutionEnvironment()) != null && env.getRunner() instanceof DlvRecordAndReplayRunner) {
            this.myRecordingInProgress = true;
        }
        this.myUnknownFunctionName = GoBundle.message((String)"go.debugger.unknown.function.name", (Object[])new Object[0]);
        this.mySymbolPrettier = new DlvSymbolPrettier(session);
        session.setPauseActionSupported(true);
    }

    public boolean isShowThreads() {
        return this.myShowThreads;
    }

    public void setShowThreads(boolean showThreads) {
        this.myShowThreads = showThreads;
        this.consumeDebuggerState();
    }

    private void consumeDebuggerState() {
        this.send(new DlvRequest.State()).thenAsync(this::consumeDebuggerState).onError(arg_0 -> ((Logger)DlvVm.LOG).info(arg_0));
    }

    @NotNull
    Promise<Void> consumeDebuggerState(@NotNull DlvApi.DebuggerState state) {
        if (state == null) {
            DlvDebugProcess.$$$reportNull$$$0(2);
        }
        Promise promise = Promises.resolvedPromise((Object)state).thenAsync(this.myStateConsumer::apply);
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(3);
        }
        return promise;
    }

    @NotNull
    Promise<Void> consumeStateWithError(@NotNull String message) {
        if (message == null) {
            DlvDebugProcess.$$$reportNull$$$0(4);
        }
        Promise promise = this.send(new DlvRequest.State()).thenAsync(s -> {
            s.err = message;
            return this.consumeDebuggerState((DlvApi.DebuggerState)s);
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(5);
        }
        return promise;
    }

    @Nullable
    public VirtualFile findFile(@Nullable DlvApi.Location location) {
        return this.findFile(location != null ? location.file : null);
    }

    @Nullable
    public VirtualFile findFile(@Nullable String remotePath) {
        if (StringUtil.isEmpty((String)remotePath)) {
            return null;
        }
        if (this.myPositionConverter != null) {
            return this.myPositionConverter.toLocalFile(remotePath);
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(remotePath);
        if (file != null) {
            return file;
        }
        if (GoOsManager.isWindows()) {
            GoSdk sdk;
            Project project = this.getSession().getProject();
            GoSdk goSdk = sdk = !project.isDisposed() ? GoSdkService.getInstance(project).getSdk(DlvUtil.getModule(this.getSession())) : GoSdk.NULL;
            if (sdk.isValid()) {
                String newUrl = StringUtil.replaceIgnoreCase((String)remotePath, (String)"c:/go", (String)sdk.getHomeUrl());
                return VirtualFileManager.getInstance().findFileByUrl(newUrl);
            }
        }
        return null;
    }

    @Nullable
    public VirtualFile getMainFile() {
        return this.findFile(this.myMainFileLocation);
    }

    public void connect(@NotNull InetSocketAddress address) {
        if (address == null) {
            DlvDebugProcess.$$$reportNull$$$0(6);
        }
        if (!(this.myConnection instanceof RemoteVmConnection)) {
            throw new IllegalStateException(GoBundle.message((String)"go.debugger.cannot.connect.non.remote", (Object[])new Object[0]));
        }
        if (this.myConnection.getState().getStatus() != ConnectionStatus.NOT_CONNECTED) {
            throw new IllegalStateException(GoBundle.message((String)"go.debugger.cannot.connect.twice", (Object[])new Object[0]));
        }
        this.myAddress = address;
        DlvVm.LOG.debug("Open connection to " + String.valueOf(address));
        ((RemoteVmConnection)this.myConnection).open(address).onError(err -> {
            String reason = err.getMessage();
            DlvVm.LOG.debug("Connection to " + String.valueOf(address) + " failed", err);
            if (!this.myShutdownStarted.get()) {
                DlvDebugProcess.showNotification(this.getSession().getProject(), NotificationType.WARNING, StringUtil.isEmpty((String)reason) ? GoBundle.message((String)"go.debugger.connection.failed.generic.message", (Object[])new Object[]{address}) : reason);
            }
            this.getSession().stop();
        });
    }

    public boolean supportsReverseExecution() {
        return this.mySupportReverseExecution;
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ProcessHandler handler;
        ProcessHandler processHandler = handler = this.myExecutionResult != null ? this.myExecutionResult.getProcessHandler() : null;
        if (handler == null) {
            return new DefaultDebugProcessHandler(){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return new ProcessHandlerWrapper((XDebugProcess)this, handler);
    }

    private static boolean isErrorBreakpoint(@Nullable DlvApi.Breakpoint point, @Nullable String error) {
        return point != null && DlvErrorBreakpointType.isErrorBreakpoint(point) || SystemInfo.isMac && NIL_DEREFERENCE_ERROR.equals(error);
    }

    @Nullable
    private DlvCommandProcessor getProcessor() {
        DlvVm dlvVm = (DlvVm)((Object)ObjectUtils.tryCast((Object)this.myConnection.getVm(), DlvVm.class));
        return dlvVm != null ? dlvVm.getCommandProcessor() : null;
    }

    @NotNull
    public <T> Promise<T> send(@NotNull DlvRequest<T> request) {
        DlvCommandProcessor processor2;
        if (request == null) {
            DlvDebugProcess.$$$reportNull$$$0(7);
        }
        if ((processor2 = this.getProcessor()) == null) {
            request.getBuffer().release();
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(8);
            }
            return promise;
        }
        Promise promise = processor2.send(request).onError(t -> {
            @NonNls String message = t.getMessage();
            if (DlvDebugProcess.isConditionEvaluationFailed(message)) {
                this.consumeStateWithError(message);
            } else if (SystemInfo.isMac && "bad access".equals(message)) {
                this.consumeStateWithError(NIL_DEREFERENCE_ERROR);
            } else {
                DlvVm.LOG.info(t);
            }
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(9);
        }
        return promise;
    }

    private static boolean isConditionEvaluationFailed(@NonNls @Nullable String s) {
        return s != null && (s.startsWith("error evaluating expression:") || s.startsWith("condition expression unreadable:") || s.startsWith("condition expression not boolean"));
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        ConnectionStatus status = this.myConnection.getState().getStatus();
        XBreakpointHandler[] xBreakpointHandlerArray = switch (status) {
            case ConnectionStatus.DISCONNECTED, ConnectionStatus.DETACHED, ConnectionStatus.CONNECTION_FAILED -> XBreakpointHandler.EMPTY_ARRAY;
            default -> this.myBreakpointHandlers;
        };
        if (xBreakpointHandlerArray == null) {
            DlvDebugProcess.$$$reportNull$$$0(10);
        }
        return xBreakpointHandlerArray;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionResult executionResult = this.myExecutionResult;
        ExecutionConsole executionConsole = executionResult == null ? super.createConsole() : executionResult.getExecutionConsole();
        if (executionConsole == null) {
            DlvDebugProcess.$$$reportNull$$$0(11);
        }
        return executionConsole;
    }

    public void dispose() {
        this.myMainFileLocation = null;
    }

    public boolean checkCanInitBreakpoints() {
        this.myConnection.stateChanged(state -> {
            String statusText = state.getStatus().getStatusText();
            String msg = state.getMessage();
            Object details = msg.equals(statusText) ? "" : " (" + msg + ")";
            DlvVm.LOG.debug("Connection state changed: status=" + statusText + (String)details);
            if (state.getStatus() == ConnectionStatus.CONNECTED) {
                this.initBreakpointHandlersAndSetBreakpoints();
            } else if (this.myConnection.getState().getStatus() == ConnectionStatus.DISCONNECTED && !this.myShutdownStarted.get()) {
                DlvDebugProcess.showNotification(this.getSession().getProject(), NotificationType.WARNING, GoBundle.message((String)"go.debugger.disconnected.unexpectedly", (Object[])new Object[0]));
                if (!this.getSession().isStopped()) {
                    this.getSession().stop();
                }
            }
            this.getSession().rebuildViews();
            return null;
        });
        if (this.connected()) {
            this.initBreakpointHandlersAndSetBreakpoints();
        }
        return false;
    }

    private void initBreakpointHandlersAndSetBreakpoints() {
        if (!this.myBreakpointsInitiated.compareAndSet(false, true)) {
            return;
        }
        DlvVm.LOG.debug("Init debug session");
        Vm vm = this.myConnection.getVm();
        assert (vm != null) : "Vm should be initialized";
        DlvDebugProcess.runInBackground(() -> this.prepareDelveForInit().thenAsync(__ -> this.checkGoVersion()).thenAsync(__ -> this.retrieveRemoteProperties()).thenAsync(__ -> this.initPositionConverter()).thenAsync(__ -> this.initBreakpoints()));
    }

    @NotNull
    private Promise<?> initBreakpoints() {
        if (this.isCoreDump()) {
            this.myBreakpointsInitFinished.set(true);
            this.consumeDebuggerState();
        } else {
            this.setAndResume();
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(12);
        }
        return promise;
    }

    private boolean isCoreDump() {
        return this.myRecorded && !this.mySupportReverseExecution;
    }

    @NotNull
    private Promise<?> initPositionConverter() {
        if (this.myRemote || this.isUseTrimPaths()) {
            Promise promise = this.send(new DlvRequest.ListSources()).onSuccess(this::setPositionConverter).onError(arg_0 -> ((Logger)DlvVm.LOG).info(arg_0));
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(13);
            }
            return promise;
        }
        Promise promise = DlvVm.LOG.isDebugEnabled() ? this.send(new DlvRequest.ListSources()).onError(arg_0 -> ((Logger)DlvVm.LOG).info(arg_0)) : Promises.resolvedPromise();
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(14);
        }
        return promise;
    }

    private boolean isUseTrimPaths() {
        RunProfile profile = this.getSession().getRunProfile();
        if (!(profile instanceof GoRunConfigurationBase)) {
            return false;
        }
        if (DlvDebugProcess.hasTrimPath(((GoRunConfigurationBase)profile).getGoToolParams())) {
            return true;
        }
        if (DlvDebugProcess.hasTrimPath(((GoRunConfigurationBase)profile).getCustomEnvironment().get("GOFLAGS"))) {
            return true;
        }
        String systemGoFlags = ((GoRunConfigurationBase)profile).isPassParentEnvironment() ? (String)EnvironmentUtil.getEnvironmentMap().get("GOFLAGS") : null;
        return DlvDebugProcess.hasTrimPath(systemGoFlags);
    }

    private static boolean hasTrimPath(@Nullable String params) {
        return params != null && GoRunUtil.findParam(params, (Condition<? super String>)((Condition)p -> p.startsWith("-trimpath"))) != null;
    }

    @NotNull
    private Promise<?> retrieveRemoteProperties() {
        Promise promise = this.send(new DlvRequest.Recorded()).onSuccess(recordedInfo -> {
            this.myRecorded = recordedInfo.Recorded;
            this.mySupportReverseExecution = this.myRecorded && StringUtil.isNotEmpty((String)recordedInfo.TraceDirectory);
        }).thenAsync(__ -> this.myRemote ? this.send(new DlvRequest.IsMulticlient()).onSuccess(result -> {
            this.myMultiClient = result;
        }) : Promises.resolvedPromise()).thenAsync(__ -> this.myRemote ? this.send(new DlvRequest.AttachedToExistingProcess()).onSuccess(result -> {
            this.myAttachedToExistingProcess = result;
        }) : Promises.resolvedPromise()).thenAsync(__ -> this.send(new DlvRequest.FindLocation("main.main"))).onSuccess(locations -> {
            this.myMainFileLocation = (DlvApi.Location)ContainerUtil.getFirstItem((List)locations);
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(15);
        }
        return promise;
    }

    @NotNull
    private Promise<?> prepareDelveForInit() {
        this.showCustomDelveNotification();
        this.myComplexCommandIsInProcess.set(true);
        Promise promise = this.send(new DlvRequest.State(true)).thenAsync(state -> {
            this.myPid = state.pid;
            if (state.recording) {
                return this.send(new DlvRequest.State(false));
            }
            if (state.running) {
                return this.command("halt");
            }
            return Promises.resolvedPromise((Object)state);
        }).thenAsync(__ -> {
            this.myComplexCommandIsInProcess.set(false);
            return Promises.resolvedPromise();
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(16);
        }
        return promise;
    }

    private void showCustomDelveNotification() {
        String customDelvePath;
        final XDebugSessionImpl session = (XDebugSessionImpl)ObjectUtils.tryCast((Object)this.getSession(), XDebugSessionImpl.class);
        ExecutionEnvironment env = session != null ? session.getExecutionEnvironment() : null;
        String string = customDelvePath = env != null ? (String)env.getUserData(CUSTOM_DELVE_PATH_KEY) : null;
        if (customDelvePath != null) {
            Notification notification;
            final AnAction editCustomPropertiesAction = DlvDebugProcess.getEditCustomPropertiesAction(session);
            if (editCustomPropertiesAction != null) {
                notification = XDebuggerManagerImpl.getNotificationGroup().createNotification(GoBundle.message((String)"go.debugger.custom.delve.extended.notification", (Object[])new Object[]{customDelvePath}), NotificationType.WARNING);
                notification.setListener(new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            editCustomPropertiesAction.actionPerformed(DlvDebugProcess.createProjectActionEvent(session));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/goide/dlv/DlvDebugProcess$4";
                        objectArray[2] = "hyperlinkUpdate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                notification = XDebuggerManagerImpl.getNotificationGroup().createNotification(GoBundle.message((String)"go.debugger.custom.delve.notification", (Object[])new Object[]{customDelvePath}), NotificationType.WARNING);
            }
            notification.notify(session.getProject());
        }
    }

    @Nullable
    private static AnAction getEditCustomPropertiesAction(@NotNull XDebugSessionImpl session) {
        AnAction result;
        if (session == null) {
            DlvDebugProcess.$$$reportNull$$$0(17);
        }
        if ((result = ActionManager.getInstance().getAction("EditCustomProperties")) == null) {
            return null;
        }
        AnActionEvent e = DlvDebugProcess.createProjectActionEvent(session);
        e.getPresentation().setEnabled(false);
        result.update(e);
        return e.getPresentation().isEnabled() ? result : null;
    }

    @NotNull
    private static AnActionEvent createProjectActionEvent(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            DlvDebugProcess.$$$reportNull$$$0(18);
        }
        Project project = session.getProject();
        DataContext context = SimpleDataContext.getProjectContext((Project)project);
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"Notification", (Presentation)new Presentation(), (DataContext)context);
        if (anActionEvent == null) {
            DlvDebugProcess.$$$reportNull$$$0(19);
        }
        return anActionEvent;
    }

    @NotNull
    private Promise<?> checkGoVersion() {
        Promise promise = this.send(new DlvRequest.GetVersion()).thenAsync(versionInfo -> {
            String goVersionPrefix;
            String targetGoVersion;
            DlvGoVersion actualGoVersion;
            String customDelvePath;
            DlvGoVersion minDelveVersion = DlvGoVersion.parse(versionInfo.MinSupportedVersionOfGo);
            if (minDelveVersion == null) {
                DlvVm.LOG.warn("Cannot parse minimum supported go version '" + versionInfo.MinSupportedVersionOfGo + "', continue without version check");
                return Promises.resolvedPromise();
            }
            XDebugSessionImpl session = (XDebugSessionImpl)ObjectUtils.tryCast((Object)this.getSession(), XDebugSessionImpl.class);
            ExecutionEnvironment env = session != null ? session.getExecutionEnvironment() : null;
            String string = customDelvePath = env != null ? (String)env.getUserData(CUSTOM_DELVE_PATH_KEY) : null;
            if (customDelvePath == null) {
                try {
                    String expectedBundledDelveCommit = (String)DlvDebugProcess.getBundledDelveArtifactVersionAndCommit().second;
                    String actualDelveCommit = DlvDebugProcess.getDelveCommit(versionInfo.DelveVersion);
                    if (actualDelveCommit == null) {
                        DlvVm.LOG.warn("Failed to extract delve commit from delve version");
                    } else if (!expectedBundledDelveCommit.equals(actualDelveCommit)) {
                        DlvVm.LOG.warn("Unexpected bundled delve version. Expected commit '" + expectedBundledDelveCommit + "', actual commit '" + actualDelveCommit + "'.");
                    }
                }
                catch (Exception e) {
                    DlvVm.LOG.warn("Failed to get expected bundled delve version", (Throwable)e);
                }
            }
            if ((actualGoVersion = DlvGoVersion.parse(targetGoVersion = StringUtil.trimStart((String)versionInfo.TargetGoVersion, (String)(goVersionPrefix = "Go cmd/compile ")))) == null) {
                DlvVm.LOG.warn("Cannot parse go version '" + versionInfo.TargetGoVersion + "', continue without version check");
                return Promises.resolvedPromise();
            }
            GoDebuggerUsageCollector.logGoTargetVersion(actualGoVersion);
            Project project = this.getSession().getProject();
            if (!actualGoVersion.isAfterOrEqual(minDelveVersion)) {
                String version = StringUtil.trimStart((String)targetGoVersion, (String)"go");
                if (actualGoVersion.isAfterOrEqual(MIN_SUPPORTED_GO_VERSION_GOLAND)) {
                    String msg = GoBundle.message((String)"go.debugger.go.version.is.not.officially.supported", (Object[])new Object[]{version, versionInfo.MinSupportedVersionOfGo});
                    DlvDebugProcess.showNotification(project, NotificationType.WARNING, msg);
                } else {
                    String msg = GoBundle.message((String)"go.debugger.go.version.is.not.supported", (Object[])new Object[]{version, versionInfo.MinSupportedVersionOfGo});
                    DlvDebugProcess.showNotification(project, NotificationType.ERROR, msg);
                    this.getSession().getConsoleView().print(msg, ConsoleViewContentType.LOG_ERROR_OUTPUT);
                    if (!Registry.is((String)"go.debugger.allow.unsupported.go.versions")) {
                        this.getSession().stop();
                        return Promises.rejectedPromise();
                    }
                }
            }
            return Promises.resolvedPromise();
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(20);
        }
        return promise;
    }

    public static void showNotification(@NotNull Project project, @NotNull NotificationType type, @NlsContexts.NotificationContent @NotNull String msg) {
        if (project == null) {
            DlvDebugProcess.$$$reportNull$$$0(21);
        }
        if (type == null) {
            DlvDebugProcess.$$$reportNull$$$0(22);
        }
        if (msg == null) {
            DlvDebugProcess.$$$reportNull$$$0(23);
        }
        XDebuggerManagerImpl.getNotificationGroup().createNotification(msg, type).notify(project);
    }

    private void setAndResume() {
        ReadAction.run(() -> this.getSession().initBreakpoints());
        this.pauseIfNeededAndProcess(() -> {
            this.myBreakpointsInitFinished.set(true);
            this.resumeIfSuspended();
            return Promises.resolvedPromise();
        });
    }

    private void resumeIfSuspended() {
        this.myComplexCommandIsInProcess.set(true);
        this.send(new DlvRequest.State(true)).onProcessed(state -> {
            this.myComplexCommandIsInProcess.set(false);
            if (state != null && !state.running) {
                this.continueVm(StepAction.CONTINUE);
            }
        });
    }

    private void setPositionConverter(@NotNull List<String> sourcesList) {
        if (sourcesList == null) {
            DlvDebugProcess.$$$reportNull$$$0(24);
        }
        Set remotePaths = ContainerUtil.map2SetNotNull(sourcesList, PathUtil::toSystemIndependentName);
        this.myPositionConverter = DlvPositionConverterFactory.create(this.getSession().getProject(), DlvUtil.getModule(this.getSession()), remotePaths);
    }

    public void rewind() {
        this.command("rewind");
    }

    @NotNull
    private Promise<DlvApi.DebuggerState> command(@NotNull String name) {
        if (name == null) {
            DlvDebugProcess.$$$reportNull$$$0(25);
        }
        Promise<DlvApi.DebuggerState> promise = this.command(new DlvRequest.Command(name));
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(26);
        }
        return promise;
    }

    @NotNull
    Promise<DlvApi.DebuggerState> command(@NotNull DlvRequest<? extends DlvApi.DebuggerState> request) {
        if (request == null) {
            DlvDebugProcess.$$$reportNull$$$0(27);
        }
        AsyncPromise result = new AsyncPromise();
        DlvDebugProcess.runInBackground(() -> this.send(request).thenAsync(state -> this.consumeDebuggerState((DlvApi.DebuggerState)state).onProcessed(__ -> result.setResult(state))));
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            DlvDebugProcess.$$$reportNull$$$0(28);
        }
        return asyncPromise;
    }

    @NotNull
    DlvSmartStepInto getSmartStepInto() {
        return new DlvSmartStepInto(this);
    }

    private void saveStackSelectedInUi() {
        XDebugSessionImpl session = (XDebugSessionImpl)ObjectUtils.tryCast((Object)this.getSession(), XDebugSessionImpl.class);
        this.myStackSelectedInUi = session != null ? (DlvSuspendContext.DlvExecutionStack)((Object)ObjectUtils.tryCast((Object)session.getCurrentExecutionStack(), DlvSuspendContext.DlvExecutionStack.class)) : null;
    }

    private void continueVmInBackground(@NotNull StepAction stepAction) {
        if (stepAction == null) {
            DlvDebugProcess.$$$reportNull$$$0(29);
        }
        DlvDebugProcess.runInBackground(() -> this.pauseIfNeededAndProcess(() -> {
            this.continueVm(stepAction);
            return Promises.resolvedPromise();
        }));
    }

    @NotNull
    private Promise<?> switchToStackSelectedInUi() {
        DlvSuspendContext.DlvExecutionStack stack = this.myStackSelectedInUi;
        if (stack == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(30);
            }
            return promise;
        }
        this.myStackSelectedInUi = null;
        if (stack.isCurrent()) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(31);
            }
            return promise;
        }
        Promise<DlvApi.DebuggerState> promise = this.send(stack.createSwitchCommand());
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(32);
        }
        return promise;
    }

    private void continueVm(@NotNull StepAction stepAction) {
        if (stepAction == null) {
            DlvDebugProcess.$$$reportNull$$$0(33);
        }
        this.switchToStackSelectedInUi().then(__ -> {
            switch (stepAction) {
                case CONTINUE: {
                    this.command("continue");
                    break;
                }
                case IN: {
                    this.stepAndConsumeState();
                    break;
                }
                case OVER: {
                    this.command("next");
                    break;
                }
                case OUT: {
                    this.command("stepOut");
                }
            }
            return null;
        });
    }

    void stepAndConsumeState() {
        DlvDebugProcess.runInBackground(() -> this.step().thenAsync(it -> this.consumeDebuggerState((DlvApi.DebuggerState)it)));
    }

    @NotNull
    Promise<DlvApi.DebuggerState> step() {
        Promise<DlvApi.DebuggerState> promise = Registry.is((String)"go.debugger.skip.autogenerated.frames") ? this.stepSkippingAutogeneratedFrames() : this.send(new DlvRequest.Command("step"));
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(34);
        }
        return promise;
    }

    @NotNull
    private Promise<DlvApi.DebuggerState> stepSkippingAutogeneratedFrames() {
        Promise promise = this.send(new DlvRequest.Command("step")).thenAsync(state -> {
            DlvApi.Location loc = DlvUtil.getCurrentLocation(state);
            return DlvUtil.isAutogenerated(loc) ? this.stepSkippingAutogeneratedFrames() : Promises.resolvedPromise((Object)state);
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(35);
        }
        return promise;
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            DlvDebugProcess.$$$reportNull$$$0(36);
        }
        VirtualFile file = position.getFile();
        int line = position.getLine();
        String debuggerPath = this.getDebuggerPath(file);
        Project project = this.getSession().getProject();
        if (debuggerPath == null) {
            DlvDebugProcess.showNotification(project, NotificationType.WARNING, GoBundle.message((String)"go.debugger.cannot.find.debugger.path", (Object[])new Object[]{file.getPath()}));
            this.command("continue");
        } else {
            DlvDebugProcess.runInBackground(() -> this.pauseIfNeededAndProcess(() -> {
                this.send(new DlvRequest.CreateBreakpoint(debuggerPath, line + 1, null)).onError(t -> {
                    DlvDebugProcess.showNotification(project, NotificationType.WARNING, GoBundle.message((String)"go.debugger.failed.to.create.breakpoint", (Object[])new Object[0]));
                    this.command("continue");
                }).onSuccess(b -> this.continueAndClearBreakpoint((DlvApi.Breakpoint)b));
                return Promises.resolvedPromise();
            }));
        }
    }

    private void continueAndClearBreakpoint(@NotNull DlvApi.Breakpoint breakpoint) {
        if (breakpoint == null) {
            DlvDebugProcess.$$$reportNull$$$0(37);
        }
        this.send(new DlvRequest.Command("continue")).onSuccess(state -> this.send(new DlvRequest.ClearBreakpoint(breakpoint.id)).onProcessed(__ -> this.consumeDebuggerState((DlvApi.DebuggerState)state))).onError(error -> DlvDebugProcess.showNotification(this.getSession().getProject(), NotificationType.WARNING, GoBundle.message((String)"go.debugger.failed.to.run.to.position", (Object[])new Object[0])));
    }

    @NotNull
    public Promise<Object> stopAsync() {
        if (!Disposer.isDisposed((Disposable)this) && this.myShutdownStarted.compareAndSet(false, true)) {
            if (!this.connected()) {
                this.myConnection.detachAndClose();
                Promise promise = Promises.resolvedPromise();
                if (promise == null) {
                    DlvDebugProcess.$$$reportNull$$$0(38);
                }
                return promise;
            }
            if (this.myRecordingInProgress) {
                this.myConnection.detachAndClose();
                Promise promise = Promises.resolvedPromise();
                if (promise == null) {
                    DlvDebugProcess.$$$reportNull$$$0(39);
                }
                return promise;
            }
            DlvDisconnectOption disconnectOption = this.getDisconnectOption();
            if (disconnectOption == DlvDisconnectOption.LEAVE_RUNNING) {
                this.myComplexCommandIsInProcess.set(true);
                Promise clearBreakpointsIfRunning = this.myProcessExited ? Promises.resolvedPromise() : this.send(new DlvRequest.Command("halt")).thenAsync(__ -> this.clearBreakpoints()).thenAsync(__ -> {
                    this.send(new DlvRequest.Command("continue"));
                    return Promises.resolvedPromise();
                });
                Promise promise = clearBreakpointsIfRunning.onProcessed(__ -> {
                    this.myComplexCommandIsInProcess.set(false);
                    Disposer.dispose((Disposable)this);
                    this.myConnection.detachAndClose();
                });
                if (promise == null) {
                    DlvDebugProcess.$$$reportNull$$$0(40);
                }
                return promise;
            }
            Promise promise = this.interruptProcessOrHaltDebugger(disconnectOption).thenAsync(__ -> this.connected() ? this.send(new DlvRequest.Detach(disconnectOption == DlvDisconnectOption.KILL)) : Promises.resolvedPromise()).onProcessed(__ -> {
                DlvVm.LOG.debug("Closing connection");
                Disposer.dispose((Disposable)this);
                this.myConnection.detachAndClose();
                if (this.myExecutionResult != null) {
                    this.myExecutionResult.getProcessHandler().waitFor(3000L);
                    DlvVm.LOG.debug("Delve terminated");
                }
            });
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(41);
            }
            return promise;
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(42);
        }
        return promise;
    }

    @NotNull
    private Promise<?> interruptProcessOrHaltDebugger(@Nullable DlvDisconnectOption disconnectOption) {
        int pid = this.myPid;
        this.myComplexCommandIsInProcess.set(true);
        GoRunConfigurationBase profile = (GoRunConfigurationBase)((Object)ObjectUtils.tryCast((Object)this.getSession().getRunProfile(), GoRunConfigurationBase.class));
        if (!(this.myRecorded || this.myRemote || this.myProcessExited || pid == 0 || disconnectOption != DlvDisconnectOption.KILL || profile != null && profile.isRunWithSudo())) {
            Promise promise = this.send(new DlvRequest.Command("halt")).thenAsync(state -> {
                if (state.exited) {
                    this.myProcessExited = true;
                    return Promises.resolvedPromise();
                }
                DlvVm.LOG.debug("Clear breakpoints before interrupting a process");
                return this.clearBreakpoints();
            }).thenAsync(__ -> {
                if (this.myProcessExited) {
                    DlvVm.LOG.debug("Process exited, skip graceful shutdown");
                    return Promises.resolvedPromise((Object)false);
                }
                return Promises.runAsync(() -> {
                    DlvVm.LOG.debug("Resume before interrupting the process");
                    AtomicBoolean running = new AtomicBoolean(false);
                    this.send(new DlvRequest.Command("continue")).thenAsync(state -> {
                        if (state != null) {
                            if (state.exited) {
                                this.myProcessExited = true;
                            }
                            if (state.running) {
                                running.set(true);
                            }
                        }
                        return Promises.resolvedPromise();
                    });
                    long t0 = System.currentTimeMillis();
                    while (!running.get()) {
                        try {
                            DlvApi.DebuggerState state2 = (DlvApi.DebuggerState)this.send(new DlvRequest.State(true)).blockingGet(1, TimeUnit.SECONDS);
                            if (state2 == null) continue;
                            if (state2.exited) {
                                this.myProcessExited = true;
                                break;
                            }
                            if (state2.running) {
                                running.set(true);
                                break;
                            }
                            long waitTime = System.currentTimeMillis() - t0;
                            if (waitTime <= 5000L) continue;
                            DlvVm.LOG.debug("Process didn't resume after " + waitTime + "ms, stop waiting");
                        }
                        catch (Exception e) {
                            running.set(false);
                        }
                        break;
                    }
                    return running.get();
                });
            }).then(programRunning -> {
                if (this.myProcessExited) {
                    DlvVm.LOG.debug("Process exited, skip graceful shutdown");
                    return false;
                }
                if (!programRunning.booleanValue()) {
                    DlvVm.LOG.debug("Process didn't resume, skip graceful shutdown");
                    return false;
                }
                try {
                    DlvVm.LOG.debug("Interrupt process " + pid);
                    OSProcessUtil.terminateProcessGracefully((int)pid);
                    return true;
                }
                catch (Exception e) {
                    DlvVm.LOG.debug("Failed to interrupt process", (Throwable)e);
                    return false;
                }
            }).thenAsync(shouldWaitForExit -> {
                if (shouldWaitForExit.booleanValue()) {
                    long t0 = System.currentTimeMillis();
                    while (!this.myProcessExited) {
                        ConnectionStatus status = this.myConnection.getState().getStatus();
                        if (status == ConnectionStatus.DISCONNECTED || status == ConnectionStatus.DETACHED) {
                            DlvVm.LOG.debug("Delve disconnected");
                            break;
                        }
                        long waitTime = System.currentTimeMillis() - t0;
                        if (waitTime > 30000L) {
                            DlvVm.LOG.debug("Process didn't exit after " + waitTime + "ms, stop waiting");
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (this.myProcessExited) {
                        DlvVm.LOG.debug("Process terminated, pid=" + pid);
                    }
                }
                return this.connected() ? this.send(new DlvRequest.Command("halt")) : Promises.resolvedPromise(null);
            });
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(43);
            }
            return promise;
        }
        Promise<DlvApi.DebuggerState> promise = this.myProcessExited ? Promises.resolvedPromise() : this.send(new DlvRequest.Command("halt"));
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(44);
        }
        return promise;
    }

    @Nullable
    private DlvDisconnectOption getDisconnectOption() {
        DlvDisconnectOption defaultDisconnectOption;
        Vm vm = this.myConnection.getVm();
        if (vm instanceof DlvVm) {
            DlvVm vm2 = (DlvVm)vm;
            v0 = vm2.getDisconnectOption();
        } else {
            v0 = defaultDisconnectOption = null;
        }
        if (!this.myRemote && !this.myAttachedToExistingProcess) {
            return defaultDisconnectOption;
        }
        AtomicReference resultRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> resultRef.set(this.askForDisconnectOption(defaultDisconnectOption)));
        return (DlvDisconnectOption)((Object)resultRef.get());
    }

    @Nullable
    private DlvDisconnectOption askForDisconnectOption(@Nullable DlvDisconnectOption disconnectOption) {
        boolean isAttachedToLocalProcess;
        boolean shouldAsk;
        Project project = this.getSession().getProject();
        DlvDisconnectOption result = disconnectOption;
        GoRemoteDebugConfigurationType.DlvRemoteDebugConfiguration config = (GoRemoteDebugConfigurationType.DlvRemoteDebugConfiguration)((Object)ObjectUtils.tryCast((Object)this.getSession().getRunProfile(), GoRemoteDebugConfigurationType.DlvRemoteDebugConfiguration.class));
        boolean bl = shouldAsk = config != null && config.getDisconnectOption() == DlvRemoteDebugDisconnectOption.ASK;
        if (this.myRemote && shouldAsk && result == DlvDisconnectOption.LEAVE_RUNNING) {
            if (this.myMultiClient) {
                String message = this.myProcessExited ? GoBundle.message((String)"go.debugger.process.terminated.stop.remote.delve.message", (Object[])new Object[0]) : GoBundle.message((String)"go.debugger.stop.remote.delve.message", (Object[])new Object[0]);
                MessageDialogBuilder.YesNo dialog = (MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)GoBundle.message((String)"go.debugger.stop.remote.delve.title", (Object[])new Object[0]), (String)message).doNotAsk((DoNotAskOption)DlvDebugProcess.getDoNotAskOption(config));
                if (dialog.ask(project)) {
                    result = DlvDisconnectOption.DETACH;
                }
            } else {
                result = DlvDisconnectOption.DETACH;
            }
        }
        if (!(isAttachedToLocalProcess = GoLocalAttachDebuggerRunner.isAttachedToLocalProcess(this.myExecutionResult)) && this.myAttachedToExistingProcess && !this.myProcessExited && result == DlvDisconnectOption.DETACH) {
            String message = GoBundle.message((String)"go.debugger.kill.existing.process.message", (Object[])new Object[0]);
            MessageDialogBuilder.YesNo dialog = MessageDialogBuilder.yesNo((String)GoBundle.message((String)"go.debugger.kill.existing.process.title", (Object[])new Object[0]), (String)message);
            if (dialog.ask(project)) {
                result = DlvDisconnectOption.KILL;
            }
        }
        return result;
    }

    @NotNull
    private static DoNotAskOption.Adapter getDoNotAskOption(final @NotNull GoRemoteDebugConfigurationType.DlvRemoteDebugConfiguration runConfig) {
        if (runConfig == null) {
            DlvDebugProcess.$$$reportNull$$$0(45);
        }
        return new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    runConfig.setDisconnectOption(exitCode == 0 ? DlvRemoteDebugDisconnectOption.STOP : DlvRemoteDebugDisconnectOption.LEAVE);
                }
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }
        };
    }

    private Promise<?> clearBreakpoints() {
        return this.send(new DlvRequest.ListBreakpoints()).thenAsync(processBreakpoints -> {
            ArrayList<Promise<DlvApi.Breakpoint>> promises = new ArrayList<Promise<DlvApi.Breakpoint>>();
            IntOpenHashSet processed = new IntOpenHashSet();
            for (DlvApi.Breakpoint breakpoint : processBreakpoints) {
                processed.add(breakpoint.id);
                promises.add(this.send(new DlvRequest.ClearBreakpoint(breakpoint.id)));
            }
            this.myBreakpoints.values().forEach(arg_0 -> this.lambda$clearBreakpoints$51((IntSet)processed, promises, arg_0));
            return Promises.collectResults(promises, (boolean)true);
        });
    }

    private void pauseIfNeededAndProcess(@NotNull Computable<Promise<?>> c) {
        if (c == null) {
            DlvDebugProcess.$$$reportNull$$$0(46);
        }
        AsyncPromise newPromise = new AsyncPromise();
        Promise oldPromise = Objects.requireNonNull((Promise)this.myCommandInProgress.getAndSet((Promise<?>)newPromise));
        oldPromise.onProcessed(__ -> this.pauseIfNeededAndProcess(c, newPromise));
    }

    private void pauseIfNeededAndProcess(@NotNull Computable<Promise<?>> c, @NotNull AsyncPromise<?> callback) {
        if (c == null) {
            DlvDebugProcess.$$$reportNull$$$0(47);
        }
        if (callback == null) {
            DlvDebugProcess.$$$reportNull$$$0(48);
        }
        if (!this.needToHalt()) {
            ((Promise)c.compute()).onProcessed(__ -> callback.setResult(null));
            return;
        }
        this.myComplexCommandIsInProcess.set(true);
        this.send(new DlvRequest.State(true)).onSuccess(state -> {
            if (state.running) {
                this.send(new DlvRequest.Command("halt")).thenAsync(__ -> (Promise)c.compute()).onProcessed(__ -> {
                    this.myComplexCommandIsInProcess.set(false);
                    if (this.connected()) {
                        this.command("continue");
                    }
                    callback.setResult(null);
                });
            } else {
                ((Promise)c.compute()).onProcessed(__ -> {
                    this.myComplexCommandIsInProcess.set(false);
                    callback.setResult(null);
                });
            }
        }).onError(error -> {
            this.myComplexCommandIsInProcess.set(false);
            callback.setError(error);
        });
    }

    private boolean needToHalt() {
        return this.myBreakpointsInitFinished.get() && this.connected() && !this.getSession().isPaused() && !this.myConsumingState.get();
    }

    public boolean connected() {
        return this.myConnection.getState().getStatus() == ConnectionStatus.CONNECTED;
    }

    @Nullable
    private String getDebuggerPath(@NotNull VirtualFile file) {
        if (file == null) {
            DlvDebugProcess.$$$reportNull$$$0(49);
        }
        return this.myPositionConverter != null ? this.myPositionConverter.toRemotePath(file) : file.getPath();
    }

    @NotNull
    public DlvValueRenderers getRenderers() {
        DlvValueRenderers dlvValueRenderers = this.myRenderers;
        if (dlvValueRenderers == null) {
            DlvDebugProcess.$$$reportNull$$$0(50);
        }
        return dlvValueRenderers;
    }

    @Nullable
    public static DlvDebugProcess getCurrentProcess(@NotNull AnActionEvent e) {
        XDebugSession session;
        if (e == null) {
            DlvDebugProcess.$$$reportNull$$$0(51);
        }
        return (session = DebuggerUIUtil.getSession((AnActionEvent)e)) != null ? (DlvDebugProcess)((Object)ObjectUtils.tryCast((Object)session.getDebugProcess(), DlvDebugProcess.class)) : null;
    }

    @NotNull
    Promise<List<XStackFrame>> getStacktrace(long goroutineId) {
        AsyncPromise promise = new AsyncPromise();
        DlvDebugProcess.runInBackground(() -> this.send(new DlvRequest.Stacktrace(goroutineId)).then(locations -> {
            if (locations == null) {
                promise.setResult(Collections.emptyList());
            } else {
                ArrayList<DlvStackFrame> result = new ArrayList<DlvStackFrame>(locations.size());
                for (int i = 0; i < locations.size(); ++i) {
                    DlvStackFuncName stackFuncName = DlvSuspendContext.getStackFuncName(this, (DlvApi.Location)locations.get(i));
                    result.add(new DlvStackFrame(this, (DlvApi.Location)locations.get(i), stackFuncName, goroutineId, i, null, false));
                }
                promise.setResult(result);
            }
            return null;
        }));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            DlvDebugProcess.$$$reportNull$$$0(52);
        }
        return asyncPromise;
    }

    @Nullable
    public GlobalSearchScope getMainPackageScope() {
        VirtualFile mainFile = this.getMainFile();
        GoFile psiFile = mainFile != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)this.getSession().getProject()).findFile(mainFile), GoFile.class)) : null;
        return psiFile != null ? GoPackageUtil.packageScope(psiFile) : null;
    }

    @TestOnly
    public void setBreakpointReachedCallback(DlvBreakpointReachedCallback breakpointReachedCallback) {
        this.myBreakpointReachedCallback = breakpointReachedCallback;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        DlvEditorsProvider dlvEditorsProvider = this.myEditorsProvider;
        if (dlvEditorsProvider == null) {
            DlvDebugProcess.$$$reportNull$$$0(53);
        }
        return dlvEditorsProvider;
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.continueVmInBackground(StepAction.OVER);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.continueVmInBackground(StepAction.OUT);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.continueVmInBackground(StepAction.CONTINUE);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.continueVmInBackground(StepAction.IN);
    }

    public void startPausing() {
        Vm vm = this.getActiveOrMainVm();
        if (vm != null) {
            vm.getSuspendContextManager().suspend().onError((Consumer)new RejectErrorReporter(this.getSession(), GoBundle.message((String)"go.debugger.cannot.pause", (Object[])new Object[0])));
        } else {
            DlvDebugProcess.showNotification(this.getSession().getProject(), NotificationType.WARNING, GoBundle.message((String)"go.debugger.cannot.pause", (Object[])new Object[0]));
        }
    }

    @Nullable
    private Vm getActiveOrMainVm() {
        XExecutionStack stack;
        XDebugSession session = this.getSession();
        XSuspendContext context = session.getSuspendContext();
        if (context != null && (stack = context.getActiveExecutionStack()) instanceof ScriptExecutionStack) {
            ScriptExecutionStack s = (ScriptExecutionStack)stack;
            return s.getVm();
        }
        return this.myConnection.getVm();
    }

    public String getCurrentStateMessage() {
        ConnectionStatus status = this.myConnection.getState().getStatus();
        if (status == ConnectionStatus.WAITING_FOR_CONNECTION) {
            InetSocketAddress address = this.myAddress;
            return address != null ? GoBundle.message((String)"go.debugger.connecting.to.address.message", (Object[])new Object[]{address.toString()}) : GoBundle.message((String)"go.debugger.connecting.to.unknown.address.message", (Object[])new Object[0]);
        }
        if (status == ConnectionStatus.CONNECTED && this.myRecordingInProgress) {
            return GoBundle.message((String)"go.debugger.recording.in.progress", (Object[])new Object[]{STOP_RECORDING_HREF});
        }
        return super.getCurrentStateMessage();
    }

    @Nullable
    public HyperlinkListener getCurrentStateHyperlinkListener() {
        ConnectionStatus status = this.myConnection.getState().getStatus();
        if (status == ConnectionStatus.CONNECTED && this.myRecordingInProgress) {
            return new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (DlvDebugProcess.STOP_RECORDING_HREF.equals(e.getDescription())) {
                        DlvDebugProcess.this.stopRecording();
                    }
                }
            };
        }
        return super.getCurrentStateHyperlinkListener();
    }

    public void stopRecording() {
        DlvVm.LOG.debug("Stop mozilla rr recording");
        this.send(new DlvRequest.StopRecording()).onError(exception -> {
            DlvVm.LOG.warn("Failed to stop mozilla rr recording", exception);
            String details = exception != null ? exception.getMessage() : null;
            String message = StringUtil.isEmpty((String)details) ? GoBundle.message((String)"go.debugger.failed.to.stop.mozilla.rr.recording", (Object[])new Object[0]) : GoBundle.message((String)"go.debugger.failed.to.stop.mozilla.rr.recording.details", (Object[])new Object[]{details});
            DlvDebugProcess.showNotification(this.getSession().getProject(), NotificationType.WARNING, message);
        });
    }

    boolean isRecorded() {
        return this.myRecorded;
    }

    @NotNull
    private Promise<DlvApi.Goroutine> findAnyGoroutine() {
        Promise promise = this.send(new DlvRequest.ListGoroutines(0, 1)).then(goroutinesPack -> (DlvApi.Goroutine)ContainerUtil.getFirstItem(goroutinesPack.Goroutines));
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(54);
        }
        return promise;
    }

    @NotNull
    private Promise<DlvApi.Goroutine> findGoroutine(long goroutineId) {
        Promise promise = this.send(new DlvRequest.ListGoroutines(0, 10000)).thenAsync(goroutinesPack -> this.findGoroutineInner(goroutineId, (DlvApi.ListGoroutinesOut)goroutinesPack));
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(55);
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Promise<DlvApi.Goroutine> findGoroutineInner(long goroutineId, @NotNull DlvApi.ListGoroutinesOut listGoroutinesOut) {
        void goroutinesPack;
        if (listGoroutinesOut == null) {
            DlvDebugProcess.$$$reportNull$$$0(56);
        }
        for (DlvApi.Goroutine goroutine : goroutinesPack.Goroutines) {
            if (goroutine.id != goroutineId) continue;
            Promise promise = Promises.resolvedPromise((Object)goroutine);
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(57);
            }
            return promise;
        }
        if (goroutinesPack.Nextg == -1) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(58);
            }
            return promise;
        }
        Promise promise = this.send(new DlvRequest.ListGoroutines(goroutinesPack.Nextg, 10000)).thenAsync(nextPack -> this.findGoroutineInner(goroutineId, (DlvApi.ListGoroutinesOut)nextPack));
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(59);
        }
        return promise;
    }

    private int getGoroutineWithStackPackSize() {
        return this.myGoroutineWithStackPackSize > 0 ? this.myGoroutineWithStackPackSize : 1000;
    }

    public void setGoroutineWithStackPackSize(int goroutineWithStackPackSize) {
        this.myGoroutineWithStackPackSize = goroutineWithStackPackSize;
    }

    @NotNull
    private Promise<DlvThreadDump> fillDump(@NotNull ProgressIndicator progress, @NotNull DlvThreadDump dump) {
        if (progress == null) {
            DlvDebugProcess.$$$reportNull$$$0(60);
        }
        if (dump == null) {
            DlvDebugProcess.$$$reportNull$$$0(61);
        }
        Promise promise = Promises.runAsync(() -> {
            block8: {
                AtomicInteger count2 = new AtomicInteger(0);
                try {
                    int start = 0;
                    while (start != -1) {
                        progress.checkCanceled();
                        DlvApi.ListGoroutinesOut pack = DlvDebugProcess.waitForPromise(progress, this.send(new DlvRequest.ListGoroutines(start, this.getGoroutineWithStackPackSize())));
                        if (pack == null) {
                            throw new ProcessCanceledException();
                        }
                        progress.checkCanceled();
                        CountDownLatch latch = new CountDownLatch(pack.Goroutines.size());
                        ArrayList<Promise> stacks = new ArrayList<Promise>(pack.Goroutines.size());
                        for (DlvApi.Goroutine goroutine : pack.Goroutines) {
                            Promise stackPromise = this.send(new DlvRequest.Stacktrace(goroutine.id)).then(stack -> {
                                progress.setText(GoBundle.message((String)"go.debugger.create.dump.background.task.progress.text", (Object[])new Object[]{count2.incrementAndGet()}));
                                return Pair.create((Object)goroutine, (Object)stack);
                            });
                            stacks.add(stackPromise);
                            stackPromise.onProcessed(it -> latch.countDown());
                        }
                        DlvDebugProcess.waitForLatch(progress, latch);
                        for (Promise stackPromise : stacks) {
                            if (!stackPromise.isSucceeded()) continue;
                            try {
                                Pair stack2 = (Pair)stackPromise.blockingGet(0);
                                if (stack2 == null) continue;
                                dump.addThread((DlvApi.Goroutine)stack2.first, (List)stack2.second);
                            }
                            catch (ExecutionException | TimeoutException exception) {}
                        }
                        start = pack.Nextg;
                    }
                }
                catch (ProcessCanceledException e) {
                    dump.setIncomplete();
                    if (dump.getThreadCount() != 0) break block8;
                    throw e;
                }
            }
            dump.sort();
            return dump;
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(62);
        }
        return promise;
    }

    private static void waitForLatch(@NotNull ProgressIndicator progress, @NotNull CountDownLatch latch) {
        if (progress == null) {
            DlvDebugProcess.$$$reportNull$$$0(63);
        }
        if (latch == null) {
            DlvDebugProcess.$$$reportNull$$$0(64);
        }
        while (!progress.isCanceled()) {
            try {
                if (!latch.await(1L, TimeUnit.SECONDS)) continue;
            }
            catch (InterruptedException e) {}
            break;
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static <T> T waitForPromise(@NotNull ProgressIndicator progress, @NotNull Promise<T> promise) {
        if (progress == null) {
            DlvDebugProcess.$$$reportNull$$$0(65);
        }
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(66);
        }
        while (true) {
            progress.checkCanceled();
            try {
                return (T)promise.blockingGet(1, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            DlvDebugProcess.$$$reportNull$$$0(67);
        }
        if (topToolbar == null) {
            DlvDebugProcess.$$$reportNull$$$0(68);
        }
        if (settings == null) {
            DlvDebugProcess.$$$reportNull$$$0(69);
        }
        if (!UIExperiment.isNewDebuggerUIEnabled()) {
            Constraints afterMute = new Constraints(Anchor.AFTER, "XDebugger.MuteBreakpoints");
            leftToolbar.add((AnAction)Separator.getInstance(), afterMute);
            leftToolbar.addAction(ActionManager.getInstance().getAction("DlvDumpAction"), afterMute);
            leftToolbar.add((AnAction)Separator.getInstance(), afterMute);
        }
    }

    public boolean isThreadDumpInProgress() {
        return this.myThreadDumpSemaphore.availablePermits() == 0;
    }

    public boolean checkCanPerformCommands() {
        XDebugSession session = this.getSession();
        if (this.isThreadDumpInProgress()) {
            DlvDebugProcess.showNotification(session.getProject(), NotificationType.WARNING, GoBundle.message((String)"go.debugger.thread.dump.is.in.progress", (Object[])new Object[0]));
            return false;
        }
        if (this.myComplexCommandIsInProcess.get()) {
            DlvDebugProcess.showNotification(session.getProject(), NotificationType.WARNING, GoBundle.message((String)"go.debugger.another.command.is.in.progress", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public @NotNull Promise<@Nullable DlvThreadDump> getThreadDump(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            DlvDebugProcess.$$$reportNull$$$0(70);
        }
        if (this.myProcessExited) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(71);
            }
            return promise;
        }
        if (!this.myThreadDumpSemaphore.tryAcquire()) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                DlvDebugProcess.$$$reportNull$$$0(72);
            }
            return promise;
        }
        AtomicBoolean wasRunning = new AtomicBoolean();
        Consumer<DlvThreadDump> release = dump -> {
            if (dump != null) {
                this.myLastDump.set((DlvThreadDump)dump);
            }
            this.myComplexCommandIsInProcess.set(false);
            if (wasRunning.get()) {
                this.command("continue");
            }
            this.myThreadDumpSemaphore.release();
        };
        String prefix = GoBundle.message((String)"go.debugger.goroutine", (Object[])new Object[0]);
        DlvThreadDump dump2 = new DlvThreadDump(this, this.myUnknownFunctionName, String.valueOf(this.myThreadDumpCount.incrementAndGet()), prefix, this.myLastDump.get());
        this.myComplexCommandIsInProcess.set(true);
        Promise promise = this.send(new DlvRequest.State(true)).thenAsync(state -> {
            wasRunning.set(state.running);
            return state.running ? this.send(new DlvRequest.Command("halt")) : Promises.resolvedPromise();
        }).thenAsync(__ -> this.fillDump(progress, dump2)).onSuccess(release).onError(error -> {
            try {
                if (error instanceof ProcessCanceledException) {
                    DlvVm.LOG.debug("Thread dump canceled");
                    return;
                }
                DlvVm.LOG.warn(error);
                String details = error.getMessage();
                if (details == null) {
                    details = error.getClass().getName();
                }
                DlvDebugProcess.showNotification(this.getSession().getProject(), NotificationType.WARNING, GoBundle.message((String)"go.debugger.thread.dump.error", (Object[])new Object[]{details}));
            }
            finally {
                release.accept(null);
            }
        });
        if (promise == null) {
            DlvDebugProcess.$$$reportNull$$$0(73);
        }
        return promise;
    }

    public void setLastSelectedDump(@NotNull DlvThreadDump dump) {
        if (dump == null) {
            DlvDebugProcess.$$$reportNull$$$0(74);
        }
        this.myLastSelectedDump.set(dump);
    }

    @Nullable
    public DlvThreadDump getLastSelectedDump() {
        return this.myLastSelectedDump.get();
    }

    @NotNull
    public DlvSymbolPrettier getSymbolPrettier() {
        DlvSymbolPrettier dlvSymbolPrettier = this.mySymbolPrettier;
        if (dlvSymbolPrettier == null) {
            DlvDebugProcess.$$$reportNull$$$0(75);
        }
        return dlvSymbolPrettier;
    }

    @NotNull
    public VmConnection<?> getConnection() {
        VmConnection<?> vmConnection = this.myConnection;
        if (vmConnection == null) {
            DlvDebugProcess.$$$reportNull$$$0(76);
        }
        return vmConnection;
    }

    static void runInBackground(@NotNull Runnable r) {
        if (r == null) {
            DlvDebugProcess.$$$reportNull$$$0(77);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(r);
        } else {
            r.run();
        }
    }

    @NotNull
    public static @NotNull Pair<@NotNull String, @NotNull String> getBundledDelveArtifactVersionAndCommit() throws IOException {
        InputStream stream = DlvDebugProcess.class.getClassLoader().getResourceAsStream("delve.properties");
        if (stream == null) {
            throw new IllegalStateException("Bundled delve properties not found");
        }
        PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
        String delveArtifactVersion = bundle.getString("delveVersion");
        if (StringUtil.isEmptyOrSpaces((String)delveArtifactVersion)) {
            throw new IllegalStateException("Delve version is missing");
        }
        String delveCommit = bundle.getString("delveCommit");
        if (StringUtil.isEmptyOrSpaces((String)delveCommit)) {
            throw new IllegalStateException("Delve commit is missing");
        }
        Pair pair = Pair.create((Object)delveArtifactVersion, (Object)delveCommit);
        Pair pair2 = pair;
        if (pair2 == null) {
            DlvDebugProcess.$$$reportNull$$$0(78);
        }
        return pair2;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Nullable
    public static String getDelveCommit(@Nullable String delveVersion) {
        if (delveVersion == null) {
            return null;
        }
        String commitPrefix = "Build: ";
        for (String line : StringUtil.splitByLines((String)delveVersion)) {
            if (!line.startsWith(commitPrefix)) continue;
            return StringUtil.trimStart((String)line, (String)commitPrefix).trim();
        }
        return null;
    }

    private /* synthetic */ void lambda$clearBreakpoints$51(IntSet processed, List promises, Integer id) {
        if (id != null && processed.add(id.intValue())) {
            promises.add(this.send(new DlvRequest.ClearBreakpoint(id)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20, 26, 28, 30, 31, 32, 34, 35, 38, 39, 40, 41, 42, 43, 44, 50, 52, 53, 54, 55, 57, 58, 59, 62, 71, 72, 73, 75, 76, 78 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvDebugProcess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 7: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcesList";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepAction";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goroutinesPack";
                break;
            }
            case 60: 
            case 63: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 61: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latch";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvDebugProcess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "consumeDebuggerState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "consumeStateWithError";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "send";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "initBreakpoints";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "initPositionConverter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveRemoteProperties";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDelveForInit";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectActionEvent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "checkGoVersion";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "command";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "switchToStackSelectedInUi";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "step";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "stepSkippingAutogeneratedFrames";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "stopAsync";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "interruptProcessOrHaltDebugger";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderers";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getStacktrace";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnyGoroutine";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoroutine";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoroutineInner";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "fillDump";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDump";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolPrettier";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledDelveArtifactVersionAndCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "consumeDebuggerState";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "consumeStateWithError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEditCustomPropertiesAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProjectActionEvent";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPositionConverter";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "command";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "continueVmInBackground";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "continueVm";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "continueAndClearBreakpoint";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDoNotAskOption";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "pauseIfNeededAndProcess";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerPath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentProcess";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findGoroutineInner";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "fillDump";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "waitForLatch";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getThreadDump";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setLastSelectedDump";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20, 26, 28, 30, 31, 32, 34, 35, 38, 39, 40, 41, 42, 43, 44, 50, 52, 53, 54, 55, 57, 58, 59, 62, 71, 72, 73, 75, 76, 78 -> new IllegalStateException(string);
        };
    }

    private final class MyBreakpointHandler
    extends XBreakpointHandler<XLineBreakpoint<DlvBreakpointProperties>> {
        private MyBreakpointHandler() {
            super(DlvBreakpointType.class);
        }

        public void registerBreakpoint(@NotNull XLineBreakpoint<DlvBreakpointProperties> breakpoint) {
            XSourcePosition breakpointPosition;
            if (breakpoint == null) {
                MyBreakpointHandler.$$$reportNull$$$0(0);
            }
            if ((breakpointPosition = breakpoint.getSourcePosition()) == null) {
                return;
            }
            VirtualFile file = breakpointPosition.getFile();
            int line = breakpointPosition.getLine();
            XExpression expression = breakpoint.getConditionExpression();
            String condition = expression != null ? expression.getExpression() : null;
            String debuggerPath = DlvDebugProcess.this.getDebuggerPath(file);
            if (debuggerPath == null) {
                DlvDebugProcess.this.getSession().setBreakpointInvalid(breakpoint, GoBundle.message((String)"go.debugger.cannot.find.debugger.path", (Object[])new Object[]{file.getPath()}));
            } else {
                DlvDebugProcess.this.pauseIfNeededAndProcess(() -> this.sendSetBreakpoint(breakpoint, line, condition, debuggerPath));
            }
        }

        public void unregisterBreakpoint(@NotNull XLineBreakpoint<DlvBreakpointProperties> breakpoint, boolean temporary) {
            XSourcePosition breakpointPosition;
            if (breakpoint == null) {
                MyBreakpointHandler.$$$reportNull$$$0(1);
            }
            if ((breakpointPosition = breakpoint.getSourcePosition()) == null) {
                return;
            }
            DlvDebugProcess.this.pauseIfNeededAndProcess(() -> {
                Integer id = DlvDebugProcess.this.myBreakpoints.remove(breakpoint);
                return id != null ? DlvDebugProcess.this.send(new DlvRequest.ClearBreakpoint(id)) : Promises.resolvedPromise();
            });
        }

        private Promise<DlvApi.Breakpoint> sendSetBreakpoint(@NotNull XLineBreakpoint<DlvBreakpointProperties> breakpoint, int line, @Nullable String condition, @NotNull String path) {
            if (breakpoint == null) {
                MyBreakpointHandler.$$$reportNull$$$0(2);
            }
            if (path == null) {
                MyBreakpointHandler.$$$reportNull$$$0(3);
            }
            return DlvDebugProcess.this.send(new DlvRequest.CreateBreakpoint(path, line + 1, condition)).onSuccess(b -> {
                DlvDebugProcess.this.myBreakpoints.put((XBreakpoint<DlvBreakpointProperties>)breakpoint, b.id);
                DlvDebugProcess.this.getSession().setBreakpointVerified(breakpoint);
            }).onError(t -> {
                String message;
                String string = message = t == null ? null : t.getMessage();
                if (message != null && message.equals("could not find file " + path)) {
                    message = GoBundle.message((String)"go.debugger.no.debug.information.for.file", (Object[])new Object[]{path});
                }
                DlvDebugProcess.this.getSession().setBreakpointInvalid(breakpoint, message);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpoint";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/goide/dlv/DlvDebugProcess$MyBreakpointHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerBreakpoint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregisterBreakpoint";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sendSetBreakpoint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

