/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvMapEntryXValue;
import com.goide.dlv.DlvNamedType;
import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvStackFrame;
import com.goide.dlv.DlvSymbolPrettier;
import com.goide.dlv.DlvVm;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.dlv.renderer.DlvDefaultSliceOrArrayPresentation;
import com.goide.dlv.renderer.DlvValueRenderer;
import com.goide.dlv.renderer.DlvValueRenderers;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReference;
import com.goide.refactor.GoNamesValidator;
import com.goide.stubs.index.GoTypesIndex;
import com.goide.utils.GoStringUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DlvXValue
extends XNamedValue {
    static final int NOT_CALL_RESULT = -1;
    @Nullable
    private final DlvXValue myParent;
    @NotNull
    private volatile DlvApi.Variable myVariable;
    public final long myGoroutineId;
    private final Icon myIcon;
    private final DlvDebugProcess myProcess;
    public final int myFrameId;
    @TestOnly
    private final AtomicInteger myLoadedChildren;
    @Nullable
    private final DlvXValue myFollowedPointer;
    private volatile int myCallResultCount;

    /*
     * WARNING - void declaration
     */
    private DlvXValue(@NotNull String name, @NotNull DlvDebugProcess process, @Nullable DlvXValue parent, @NotNull DlvApi.Variable variable, int frameId, long goroutineId, @Nullable Icon icon, @Nullable DlvXValue dlvXValue) {
        void followedPointer;
        if (name == null) {
            DlvXValue.$$$reportNull$$$0(0);
        }
        if (process == null) {
            DlvXValue.$$$reportNull$$$0(1);
        }
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(2);
        }
        super(name);
        this.myLoadedChildren = new AtomicInteger(0);
        this.myCallResultCount = -1;
        this.myProcess = process;
        this.myParent = parent;
        this.myVariable = variable;
        this.myGoroutineId = goroutineId;
        this.myIcon = icon;
        this.myFrameId = frameId;
        this.myFollowedPointer = followedPointer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static DlvXValue create(@NotNull DlvDebugProcess process, @Nullable DlvXValue parent, @NotNull DlvApi.Variable variable, int frameId, long goroutineId, @Nullable Icon icon) {
        void icon2;
        if (process == null) {
            DlvXValue.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(4);
        }
        return DlvXValue.create(variable.name, process, parent, variable, frameId, goroutineId, (Icon)icon2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static DlvXValue create(@NotNull String name, @NotNull DlvDebugProcess process, @Nullable DlvXValue parent, @NotNull DlvApi.Variable variable, int frameId, long goroutineId, @Nullable Icon icon) {
        void icon2;
        if (name == null) {
            DlvXValue.$$$reportNull$$$0(5);
        }
        if (process == null) {
            DlvXValue.$$$reportNull$$$0(6);
        }
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(7);
        }
        return DlvXValue.createInner(name, process, parent, variable, frameId, goroutineId, (Icon)icon2);
    }

    @NotNull
    public static DlvXValue createCallResult(@NotNull String expression, @NotNull List<DlvApi.Variable> callResults, @NotNull DlvDebugProcess process, int frameId, long goroutineId) {
        DlvXValue val;
        if (expression == null) {
            DlvXValue.$$$reportNull$$$0(8);
        }
        if (callResults == null) {
            DlvXValue.$$$reportNull$$$0(9);
        }
        if (process == null) {
            DlvXValue.$$$reportNull$$$0(10);
        }
        switch (callResults.size()) {
            case 0: {
                val = DlvXValue.createVoidCallResult(expression, process, frameId, goroutineId);
                val.myCallResultCount = 0;
                break;
            }
            case 1: {
                val = DlvXValue.create(expression, process, null, callResults.get(0), frameId, goroutineId, AllIcons.Debugger.Watch);
                val.myCallResultCount = 1;
                break;
            }
            default: {
                DlvApi.Variable resultVar = new DlvApi.Variable();
                resultVar.type = "";
                resultVar.value = "";
                resultVar.name = "result";
                resultVar.type = callResults.stream().map(it -> it.type).collect(Collectors.joining(", "));
                resultVar.children = callResults.toArray(new DlvApi.Variable[0]);
                val = DlvXValue.create(expression, process, null, resultVar, frameId, goroutineId, AllIcons.Debugger.Watch);
                val.myCallResultCount = resultVar.children.length;
            }
        }
        DlvXValue dlvXValue = val;
        if (dlvXValue == null) {
            DlvXValue.$$$reportNull$$$0(11);
        }
        return dlvXValue;
    }

    @NotNull
    private static DlvXValue createVoidCallResult(final @NotNull String expression, @NotNull DlvDebugProcess process, int frameId, long goroutineId) {
        if (expression == null) {
            DlvXValue.$$$reportNull$$$0(12);
        }
        if (process == null) {
            DlvXValue.$$$reportNull$$$0(13);
        }
        final DlvApi.Variable resultVar = new DlvApi.Variable();
        resultVar.type = "";
        resultVar.name = "result";
        resultVar.value = "undefined";
        return new DlvXValue(expression, process, null, resultVar, frameId, goroutineId, null, null){

            @Override
            public String getEvaluationExpression() {
                return expression;
            }

            @Override
            public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    1.$$$reportNull$$$0(1);
                }
                XValuePresentation p = new XValuePresentation(){

                    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                        if (renderer == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        renderer.renderValue(resultVar.value);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/goide/dlv/DlvXValue$1$1", "renderValue"));
                    }
                };
                node2.setPresentation(null, p, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "place";
                        break;
                    }
                }
                objectArray[1] = "com/goide/dlv/DlvXValue$1";
                objectArray[2] = "computePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static DlvXValue createInner(@NotNull String name, @NotNull DlvDebugProcess process, @Nullable DlvXValue parent, @NotNull DlvApi.Variable variable, int frameId, long goroutineId, @Nullable Icon icon) {
        void icon2;
        if (name == null) {
            DlvXValue.$$$reportNull$$$0(14);
        }
        if (process == null) {
            DlvXValue.$$$reportNull$$$0(15);
        }
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(16);
        }
        DlvXValue followedPointer = null;
        DlvApi.Variable v = variable;
        while ((v.isPtr() || v.isInterface()) && v.children.length == 1) {
            followedPointer = new DlvXValue(name, process, parent, v, frameId, goroutineId, (Icon)icon2, followedPointer);
            v = v.children[0];
        }
        if (DlvXValue.isTruncatedString(v) && followedPointer != null) {
            DlvXValue dlvXValue = followedPointer;
            if (dlvXValue == null) {
                DlvXValue.$$$reportNull$$$0(17);
            }
            return dlvXValue;
        }
        return new DlvXValue(name, process, parent, v, frameId, goroutineId, (Icon)icon2, followedPointer);
    }

    private static boolean isTruncatedString(@NotNull DlvApi.Variable v) {
        if (v == null) {
            DlvXValue.$$$reportNull$$$0(18);
        }
        return v.isString() && v.len != 0L && v.value.isEmpty();
    }

    public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(19);
        }
        if (place == null) {
            DlvXValue.$$$reportNull$$$0(20);
        }
        this.computePresentation(node2).onSuccess(presentation2 -> {
            boolean isPartiallyLoadedString;
            int maxStringLen = DlvSettings.getInstance().getMaxStringLen();
            boolean bl = isPartiallyLoadedString = this.myVariable.isString() && this.myVariable.len > (long)maxStringLen && this.myVariable.len < 0xA00000L;
            if (!this.isPartOfCallResult() && (isPartiallyLoadedString || DlvXValue.isNonEmptyByteSliceOrArray(this.myVariable) && presentation2 instanceof DlvDefaultSliceOrArrayPresentation)) {
                node2.setFullValueEvaluator((XFullValueEvaluator)new MyXFullValueEvaluator());
            }
            node2.setPresentation(this.getIcon(), presentation2, this.hasChildren());
        }).onError(error -> {
            DlvVm.LOG.debug("Failed to compute debug node presentation", error);
            String errorMessage = GoBundle.message((String)"go.debugger.failed.to.compute.node.presentation", (Object[])new Object[0]);
            node2.setPresentation(this.getIcon(), (XValuePresentation)new XErrorValuePresentation(errorMessage), false);
        });
    }

    private static boolean isNonEmptyByteSliceOrArray(@NotNull DlvApi.Variable v) {
        if (v == null) {
            DlvXValue.$$$reportNull$$$0(21);
        }
        if (v.len == 0L || !v.isArray() && !v.isSlice()) {
            return false;
        }
        DlvApi.Variable child = v.children != null && v.children.length > 0 ? v.children[0] : null;
        return child != null && child.isUint8();
    }

    private boolean isPartOfCallResult() {
        DlvXValue value2 = this;
        do {
            if (!value2.isCallResult()) continue;
            return true;
        } while ((value2 = value2.myParent) != null);
        return false;
    }

    private boolean isCallResult() {
        return this.myCallResultCount > -1;
    }

    @NotNull
    private Icon getIcon() {
        if (this.myIcon != null) {
            Icon icon = this.myIcon;
            if (icon == null) {
                DlvXValue.$$$reportNull$$$0(22);
            }
            return icon;
        }
        if (this.myVariable.isNumber() || this.myVariable.isString() || this.myVariable.isBool()) {
            Icon icon = AllIcons.Debugger.Db_primitive;
            if (icon == null) {
                DlvXValue.$$$reportNull$$$0(23);
            }
            return icon;
        }
        if (this.myVariable.isArray() || this.myVariable.isSlice()) {
            Icon icon = AllIcons.Debugger.Db_array;
            if (icon == null) {
                DlvXValue.$$$reportNull$$$0(24);
            }
            return icon;
        }
        Icon icon = AllIcons.Debugger.Value;
        if (icon == null) {
            DlvXValue.$$$reportNull$$$0(25);
        }
        return icon;
    }

    private boolean hasChildren() {
        return this.myVariable.children != null && this.myVariable.children.length > 0 || !DlvXValue.isCompleteVariable(this.myVariable);
    }

    private static byte parseUint8(@NotNull String value2) {
        int n;
        if (value2 == null) {
            DlvXValue.$$$reportNull$$$0(26);
        }
        if ((n = Integer.parseInt(value2)) < 0 || n > 255) {
            throw new RuntimeException("Uint8 value out of range: " + value2);
        }
        return (byte)(n & 0xFF);
    }

    @Nullable
    public String getEvaluationExpression() {
        return this.getEvaluationExpression(true);
    }

    @NotNull
    private String getEvaluationExpression(boolean traverseParents) {
        String name = this.getTopLevelVariableName(traverseParents);
        if (StringUtil.isNotEmpty((String)name)) {
            String string = name;
            if (string == null) {
                DlvXValue.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = "*(*\"" + this.myVariable.realType + "\")(" + String.valueOf(this.myVariable.addr) + ")";
        if (string == null) {
            DlvXValue.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    private String getTopLevelVariableName(boolean traverseParents) {
        DlvApi.Variable parentVar;
        if (!this.isFollowedPointer() && this.myParent == null) {
            return StringUtil.nullize((String)this.myVariable.name);
        }
        if (!traverseParents) {
            return null;
        }
        DlvXValue child = this;
        DlvXValue parent = this.myFollowedPointer;
        while (parent != null && ((parentVar = parent.myVariable).isInterface() || parentVar.isPtr()) && parentVar.children.length == 1 && child.myVariable == parentVar.children[0]) {
            if (!parent.isFollowedPointer() && parent.myParent == null) {
                return StringUtil.nullize((String)parentVar.name);
            }
            child = parent;
            parent = parent.myFollowedPointer;
        }
        return null;
    }

    public void computeChildren(@NotNull XCompositeNode node2) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(29);
        }
        this.computeChildren(node2, 0);
    }

    public void computeChildren(@NotNull XCompositeNode node2, int startFrom) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(30);
        }
        DlvApi.Variable variable = this.myVariable;
        if (this.isCallResult()) {
            if (startFrom < variable.children.length) {
                this.computeChildrenInner(node2, variable, variable.children, 0);
            } else if (!DlvXValue.isCompleteVariable(this.myVariable)) {
                XValueChildrenList list = new XValueChildrenList(1);
                list.add(new XNamedValue("error"){

                    public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
                        if (node2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (place == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        node2.setPresentation(XDebuggerUIConstants.ERROR_MESSAGE_ICON, new XValuePresentation(){

                            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                                if (renderer == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                renderer.renderError(GoBundle.message((String)"go.debugger.cannot.load.remaining.call.result.children", (Object[])new Object[0]));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/goide/dlv/DlvXValue$2$1", "renderValue"));
                            }
                        }, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "node";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "place";
                                break;
                            }
                        }
                        objectArray[1] = "com/goide/dlv/DlvXValue$2";
                        objectArray[2] = "computePresentation";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                node2.addChildren(list, true);
            }
            return;
        }
        if (!DlvXValue.isCompleteVariable(variable)) {
            if ((variable.isArray() || variable.isMap() || variable.isSlice() || variable.isStructure()) && variable.children != null && variable.children.length <= startFrom) {
                int startOffset = variable.isMap() ? startFrom / 2 : startFrom;
                String expression = variable.isStructure() ? DlvXValue.evaluationExpression(variable) : "(" + DlvXValue.evaluationExpression(variable) + ")[" + startOffset + ":]";
                this.myProcess.send(new DlvRequest.Eval(expression, this.myFrameId, this.myGoroutineId)).onSuccess(v -> this.computeChildrenInner(node2, variable, v.children, startFrom)).onError(t -> {
                    DlvVm.LOG.warn("Cannot load rest children: " + expression, t);
                    super.computeChildren(node2);
                });
                return;
            }
            if ((variable.isPtr() || variable.isInterface()) && !DlvXValue.isZero(variable.addr) && variable.children.length == 0 && variable.onlyAddr) {
                String expression = DlvXValue.evaluationExpression(variable);
                this.myProcess.send(new DlvRequest.Eval(expression, this.myFrameId, this.myGoroutineId)).onSuccess(v -> {
                    if (v.children.length == 1 && DlvXValue.isZero(v.children[0].addr) && StringUtil.isEmpty((String)v.children[0].value)) {
                        v.name = "";
                        v.type = "";
                        this.computeChildrenInner(node2, variable, new DlvApi.Variable[]{v}, startFrom);
                    } else {
                        this.computeChildrenInner(node2, variable, v.children, startFrom);
                    }
                }).onError(t -> {
                    DlvVm.LOG.warn("Cannot load rest children: " + expression, t);
                    super.computeChildren(node2);
                });
                return;
            }
        } else if (BigInteger.ZERO.equals(variable.addr) && variable.children != null && variable.children.length > 0 && (variable.isSlice() || variable.isArray())) {
            this.computeChildrenInner(node2, variable, variable.children, 0);
            return;
        }
        String expression = DlvXValue.evaluationExpression(variable);
        this.myProcess.send(new DlvRequest.Eval(expression, this.myFrameId, this.myGoroutineId)).onSuccess(v -> {
            this.myVariable = v;
            this.computeChildrenInner(node2, (DlvApi.Variable)v, v.children, 0);
        }).onError(t -> {
            DlvVm.LOG.warn("Cannot evaluate nested variable: " + expression, t);
            super.computeChildren(node2);
        });
    }

    @NotNull
    public static String evaluationExpression(@NotNull DlvApi.Variable variable) {
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(31);
        }
        StringBuilder expression = new StringBuilder("*(*\"");
        GoStringUtil.escapeString(variable.realType, expression);
        String string = expression.append("\")(").append(variable.addr).append(")").toString();
        if (string == null) {
            DlvXValue.$$$reportNull$$$0(32);
        }
        return string;
    }

    @TestOnly
    public int getLoadedChildrenCount() {
        return this.myLoadedChildren.get();
    }

    private static boolean isCompleteVariable(@NotNull DlvApi.Variable variable) {
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(33);
        }
        if (DlvXValue.isUnreadable(variable)) {
            return true;
        }
        if (variable.isPtr() || variable.isInterface()) {
            return variable.children.length != 0 && (variable.children.length != 1 || !variable.children[0].onlyAddr || DlvXValue.isZero(variable.addr));
        }
        if (variable.isStructure() || variable.isArray() || variable.isSlice()) {
            return !variable.onlyAddr && (variable.len == 0L || (long)variable.children.length == variable.len);
        }
        if (variable.isMap()) {
            return !variable.onlyAddr && (long)(variable.children.length / 2) == variable.len;
        }
        return true;
    }

    private void computeChildrenInner(@NotNull XCompositeNode node2, @NotNull DlvApi.Variable variable, DlvApi.Variable @Nullable [] childrenToAdd, int startIndexInParent) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(34);
        }
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(35);
        }
        if (childrenToAdd == null || childrenToAdd.length == 0) {
            super.computeChildren(node2);
        } else {
            int remaining;
            Icon icon;
            int nextBatchStart = startIndexInParent + childrenToAdd.length;
            Icon icon2 = icon = variable.isStructure() ? AllIcons.Nodes.Field : null;
            if (variable.isMap()) {
                XValueChildrenList list = new XValueChildrenList(childrenToAdd.length / 2);
                for (int i = 0; i < childrenToAdd.length; i += 2) {
                    int indexInParent = startIndexInParent + i;
                    String name = String.valueOf(indexInParent / 2);
                    DlvXValue k = DlvXValue.create(name, this.myProcess, this, childrenToAdd[i], this.myFrameId, this.myGoroutineId, icon);
                    DlvXValue v = DlvXValue.create(name, this.myProcess, this, childrenToAdd[i + 1], this.myFrameId, this.myGoroutineId, icon);
                    list.add((XNamedValue)new DlvMapEntryXValue(name, k, v));
                    this.myLoadedChildren.addAndGet(2);
                }
                node2.addChildren(list, true);
                int remaining2 = (int)(this.myVariable.len * 2L) - nextBatchStart;
                if (remaining2 > 0) {
                    int remainingEntriesCount = remaining2 / 2;
                    node2.tooManyChildren(remainingEntriesCount, () -> this.computeChildren(node2, nextBatchStart));
                }
                return;
            }
            XValueChildrenList list = new XValueChildrenList(childrenToAdd.length);
            for (int i = 0; i < childrenToAdd.length; ++i) {
                DlvXValue value2 = variable.isSlice() || variable.isArray() ? DlvXValue.create(String.valueOf(startIndexInParent + i), this.myProcess, this, childrenToAdd[i], this.myFrameId, this.myGoroutineId, icon) : DlvXValue.create(this.myProcess, this, childrenToAdd[i], this.myFrameId, this.myGoroutineId, icon);
                list.add(value2.getName(), (XValue)value2);
                this.myLoadedChildren.incrementAndGet();
            }
            node2.addChildren(list, true);
            if ((variable.isArray() || variable.isSlice()) && (remaining = (int)this.myVariable.len - nextBatchStart) > 0) {
                node2.tooManyChildren(remaining, () -> this.computeChildren(node2, nextBatchStart));
            }
        }
    }

    @Nullable
    public XValueModifier getModifier() {
        if (this.myProcess.isRecorded()) {
            return null;
        }
        final String evalExpression = this.getEvaluationExpression(false);
        return new XValueModifier(){

            public void setValue(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    3.$$$reportNull$$$0(1);
                }
                DlvRequest.DlvObjRequest command = DlvXValue.this.myVariable.isString() ? new DlvRequest.Call(evalExpression + "=" + DlvXValue.quote(expression.getExpression())) : new DlvRequest.Set(evalExpression, expression.getExpression(), DlvXValue.this.myGoroutineId, DlvXValue.this.myFrameId);
                DlvXValue.this.myProcess.send(command).onProcessed(o -> {
                    if (o != null) {
                        callback.valueModified();
                    }
                }).onError(throwable -> callback.errorOccurred(throwable.getMessage()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/goide/dlv/DlvXValue$3";
                objectArray[2] = "setValue";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static String quote(@NotNull String s) {
        if (s == null) {
            DlvXValue.$$$reportNull$$$0(36);
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = StringUtil.unquoteString((String)s);
        }
        String string = "\"" + StringUtil.escapeQuotes((String)s) + "\"";
        if (string == null) {
            DlvXValue.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static boolean isUnreadable(@NotNull DlvApi.Variable variable) {
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(38);
        }
        return StringUtil.isNotEmpty((String)StringUtil.trim((String)variable.unreadable));
    }

    public boolean isUnreadable() {
        return DlvXValue.isUnreadable(this.myVariable);
    }

    public boolean isNil() {
        return this.myVariable.isChan() && this.myVariable.children.length == 0 || this.myVariable.isInterface() && DlvXValue.isZero(this.myVariable.addr) || this.myVariable.isFunction() && StringUtil.isEmpty((String)this.myVariable.value) || (this.myVariable.isSlice() || this.myVariable.isMap()) && DlvXValue.isZero(this.myVariable.base) && !this.hasChildren() || this.isFollowedPointer() && DlvXValue.isZero(this.myVariable.addr) && StringUtil.isEmpty((String)this.myVariable.value);
    }

    @NotNull
    @NotNull Promise<@NotNull XValuePresentation> computePresentation(@NotNull XValueNode node2) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(39);
        }
        Promise<XValuePresentation> promise = DlvXValue.executeOnBGT(() -> {
            DlvStackFrame frame = (DlvStackFrame)((Object)((Object)ObjectUtils.tryCast((Object)this.myProcess.getSession().getCurrentStackFrame(), DlvStackFrame.class)));
            DlvValueRenderer renderer = this.myProcess.getRenderers().getRenderer(frame, node2, this);
            return renderer.getPresentation(node2, this).thenAsync(presentation2 -> presentation2 != null ? Promises.resolvedPromise((Object)presentation2) : DlvValueRenderers.DEFAULT.getPresentation(node2, this));
        });
        if (promise == null) {
            DlvXValue.$$$reportNull$$$0(40);
        }
        return promise;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Promise<XValuePresentation> executeOnBGT(Supplier<@NotNull Promise<XValuePresentation>> presentationSupplier) {
        @NotNull AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ((Promise)presentationSupplier.get()).processed((Promise)promise));
        return promise;
    }

    public @NotNull Promise<@Nullable String> getTypePresentationAsync(@NotNull XValueNode node2) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(41);
        }
        if (node2.isObsolete()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DlvXValue.$$$reportNull$$$0(42);
            }
            return promise;
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> node2.isObsolete() ? null : this.getTypePresentation()).submit((Executor)NonUrgentExecutor.getInstance());
        if (cancellablePromise == null) {
            DlvXValue.$$$reportNull$$$0(43);
        }
        return cancellablePromise;
    }

    @Nullable
    private String getTypePresentation() {
        BigInteger address;
        DlvSettings settings = DlvSettings.getInstance();
        StringBuilder result = new StringBuilder();
        if (settings.getShowTypes()) {
            StringUtil.join(this.getTypeParts(), (String)" | ", (StringBuilder)result);
        }
        if (settings.getShowPointerAddresses() && (address = this.getPointerAddress()) != null) {
            if (!result.isEmpty()) {
                result.append(" | ");
            }
            result.append("0x");
            result.append(address.toString(16));
        }
        return StringUtil.nullize((String)result.toString());
    }

    @Nullable
    private BigInteger getPointerAddress() {
        DlvXValue pointer = this.getTopFollowedPointer();
        DlvApi.Variable pointerVar = pointer != null ? pointer.getVariable() : null;
        return pointerVar != null && pointerVar.isPtr() && pointerVar.children.length == 1 ? pointerVar.children[0].addr : null;
    }

    @NotNull
    public @NotNull Promise<@NotNull List<String>> getTypePartsAsync(@NotNull XValueNode node2) {
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(44);
        }
        if (node2.isObsolete()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DlvXValue.$$$reportNull$$$0(45);
            }
            return promise;
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> node2.isObsolete() ? null : this.getTypeParts()).submit((Executor)NonUrgentExecutor.getInstance());
        if (cancellablePromise == null) {
            DlvXValue.$$$reportNull$$$0(46);
        }
        return cancellablePromise;
    }

    @NotNull
    private List<String> getTypeParts() {
        ArrayList<String> typesReversed = new ArrayList<String>();
        DlvXValue value2 = this;
        DlvSymbolPrettier prettier = this.myProcess.getSymbolPrettier();
        while (value2 != null) {
            DlvApi.Variable var = value2.getVariable();
            if (var.isPtr()) {
                if (typesReversed.isEmpty()) {
                    typesReversed.add(prettier.prettifyType(var.type));
                } else {
                    typesReversed.set(typesReversed.size() - 1, prettier.prettifyType(var.type));
                }
            } else {
                typesReversed.add(prettier.prettifyType(var.type));
            }
            value2 = value2.myFollowedPointer;
        }
        Collections.reverse(typesReversed);
        if ("void".equals(ContainerUtil.getLastItem(typesReversed))) {
            typesReversed.remove(typesReversed.size() - 1);
        }
        ArrayList<String> arrayList = typesReversed;
        if (arrayList == null) {
            DlvXValue.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    @NotNull
    public DlvApi.Variable getVariable() {
        DlvApi.Variable variable = this.myVariable;
        if (variable == null) {
            DlvXValue.$$$reportNull$$$0(48);
        }
        return variable;
    }

    public static boolean isZero(@Nullable BigInteger o) {
        return BigInteger.ZERO.equals(o);
    }

    @Nullable
    private PsiElement findTargetElement(@NotNull Project project, @NotNull XSourcePosition position, @NotNull String name) {
        DlvXValue topmostParent;
        PsiFile file;
        if (project == null) {
            DlvXValue.$$$reportNull$$$0(49);
        }
        if (position == null) {
            DlvXValue.$$$reportNull$$$0(50);
        }
        if (name == null) {
            DlvXValue.$$$reportNull$$$0(51);
        }
        if ((file = PsiManager.getInstance((Project)project).findFile(position.getFile())) == null) {
            return null;
        }
        if (this.myParent != null && this.myParent.myVariable.isStructure()) {
            return this.findTargetField(project, this.myParent.myVariable.type, this.myName, file);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        Ref result = Ref.create();
        BigInteger declLine = ((topmostParent = this.getTopmostParent()) != null ? topmostParent.myVariable : this.myVariable).declLine;
        int varLine = declLine != null ? declLine.intValue() - 1 : 0;
        DlvStackFrame.processIdentifiers(file, document, varLine, (Processor<? super PsiElement>)((Processor)identifier -> {
            PsiElement parent = identifier.getParent();
            if ((parent instanceof GoVarDefinition || parent instanceof GoParamDefinition) && name.equals(((GoNamedElement)parent).getName())) {
                result.set((Object)parent);
                return false;
            }
            return true;
        }));
        if (!result.isNull()) {
            return (PsiElement)result.get();
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        int offset = varLine > 0 && document != null && varLine < document.getLineCount() ? document.getLineStartOffset(varLine) : position.getOffset();
        ASTNode leafElement = offset > 0 ? FormatterUtil.getNextNonWhitespaceLeaf((ASTNode)file.getNode().findLeafElementAt(offset)) : null;
        PsiElement visibleElement = leafElement != null ? leafElement.getPsi() : null;
        GoStatement statement = (GoStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)visibleElement, (Class[])new Class[]{GoStatement.class});
        PsiElement context = (PsiElement)ObjectUtils.chooseNotNull((Object)(statement != null ? statement.getNextSibling() : null), (Object)visibleElement);
        return context != null && GoNamesValidator.INSTANCE.isIdentifier(name, project) ? GoReference.create(name, context).resolve() : null;
    }

    @Nullable
    private DlvXValue getTopmostParent() {
        DlvXValue result = null;
        DlvXValue parent = this.myParent;
        while (parent != null) {
            result = parent;
            parent = parent.myParent;
        }
        return result;
    }

    @Nullable
    private PsiElement findTargetField(@NotNull Project project, @NotNull String structType, @NotNull String fieldName, @NotNull PsiFile file) {
        ResolveState state;
        GoVarDeclaration var;
        if (project == null) {
            DlvXValue.$$$reportNull$$$0(52);
        }
        if (structType == null) {
            DlvXValue.$$$reportNull$$$0(53);
        }
        if (fieldName == null) {
            DlvXValue.$$$reportNull$$$0(54);
        }
        if (file == null) {
            DlvXValue.$$$reportNull$$$0(55);
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        int index = structType.lastIndexOf(46);
        if (index == -1 || structType.startsWith("struct {")) {
            return null;
        }
        String importPath = structType.substring(0, index);
        String typeName = structType.substring(index + 1);
        if ("main".equals(importPath)) {
            VirtualFile mainFile = this.myProcess.getMainFile();
            Document document = mainFile != null ? FileDocumentManager.getInstance().getDocument(mainFile) : null;
            PsiFile mainPsiFile = document != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(document) : null;
            @NonNls String text = "package main; var a=" + typeName + "{}." + fieldName;
            var = mainPsiFile != null ? GoElementFactory.createElement(project, text, GoVarDeclaration.class, (PsiElement)mainPsiFile) : null;
            state = GoPsiImplUtil.createContextOnElement((PsiElement)mainPsiFile);
        } else {
            @NonNls String text = "package main; import pkg \"" + importPath + "\"; var a=pkg." + typeName + "{}." + fieldName;
            var = GoElementFactory.createElement(project, text, GoVarDeclaration.class);
            state = GoPsiImplUtil.createContextOnElement((PsiElement)file);
        }
        List<GoVarSpec> varSpecs = var != null ? var.getVarSpecList() : null;
        GoVarSpec spec = varSpecs != null && !varSpecs.isEmpty() ? varSpecs.get(0) : null;
        GoReferenceExpression expression = (GoReferenceExpression)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(spec != null ? spec.getExpressionList() : null), GoReferenceExpression.class);
        return expression != null ? expression.resolve(state) : null;
    }

    public void computeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            DlvXValue.$$$reportNull$$$0(56);
        }
        DlvXValue.readActionInPooledThread(new Runnable(){

            @Override
            public void run() {
                navigatable.setSourcePosition(this.findPosition());
            }

            @Nullable
            private XSourcePosition findPosition() {
                XDebugSession debugSession = DlvXValue.this.getSession();
                if (debugSession == null) {
                    return null;
                }
                XStackFrame stackFrame = debugSession.getCurrentStackFrame();
                if (stackFrame == null) {
                    return null;
                }
                Project project = debugSession.getProject();
                XSourcePosition position = debugSession.getCurrentPosition();
                if (position == null) {
                    return null;
                }
                String name = DlvXValue.this.myName.startsWith("*") || DlvXValue.this.myName.startsWith("&") ? DlvXValue.this.myName.substring(1) : DlvXValue.this.myName;
                PsiElement resolved = DlvXValue.this.findTargetElement(project, position, name);
                if (resolved == null) {
                    return null;
                }
                PsiFile containingFile = resolved.getContainingFile();
                if (containingFile == null) {
                    return null;
                }
                VirtualFile virtualFile = containingFile.getViewProvider().getVirtualFile();
                return XDebuggerUtil.getInstance().createPositionByOffset(virtualFile, resolved.getTextOffset());
            }
        });
    }

    private static void readActionInPooledThread(@NotNull Runnable runnable) {
        if (runnable == null) {
            DlvXValue.$$$reportNull$$$0(57);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ApplicationManager.getApplication().runReadAction(runnable));
    }

    @Nullable
    public Project getProject() {
        XDebugSession session = this.getSession();
        return session != null ? session.getProject() : null;
    }

    @Nullable
    XDebugSession getSession() {
        return this.myProcess.getSession();
    }

    @NotNull
    public DlvDebugProcess getProcess() {
        DlvDebugProcess dlvDebugProcess = this.myProcess;
        if (dlvDebugProcess == null) {
            DlvXValue.$$$reportNull$$$0(58);
        }
        return dlvDebugProcess;
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            DlvXValue.$$$reportNull$$$0(59);
        }
        if (this.myParent != null && this.myParent.myVariable.isStructure()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                DlvXValue.$$$reportNull$$$0(60);
            }
            return threeState;
        }
        this.computeSourcePosition(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            DlvXValue.$$$reportNull$$$0(61);
        }
        return threeState;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigateToTypeSource() {
        return (this.myVariable.isStructure() || this.myVariable.isPtr() || this.myVariable.isInterface() || this.myVariable.isFunction()) && this.getProject() != null;
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            DlvXValue.$$$reportNull$$$0(62);
        }
        DlvXValue.readActionInPooledThread(() -> {
            String name;
            boolean isStructure = this.myVariable.isStructure();
            boolean isInterface = this.myVariable.isInterface();
            boolean isFunction = this.myVariable.isFunction();
            boolean isPtr = this.myVariable.isPtr();
            if (!(isStructure || isPtr || isInterface || isFunction)) {
                return;
            }
            Project project = this.getProject();
            if (project == null) {
                return;
            }
            String typeName = this.myVariable.type;
            String fullName = (isPtr && typeName.startsWith("*") ? typeName.substring(1) : typeName).replaceFirst(isPtr ? "\\*struct " : "struct ", "");
            DlvNamedType dlvNamedType = DlvNamedType.parse(fullName);
            String string = name = dlvNamedType != null ? dlvNamedType.getTypeName() : null;
            if (StringUtil.isNotEmpty((String)name)) {
                GlobalSearchScope scope;
                GlobalSearchScope globalSearchScope = scope = dlvNamedType.isFromMainPackage() ? this.myProcess.getMainPackageScope() : GlobalSearchScope.allScope((Project)project);
                if (scope == null) {
                    return;
                }
                GoTypesIndex.process(name, project, scope, null, (Processor<? super GoTypeSpec>)((Processor)type -> {
                    if (DlvXValue.inPackagePath(type, dlvNamedType.getPackagePath())) {
                        navigatable.setSourcePosition(XDebuggerUtil.getInstance().createPositionByOffset(type.getContainingFile().getVirtualFile(), type.getTextOffset()));
                        return false;
                    }
                    return true;
                }));
            }
        });
    }

    private static boolean inPackagePath(@NotNull GoTypeSpec type, @NotNull String packagePath) {
        if (type == null) {
            DlvXValue.$$$reportNull$$$0(63);
        }
        if (packagePath == null) {
            DlvXValue.$$$reportNull$$$0(64);
        }
        return StringUtil.isEmpty((String)packagePath) || "main".equals(packagePath) || Objects.equals(type.getContainingFile().getImportPath(false), packagePath);
    }

    @Nullable
    public static DlvXValue getNodeValue(@NotNull XValueNode node2) {
        DlvXValue value2;
        XValueNodeImpl valueNode;
        XValueContainer xValueContainer;
        if (node2 == null) {
            DlvXValue.$$$reportNull$$$0(65);
        }
        return node2 instanceof XValueNodeImpl && (xValueContainer = (valueNode = (XValueNodeImpl)node2).getValueContainer()) instanceof DlvXValue ? (value2 = (DlvXValue)xValueContainer) : null;
    }

    int getCallResultCount() {
        return this.myCallResultCount;
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return new XInstanceEvaluator(){

            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @NotNull XStackFrame frame) {
                DlvStackFrame dlvStackFrame;
                if (frame == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((dlvStackFrame = (DlvStackFrame)((Object)ObjectUtils.tryCast((Object)frame, DlvStackFrame.class))) != null) {
                    callback.evaluated((XValue)new DlvXValue(DlvXValue.this.myName, DlvXValue.this.myProcess, DlvXValue.this.myParent, DlvXValue.this.myVariable, dlvStackFrame.getFrameId(), dlvStackFrame.getGoroutineId(), DlvXValue.this.myIcon, DlvXValue.this.myFollowedPointer));
                } else {
                    callback.evaluated((XValue)DlvXValue.this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "frame";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/goide/dlv/DlvXValue$5";
                objectArray[2] = "evaluate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private boolean isFollowedPointer() {
        return this.myFollowedPointer != null;
    }

    @Nullable
    public DlvXValue getTopFollowedPointer() {
        DlvXValue p;
        DlvXValue result = this.myFollowedPointer;
        while (result != null && (p = result.myFollowedPointer) != null) {
            result = p;
        }
        return result;
    }

    public String getQualifiedName() {
        if (this.myParent != null) {
            return this.myParent.getQualifiedName() + "." + this.getName();
        }
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 17, 22, 23, 24, 25, 27, 28, 32, 37, 40, 42, 43, 45, 46, 47, 48, 58, 60, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 16: 
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callResults";
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 58: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvXValue";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 19: 
            case 29: 
            case 30: 
            case 34: 
            case 39: 
            case 41: 
            case 44: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 56: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvXValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallResult";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createInner";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluationExpression";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentationAsync";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePartsAsync";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParts";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariable";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCallResult";
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 58: 
            case 60: 
            case 61: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVoidCallResult";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInner";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isTruncatedString";
                break;
            }
            case 19: 
            case 20: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNonEmptyByteSliceOrArray";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseUint8";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "evaluationExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isCompleteVariable";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "computeChildrenInner";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isUnreadable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentationAsync";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getTypePartsAsync";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findTargetField";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "readActionInPooledThread";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "inPackagePath";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getNodeValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 17, 22, 23, 24, 25, 27, 28, 32, 37, 40, 42, 43, 45, 46, 47, 48, 58, 60, 61 -> new IllegalStateException(string);
        };
    }

    private class MyXFullValueEvaluator
    extends XFullValueEvaluator {
        private MyXFullValueEvaluator() {
        }

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                MyXFullValueEvaluator.$$$reportNull$$$0(0);
            }
            if (callback.isObsolete()) {
                return;
            }
            String evaluationExpression = DlvXValue.this.getEvaluationExpression();
            if (evaluationExpression == null) {
                callback.errorOccurred(GoBundle.message((String)"go.debugger.cannot.calculate.value", (Object[])new Object[0]));
                return;
            }
            DlvXValue.this.myProcess.send(new DlvRequest.Eval(evaluationExpression, DlvXValue.this.myFrameId, DlvXValue.this.myGoroutineId, DlvXValue.this.myVariable.len)).onSuccess(v -> callback.evaluated(callback.isObsolete() ? GoBundle.message((String)"go.debugger.obsolete.value", (Object[])new Object[0]) : this.calcString((DlvApi.Variable)v))).onError(e -> callback.errorOccurred(e.getMessage()));
        }

        @NotNull
        String calcString(@NotNull DlvApi.Variable v) {
            if (v == null) {
                MyXFullValueEvaluator.$$$reportNull$$$0(1);
            }
            if (DlvXValue.this.myVariable.isString()) {
                if (!DlvXValue.this.isFollowedPointer() || v.isString()) {
                    String string = v.value;
                    if (string == null) {
                        MyXFullValueEvaluator.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                while ((v.isInterface() || v.isPtr()) && v.children.length == 1) {
                    DlvApi.Variable firstChild = v.children[0];
                    if (firstChild.isString()) {
                        String string = firstChild.value;
                        if (string == null) {
                            MyXFullValueEvaluator.$$$reportNull$$$0(3);
                        }
                        return string;
                    }
                    v = firstChild;
                }
                return "";
            }
            if (DlvXValue.isNonEmptyByteSliceOrArray(v)) {
                try {
                    return new String(StreamEx.of((Object[])v.children).mapToInt(child -> DlvXValue.parseUint8(child.value)).toByteArray(), StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    String string = GoBundle.message((String)"go.debugger.cannot.calculate.string.presentation", (Object[])new Object[]{e.getMessage()});
                    if (string == null) {
                        MyXFullValueEvaluator.$$$reportNull$$$0(4);
                    }
                    return string;
                }
            }
            String msg = GoBundle.message((String)"go.debugger.unsupported.type", (Object[])new Object[]{DlvXValue.this.myVariable.realType});
            assert (false) : msg;
            String string = msg;
            if (string == null) {
                MyXFullValueEvaluator.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvXValue$MyXFullValueEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvXValue$MyXFullValueEvaluator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "startEvaluation";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "calcString";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

