/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.dump;

import com.goide.dlv.dump.DlvFilteredThreads;
import com.goide.dlv.dump.DlvThreadDump;
import com.goide.dlv.dump.DumpedThread;
import com.goide.i18n.GoBundle;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DlvDumpPanel
extends JPanel
implements Disposable,
UiDataProvider {
    private final Project myProject;
    private final DlvThreadDump myDump;
    private final Exporter myExporter;
    private final JBList<DumpedThread> myThreadList;
    private final ThreadDumpListModel myModel;
    private final ConsoleView myConsole;
    private final JPanel myFilterPanel;
    private final SearchTextField myFilterField;
    private final JLabel myHeaderText;
    private volatile boolean myApplyFilter;
    private final AtomicReference<ProgressIndicator> myFilteringProgress;
    private volatile boolean myMergeStacks;

    public DlvDumpPanel(final @NotNull Project project, @NotNull DlvThreadDump dump, @Nullable DlvThreadDump.UiFilterSettings filter) {
        if (project == null) {
            DlvDumpPanel.$$$reportNull$$$0(0);
        }
        if (dump == null) {
            DlvDumpPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myFilteringProgress = new AtomicReference();
        this.myProject = project;
        this.myDump = dump;
        this.myExporter = new Exporter(project, dump);
        this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        this.myConsole.allowHeavyFilters();
        this.myModel = new ThreadDumpListModel();
        this.myThreadList = new JBList((ListModel)this.myModel);
        this.myThreadList.setSelectionMode(0);
        ColoredListCellRenderer<DumpedThread> renderer = new ColoredListCellRenderer<DumpedThread>(){

            protected void customizeCellRenderer(@NotNull JList list, DumpedThread value2, int index, boolean selected, boolean hasFocus) {
                boolean hidden;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (hidden = DlvDumpPanel.this.myModel.isHidden(index)) {
                    this.setIcon(AllIcons.Nodes.EmptyNode);
                }
                value2.renderTitle((ColoredTextContainer)this, selected, hasFocus, hidden);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/goide/dlv/dump/DlvDumpPanel$1", "customizeCellRenderer"));
            }
        };
        this.myThreadList.setCellRenderer((ListCellRenderer)renderer);
        JBPopupMenu popupMenu = new JBPopupMenu();
        JMenuItem hideThis = popupMenu.add((JMenuItem)((Object)new HideMenuItem(false)));
        JMenuItem hideAll = popupMenu.add((JMenuItem)((Object)new HideMenuItem(true)));
        this.myThreadList.addMouseListener((MouseListener)new MouseAdapter((ColoredListCellRenderer)renderer, hideThis, hideAll, popupMenu){
            final /* synthetic */ ColoredListCellRenderer val$renderer;
            final /* synthetic */ JMenuItem val$hideThis;
            final /* synthetic */ JMenuItem val$hideAll;
            final /* synthetic */ JBPopupMenu val$popupMenu;
            {
                this.val$renderer = coloredListCellRenderer;
                this.val$hideThis = jMenuItem;
                this.val$hideAll = jMenuItem2;
                this.val$popupMenu = jBPopupMenu;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    DumpedThread value2 = (DumpedThread)DlvDumpPanel.this.myThreadList.getSelectedValue();
                    if (value2 instanceof ThreadDumpListModel.HiddenGroup) {
                        Icon icon = ((ThreadDumpListModel.HiddenGroup)value2).getIcon(true);
                        if (e.getPoint().x < this.val$renderer.getIpad().left + icon.getIconWidth()) {
                            DlvDumpPanel.this.toggleHiddenGroup();
                        }
                    } else if (value2 instanceof ThreadDumpListModel.ShowAll) {
                        int index = DlvDumpPanel.this.myThreadList.getSelectedIndex();
                        DlvDumpPanel.this.myModel.showAll();
                        DlvDumpPanel.this.myThreadList.setSelectedIndex(index);
                    }
                } else {
                    int index = DlvDumpPanel.this.myThreadList.locationToIndex(e.getPoint());
                    if (index >= 0) {
                        DlvDumpPanel.this.myThreadList.setSelectedIndex(index);
                        if (DlvDumpPanel.this.myModel.isRegularItem(DlvDumpPanel.this.myThreadList.getSelectedIndex())) {
                            this.val$hideThis.setEnabled(!((DumpedThread)DlvDumpPanel.this.myThreadList.getSelectedValue()).isMergesSeveralThreads());
                            this.val$hideAll.setEnabled(true);
                            JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)this.val$popupMenu);
                        }
                    }
                }
            }
        });
        this.myThreadList.addListSelectionListener(event -> this.showSelectedStack());
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                return DlvDumpPanel.this.toggleHiddenGroup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/dlv/dump/DlvDumpPanel$3", "onDoubleClick"));
            }
        }.installOn(this.myThreadList);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int index;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((index = DlvDumpPanel.this.myThreadList.getSelectedIndex()) == DlvDumpPanel.this.myModel.getShowAllIndex()) {
                    DlvDumpPanel.this.myModel.showAll();
                    DlvDumpPanel.this.myThreadList.setSelectedIndex(index);
                } else {
                    DlvDumpPanel.this.toggleHiddenGroup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$4", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorEnter").getShortcutSet(), this.myThreadList);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                int index = DlvDumpPanel.this.myThreadList.getSelectedIndex();
                if (DlvDumpPanel.this.myModel.getHiddenGroupIndex() == index && DlvDumpPanel.this.myModel.expandHidden()) {
                    DlvDumpPanel.this.myThreadList.ensureIndexIsVisible(index + 1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$5", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorRight").getShortcutSet(), this.myThreadList);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                int selectedIndex = DlvDumpPanel.this.myThreadList.getSelectedIndex();
                int hiddenGroupIndex = DlvDumpPanel.this.myModel.getHiddenGroupIndex();
                if (hiddenGroupIndex >= 0) {
                    if (selectedIndex == hiddenGroupIndex) {
                        DlvDumpPanel.this.myModel.collapseHidden();
                    } else if (selectedIndex > hiddenGroupIndex) {
                        DlvDumpPanel.this.myThreadList.setSelectedIndex(hiddenGroupIndex);
                        DlvDumpPanel.this.myThreadList.ensureIndexIsVisible(hiddenGroupIndex);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$6", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorLeft").getShortcutSet(), this.myThreadList);
        if (filter != null) {
            dump.applyFilter(filter);
        }
        String expectedStackContent = filter != null ? StringUtil.nullize((String)filter.getExpectedStackContent(), (boolean)true) : null;
        this.myApplyFilter = expectedStackContent != null;
        this.myFilterField = this.createSearchField(expectedStackContent);
        this.myFilterPanel = new JPanel(new BorderLayout());
        this.myFilterPanel.add((Component)new JLabel(CommonBundle.message((String)"label.filter", (Object[])new Object[0]) + ":"), "West");
        this.myFilterPanel.add((Component)this.myFilterField);
        this.myFilterPanel.setVisible(expectedStackContent != null);
        final AnAction filterAction = ActionManager.getInstance().getAction("DlvFilterGoroutinesAction");
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (DlvDumpPanel.this.myFilterPanel.isVisible()) {
                    DlvDumpPanel.this.myFilterField.requestFocus();
                } else {
                    filterAction.actionPerformed(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$7", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("Find").getShortcutSet(), this.myThreadList);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        this.myMergeStacks = filter != null && filter.isMergeStacks() || UISettings.getInstance().getState().getMergeEqualStackTraces();
        toolbarActions.add((AnAction)new MergeStacktracesAction());
        toolbarActions.add(filterAction);
        HideThreadAction hideAction = new HideThreadAction();
        CustomShortcutSet hideShortcuts = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(127, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(127, 64), null)});
        hideAction.registerCustomShortcutSet((ShortcutSet)hideShortcuts, (JComponent)this.myThreadList);
        toolbarActions.add(ActionManager.getInstance().getAction("DlvResetHiddenGoroutinesAction"));
        toolbarActions.add(ActionManager.getInstance().getAction("ExportToTextFile"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ThreadDump", (ActionGroup)toolbarActions, false);
        this.add((Component)toolbar.getComponent(), "West");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myFilterPanel, "North");
        leftPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myThreadList, (int)5), "Center");
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        this.myHeaderText = new JLabel("");
        headerPanel.add((Component)this.myHeaderText, "West");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent(this.myConsole.getComponent());
        JPanel headerAndSplitter = new JPanel(new BorderLayout());
        headerAndSplitter.add((Component)headerPanel, "North");
        headerAndSplitter.add((Component)splitter, "Center");
        this.add((Component)headerAndSplitter, "Center");
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)this.myConsole.getPreferredFocusableComponent()));
        if (editor != null) {
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent e) {
                    int selectedIndex;
                    String filter;
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    String string = filter = DlvDumpPanel.this.myApplyFilter ? DlvDumpPanel.this.myFilterField.getText() : null;
                    if (StringUtil.isNotEmpty((String)filter) && !DlvDumpPanel.this.myModel.isHidden(selectedIndex = DlvDumpPanel.this.myThreadList.getSelectedIndex())) {
                        DlvDumpPanel.highlightOccurrences(filter, project, editor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$8", "documentChanged"));
                }
            }, (Disposable)this.myConsole);
        }
        this.updateThreads();
    }

    @NotNull
    private SearchTextField createSearchField(@Nullable String searchText) {
        final SearchTextField field = new SearchTextField();
        if (searchText != null) {
            field.setText(searchText);
        }
        field.addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                DlvDumpPanel.this.scheduleUpdateThreads();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$9", "textChanged"));
            }
        });
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int index;
                int nextIndex;
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                int n = nextIndex = (index = DlvDumpPanel.this.myThreadList.getSelectedIndex()) >= 0 ? index + 1 : 0;
                if (!DlvDumpPanel.this.myThreadList.isEmpty()) {
                    DlvDumpPanel.this.myThreadList.setSelectedIndex(nextIndex);
                    DlvDumpPanel.this.myThreadList.requestFocus();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$10", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorDown").getShortcutSet(), (JComponent)field);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int index;
                int prevIndex;
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                int n = prevIndex = (index = DlvDumpPanel.this.myThreadList.getSelectedIndex()) > 0 ? index - 1 : 0;
                if (!DlvDumpPanel.this.myThreadList.isEmpty()) {
                    DlvDumpPanel.this.myThreadList.setSelectedIndex(prevIndex);
                    DlvDumpPanel.this.myThreadList.requestFocus();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$11", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorUp").getShortcutSet(), (JComponent)field);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                if (!DlvDumpPanel.this.myThreadList.isEmpty()) {
                    DlvDumpPanel.this.myThreadList.requestFocus();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$12", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorEnter").getShortcutSet(), (JComponent)field);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (StringUtil.isEmpty((String)field.getText())) {
                    DlvDumpPanel.this.myFilterPanel.setVisible(false);
                    if (!DlvDumpPanel.this.myThreadList.isEmpty()) {
                        DlvDumpPanel.this.myThreadList.requestFocus();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/dlv/dump/DlvDumpPanel$13", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorEscape").getShortcutSet(), (JComponent)field);
        SearchTextField searchTextField = field;
        if (searchTextField == null) {
            DlvDumpPanel.$$$reportNull$$$0(2);
        }
        return searchTextField;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myConsole);
    }

    private void showSelectedStack() {
        int index = this.myThreadList.getSelectedIndex();
        this.myConsole.clear();
        if (index >= 0) {
            DumpedThread thread = this.myModel.getElementAt(index);
            thread.renderStack(this.myConsole);
        }
        this.myConsole.scrollTo(0);
    }

    private void scheduleUpdateThreads() {
        final EmptyProgressIndicator progress = new EmptyProgressIndicator();
        ProgressIndicator currentProgress = this.myFilteringProgress.getAndSet((ProgressIndicator)progress);
        if (currentProgress != null) {
            currentProgress.cancel();
        }
        this.updateUIOptions();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, GoBundle.message((String)"action.DlvFilterGoroutinesAction.task.name", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    14.$$$reportNull$$$0(0);
                }
                DlvFilteredThreads filteredThreads = DlvDumpPanel.this.myDump.getFilteredThreads(indicator);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!indicator.isCanceled()) {
                        DlvDumpPanel.this.updateThreadListAndHeader(filteredThreads, -1, false);
                        DlvDumpPanel.this.myFilteringProgress.compareAndSet((ProgressIndicator)progress, null);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/dlv/dump/DlvDumpPanel$14", "run"));
            }
        }, (ProgressIndicator)progress);
    }

    private void updateThreads() {
        this.updateThreads(-1, false);
    }

    private void updateThreads(int suggestedIndexAfterUpdate, boolean afterHide) {
        this.updateUIOptions();
        this.updateThreadListAndHeader(this.myDump.getFilteredThreads((ProgressIndicator)new EmptyProgressIndicator()), suggestedIndexAfterUpdate, afterHide);
    }

    private void updateThreadListAndHeader(@NotNull DlvFilteredThreads filteredThreads, int indexToSelect, boolean afterHide) {
        if (filteredThreads == null) {
            DlvDumpPanel.$$$reportNull$$$0(3);
        }
        List<DumpedThread> threads = filteredThreads.getThreads();
        this.myModel.setElements(threads, filteredThreads.getHiddenThreads(), afterHide);
        this.myHeaderText.setText(DlvDumpPanel.getHeaderText(filteredThreads));
        if (indexToSelect == -1) {
            int index = this.myThreadList.getSelectedIndex();
            DumpedThread currentThread = index >= 0 ? this.myModel.getElementAt(index) : null;
            indexToSelect = this.myDump.getSimilarThreadIndex(threads, currentThread);
        }
        if (!threads.isEmpty() && indexToSelect >= 0) {
            int selected = Math.min(threads.size() - 1, indexToSelect);
            this.myThreadList.setSelectedIndex(selected);
            this.myThreadList.ensureIndexIsVisible(selected);
        }
    }

    private void updateUIOptions() {
        this.myDump.setMergeStacks(this.myMergeStacks);
        this.myDump.setExpectedStackContent(this.myApplyFilter ? StringUtil.nullize((String)this.myFilterField.getText(), (boolean)true) : null);
    }

    private static void highlightOccurrences(@NotNull String filter, @NotNull Project project, @NotNull Editor editor) {
        int nextOccurrence;
        if (filter == null) {
            DlvDumpPanel.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DlvDumpPanel.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            DlvDumpPanel.$$$reportNull$$$0(6);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String documentText = editor.getDocument().getText();
        int i = -1;
        while ((nextOccurrence = StringUtil.indexOfIgnoreCase((String)documentText, (String)filter, (int)(i + 1))) >= 0) {
            i = nextOccurrence;
            highlightManager.addOccurrenceHighlight(editor, i, i + filter.length(), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, 4, null);
        }
    }

    @NotNull
    @Nls
    private static String getHeaderText(@NotNull DlvFilteredThreads filteredThreads) {
        if (filteredThreads == null) {
            DlvDumpPanel.$$$reportNull$$$0(7);
        }
        String result = GoBundle.message((String)"go.debugger.thread.dump.n.goroutines", (Object[])new Object[]{filteredThreads.getTotalThreadCount()}) + ", " + GoBundle.message((String)"go.debugger.thread.dump.n.unique.stacks", (Object[])new Object[]{filteredThreads.getUniqueStackCount()});
        if (filteredThreads.getHiddenCount() != 0) {
            result = result + ", " + GoBundle.message((String)"go.debugger.thread.dump.n.hidden.goroutines", (Object[])new Object[]{filteredThreads.getHiddenCount()});
        }
        if (filteredThreads.isFilterApplied()) {
            result = result + ", " + GoBundle.message((String)"go.debugger.thread.dump.n.goroutines.matched.by.filter", (Object[])new Object[]{filteredThreads.getMatchedByFilterCount()});
        }
        String string = result;
        if (string == null) {
            DlvDumpPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean toggleHiddenGroup() {
        int index = this.myThreadList.getSelectedIndex();
        if (this.myModel.getHiddenGroupIndex() == index && this.myModel.toggleHidden()) {
            this.myThreadList.ensureIndexIsVisible(index + 1);
            return true;
        }
        return false;
    }

    boolean isFilterSelected() {
        return this.myFilterPanel.isVisible();
    }

    void setFilterSelected(@NotNull AnActionEvent e, boolean isSelected) {
        if (e == null) {
            DlvDumpPanel.$$$reportNull$$$0(9);
        }
        this.myFilterPanel.setVisible(isSelected);
        this.myApplyFilter = isSelected;
        if (isSelected) {
            IdeFocusManager.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).requestFocus((Component)this.myFilterField, true);
            this.myFilterField.selectText();
        }
        this.updateThreads();
    }

    boolean hasHiddenThreads() {
        return this.myDump.hasHiddenThreads();
    }

    void resetHiddenThreads() {
        this.myDump.resetHiddenThreads();
        this.updateThreads();
    }

    @Nullable
    static DlvDumpPanel getPanelFromContext(@NotNull DataContext context) {
        if (context == null) {
            DlvDumpPanel.$$$reportNull$$$0(10);
        }
        return (DlvDumpPanel)UIUtil.getParentOfType(DlvDumpPanel.class, (Component)((Component)context.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)));
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DlvDumpPanel.$$$reportNull$$$0(11);
        }
        sink.set(PlatformDataKeys.EXPORTER_TO_TEXT_FILE, (Object)this.myExporter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/dump/DlvDumpPanel";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredThreads";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/dump/DlvDumpPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadListAndHeader";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightOccurrences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFilterSelected";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPanelFromContext";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8 -> new IllegalStateException(string);
        };
    }

    private static final class Exporter
    implements ExporterToTextFile {
        private final Project myProject;
        private final DlvThreadDump myDump;

        private Exporter(@NotNull Project project, @NotNull DlvThreadDump dump) {
            if (project == null) {
                Exporter.$$$reportNull$$$0(0);
            }
            if (dump == null) {
                Exporter.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myDump = dump;
        }

        @NotNull
        public String getReportText() {
            DlvFilteredThreads threads = this.myDump.getAllThreads();
            StringBuilder result = new StringBuilder();
            for (DumpedThread thread : threads.getThreads()) {
                thread.print(result);
                result.append("\n");
            }
            String string = result.toString();
            if (string == null) {
                Exporter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getDefaultFilePath() {
            String baseDirPath;
            VirtualFile dir = ProjectUtil.guessProjectDir((Project)this.myProject);
            if (dir == null) {
                dir = VfsUtil.getUserHomeDir();
            }
            String string = baseDirPath = dir != null ? dir.getCanonicalPath() : null;
            if (baseDirPath != null) {
                String string2 = baseDirPath + File.separator + "goroutines.txt";
                if (string2 == null) {
                    Exporter.$$$reportNull$$$0(3);
                }
                return string2;
            }
            return "";
        }

        public boolean canExport() {
            return this.myDump.getThreadCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dump";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/dump/DlvDumpPanel$Exporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/dump/DlvDumpPanel$Exporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReportText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ThreadDumpListModel
    extends AbstractListModel<DumpedThread> {
        private static final int INITIAL_ITEMS_COUNT = 100;
        private final Object myLock = new Object();
        private List<DumpedThread> myItems = new ArrayList<DumpedThread>();
        private List<DumpedThread> myHiddenItems = new ArrayList<DumpedThread>();
        private boolean myHiddenExpanded = false;
        private HiddenGroup myHiddenGroup = null;
        private ShowAll myShowAllItem = null;

        private ThreadDumpListModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int shownItemsCount() {
            Object object = this.myLock;
            synchronized (object) {
                return this.myShowAllItem != null ? 100 : this.myItems.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getSize() {
            Object object = this.myLock;
            synchronized (object) {
                int result = this.shownItemsCount();
                if (this.myShowAllItem != null) {
                    ++result;
                }
                if (this.myHiddenGroup != null) {
                    ++result;
                    if (this.myHiddenExpanded) {
                        result += this.myHiddenItems.size();
                    }
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DumpedThread getElementAt(int i) {
            Object object = this.myLock;
            synchronized (object) {
                int shownItemsCount = this.shownItemsCount();
                if (i < shownItemsCount) {
                    return this.myItems.get(i);
                }
                if (this.myShowAllItem != null) {
                    if (i == shownItemsCount) {
                        return this.myShowAllItem;
                    }
                    --i;
                }
                assert (this.myHiddenGroup != null);
                if (i == shownItemsCount) {
                    return this.myHiddenGroup;
                }
                return this.myHiddenItems.get(i - shownItemsCount - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setElements(@NotNull List<DumpedThread> items, @NotNull List<DumpedThread> hiddenItems, boolean afterHide) {
            if (items == null) {
                ThreadDumpListModel.$$$reportNull$$$0(0);
            }
            if (hiddenItems == null) {
                ThreadDumpListModel.$$$reportNull$$$0(1);
            }
            Object object = this.myLock;
            synchronized (object) {
                boolean showOnlyInitialItems;
                boolean showAllWasExpanded = this.myItems.size() > 100 && this.myShowAllItem == null;
                this.clear();
                this.myItems = items;
                boolean bl = showOnlyInitialItems = !afterHide || !showAllWasExpanded;
                if (showOnlyInitialItems && this.myItems.size() > 100) {
                    this.myShowAllItem = new ShowAll();
                }
                this.myHiddenItems = hiddenItems;
                this.myHiddenGroup = hiddenItems.isEmpty() ? null : new HiddenGroup();
                this.fireIntervalAdded(this, 0, Math.max(this.getSize() - 1, 0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            Object object = this.myLock;
            synchronized (object) {
                int size = this.getSize();
                this.myItems = Collections.emptyList();
                this.myShowAllItem = null;
                this.myHiddenGroup = null;
                this.myHiddenItems = Collections.emptyList();
                if (size > 0) {
                    this.fireIntervalRemoved(this, 0, size - 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean expandHidden() {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myHiddenItems.isEmpty() && !this.myHiddenExpanded) {
                    int hiddenGroupIndex = this.getHiddenGroupIndex();
                    this.myHiddenExpanded = true;
                    this.fireIntervalAdded(this, hiddenGroupIndex + 1, hiddenGroupIndex + 1 + this.myHiddenItems.size());
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void collapseHidden() {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myHiddenItems.isEmpty() && this.myHiddenExpanded) {
                    int hiddenGroupIndex = this.getHiddenGroupIndex();
                    this.myHiddenExpanded = false;
                    this.fireIntervalRemoved(this, hiddenGroupIndex + 1, hiddenGroupIndex + 1 + this.myHiddenItems.size());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean toggleHidden() {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myHiddenExpanded) {
                    this.collapseHidden();
                    return false;
                }
                return this.expandHidden();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void showAll() {
            Object object = this.myLock;
            synchronized (object) {
                int showAllIndex = this.shownItemsCount();
                this.myShowAllItem = null;
                this.fireIntervalRemoved(this, showAllIndex, showAllIndex + 1);
                this.fireIntervalAdded(this, showAllIndex, showAllIndex + this.myItems.size() - 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isHidden(int index) {
            Object object = this.myLock;
            synchronized (object) {
                return index > this.shownItemsCount() && !this.myHiddenItems.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isRegularItem(int index) {
            Object object = this.myLock;
            synchronized (object) {
                return index >= 0 && index < this.shownItemsCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getShowAllIndex() {
            Object object = this.myLock;
            synchronized (object) {
                return this.myShowAllItem != null ? this.shownItemsCount() : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getHiddenGroupIndex() {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myHiddenGroup != null) {
                    int shownItemsSize = this.shownItemsCount();
                    if (this.myShowAllItem != null) {
                        ++shownItemsSize;
                    }
                    return shownItemsSize;
                }
                return -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "items";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hiddenItems";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/dump/DlvDumpPanel$ThreadDumpListModel";
            objectArray[2] = "setElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class HiddenGroup
        implements DumpedThread {
            private HiddenGroup() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renderTitle(@NotNull ColoredTextContainer renderer, boolean selected, boolean hasFocus, boolean hidden) {
                if (renderer == null) {
                    HiddenGroup.$$$reportNull$$$0(0);
                }
                Object object = ThreadDumpListModel.this.myLock;
                synchronized (object) {
                    boolean selectedOrFocused = selected || hasFocus;
                    Icon icon = this.getIcon(selectedOrFocused);
                    renderer.setIcon(icon);
                    String hiddenGroupName = GoBundle.message((String)"go.debugger.hidden.group.name", (Object[])new Object[]{ThreadDumpListModel.this.myHiddenItems.size()});
                    renderer.append(hiddenGroupName, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }

            @Override
            public void renderStack(@NotNull ConsoleView console) {
                if (console == null) {
                    HiddenGroup.$$$reportNull$$$0(1);
                }
                console.clear();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @NotNull
            public Icon getIcon(boolean selectedOrFocused) {
                Object object = ThreadDumpListModel.this.myLock;
                // MONITORENTER : object
                Icon icon = UIUtil.getTreeNodeIcon((boolean)ThreadDumpListModel.this.myHiddenExpanded, (boolean)selectedOrFocused, (boolean)selectedOrFocused);
                // MONITOREXIT : object
                if (icon != null) return icon;
                HiddenGroup.$$$reportNull$$$0(2);
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/dlv/dump/DlvDumpPanel$ThreadDumpListModel$HiddenGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/dlv/dump/DlvDumpPanel$ThreadDumpListModel$HiddenGroup";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "renderTitle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "renderStack";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        private class ShowAll
        implements DumpedThread {
            private ShowAll() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renderTitle(@NotNull ColoredTextContainer renderer, boolean selected, boolean hasFocus, boolean hidden) {
                int total;
                if (renderer == null) {
                    ShowAll.$$$reportNull$$$0(0);
                }
                Object object = ThreadDumpListModel.this.myLock;
                synchronized (object) {
                    total = ThreadDumpListModel.this.myItems.size();
                }
                renderer.append(GoBundle.message((String)"go.debugger.and.n.more", (Object[])new Object[]{total - 100}), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES);
            }

            @Override
            public void renderStack(@NotNull ConsoleView console) {
                if (console == null) {
                    ShowAll.$$$reportNull$$$0(1);
                }
                console.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/dlv/dump/DlvDumpPanel$ThreadDumpListModel$ShowAll";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "renderTitle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "renderStack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class HideMenuItem
    extends JBMenuItem {
        private final boolean myHideSimilar;

        private HideMenuItem(boolean hideSimilar) {
            super(hideSimilar ? GoBundle.message((String)"action.HideSimilarGoroutines", (Object[])new Object[0]) : GoBundle.message((String)"action.HideGoroutine", (Object[])new Object[0]));
            this.myHideSimilar = hideSimilar;
            this.addActionListener(e -> {
                int index = DlvDumpPanel.this.myThreadList.getSelectedIndex();
                if (DlvDumpPanel.this.myModel.isRegularItem(index)) {
                    DumpedThread currentThread = DlvDumpPanel.this.myModel.getElementAt(index);
                    DlvDumpPanel.this.myDump.hideThread(currentThread, this.myHideSimilar);
                    DlvDumpPanel.this.updateThreads(index, true);
                }
            });
        }
    }

    private final class MergeStacktracesAction
    extends ToggleAction
    implements DumbAware {
        private MergeStacktracesAction() {
            super(() -> GoBundle.message((String)"action.MergeIdenticalStacktraces.text", (Object[])new Object[0]), AllIcons.Actions.Collapseall);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MergeStacktracesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeStacktracesAction.$$$reportNull$$$0(1);
            }
            return DlvDumpPanel.this.myMergeStacks;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MergeStacktracesAction.$$$reportNull$$$0(2);
            }
            DlvDumpPanel.this.myMergeStacks = state;
            UISettings.getInstance().getState().setMergeEqualStackTraces(state);
            DlvDumpPanel.this.updateThreads();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/dump/DlvDumpPanel$MergeStacktracesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/dump/DlvDumpPanel$MergeStacktracesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class HideThreadAction
    extends AnAction
    implements DumbAware {
        private HideThreadAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                HideThreadAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            int index;
            if (e == null) {
                HideThreadAction.$$$reportNull$$$0(1);
            }
            if ((index = DlvDumpPanel.this.myThreadList.getSelectedIndex()) >= 0) {
                boolean hidden = DlvDumpPanel.this.myThreadList.getSelectedValue() instanceof ThreadDumpListModel.HiddenGroup || DlvDumpPanel.this.myModel.isHidden(index);
                e.getPresentation().setEnabled(!hidden);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int index;
            if (e == null) {
                HideThreadAction.$$$reportNull$$$0(2);
            }
            DumpedThread currentThread = (index = DlvDumpPanel.this.myThreadList.getSelectedIndex()) >= 0 ? DlvDumpPanel.this.myModel.getElementAt(index) : null;
            boolean hideSimilar = BitUtil.isSet((int)e.getInputEvent().getModifiersEx(), (int)64);
            if (currentThread != null) {
                DlvDumpPanel.this.myDump.hideThread(currentThread, hideSimilar);
                DlvDumpPanel.this.updateThreads(index, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/dump/DlvDumpPanel$HideThreadAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/dump/DlvDumpPanel$HideThreadAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

