/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.dump;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvSuspendContext;
import com.goide.dlv.dump.DlvFilteredThreads;
import com.goide.dlv.dump.DlvStack;
import com.goide.dlv.dump.DlvStackIndex;
import com.goide.dlv.dump.DumpedThread;
import com.goide.dlv.protocol.DlvApi;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DlvThreadDump {
    private final String myUnknownFunctionName;
    private final DlvDebugProcess myProcess;
    private final String myId;
    @Nls
    private final String myThreadNamePrefix;
    private final DlvStackIndex myStackIndex;
    private final List<GoThread> myThreads;
    private final Long2ObjectMap<@Nls String> myDetails;
    private volatile boolean myIncomplete;
    private volatile boolean myMergeStacks;
    private volatile String myExpectedStackContent;
    private volatile LongSet myHiddenThreadIds;
    private volatile IntSet myHiddenStackIds;
    private final Object myHiddenSetsLock;
    private final Lazy<Integer> myUniqueStackCount;

    public DlvThreadDump(@NotNull DlvDebugProcess process, @NotNull String unknownFunctionName, @NotNull String dumpId, @NotNull @Nls String threadNamePrefix, @Nullable DlvThreadDump baseDump) {
        if (process == null) {
            DlvThreadDump.$$$reportNull$$$0(0);
        }
        if (unknownFunctionName == null) {
            DlvThreadDump.$$$reportNull$$$0(1);
        }
        if (dumpId == null) {
            DlvThreadDump.$$$reportNull$$$0(2);
        }
        if (threadNamePrefix == null) {
            DlvThreadDump.$$$reportNull$$$0(3);
        }
        this.myThreads = new ArrayList<GoThread>();
        this.myUnknownFunctionName = unknownFunctionName;
        this.myId = dumpId;
        this.myThreadNamePrefix = threadNamePrefix;
        this.myProcess = process;
        this.myStackIndex = new DlvStackIndex(baseDump != null ? baseDump.myStackIndex : null);
        this.myDetails = new Long2ObjectOpenHashMap();
        this.myHiddenThreadIds = new LongOpenHashSet();
        this.myHiddenStackIds = new IntOpenHashSet();
        this.myHiddenSetsLock = new Object();
        this.myUniqueStackCount = LazyKt.lazy(() -> {
            IntOpenHashSet unique = new IntOpenHashSet();
            for (GoThread t : this.myThreads) {
                unique.add(t.getStackId());
            }
            return unique.size();
        });
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            DlvThreadDump.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setMergeStacks(boolean mergeStacks) {
        this.myMergeStacks = mergeStacks;
    }

    public void setExpectedStackContent(@Nullable String s) {
        this.myExpectedStackContent = s;
    }

    public void setIncomplete() {
        this.myIncomplete = true;
    }

    public boolean isIncomplete() {
        return this.myIncomplete;
    }

    public int getThreadCount() {
        return this.myThreads.size();
    }

    public void sort() {
        Collections.sort(this.myThreads, Comparator.comparingLong(t -> t.myId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHiddenThreads() {
        Object object = this.myHiddenSetsLock;
        synchronized (object) {
            this.myHiddenThreadIds = new LongOpenHashSet();
            this.myHiddenStackIds = new IntOpenHashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideThread(@NotNull DumpedThread thread, boolean hideSimilarThreads) {
        if (thread == null) {
            DlvThreadDump.$$$reportNull$$$0(5);
        }
        if (hideSimilarThreads || thread instanceof MergedStack) {
            int stackId = ((GoStackOwner)((Object)thread)).getStackId();
            Object object = this.myHiddenSetsLock;
            synchronized (object) {
                IntOpenHashSet updated2 = new IntOpenHashSet((IntCollection)this.myHiddenStackIds);
                updated2.add(stackId);
                this.myHiddenStackIds = updated2;
            }
        }
        long threadId = ((GoThread)thread).myId;
        Object object = this.myHiddenSetsLock;
        synchronized (object) {
            LongOpenHashSet updated3 = new LongOpenHashSet((LongCollection)this.myHiddenThreadIds);
            updated3.add(threadId);
            this.myHiddenThreadIds = updated3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHiddenThreads() {
        Object object = this.myHiddenSetsLock;
        synchronized (object) {
            return !this.myHiddenThreadIds.isEmpty() || !this.myHiddenStackIds.isEmpty();
        }
    }

    private boolean isHidden(@NotNull GoThread thread, LongSet hiddenThreadIds, IntSet hiddenStackIds) {
        if (thread == null) {
            DlvThreadDump.$$$reportNull$$$0(6);
        }
        return hiddenThreadIds.contains(thread.myId) || hiddenStackIds.contains(thread.myStackId);
    }

    /*
     * WARNING - void declaration
     */
    private void addThread(long threadId, @NotNull List<DlvApi.Location> stackFrames, int asyncFrameIndex, int n) {
        void topUserFrameIndex;
        if (stackFrames == null) {
            DlvThreadDump.$$$reportNull$$$0(7);
        }
        DlvStack stack = new DlvStack(this.myStackIndex, stackFrames, asyncFrameIndex);
        int stackId = this.myStackIndex.addStackIfAbsent(stack);
        this.myThreads.add(new GoThread(threadId, stackId, (int)topUserFrameIndex));
    }

    public void addThread(@NotNull DlvApi.Goroutine goroutine, @NotNull List<DlvApi.Location> stackFrames) {
        if (goroutine == null) {
            DlvThreadDump.$$$reportNull$$$0(8);
        }
        if (stackFrames == null) {
            DlvThreadDump.$$$reportNull$$$0(9);
        }
        int topUserFrameIndex = Math.max(0, stackFrames.indexOf(goroutine.userCurrentLoc));
        if (goroutine.goStatementLoc != null) {
            stackFrames.add(goroutine.goStatementLoc);
            this.addThread(goroutine.id, stackFrames, stackFrames.size() - 1, topUserFrameIndex);
        } else {
            this.addThread(goroutine.id, stackFrames, -1, topUserFrameIndex);
        }
        String details = DlvSuspendContext.getLabelsString(goroutine);
        if (details != null) {
            this.myDetails.put(goroutine.id, (Object)details);
        }
    }

    public int getSimilarThreadIndex(@NotNull List<? extends DumpedThread> threads, @Nullable DumpedThread thread) {
        if (threads == null) {
            DlvThreadDump.$$$reportNull$$$0(10);
        }
        if (!(thread instanceof GoStackOwner)) {
            return 0;
        }
        int stackId = ((GoStackOwner)((Object)thread)).getStackId();
        int firstIndexWithSameStack = -1;
        for (int i = 0; i < threads.size(); ++i) {
            DumpedThread t = threads.get(i);
            if (t == thread) {
                return i;
            }
            if (firstIndexWithSameStack != -1 || !(t instanceof GoStackOwner) || ((GoStackOwner)((Object)t)).getStackId() != stackId) continue;
            firstIndexWithSameStack = i;
        }
        return firstIndexWithSameStack != -1 ? firstIndexWithSameStack : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DlvFilteredThreads getFilteredThreads(@NotNull ProgressIndicator indicator) {
        IntSet hiddenStackIds;
        LongSet hiddenThreadIds;
        if (indicator == null) {
            DlvThreadDump.$$$reportNull$$$0(11);
        }
        Object object = this.myHiddenSetsLock;
        synchronized (object) {
            hiddenThreadIds = this.myHiddenThreadIds;
            hiddenStackIds = this.myHiddenStackIds;
        }
        ArrayList<Object> result = new ArrayList();
        ArrayList<DumpedThread> hiddenThreads = new ArrayList<DumpedThread>();
        if (this.myMergeStacks) {
            Int2ObjectOpenHashMap merged = new Int2ObjectOpenHashMap();
            result = new ArrayList();
            for (GoThread thread : this.myThreads) {
                if (this.isHidden(thread, hiddenThreadIds, hiddenStackIds)) {
                    hiddenThreads.add(thread);
                    continue;
                }
                MergedStack mergedStack = (MergedStack)merged.get(thread.myStackId);
                if (mergedStack == null) {
                    mergedStack = new MergedStack(thread);
                    merged.put(thread.myStackId, (Object)mergedStack);
                    result.add(mergedStack);
                    continue;
                }
                ++mergedStack.myCount;
            }
        } else if (this.hasHiddenThreads()) {
            for (GoThread thread : this.myThreads) {
                if (this.isHidden(thread, hiddenThreadIds, hiddenStackIds)) {
                    hiddenThreads.add(thread);
                    continue;
                }
                result.add(thread);
            }
        } else {
            result = new ArrayList<GoThread>(this.myThreads);
        }
        int matchedByFilterCount = 0;
        boolean filterApplied = false;
        if (this.myExpectedStackContent != null) {
            filterApplied = true;
            ArrayList<DumpedThread> filtered = new ArrayList<DumpedThread>();
            boolean ignoreCase = this.myExpectedStackContent.equals(StringUtil.toLowerCase((String)this.myExpectedStackContent));
            DlvStack.ContentMatcher matcher = new DlvStack.ContentMatcher(this.myStackIndex, this.myUnknownFunctionName, this.myExpectedStackContent, ignoreCase);
            for (DumpedThread thread : result) {
                indicator.checkCanceled();
                String details = this.getDetails(thread);
                if (details != null && (ignoreCase ? StringUtil.toLowerCase((String)details) : details).contains(this.myExpectedStackContent)) {
                    filtered.add(thread);
                    matchedByFilterCount += thread instanceof MergedStack ? ((MergedStack)thread).myCount : 1;
                    continue;
                }
                int stackId = ((GoStackOwner)((Object)thread)).getStackId();
                if (!matcher.matches(stackId)) continue;
                filtered.add(thread);
                matchedByFilterCount += thread instanceof MergedStack ? ((MergedStack)thread).myCount : 1;
            }
            result = filtered;
        }
        return new DlvFilteredThreads(result, hiddenThreads, this.getThreadCount(), (Integer)this.myUniqueStackCount.getValue(), filterApplied, matchedByFilterCount);
    }

    @NotNull
    public DlvFilteredThreads getAllThreads() {
        return new DlvFilteredThreads(ContainerUtil.map(this.myThreads, it -> new GoThread(it.myId, it.getStackId(), it.myTopUserFrameIndex)), Collections.emptyList(), this.getThreadCount(), (Integer)this.myUniqueStackCount.getValue(), false, this.getThreadCount());
    }

    @Nullable
    private String getDetails(DumpedThread thread) {
        if (thread instanceof GoThread) {
            return (String)this.myDetails.get(((GoThread)thread).myId);
        }
        if (thread instanceof MergedStack && ((MergedStack)thread).myCount == 1) {
            return (String)this.myDetails.get(((MergedStack)thread).myFirstThread.myId);
        }
        return null;
    }

    static void append(@NotNull ColoredTextContainer container, @NotNull @Nls String text, boolean hidden) {
        if (container == null) {
            DlvThreadDump.$$$reportNull$$$0(12);
        }
        if (text == null) {
            DlvThreadDump.$$$reportNull$$$0(13);
        }
        container.append(text, hidden ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UiFilterSettings getUiFilterSettings() {
        Object object = this.myHiddenSetsLock;
        // MONITORENTER : object
        UiFilterSettings uiFilterSettings = new UiFilterSettings(this.myMergeStacks, this.myExpectedStackContent, (LongSet)new LongOpenHashSet((LongCollection)this.myHiddenThreadIds), (IntSet)new IntOpenHashSet((IntCollection)this.myHiddenStackIds));
        // MONITOREXIT : object
        if (uiFilterSettings != null) return uiFilterSettings;
        DlvThreadDump.$$$reportNull$$$0(14);
        return uiFilterSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFilter(@NotNull UiFilterSettings filter) {
        if (filter == null) {
            DlvThreadDump.$$$reportNull$$$0(15);
        }
        Object object = this.myHiddenSetsLock;
        synchronized (object) {
            this.myMergeStacks = filter.myMergeStacks;
            this.myExpectedStackContent = filter.myExpectedStackContent;
            this.myHiddenThreadIds = new LongOpenHashSet((LongCollection)filter.myHiddenThreadIds);
            this.myHiddenStackIds = new IntOpenHashSet((IntCollection)filter.myHiddenStackIds);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownFunctionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadNamePrefix";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/dump/DlvThreadDump";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goroutine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/dump/DlvThreadDump";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiFilterSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hideThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addThread";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSimilarThreadIndex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredThreads";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 14 -> new IllegalStateException(string);
        };
    }

    private class MergedStack
    implements DumpedThread,
    GoStackOwner {
        private final GoThread myFirstThread;
        private int myCount;

        private MergedStack(GoThread firstItem) {
            if (firstItem == null) {
                MergedStack.$$$reportNull$$$0(0);
            }
            this.myFirstThread = firstItem;
            this.myCount = 1;
        }

        @Override
        public boolean isMergesSeveralThreads() {
            return this.myCount > 1;
        }

        @Override
        public int getStackId() {
            return this.myFirstThread.myStackId;
        }

        @Override
        public void renderTitle(@NotNull ColoredTextContainer renderer, boolean selected, boolean hasFocus, boolean hidden) {
            if (renderer == null) {
                MergedStack.$$$reportNull$$$0(1);
            }
            if (this.myCount == 1) {
                this.myFirstThread.renderTitle(renderer, selected, hasFocus, hidden);
            } else {
                DlvStack stack = Objects.requireNonNull(DlvThreadDump.this.myStackIndex.getStack(this.myFirstThread.myStackId));
                stack.renderFrame(DlvThreadDump.this.myStackIndex, renderer, this.myFirstThread.myTopUserFrameIndex, DlvThreadDump.this.myUnknownFunctionName, hidden);
                DlvThreadDump.append(renderer, " (" + this.myCount + ")", hidden);
            }
        }

        @Override
        public void renderStack(@NotNull ConsoleView console) {
            if (console == null) {
                MergedStack.$$$reportNull$$$0(2);
            }
            if (this.myCount == 1) {
                this.myFirstThread.renderStack(console);
            } else {
                DlvStack stack = Objects.requireNonNull(DlvThreadDump.this.myStackIndex.getStack(this.myFirstThread.myStackId));
                stack.renderStack(DlvThreadDump.this.myProcess, DlvThreadDump.this.myStackIndex, console, DlvThreadDump.this.myUnknownFunctionName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
            }
            objectArray2[1] = "com/goide/dlv/dump/DlvThreadDump$MergedStack";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface GoStackOwner {
        public int getStackId();
    }

    private class GoThread
    implements DumpedThread,
    GoStackOwner {
        private final long myId;
        private final int myStackId;
        private final int myTopUserFrameIndex;

        private GoThread(long id, int stackId, int topUserFrameIndex) {
            this.myId = id;
            this.myStackId = stackId;
            this.myTopUserFrameIndex = topUserFrameIndex;
        }

        @Override
        public int getStackId() {
            return this.myStackId;
        }

        @Override
        public void print(@NotNull StringBuilder buffer) {
            if (buffer == null) {
                GoThread.$$$reportNull$$$0(0);
            }
            buffer.append(DlvThreadDump.this.myThreadNamePrefix).append(" ").append(this.myId);
            String details = (String)DlvThreadDump.this.myDetails.get(this.myId);
            if (details != null) {
                buffer.append(" ").append(details);
            }
            buffer.append("\n");
            DlvStack stack = Objects.requireNonNull(DlvThreadDump.this.myStackIndex.getStack(this.myStackId));
            stack.print(DlvThreadDump.this.myStackIndex, DlvThreadDump.this.myUnknownFunctionName, buffer);
        }

        @Override
        public void renderTitle(@NotNull ColoredTextContainer renderer, boolean selected, boolean hasFocus, boolean hidden) {
            if (renderer == null) {
                GoThread.$$$reportNull$$$0(1);
            }
            DlvStack stack = Objects.requireNonNull(DlvThreadDump.this.myStackIndex.getStack(this.myStackId));
            DlvThreadDump.append(renderer, DlvThreadDump.this.myThreadNamePrefix, hidden);
            DlvThreadDump.append(renderer, " ", hidden);
            DlvThreadDump.append(renderer, String.valueOf(this.myId), hidden);
            DlvThreadDump.append(renderer, " ", hidden);
            String details = (String)DlvThreadDump.this.myDetails.get(this.myId);
            if (details != null) {
                DlvThreadDump.append(renderer, " ", hidden);
                DlvThreadDump.append(renderer, details, hidden);
                DlvThreadDump.append(renderer, ", ", hidden);
            }
            stack.renderFrame(DlvThreadDump.this.myStackIndex, renderer, this.myTopUserFrameIndex, DlvThreadDump.this.myUnknownFunctionName, hidden);
        }

        @Override
        public void renderStack(@NotNull ConsoleView console) {
            String details;
            if (console == null) {
                GoThread.$$$reportNull$$$0(2);
            }
            if ((details = (String)DlvThreadDump.this.myDetails.get(this.myId)) != null) {
                console.print(details, ConsoleViewContentType.LOG_VERBOSE_OUTPUT);
                console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            DlvStack stack = Objects.requireNonNull(DlvThreadDump.this.myStackIndex.getStack(this.myStackId));
            stack.renderStack(DlvThreadDump.this.myProcess, DlvThreadDump.this.myStackIndex, console, DlvThreadDump.this.myUnknownFunctionName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
            }
            objectArray2[1] = "com/goide/dlv/dump/DlvThreadDump$GoThread";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class UiFilterSettings {
        private final boolean myMergeStacks;
        private final String myExpectedStackContent;
        private final LongSet myHiddenThreadIds;
        private final IntSet myHiddenStackIds;

        UiFilterSettings(boolean mergeStacks, @Nullable String expectedStackContent, @NotNull LongSet hiddenThreadIds, @NotNull IntSet hiddenStackIds) {
            if (hiddenThreadIds == null) {
                UiFilterSettings.$$$reportNull$$$0(0);
            }
            if (hiddenStackIds == null) {
                UiFilterSettings.$$$reportNull$$$0(1);
            }
            this.myMergeStacks = mergeStacks;
            this.myExpectedStackContent = expectedStackContent;
            this.myHiddenThreadIds = hiddenThreadIds;
            this.myHiddenStackIds = hiddenStackIds;
        }

        public boolean isMergeStacks() {
            return this.myMergeStacks;
        }

        @Nullable
        public String getExpectedStackContent() {
            return this.myExpectedStackContent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hiddenThreadIds";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hiddenStackIds";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/dump/DlvThreadDump$UiFilterSettings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

