/*
 * Decompiled with CFR 0.152.
 */
package com.goide.documentation;

import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoAllPrivateNamesIndex;
import com.goide.stubs.index.GoAllPublicNamesIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDocLink {
    private final Type myType;
    private final String myImportPath;
    private final String myAnchor;

    private GoDocLink(@Nullable Type type, @NotNull String importPath, @Nullable String anchor) {
        if (importPath == null) {
            GoDocLink.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.myImportPath = importPath;
        this.myAnchor = anchor;
    }

    @NotNull
    public String getImportPath() {
        String string = this.myImportPath;
        if (string == null) {
            GoDocLink.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean canFindElement() {
        return this.myType != null && StringUtil.isNotEmpty((String)this.myAnchor);
    }

    @Nullable
    public PsiElement findElement(@NotNull Project project, @NotNull Collection<GoPackage> packages) {
        if (project == null) {
            GoDocLink.$$$reportNull$$$0(2);
        }
        if (packages == null) {
            GoDocLink.$$$reportNull$$$0(3);
        }
        return this.canFindElement() ? this.myType.findElement(project, packages, this.myAnchor) : null;
    }

    static String serialize(@NotNull PsiElement element, @Nullable String importPath, @Nullable String anchor) {
        Type linkType;
        if (element == null) {
            GoDocLink.$$$reportNull$$$0(4);
        }
        String typePrefix = (linkType = Type.of(element)) != null ? linkType.name() + ":" : "";
        Object anchorSuffix = anchor != null ? "#" + anchor : "";
        return typePrefix + StringUtil.notNullize((String)importPath) + (String)anchorSuffix;
    }

    @NotNull
    public static String getKeywordLink(@NotNull String keyword) {
        if (keyword == null) {
            GoDocLink.$$$reportNull$$$0(5);
        }
        String string = Type.KEYWORD.name() + ":#" + keyword;
        if (string == null) {
            GoDocLink.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    static GoDocLink parseLink(@NotNull String link) {
        if (link == null) {
            GoDocLink.$$$reportNull$$$0(7);
        }
        int typeEndIndex = link.indexOf(":");
        Type type = null;
        try {
            type = typeEndIndex != -1 ? Type.valueOf(link.substring(0, typeEndIndex)) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String linkNoType = link.substring(typeEndIndex + 1);
        int hash = linkNoType.indexOf(35);
        String importPath = hash >= 0 ? linkNoType.substring(0, hash) : linkNoType;
        String anchor = hash >= 0 ? linkNoType.substring(Math.min(hash + 1, linkNoType.length())) : null;
        return new GoDocLink(type, importPath, anchor);
    }

    @Nullable
    private static PsiElement findElementByFqn(@NotNull Project project, @NotNull Collection<GoPackage> packages, @Nullable String fqn, @NotNull Condition<GoNamedElement> condition) {
        if (project == null) {
            GoDocLink.$$$reportNull$$$0(8);
        }
        if (packages == null) {
            GoDocLink.$$$reportNull$$$0(9);
        }
        if (condition == null) {
            GoDocLink.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            return null;
        }
        int dot = fqn.indexOf(46);
        if (dot == -1 || dot == fqn.length() - 1) {
            return null;
        }
        boolean isPublic = Character.isUpperCase(fqn.charAt(dot + 1));
        StubIndexKey<String, GoNamedElement> index = isPublic ? GoAllPublicNamesIndex.ALL_PUBLIC_NAMES : GoAllPrivateNamesIndex.ALL_PRIVATE_NAMES;
        GlobalSearchScope scope = !packages.isEmpty() ? GoPackageUtil.packagesScope(packages) : GlobalSearchScope.projectScope((Project)project);
        return (PsiElement)ContainerUtil.find((Iterable)StubIndex.getElements(index, (Object)fqn, (Project)project, (GlobalSearchScope)scope, GoNamedElement.class), condition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/documentation/GoDocLink";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/documentation/GoDocLink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordLink";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseLink";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findElementByFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Type {
        FUNCTION(GoFunctionDeclaration.class),
        TYPE(GoTypeSpec.class),
        VAR_OR_CONST(GoVarOrConstDefinition.class),
        PACKAGE(null),
        METHOD(GoMethodDeclaration.class){

            @Override
            @Nullable
            public PsiElement findElement(@NotNull Project project, @NotNull Collection<GoPackage> packages, @NotNull String anchor) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (packages == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (anchor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return this.findFieldOrMethod(project, packages, anchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packages";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "anchor";
                        break;
                    }
                }
                objectArray[1] = "com/goide/documentation/GoDocLink$Type$1";
                objectArray[2] = "findElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        METHOD_SPEC(GoMethodSpec.class){

            @Override
            @Nullable
            public PsiElement findElement(@NotNull Project project, @NotNull Collection<GoPackage> packages, @NotNull String anchor) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (packages == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (anchor == null) {
                    2.$$$reportNull$$$0(2);
                }
                return this.findFieldOrMethod(project, packages, anchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packages";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "anchor";
                        break;
                    }
                }
                objectArray[1] = "com/goide/documentation/GoDocLink$Type$2";
                objectArray[2] = "findElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        FIELD(GoFieldDefinition.class){

            @Override
            @Nullable
            public PsiElement findElement(@NotNull Project project, @NotNull Collection<GoPackage> packages, @NotNull String anchor) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (packages == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (anchor == null) {
                    3.$$$reportNull$$$0(2);
                }
                return this.findFieldOrMethod(project, packages, anchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packages";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "anchor";
                        break;
                    }
                }
                objectArray[1] = "com/goide/documentation/GoDocLink$Type$3";
                objectArray[2] = "findElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        KEYWORD(null){

            @Override
            @Nullable
            public PsiElement findElement(@NotNull Project project, @NotNull Collection<GoPackage> packages, @NotNull String anchor) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (packages == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (anchor == null) {
                    4.$$$reportNull$$$0(2);
                }
                return GoElementFactory.createKeywordElement(project, anchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packages";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "anchor";
                        break;
                    }
                }
                objectArray[1] = "com/goide/documentation/GoDocLink$Type$4";
                objectArray[2] = "findElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        protected final Class<? extends GoNamedElement> myElementClass;

        private Type(Class<? extends GoNamedElement> elementClass) {
            this.myElementClass = elementClass;
        }

        @Nullable
        public PsiElement findElement(@NotNull Project project, @NotNull Collection<GoPackage> packages, @NotNull String anchor) {
            if (project == null) {
                Type.$$$reportNull$$$0(0);
            }
            if (packages == null) {
                Type.$$$reportNull$$$0(1);
            }
            if (anchor == null) {
                Type.$$$reportNull$$$0(2);
            }
            if (this.myElementClass == null) {
                return null;
            }
            return GoDocLink.findElementByFqn(project, packages, anchor, (Condition<GoNamedElement>)((Condition)it -> this.myElementClass.isInstance(it)));
        }

        @Nullable
        public PsiElement findFieldOrMethod(@NotNull Project project, @NotNull Collection<GoPackage> packages, @NotNull String anchor) {
            if (project == null) {
                Type.$$$reportNull$$$0(3);
            }
            if (packages == null) {
                Type.$$$reportNull$$$0(4);
            }
            if (anchor == null) {
                Type.$$$reportNull$$$0(5);
            }
            if (this.myElementClass == null) {
                return null;
            }
            Pair<Integer, Integer> boundaries = Type.getTypeBoundaries(anchor);
            if (boundaries == null) {
                return null;
            }
            String typeFqn = anchor.substring(0, (Integer)boundaries.second);
            int typeParamsStart = typeFqn.indexOf(91);
            if (typeParamsStart >= 0) {
                typeFqn = typeFqn.substring(0, typeParamsStart);
            }
            PsiElement typeSpec = (PsiElement)ObjectUtils.tryCast((Object)GoDocLink.findElementByFqn(project, packages, typeFqn, (Condition<GoNamedElement>)((Condition)it -> it instanceof GoTypeSpec)), GoTypeSpec.class);
            String fieldOrMethodName = anchor.substring((Integer)boundaries.second + 1);
            return GoPsiImplUtil.findFieldOrMethod((GoTypeSpec)ObjectUtils.tryCast((Object)typeSpec, GoTypeSpec.class), it -> this.myElementClass.isInstance(it) && fieldOrMethodName.equals(it.getName()));
        }

        @Nullable
        private static Pair<Integer, Integer> getTypeBoundaries(@NotNull String anchor) {
            if (anchor == null) {
                Type.$$$reportNull$$$0(6);
            }
            int packageEnd = anchor.indexOf(".");
            int typeEnd = anchor.indexOf(".", packageEnd + 1);
            if (packageEnd < 0 || typeEnd < 0 || typeEnd <= packageEnd) {
                return null;
            }
            return Pair.create((Object)(packageEnd + 1), (Object)typeEnd);
        }

        @Nullable
        private static Type of(@Nullable PsiElement element) {
            if (element == null) {
                return null;
            }
            PsiFile file = element.getContainingFile();
            if (file instanceof GoFile) {
                if (element instanceof GoFunctionDeclaration) {
                    return FUNCTION;
                }
                if (element instanceof GoTypeSpec) {
                    return TYPE;
                }
                if (element instanceof GoVarOrConstDefinition) {
                    return VAR_OR_CONST;
                }
                if (element instanceof GoMethodDeclaration) {
                    return METHOD;
                }
                if (element instanceof GoMethodSpec && ((GoMethodSpec)element).getTypeReferenceExpression() == null) {
                    return METHOD_SPEC;
                }
                if (element instanceof GoFieldDefinition) {
                    return FIELD;
                }
            } else if (element instanceof PsiDirectory) {
                return PACKAGE;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packages";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            objectArray2[1] = "com/goide/documentation/GoDocLink$Type";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findFieldOrMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTypeBoundaries";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

