/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.dlv.DlvDebugProcess;
import com.goide.execution.DefaultTargetEnvironmentProvider;
import com.goide.execution.GoConsoleFilter;
import com.goide.execution.GoLazyDelegatingSearchScope;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRuntimeErrorsListener;
import com.goide.execution.extension.GoRunConfigurationExtensionsManager;
import com.goide.execution.target.GoCommandLineSetup;
import com.goide.i18n.GoBundle;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoExecutor;
import com.goide.util.GoLocalEnvironmentRequest;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class GoRunningState<T extends GoRunConfigurationBase<?>>
implements RunProfileState,
UserDataHolder {
    private static final Logger LOG = Logger.getInstance(GoRunningState.class);
    @Nullable
    protected final Module myModule;
    @NotNull
    protected final ExecutionEnvironment myEnvironment;
    @NotNull
    private final List<ProcessListener> myProcessListeners;
    @Nullable
    private volatile TargetValue<Integer> myDebugPortValue;
    private final UserDataHolderBase myUserData;
    @NotNull
    private final GoLazyDelegatingSearchScope myExecutionScope;
    @NotNull
    protected final T myConfiguration;

    @NotNull
    public T getConfiguration() {
        T t = this.myConfiguration;
        if (t == null) {
            GoRunningState.$$$reportNull$$$0(0);
        }
        return t;
    }

    public GoRunningState(@NotNull ExecutionEnvironment env, @Nullable Module module, @NotNull T configuration) {
        if (env == null) {
            GoRunningState.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            GoRunningState.$$$reportNull$$$0(2);
        }
        this.myProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myUserData = new UserDataHolderBase();
        this.myEnvironment = env;
        this.myModule = module;
        this.myConfiguration = configuration;
        Project project = this.myConfiguration.getProject();
        this.myExecutionScope = new GoLazyDelegatingSearchScope(project, () -> ExecutionSearchScopes.executionScope((Project)project, (RunProfile)this.myEnvironment.getRunProfile()));
    }

    public boolean isDebug() {
        return "Debug".equals(this.myEnvironment.getExecutor().getId()) || "DlvRecordAndDebug".equals(this.myEnvironment.getExecutor().getId());
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            GoRunningState.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            GoRunningState.$$$reportNull$$$0(4);
        }
        ExecutionResult executionResult = this.execute(executor, runner, this.startProcess());
        if (executionResult == null) {
            GoRunningState.$$$reportNull$$$0(5);
        }
        return executionResult;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner, @NotNull ProcessHandler processHandler) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            GoRunningState.$$$reportNull$$$0(6);
        }
        if (runner == null) {
            GoRunningState.$$$reportNull$$$0(7);
        }
        if (processHandler == null) {
            GoRunningState.$$$reportNull$$$0(8);
        }
        if ((console = this.createConsole(executor, processHandler)) != null) {
            Project project = this.myConfiguration.getProject();
            console.addMessageFilter((Filter)new GoConsoleFilter(project, this.myModule, ((GoRunConfigurationBase)((Object)this.myConfiguration)).getWorkingDirectoryUrl()));
            for (Filter filter : ConsoleViewUtil.computeConsoleFilters((Project)project, (ConsoleView)console, (GlobalSearchScope)this.getSearchScope())) {
                console.addMessageFilter(filter);
            }
            console.attachToProcess(processHandler);
        }
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    public boolean isRemoteDebug() {
        try {
            return this.getTargetEnvironmentRequest() != null;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public InetSocketAddress getDebugAddress() {
        try {
            return this.getDebugServerAddress();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public InetSocketAddress getDebugServerAddress() throws ExecutionException {
        return null;
    }

    @NotNull
    public Promise<InetSocketAddress> getDebugClientAddress() throws ExecutionException {
        InetSocketAddress serverAddress = this.getDebugServerAddress();
        if (serverAddress == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                GoRunningState.$$$reportNull$$$0(9);
            }
            return promise;
        }
        if (this.myDebugPortValue == null) {
            Promise promise = Promises.resolvedPromise((Object)serverAddress);
            if (promise == null) {
                GoRunningState.$$$reportNull$$$0(10);
            }
            return promise;
        }
        Promise promise = Objects.requireNonNull(this.myDebugPortValue).getLocalValue().thenAsync(port -> port != null ? this.getIpAddress(serverAddress).then(addr -> new InetSocketAddress((InetAddress)addr, (int)port)) : Promises.resolvedPromise(null));
        if (promise == null) {
            GoRunningState.$$$reportNull$$$0(11);
        }
        return promise;
    }

    @NotNull
    private Promise<InetAddress> getIpAddress(@NotNull InetSocketAddress delveAddress) {
        InetAddress defaultAddress;
        block11: {
            AsyncPromise asyncPromise;
            WSLDistribution wsl;
            block13: {
                block12: {
                    if (delveAddress == null) {
                        GoRunningState.$$$reportNull$$$0(12);
                    }
                    defaultAddress = delveAddress.getAddress();
                    if (!Registry.is((String)"go.debugger.use.internal.wsl.ip")) {
                        Promise promise = Promises.resolvedPromise((Object)defaultAddress);
                        if (promise == null) {
                            GoRunningState.$$$reportNull$$$0(13);
                        }
                        return promise;
                    }
                    TargetEnvironmentRequest request = this.getTargetEnvironmentRequest();
                    if (!(request instanceof WslTargetEnvironmentRequest)) break block11;
                    wsl = ((WslTargetEnvironmentRequest)request).getConfiguration().getDistribution();
                    if (wsl != null) break block12;
                    LOG.warn("Failed to get wsl distribution");
                    Promise promise = Promises.resolvedPromise((Object)defaultAddress);
                    if (promise == null) {
                        GoRunningState.$$$reportNull$$$0(14);
                    }
                    return promise;
                }
                if (wsl.getVersion() != 1) break block13;
                Promise promise = Promises.resolvedPromise((Object)defaultAddress);
                if (promise == null) {
                    GoRunningState.$$$reportNull$$$0(15);
                }
                return promise;
            }
            try {
                AsyncPromise promise = new AsyncPromise();
                ApplicationManager.getApplication().executeOnPooledThread(() -> promise.setResult((Object)new WSLDistribution(wsl.getMsId()).getWslIpAddress()));
                asyncPromise = promise;
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to get target environment request", (Throwable)e);
            }
            if (asyncPromise == null) {
                GoRunningState.$$$reportNull$$$0(16);
            }
            return asyncPromise;
        }
        Promise promise = Promises.resolvedPromise((Object)defaultAddress);
        if (promise == null) {
            GoRunningState.$$$reportNull$$$0(17);
        }
        return promise;
    }

    public void addProcessListener(@NotNull ProcessListener listener2) {
        if (listener2 == null) {
            GoRunningState.$$$reportNull$$$0(18);
        }
        this.myProcessListeners.add(listener2);
    }

    protected ConsoleView createConsole(@NotNull Executor executor, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            GoRunningState.$$$reportNull$$$0(19);
        }
        if (processHandler == null) {
            GoRunningState.$$$reportNull$$$0(20);
        }
        Project project = this.myEnvironment.getProject();
        if (TerminalExecutionConsole.isAcceptable((ProcessHandler)processHandler)) {
            return new TerminalExecutionConsole(project, processHandler).withEnterKeyDefaultCodeEnabled(true);
        }
        GlobalSearchScope searchScope = ExecutionSearchScopes.executionScope((Project)project, (RunProfile)this.myEnvironment.getRunProfile());
        return new ConsoleViewImpl(project, searchScope, false, false);
    }

    @NotNull
    public ProcessHandler startProcess() throws ExecutionException {
        final GoExecutor executor = this.createRunExecutor().withParameterString(this.getRunParameters());
        TargetEnvironmentRequest request = executor.getTargetEnvironmentRequest();
        if (((GoRunConfigurationBase)((Object)this.myConfiguration)).isRunWithSudo() && request instanceof WslTargetEnvironmentRequest) {
            ((WslTargetEnvironmentRequest)request).getWslOptions().setSudo(true);
        }
        ProgressIndicator indicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        TargetEnvironment environment = executor.prepareRemoteEnvironment(request, indicator);
        TargetedCommandLineBuilder commandLineBuilder = executor.createCommandLine(request);
        TargetedCommandLine commandLine = commandLineBuilder.build();
        Process process = environment.createProcess(commandLine, indicator);
        String commandRepresentation = commandLine.getCommandPresentation(environment);
        final Map environmentVariables = commandLine.getEnvironmentVariables();
        Object handler = GoRunningState.useColoredHandler(environment, commandLine) ? new KillableColoredProcessHandler(process, commandRepresentation + " #gosetup", commandLine.getCharset()){

            public void startNotify() {
                if (executor.isShowGoEnvVariables()) {
                    GoRunUtil.printGoEnvVariables(GoRunningState.this.myConfiguration.getProject(), environmentVariables, (ProcessHandler)this);
                }
                super.startNotify();
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/execution/GoRunningState$1", "readerOptions"));
            }
        } : new KillableProcessHandler(process, commandRepresentation, commandLine.getCharset()){

            public void startNotify() {
                if (executor.isShowGoEnvVariables()) {
                    GoRunUtil.printGoEnvVariables(GoRunningState.this.myConfiguration.getProject(), environmentVariables, (ProcessHandler)this);
                }
                super.startNotify();
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
                if (options == null) {
                    2.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/execution/GoRunningState$2", "readerOptions"));
            }
        };
        ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)this.myConfiguration.getProject(), (String)("\n" + GoBundle.message((String)"go.execution.process.finished.with.exit.code", (Object[])new Object[]{this.getProcessName(), "$EXIT_CODE$"}) + "\n"));
        GoRunConfigurationExtensionsManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)handler, this.myEnvironment.getRunnerSettings());
        handler.addProcessListener(this.getRuntimeErrorsListener());
        this.myProcessListeners.forEach(arg_0 -> GoRunningState.lambda$startProcess$4((KillableProcessHandler)handler, arg_0));
        Object object = handler;
        if (object == null) {
            GoRunningState.$$$reportNull$$$0(21);
        }
        return object;
    }

    @NotNull
    protected String getRunParameters() {
        String string = ProgramParametersConfigurator.expandMacros((String)((GoRunConfigurationBase)((Object)this.myConfiguration)).getParams());
        if (string == null) {
            GoRunningState.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    @Nls
    protected String getProcessName() {
        String string = this.isDebug() ? GoBundle.message((String)"go.execution.debugger.process.name", (Object[])new Object[0]) : GoBundle.message((String)"go.execution.application.process.name", (Object[])new Object[0]);
        if (string == null) {
            GoRunningState.$$$reportNull$$$0(23);
        }
        return string;
    }

    protected GoExecutor createRunExecutor() throws ExecutionException {
        return this.patchCommandLine(this.createCommonExecutor(), CommandLineType.RUN);
    }

    @NotNull
    protected GoExecutor patchCommandLine(@NotNull GoExecutor executor, @NotNull CommandLineType commandLineType) {
        if (executor == null) {
            GoRunningState.$$$reportNull$$$0(24);
        }
        if (commandLineType == null) {
            GoRunningState.$$$reportNull$$$0(25);
        }
        GoExecutor goExecutor = executor.withExecutorPatcher((ThrowableRunnable<? extends ExecutionException>)((ThrowableRunnable)() -> GoRunConfigurationExtensionsManager.getInstance().patchExecutor((GoRunConfigurationBase<?>)((Object)((Object)this.myConfiguration)), this.myEnvironment.getRunnerSettings(), executor, this.myEnvironment.getRunner().getRunnerId(), this, commandLineType))).withCommandLinePatcher((ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException>)((ThrowableConsumer)commandLine -> GoRunConfigurationExtensionsManager.getInstance().patchCommandLine((GoRunConfigurationBase<?>)((Object)((Object)this.myConfiguration)), this.myEnvironment.getRunnerSettings(), (GeneralCommandLine)commandLine, this.myEnvironment.getRunner().getRunnerId(), (GoRunningState<? extends GoRunConfigurationBase<?>>)this, commandLineType))).withTargetedCommandLinePatcher((ThrowableConsumer<? super TargetedCommandLineBuilder, ? extends ExecutionException>)((ThrowableConsumer)commandLine -> GoRunConfigurationExtensionsManager.getInstance().patchCommandLine((GoRunConfigurationBase<?>)((Object)((Object)this.myConfiguration)), this.myEnvironment.getRunnerSettings(), (TargetedCommandLineBuilder)commandLine, this.myEnvironment.getRunner().getRunnerId(), (GoRunningState<? extends GoRunConfigurationBase<?>>)this, commandLineType)));
        if (goExecutor == null) {
            GoRunningState.$$$reportNull$$$0(26);
        }
        return goExecutor;
    }

    @NotNull
    protected GoExecutor createCommonExecutor() throws ExecutionException {
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>(((GoRunConfigurationBase)((Object)this.myConfiguration)).getCustomEnvironment());
        EnvironmentUtil.inlineParentOccurrences(environment);
        GoExecutor goExecutor = GoExecutor.in(this.myConfiguration.getProject(), this.myModule).withTargetEnvironmentRequest(this.getTargetEnvironmentRequest()).withWorkDirectory(((GoRunConfigurationBase)((Object)this.myConfiguration)).getWorkingDirectory()).withUserDefinedEnvironment(environment).withPassParentEnvironment(((GoRunConfigurationBase)((Object)this.myConfiguration)).isPassParentEnvironment());
        if (goExecutor == null) {
            GoRunningState.$$$reportNull$$$0(27);
        }
        return goExecutor;
    }

    @NotNull
    protected GoExecutor createDelveExecutor() throws ExecutionException {
        InetSocketAddress address = this.getDebugServerAddress();
        if (address == null) {
            throw new ExecutionException(GoBundle.message((String)"go.execution.unknown.target.delve.socket.error", (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        GoExecutor executor = this.patchCommandLine(this.createCommonExecutor(), CommandLineType.RUN);
        TargetEnvironmentRequest environmentRequest = executor.getTargetEnvironmentRequest();
        File dlv = GoRunUtil.dlv(environmentRequest);
        if (!dlv.exists()) {
            String os = GoRunUtil.getTargetPlatform(environmentRequest);
            String arch = GoRunUtil.getTargetArch(environmentRequest);
            throw new ExecutionException(os != null && arch != null ? GoBundle.message((String)"go.execution.dlv.not.found.for", (Object[])new Object[]{os, arch}) : GoBundle.message((String)"go.execution.dlv.not.found.for.target.platform", (Object[])new Object[0]));
        }
        if (dlv.exists() && !dlv.canExecute()) {
            dlv.setExecutable(true, false);
        }
        @NonNls Object startDelveMessage = "Start Delve debug process";
        String delvePath = dlv.getAbsolutePath();
        if (environmentRequest instanceof LocalTargetEnvironmentRequest && !FileUtil.filesEqual((File)dlv, (File)GoRunUtil.getBundledDlv(null))) {
            startDelveMessage = (String)startDelveMessage + ", custom Delve path: " + delvePath;
            this.myEnvironment.putUserData(DlvDebugProcess.CUSTOM_DELVE_PATH_KEY, (Object)delvePath);
        }
        LOG.info((String)startDelveMessage);
        executor.showGoEnvVariables(false).withExePath(GoCommandLineParameter.path(delvePath)).withParameters(new DebugListenParameter(address)).withParameters("--headless=true", "--api-version=2", "--check-go-version=false", "--only-same-user=false");
        if ("DlvRecordAndDebug".equals(this.myEnvironment.getExecutor().getId())) {
            executor.withParameters("--backend=rr");
        } else if (SystemProperties.getBooleanProperty((String)"dlv.native.backend", (boolean)false)) {
            executor.withParameters("--backend=native");
        }
        GoExecutor goExecutor = executor;
        if (goExecutor == null) {
            GoRunningState.$$$reportNull$$$0(28);
        }
        return goExecutor;
    }

    @NotNull
    protected ProcessListener getRuntimeErrorsListener() {
        return new GoRuntimeErrorsListener(this.myConfiguration.getProject(), true);
    }

    @Nullable
    public <V> V getUserData(@NotNull Key<V> key) {
        if (key == null) {
            GoRunningState.$$$reportNull$$$0(29);
        }
        return (V)this.myUserData.getUserData(key);
    }

    public <V> void putUserData(@NotNull Key<V> key, @Nullable V value2) {
        if (key == null) {
            GoRunningState.$$$reportNull$$$0(30);
        }
        this.myUserData.putUserData(key, value2);
    }

    @Nullable
    public TargetEnvironmentRequest getTargetEnvironmentRequest() throws ExecutionException {
        if (RunTargetsEnabled.get()) {
            Project project = this.myEnvironment.getProject();
            String targetName = TargetEnvironmentConfigurations.getEffectiveTargetName(this.myConfiguration, (Project)project);
            if (targetName != null) {
                TargetEnvironmentConfiguration config = (TargetEnvironmentConfiguration)this.getTargetManager().getTargets().findByName(targetName);
                if (config == null) {
                    throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.find.target.error", (Object[])new Object[]{targetName}));
                }
                return config.createEnvironmentRequest(project);
            }
            TargetEnvironmentConfiguration env = DefaultTargetEnvironmentProvider.getDefaultTargetEnvironment(project, this.myModule);
            return env != null ? env.createEnvironmentRequest(project) : null;
        }
        return null;
    }

    @NotNull
    private TargetEnvironmentsManager getTargetManager() {
        TargetEnvironmentsManager targetEnvironmentsManager = TargetEnvironmentsManager.getInstance((Project)this.myEnvironment.getProject());
        if (targetEnvironmentsManager == null) {
            GoRunningState.$$$reportNull$$$0(31);
        }
        return targetEnvironmentsManager;
    }

    private static boolean useColoredHandler(@NotNull TargetEnvironment environment, @NotNull TargetedCommandLine commandLine) {
        if (environment == null) {
            GoRunningState.$$$reportNull$$$0(32);
        }
        if (commandLine == null) {
            GoRunningState.$$$reportNull$$$0(33);
        }
        if (environment instanceof GoLocalEnvironmentRequest.GoLocalRemoteEnvironment && ((GoLocalEnvironmentRequest.GoLocalRemoteEnvironment)environment).isConsoleMode()) {
            return true;
        }
        return commandLine.getPtyOptions() == null;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    public void prepareStateInBGT() {
        ThreadingAssertions.assertBackgroundThread();
        this.myExecutionScope.initialize();
    }

    @NotNull
    private GlobalSearchScope getSearchScope() {
        GoLazyDelegatingSearchScope goLazyDelegatingSearchScope = this.myExecutionScope;
        if (goLazyDelegatingSearchScope == null) {
            GoRunningState.$$$reportNull$$$0(34);
        }
        return goLazyDelegatingSearchScope;
    }

    private static /* synthetic */ void lambda$startProcess$4(KillableProcessHandler handler, ProcessListener it) {
        handler.addProcessListener(it);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 12, 18, 19, 20, 24, 25, 29, 30, 32, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoRunningState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 6: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delveAddress";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineType";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoRunningState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugClientAddress";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpAddress";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonExecutor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createDelveExecutor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetManager";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIpAddress";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addProcessListener";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "useColoredHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 12, 18, 19, 20, 24, 25, 29, 30, 32, 33 -> new IllegalArgumentException(string);
        };
    }

    public static enum CommandLineType {
        BUILD,
        RUN;

    }

    private class DebugListenParameter
    implements GoCommandLineParameter {
        private final InetSocketAddress myAddress;
        private static final String ANY_IP = "0.0.0.0";
        private volatile String myTargetHost;

        DebugListenParameter(InetSocketAddress address) {
            if (address == null) {
                DebugListenParameter.$$$reportNull$$$0(0);
            }
            this.myAddress = address;
        }

        @Override
        public void prepare(@NotNull GoCommandLineSetup setup) {
            if (setup == null) {
                DebugListenParameter.$$$reportNull$$$0(1);
            }
            this.myTargetHost = setup.getRequest() instanceof LocalTargetEnvironmentRequest || setup.getRequest() instanceof WslTargetEnvironmentRequest ? this.myAddress.getAddress().getHostAddress() : ANY_IP;
            GoRunningState.this.myDebugPortValue = setup.requestPort(this.myAddress.getPort());
        }

        @Override
        public TargetValue<String> toValue() {
            return new TargetValue<String>(){

                public Promise<String> getLocalValue() {
                    return Objects.requireNonNull(GoRunningState.this.myDebugPortValue).getLocalValue().then(localPort -> DebugListenParameter.listen("localhost", localPort));
                }

                public Promise<String> getTargetValue() {
                    return Objects.requireNonNull(GoRunningState.this.myDebugPortValue).getTargetValue().then(targetPort -> DebugListenParameter.listen(DebugListenParameter.this.myTargetHost, targetPort));
                }
            };
        }

        @Override
        @NotNull
        public String toPresentableString() {
            String string = DebugListenParameter.listen(this.myTargetHost, this.myAddress.getPort());
            if (string == null) {
                DebugListenParameter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static String listen(String host, Integer port) {
            return "--listen=" + host + ":" + port;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "address";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoRunningState$DebugListenParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoRunningState$DebugListenParameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPresentableString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

