/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.goide.GoFileType;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.coverage.GoCoverageAnnotator;
import com.goide.execution.testing.coverage.GoCoverageEnabledConfiguration;
import com.goide.execution.testing.coverage.GoCoverageSuite;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkService;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GoCoverageEngine
extends CoverageEngine {
    public static final GoCoverageEngine INSTANCE = new GoCoverageEngine();
    private static final Condition<AbstractTreeNode<?>> NODE_TO_COVERAGE = node2 -> {
        Object value2 = node2.getValue();
        if (value2 instanceof PsiFile) {
            return GoCoverageEngine.isProductionGoFile((PsiFile)value2);
        }
        return !StringUtil.equals((CharSequence)node2.getName(), (CharSequence)".idea");
    };

    public static boolean isApplicable(@Nullable RunProfile conf) {
        if (conf instanceof WrappingRunConfiguration) {
            conf = ((WrappingRunConfiguration)conf).getPeer();
        }
        Module module = (Module)ObjectUtils.doIfCast((Object)conf, ModuleBasedConfiguration.class, c -> c.getConfigurationModule().getModule());
        if (conf instanceof GoTestRunConfiguration) {
            if (((GoTestRunConfiguration)conf).getKind() != GoBuildingRunConfiguration.Kind.DIRECTORY) {
                return true;
            }
            if (module != null) {
                return GoSdkService.getInstance(module.getProject()).getSdk(module).supportsMultiPackageCoverage();
            }
        }
        if (conf instanceof GoApplicationConfiguration && module != null) {
            return GoSdkService.getInstance(module.getProject()).getSdk(module).supportsApplicationCoverage();
        }
        return false;
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            GoCoverageEngine.$$$reportNull$$$0(0);
        }
        return GoCoverageEngine.isApplicable((RunProfile)conf);
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            GoCoverageEngine.$$$reportNull$$$0(1);
        }
        return new GoCoverageEnabledConfiguration((GoBuildingRunConfiguration)conf);
    }

    @NotNull
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            GoCoverageEngine.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoCoverageEngine.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            GoCoverageEngine.$$$reportNull$$$0(4);
        }
        if (fileProvider == null) {
            GoCoverageEngine.$$$reportNull$$$0(5);
        }
        return new GoCoverageSuite(name, project, runner, fileProvider, timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp, @NotNull CoverageEnabledConfiguration coverageEnabledConfiguration) {
        void config;
        if (name == null) {
            GoCoverageEngine.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GoCoverageEngine.$$$reportNull$$$0(7);
        }
        if (runner == null) {
            GoCoverageEngine.$$$reportNull$$$0(8);
        }
        if (fileProvider == null) {
            GoCoverageEngine.$$$reportNull$$$0(9);
        }
        if (coverageEnabledConfiguration == null) {
            GoCoverageEngine.$$$reportNull$$$0(10);
        }
        if (config instanceof GoCoverageEnabledConfiguration) {
            return new GoCoverageSuite(name, project, runner, fileProvider, timestamp);
        }
        return null;
    }

    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            GoCoverageEngine.$$$reportNull$$$0(11);
        }
        return new GoCoverageSuite();
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(Project project) {
        GoCoverageAnnotator goCoverageAnnotator = GoCoverageAnnotator.getInstance(project);
        if (goCoverageAnnotator == null) {
            GoCoverageEngine.$$$reportNull$$$0(12);
        }
        return goCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(13);
        }
        return GoCoverageEngine.isProductionGoFile(psiFile);
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(14);
        }
        if (suite == null) {
            GoCoverageEngine.$$$reportNull$$$0(15);
        }
        return GoCoverageEngine.isProductionGoFile(psiFile);
    }

    private static boolean isProductionGoFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(16);
        }
        return psiFile.getFileType() == GoFileType.INSTANCE && !GoTestFinder.isTestFile(psiFile);
    }

    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(17);
        }
        if (sourceFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(18);
        }
        return sourceFile.getVirtualFile().getPath();
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(19);
        }
        Set<String> set = Collections.singleton(sourceFile.getVirtualFile().getPath());
        if (set == null) {
            GoCoverageEngine.$$$reportNull$$$0(20);
        }
        return set;
    }

    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        if (classFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(21);
        }
        if (suite == null) {
            GoCoverageEngine.$$$reportNull$$$0(22);
        }
        return null;
    }

    @Nls
    public String getPresentableText() {
        return GoBundle.message((String)"go.execution.coverage.engine.name", (Object[])new Object[0]);
    }

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return !fileOrDir.isDirectory() && FileTypeRegistry.getInstance().isFileOfType(fileOrDir, (FileType)GoFileType.INSTANCE) && !GoTestFinder.isTestFile(fileOrDir);
    }

    public CoverageViewExtension createCoverageViewExtension(final Project project, CoverageSuitesBundle suiteBundle) {
        return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle){

            @NotNull
            public AbstractTreeNode<?> createRootNode() {
                VirtualFile[] roots = ProjectRootManager.getInstance((Project)project).getContentRoots();
                VirtualFile commonAncestor = VfsUtil.getCommonAncestor(Arrays.asList(roots));
                VirtualFile baseDir = (VirtualFile)ObjectUtils.chooseNotNull((Object)commonAncestor, (Object)ProjectUtil.guessProjectDir((Project)project));
                PsiDirectory root = PsiManager.getInstance((Project)this.myProject).findDirectory(Objects.requireNonNull(baseDir));
                return new CoverageListRootNode(this.myProject, (PsiNamedElement)Objects.requireNonNull(root), this.mySuitesBundle);
            }

            public @Unmodifiable List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode node2) {
                return ContainerUtil.filter((Collection)super.getChildrenNodes(node2), NODE_TO_COVERAGE);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageEngine";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageEngine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageEnabledConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 12: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isProductionGoFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 20 -> new IllegalStateException(string);
        };
    }
}

