/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gobench;

import com.goide.execution.testing.frameworks.gotest.GoTestEventsConverterBaseImpl;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;

public class GobenchEventsConverter
extends GoTestEventsConverterBaseImpl {
    private static final Pattern RUN = Pattern.compile("^(Benchmark([\\p{javaLetter}_][\\p{javaLetterOrDigit}_]*(/\\S*)?)?)");
    private static final Pattern FAIL = Pattern.compile("^--- FAIL: (Benchmark([\\p{javaLetter}_][\\p{javaLetterOrDigit}_]*(/\\S*)?)?).*");

    public GobenchEventsConverter(@NotNull String defaultImportPath, @NotNull TestConsoleProperties properties) {
        if (defaultImportPath == null) {
            GobenchEventsConverter.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            GobenchEventsConverter.$$$reportNull$$$0(1);
        }
        super("gobench", defaultImportPath, properties);
    }

    @Override
    protected int processLine(@NotNull String line, int start, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        Matcher matcher;
        if (line == null) {
            GobenchEventsConverter.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            GobenchEventsConverter.$$$reportNull$$$0(3);
        }
        if (visitor2 == null) {
            GobenchEventsConverter.$$$reportNull$$$0(4);
        }
        if ((matcher = RUN.matcher(line)).find(start)) {
            Matcher failMatcher;
            this.startTest(matcher.group(1), outputType, visitor2);
            start = matcher.start(1);
            int nameEndOffset = GobenchEventsConverter.findFirstNonWSIndex(line, start + matcher.end(1));
            if (nameEndOffset > -1 && (failMatcher = FAIL.matcher(line.substring(nameEndOffset))).find()) {
                this.finishTest(failMatcher.group(1), GoTestEventsConverterBaseImpl.TestResult.FAILED, visitor2);
                int newStartOffset = GobenchEventsConverter.findFirstNonWSIndex(line, start + failMatcher.end(1));
                return newStartOffset != -1 ? newStartOffset : line.length();
            }
        }
        return start;
    }

    @Override
    protected void startTest(@NotNull String testName, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        String currentTestName;
        if (testName == null) {
            GobenchEventsConverter.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            GobenchEventsConverter.$$$reportNull$$$0(6);
        }
        if (visitor2 == null) {
            GobenchEventsConverter.$$$reportNull$$$0(7);
        }
        if ((currentTestName = this.getCurrentTestName()) != null && !currentTestName.equals(testName)) {
            this.finishTest(currentTestName, GoTestEventsConverterBaseImpl.TestResult.PASSED, visitor2);
        }
        super.startTest(testName, outputType, visitor2);
    }

    @Override
    protected GoTestEventsConverterBaseImpl.TestResult getDefaultUnfinishedTestResult() {
        return GoTestEventsConverterBaseImpl.TestResult.PASSED;
    }

    private static int findFirstNonWSIndex(@NotNull String text, int startOffset) {
        int whitespaceIndex;
        if (text == null) {
            GobenchEventsConverter.$$$reportNull$$$0(8);
        }
        if ((whitespaceIndex = StringUtil.indexOfAny((String)text, (String)" \t", (int)startOffset, (int)text.length())) != -1) {
            int newStartOffset;
            for (newStartOffset = whitespaceIndex; newStartOffset < text.length() && Character.isWhitespace(text.charAt(newStartOffset)); ++newStartOffset) {
            }
            return newStartOffset;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/testing/frameworks/gobench/GobenchEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processLine";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "startTest";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstNonWSIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

