/*
 * Decompiled with CFR 0.152.
 */
package com.goide.go;

import com.goide.GoTypes;
import com.goide.go.GoDefaultRenderer;
import com.goide.go.GoGotoPopup;
import com.goide.go.GoGotoUtil;
import com.goide.go.GoMethodInheritorsSearch;
import com.goide.go.GoMethodRenderer;
import com.goide.go.GoPopupItemPresentationProvider;
import com.goide.go.GoShadowingMethodsSearch;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInheritorsSearch
extends QueryExecutorBase<GoTypeSpec, DefinitionsScopedSearch.SearchParameters> {
    public static final GoInheritorsSearch INHERITORS_SEARCH = new GoInheritorsSearch();
    public static final Icon IMPLEMENTED_ICON = AllIcons.Gutter.ImplementedMethod;
    public static final Icon GO_TO_SHADOWING_ICON = AllIcons.Gutter.OverridenMethod;
    public static final GoMethodInheritorsSearch METHOD_INHERITORS_SEARCH = new GoMethodInheritorsSearch();

    public GoInheritorsSearch() {
        super(true);
    }

    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters parameter, @NotNull Processor<? super GoTypeSpec> processor2) {
        if (parameter == null) {
            GoInheritorsSearch.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            GoInheritorsSearch.$$$reportNull$$$0(1);
        }
        if (!parameter.isCheckDeep()) {
            return;
        }
        PsiElement o = parameter.getElement();
        if (o instanceof GoTypeSpec) {
            GoInterfaceType interfaceType = GoInheritorsSearch.getInterfaceType((GoTypeSpec)o);
            if (interfaceType == null) {
                return;
            }
            ReferenceOpenHashSet visitedSpecs = new ReferenceOpenHashSet();
            List<GoMethodSpec> ownMethods = interfaceType.getMethods();
            GoInheritorsSearch.processTypeSpec(parameter, processor2, (GoTypeSpec)o, interfaceType, ownMethods, true, (Set<GoTypeSpec>)visitedSpecs);
            Collection methods = ContainerUtil.subtract(interfaceType.getAllMethods(), ownMethods);
            GoInheritorsSearch.processTypeSpec(parameter, processor2, (GoTypeSpec)o, interfaceType, methods, true, (Set<GoTypeSpec>)visitedSpecs);
        }
    }

    @Nullable
    static GoInterfaceType getInterfaceType(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoInheritorsSearch.$$$reportNull$$$0(2);
        }
        return (GoInterfaceType)ObjectUtils.tryCast((Object)typeSpec.getSpecType().getContextlessUnderlyingType(), GoInterfaceType.class);
    }

    static void processTypeSpec(@NotNull DefinitionsScopedSearch.SearchParameters parameter, @NotNull Processor<? super GoTypeSpec> processor2, @NotNull GoTypeSpec typeSpec, @NotNull GoInterfaceType interfaceType, @NotNull Collection<GoMethodSpec> methods, boolean canBeImplementedOutsidePackage) {
        if (parameter == null) {
            GoInheritorsSearch.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            GoInheritorsSearch.$$$reportNull$$$0(4);
        }
        if (typeSpec == null) {
            GoInheritorsSearch.$$$reportNull$$$0(5);
        }
        if (interfaceType == null) {
            GoInheritorsSearch.$$$reportNull$$$0(6);
        }
        if (methods == null) {
            GoInheritorsSearch.$$$reportNull$$$0(7);
        }
        GoInheritorsSearch.processTypeSpec(parameter, processor2, typeSpec, interfaceType, methods, canBeImplementedOutsidePackage, (Set<GoTypeSpec>)new ReferenceOpenHashSet());
    }

    private static void processTypeSpec(@NotNull DefinitionsScopedSearch.SearchParameters parameter, @NotNull Processor<? super GoTypeSpec> processor2, @NotNull GoTypeSpec typeSpec, @NotNull GoInterfaceType interfaceType, @NotNull Collection<GoMethodSpec> methods, boolean canBeImplementedOutsidePackage, @NotNull Set<GoTypeSpec> visitedSpecs) {
        if (parameter == null) {
            GoInheritorsSearch.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            GoInheritorsSearch.$$$reportNull$$$0(9);
        }
        if (typeSpec == null) {
            GoInheritorsSearch.$$$reportNull$$$0(10);
        }
        if (interfaceType == null) {
            GoInheritorsSearch.$$$reportNull$$$0(11);
        }
        if (methods == null) {
            GoInheritorsSearch.$$$reportNull$$$0(12);
        }
        if (visitedSpecs == null) {
            GoInheritorsSearch.$$$reportNull$$$0(13);
        }
        GlobalSearchScope searchScope = GoGotoUtil.intersectIfNeeded(parameter, GoInheritorsSearch.getSearchScope(typeSpec, canBeImplementedOutsidePackage));
        Project project = typeSpec.getProject();
        Condition condition = spec -> GoTypeUtil.isImplementsInterface(interfaceType, spec.getSpecType(), true, false, true, typeSpec);
        GoGotoUtil.searchInContentFirst(project, searchScope, (Processor<? super GlobalSearchScope>)((Processor)scope -> GoInheritorsSearch.processMethodOwners(project, methods, scope, GoGotoUtil.createCandidatesProcessor(project, processor2, typeSpec, scope, (Condition<GoTypeSpec>)condition), visitedSpecs)));
    }

    private static boolean processMethodOwners(@NotNull Project project, @NotNull Collection<GoMethodSpec> methods, @NotNull GlobalSearchScope scope, @NotNull Processor<? super GoTypeSpec> processor2, @NotNull Set<GoTypeSpec> visitedSpecs) {
        if (project == null) {
            GoInheritorsSearch.$$$reportNull$$$0(14);
        }
        if (methods == null) {
            GoInheritorsSearch.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            GoInheritorsSearch.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            GoInheritorsSearch.$$$reportNull$$$0(17);
        }
        if (visitedSpecs == null) {
            GoInheritorsSearch.$$$reportNull$$$0(18);
        }
        for (GoNamedSignatureOwner method : JBIterable.from(methods).filter(PsiElement::isValid).sort(Comparator.comparing(o -> -GoPsiImplUtil.getArity(o)))) {
            if (!GoGotoUtil.processMethodStructs(project, scope, processor2, visitedSpecs, method)) {
                return false;
            }
            if (GoGotoUtil.processMethodInterfaces(project, scope, processor2, visitedSpecs, method)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static GlobalSearchScope getSearchScope(@NotNull GoTypeSpec o, boolean canBeImplementedOutsidePackage) {
        if (o == null) {
            GoInheritorsSearch.$$$reportNull$$$0(19);
        }
        GoFile file = o.getContainingFile();
        GlobalSearchScope scope = canBeImplementedOutsidePackage ? GoUtil.goPathProjectScope(o) : GoPackageUtil.packageScope(file);
        GlobalSearchScope globalSearchScope = scope.union((SearchScope)GlobalSearchScope.fileScope((PsiFile)file));
        if (globalSearchScope == null) {
            GoInheritorsSearch.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceType";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedSpecs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/go/GoInheritorsSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/go/GoInheritorsSearch";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTypeSpec";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processMethodOwners";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 20: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20 -> new IllegalStateException(string);
        };
    }

    public static final class GoInheritorMarkerProvider
    extends LineMarkerProviderDescriptor {
        public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
            if (element == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(0);
            }
            return null;
        }

        public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result) {
            if (elements2 == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(2);
            }
            ReferenceOpenHashSet allSpecs = new ReferenceOpenHashSet();
            ReferenceOpenHashSet specsWithImplementations = new ReferenceOpenHashSet();
            for (PsiElement psiElement : elements2) {
                GoMethodDeclaration method;
                PsiElement grand;
                ProgressManager.checkCanceled();
                if (!(psiElement instanceof LeafPsiElement) || ((LeafPsiElement)psiElement).getElementType() != GoTypes.IDENTIFIER) continue;
                PsiElement parent = psiElement.getParent();
                if (parent instanceof GoSpecType && (grand = parent.getParent()) instanceof GoTypeSpec) {
                    GoTypeSpec spec = (GoTypeSpec)grand;
                    allSpecs.add(spec);
                    if (GoInheritorMarkerProvider.hasImplementations(spec)) {
                        specsWithImplementations.add(spec);
                        result.add(GoInheritorMarkerProvider.createTypeSpecInfo(psiElement, spec));
                    }
                }
                if (parent instanceof GoMethodSpec) {
                    GoTypeSpec spec;
                    GoMethodSpec method2 = (GoMethodSpec)parent;
                    if (method2.getTypeReferenceExpression() != null || (spec = (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)method2, GoTypeSpec.class)) == null) continue;
                    if (!allSpecs.contains(spec)) {
                        allSpecs.add(spec);
                        if (GoInheritorMarkerProvider.hasImplementations(spec)) {
                            specsWithImplementations.add(spec);
                        }
                    }
                    if (!specsWithImplementations.contains(spec)) continue;
                    result.add(GoInheritorMarkerProvider.createMethodInfo(psiElement, method2));
                    continue;
                }
                if (!(parent instanceof GoMethodDeclaration) || !GoInheritorMarkerProvider.hasShadowingMethods(method = (GoMethodDeclaration)parent)) continue;
                result.add(GoInheritorMarkerProvider.createShadowingMethodInfo(psiElement, method));
            }
        }

        @NotNull
        private static <T extends PsiElement> GutterIconNavigationHandler<PsiElement> getHandler(@NotNull Function<PsiElement, T> elementExtractor, @NotNull QueryExecutorBase<T, DefinitionsScopedSearch.SearchParameters> search, @NotNull Function<Integer, @Nls String> createTitle, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String targetKind, @NotNull GoPopupItemPresentationProvider renderer) {
            if (elementExtractor == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(3);
            }
            if (search == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(4);
            }
            if (createTitle == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(5);
            }
            if (targetKind == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(6);
            }
            if (renderer == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(7);
            }
            GutterIconNavigationHandler gutterIconNavigationHandler = (e, identifier) -> {
                PsiElement element = (PsiElement)elementExtractor.apply(identifier);
                if (element == null) {
                    return;
                }
                GoGotoPopup.showGotoPopup(element.getProject(), e, null, createTitle, targetKind, renderer, search, GoGotoUtil.param(element), x -> true);
            };
            if (gutterIconNavigationHandler == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(8);
            }
            return gutterIconNavigationHandler;
        }

        private static LineMarkerInfo<PsiElement> createTypeSpecInfo(@NotNull PsiElement anchor, @NotNull GoTypeSpec spec) {
            if (anchor == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(9);
            }
            if (spec == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(10);
            }
            String name = StringUtil.notNullize((String)spec.getName());
            return GoInheritorMarkerProvider.createInfo(anchor, GoInheritorMarkerProvider.getHandler(identifier -> {
                PsiElement parent = (PsiElement)ObjectUtils.doIfNotNull((Object)identifier.getParent(), PsiElement::getParent);
                return (GoTypeSpec)ObjectUtils.tryCast((Object)parent, GoTypeSpec.class);
            }, INHERITORS_SEARCH, size -> GoBundle.message((String)"go.navigation.go.to.type.implementation.popup.title", (Object[])new Object[]{name, size}), GoBundle.message((String)"go.navigation.go.to.implementation.find.usages.title", (Object[])new Object[]{name}), GoDefaultRenderer.fromContext(anchor)), GoBundle.message((String)"go.navigation.go.to.implementation", (Object[])new Object[0]), IMPLEMENTED_ICON);
        }

        private static LineMarkerInfo<PsiElement> createMethodInfo(@NotNull PsiElement anchor, @NotNull GoMethodSpec method) {
            if (anchor == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(11);
            }
            if (method == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(12);
            }
            String name = StringUtil.notNullize((String)method.getName());
            return GoInheritorMarkerProvider.createInfo(anchor, GoInheritorMarkerProvider.getHandler(identifier -> (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)identifier.getParent(), GoMethodSpec.class), METHOD_INHERITORS_SEARCH, size -> GoBundle.message((String)"go.navigation.go.to.method.implementation.popup.title", (Object[])new Object[]{name, size}), GoBundle.message((String)"go.navigation.go.to.implementation.find.usages.title", (Object[])new Object[]{name}), GoMethodRenderer.fromContext(anchor)), GoBundle.message((String)"go.navigation.go.to.implementation", (Object[])new Object[0]), IMPLEMENTED_ICON);
        }

        private static LineMarkerInfo<PsiElement> createShadowingMethodInfo(@NotNull PsiElement anchor, @NotNull GoMethodDeclaration method) {
            if (anchor == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(13);
            }
            if (method == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(14);
            }
            String name = StringUtil.notNullize((String)method.getName());
            return GoInheritorMarkerProvider.createInfo(anchor, GoInheritorMarkerProvider.getHandler(identifier -> (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)identifier.getParent(), GoMethodDeclaration.class), GoShadowingMethodsSearch.SHADOWING_METHODS_SEARCH, size -> GoBundle.message((String)"go.navigation.go.to.shadowing.method.popup.title", (Object[])new Object[]{name, size}), GoBundle.message((String)"go.navigation.go.to.shadowing.method.find.usages.title", (Object[])new Object[]{name}), GoMethodRenderer.fromContext(anchor)), GoBundle.message((String)"go.navigation.go.to.shadowing.method", (Object[])new Object[0]), GO_TO_SHADOWING_ICON);
        }

        @Nullable
        public String getName() {
            return GoBundle.message((String)"go.navigation.go.to.implementation", (Object[])new Object[0]);
        }

        @Nullable
        public Icon getIcon() {
            return IMPLEMENTED_ICON;
        }

        private static <T extends PsiElement> LineMarkerInfo<T> createInfo(@NotNull T o, @NotNull GutterIconNavigationHandler<T> handler, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String text, @NotNull Icon icon) {
            if (o == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(15);
            }
            if (handler == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(16);
            }
            if (text == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(17);
            }
            if (icon == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(18);
            }
            String tooltip = GoGotoUtil.makeTooltipText(text, "GotoImplementation");
            LineMarkerInfo info = new LineMarkerInfo(o, o.getTextRange(), icon, t -> tooltip, handler, GutterIconRenderer.Alignment.RIGHT, () -> tooltip);
            return NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)text, (String)"GotoImplementation");
        }

        private static boolean hasImplementations(@NotNull GoTypeSpec o) {
            if (o == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(19);
            }
            return GoInheritorMarkerProvider.hasImplementations(o, INHERITORS_SEARCH);
        }

        private static boolean hasShadowingMethods(@NotNull GoMethodDeclaration method) {
            if (method == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(20);
            }
            return GoInheritorMarkerProvider.hasImplementations(method, GoShadowingMethodsSearch.SHADOWING_METHODS_SEARCH);
        }

        private static <T extends PsiElement> boolean hasImplementations(@NotNull T element, @NotNull QueryExecutorBase<T, DefinitionsScopedSearch.SearchParameters> search) {
            if (element == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(21);
            }
            if (search == null) {
                GoInheritorMarkerProvider.$$$reportNull$$$0(22);
            }
            CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
            search.processQuery((Object)GoGotoUtil.param(element), (Processor)processor2);
            return processor2.isFound();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementExtractor";
                    break;
                }
                case 4: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createTitle";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetKind";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/go/GoInheritorsSearch$GoInheritorMarkerProvider";
                    break;
                }
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 12: 
                case 14: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 15: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/go/GoInheritorsSearch$GoInheritorMarkerProvider";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineMarkerInfo";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSlowLineMarkers";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getHandler";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createTypeSpecInfo";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createMethodInfo";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadowingMethodInfo";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "createInfo";
                    break;
                }
                case 19: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "hasImplementations";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "hasShadowingMethods";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

