/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoStringLiteralSpecChecker;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoLiteral;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class GoRuneLiteralSpecChecker
extends GoSpecCheckerBase {
    public GoRuneLiteralSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoRuneLiteralSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitLiteral(@NotNull GoLiteral literal) {
        PsiElement rune;
        if (literal == null) {
            GoRuneLiteralSpecChecker.$$$reportNull$$$0(1);
        }
        if ((rune = literal.getChar()) == null) {
            return;
        }
        String fullText = rune.getText();
        if (fullText.equals("'") || !StringUtil.endsWithChar((CharSequence)fullText, (char)'\'')) {
            this.myHolder.newErrorAnnotation(literal, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.closing.single.quote.expected")).create();
            return;
        }
        String text = StringUtil.unquoteString((String)fullText, (char)'\'');
        if (!StringUtil.startsWithChar((CharSequence)text, (char)'\\')) {
            if (text.length() == 1 || text.length() == 2 && Character.isSurrogatePair(text.charAt(0), text.charAt(1))) {
                return;
            }
            GoInspectionMessageWithI18n message = text.isEmpty() ? GoInspectionMessageWithI18n.message("go.error.annotator.empty.rune.literal") : GoInspectionMessageWithI18n.message("go.error.annotator.too.many.characters.in.rune.literal");
            this.myHolder.newErrorAnnotation(literal, (GoInspectionMessage)message).create();
            return;
        }
        GoInspectionMessage problem = GoStringLiteralSpecChecker.checkEscapeSequence(text, true, true);
        if (problem != null) {
            this.myHolder.newErrorAnnotation(literal, problem).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoRuneLiteralSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

