/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoConstraintElem;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.quickfix.GoDeleteRangeQuickFix;
import com.goide.quickfix.GoShowSdkConfigurableFix;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/goide/highlighting/errors/GoTypeParametersSpecChecker;", "Lcom/goide/highlighting/errors/GoSpecCheckerBase;", "holder", "Lcom/goide/highlighting/GoAnnotationHolder;", "<init>", "(Lcom/goide/highlighting/GoAnnotationHolder;)V", "visitTypeArguments", "", "o", "Lcom/goide/psi/GoTypeArguments;", "visitConstraintElem", "Lcom/goide/psi/GoConstraintElem;", "visitTypeParameters", "Lcom/goide/psi/GoTypeParameters;", "visitIndexOrSliceExpr", "Lcom/goide/psi/GoIndexOrSliceExpr;", "checkTypeParametersEnabled", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoTypeParametersSpecChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTypeParametersSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeParametersSpecChecker\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,85:1\n19#2:86\n*S KotlinDebug\n*F\n+ 1 GoTypeParametersSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeParametersSpecChecker\n*L\n36#1:86\n*E\n"})
public final class GoTypeParametersSpecChecker
extends GoSpecCheckerBase {
    public GoTypeParametersSpecChecker(@NotNull GoAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    @Override
    public void visitTypeArguments(@NotNull GoTypeArguments o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (!this.checkTypeParametersEnabled(o)) {
            return;
        }
    }

    @Override
    public void visitConstraintElem(@NotNull GoConstraintElem o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (!(o.getParent() instanceof GoTypeParameterDeclaration)) {
            this.checkTypeParametersEnabled(o);
        }
    }

    @Override
    public void visitTypeParameters(@NotNull GoTypeParameters o) {
        Object object;
        GoSignature signature;
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (!this.checkTypeParametersEnabled(o)) {
            return;
        }
        PsiElement $this$asSafely$iv = o.getParent();
        boolean $i$f$asSafely2 = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof GoSignature)) {
            psiElement = null;
        }
        GoSignature goSignature = signature = (GoSignature)psiElement;
        Object object2 = object = goSignature != null ? goSignature.getParent() : null;
        if (object instanceof GoMethodDeclaration) {
            Object[] $i$f$asSafely2 = new Object[]{GoBundle.message((String)"go.terms.type.parameters", (Object[])new Object[0])};
            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.method.cannot.have.type.parameters")).withFix((IntentionAction)new GoDeleteRangeQuickFix(o, o, GoBundle.message((String)"go.fix.delete.name", (Object[])$i$f$asSafely2))).create();
            return;
        }
        if (object instanceof GoFunctionLit) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.func.literal.cannot.have.type.parameters");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            GoSpecCheckerBase.withQuickFix(this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message), GoDeleteQuickFix.Fixes.DELETE_TYPE_PARAMETERS_FIX, o, message).create();
            return;
        }
        if (object instanceof GoFunctionDeclaration && o.getTypeParameterDeclarationList().isEmpty()) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.list.of.type.parameters.must.not.be.empty");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            GoSpecCheckerBase.withQuickFix(this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message), GoDeleteQuickFix.Fixes.DELETE_TYPE_PARAMETERS_FIX, o, message).create();
        }
        for (GoTypeParameterDeclaration typeParamDecl : o.getTypeParameterDeclarationList()) {
            GoInspectionMessageWithI18n message;
            if (typeParamDecl.getConstraintElem() != null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)GoInspectionMessageWithI18n.message("go.error.annotator.type.constraint.is.missing"), (String)"message(...)");
            this.myHolder.newErrorAnnotation(typeParamDecl, (GoInspectionMessage)message).create();
        }
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        PsiElement psiElement = GoPsiUtil.getTypeArgument(o);
        if (psiElement == null) {
            return;
        }
        PsiElement typeArgument = psiElement;
        this.checkTypeParametersEnabled(typeArgument);
    }

    private final boolean checkTypeParametersEnabled(PsiElement element) {
        GoSdkUtil.FeatureSupported featureSupported = GoSdkUtil.featureSupported(element, false, GoSdkVersion::supportsGenerics);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)featureSupported), (String)"featureSupported(...)");
        GoSdkUtil.FeatureSupported supported = featureSupported;
        if (supported == GoSdkUtil.FeatureSupported.NO) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.type.parameters.are.not.supported");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            GoSpecCheckerBase.withQuickFix(this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)message), new GoShowSdkConfigurableFix(), element, message).create();
            return false;
        }
        if (supported == GoSdkUtil.FeatureSupported.NEED_VERSION_UPDATE) {
            this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.type.parameters.are.not.supported")).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdkVersion.GO_1_18)).create();
            return false;
        }
        return true;
    }
}

