/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoConstraintElem;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoParType;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoRecursiveTypeInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoRecursiveTypeInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitTypeSpec(@NotNull GoTypeSpec o) {
        if (o == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(1);
        }
        if (o.getSpecType().getType() instanceof GoInterfaceType) {
            return;
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoRecursiveTypeInspection.checkHasRecursiveReference(o, this.myHolder, context);
    }

    public static void checkHasRecursiveReference(@NotNull GoTypeSpec o, @NotNull GoProblemsHolder holder, @NotNull PsiElement context) {
        if (o == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(4);
        }
        if (GoPsiImplUtil.builtin(o)) {
            return;
        }
        GoSpecType specType = o.getSpecType();
        String typeName = o.getName();
        if (StringUtil.isEmpty((String)typeName)) {
            return;
        }
        PsiElement nameIdentifier = o.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        Stack trail = new Stack();
        Ref firstFieldInTheCycle = new Ref();
        ResolveState state = GoPsiImplUtil.createContextOnElement(context);
        if (GoRecursiveTypeInspection.hasRecursiveReference(specType, (GoType)specType, (Stack<String>)trail, (Ref<GoFieldDeclaration>)firstFieldInTheCycle, new HashSet<GoType>(), state, true)) {
            String description = UsageViewUtil.getType((PsiElement)o);
            String details = trail.size() > 2 ? "\n" + StringUtil.join((Collection)trail, (String)(" " + UIUtil.rightArrow() + " ")) : "";
            holder.registerProblem(nameIdentifier, GoInspectionProblemUtil.message("go.inspection.problem.invalid.recursive.type", description, GoInspectionProblemUtil.code(typeName), details), !firstFieldInTheCycle.isNull() ? GoInspectionProblemUtil.fixes(new LocalQuickFix[]{new GoReplaceFieldTypeWithPointerQuickFix((GoFieldDeclaration)firstFieldInTheCycle.get())}) : null);
        }
    }

    public static boolean hasRecursiveReference(@Nullable GoType currentType, @NotNull GoType targetType, @NotNull Stack<String> trail, @NotNull Ref<GoFieldDeclaration> firstFieldInTheCycle, @NotNull Set<GoType> visited, @NotNull ResolveState context, boolean allowReference) {
        GoArrayOrSliceType arrayOrSliceType;
        boolean firstStep;
        if (targetType == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(5);
        }
        if (trail == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(6);
        }
        if (firstFieldInTheCycle == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(7);
        }
        if (visited == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(9);
        }
        if (!(firstStep = visited.isEmpty()) && currentType == targetType) {
            GoRecursiveTypeInspection.pushTypeName(trail, currentType);
            return true;
        }
        if (currentType == null || !visited.add(currentType)) {
            return false;
        }
        if (currentType instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)currentType;
            boolean typeNamePushed = GoRecursiveTypeInspection.pushTypeName(trail, currentType);
            boolean isAlias = GoRecursiveTypeInspection.isAlias(specType);
            GoTypeParameters typeParameters = specType.getTypeParameters();
            if (typeParameters != null) {
                List<GoTypeParameterDeclaration> parameterDeclarations = typeParameters.getTypeParameterDeclarationList();
                for (GoTypeParameterDeclaration parameterDeclaration : parameterDeclarations) {
                    if (!GoRecursiveTypeInspection.hasRecursiveReference(parameterDeclaration.getType(), targetType, trail, firstFieldInTheCycle, visited, context, !isAlias)) continue;
                    return true;
                }
            }
            if (GoRecursiveTypeInspection.hasRecursiveReference(specType.getType(), targetType, trail, firstFieldInTheCycle, visited, context, !isAlias)) {
                return true;
            }
            if (typeNamePushed) {
                trail.pop();
            }
            return false;
        }
        if (currentType instanceof GoStructType) {
            GoStructType structType = (GoStructType)currentType;
            for (GoFieldDeclaration declaration : structType.getFieldDeclarationList()) {
                GoAnonymousFieldDefinition anonymousFieldDefinition = declaration.getAnonymousFieldDefinition();
                if (anonymousFieldDefinition != null) {
                    if (!GoRecursiveTypeInspection.hasRecursiveReference(anonymousFieldDefinition.getType(), targetType, trail, firstFieldInTheCycle, visited, context, allowReference)) continue;
                    firstFieldInTheCycle.set((Object)declaration);
                    return true;
                }
                if (!GoRecursiveTypeInspection.hasRecursiveReference(declaration.getType(), targetType, trail, firstFieldInTheCycle, visited, context, allowReference)) continue;
                firstFieldInTheCycle.set((Object)declaration);
                return true;
            }
            return false;
        }
        if (currentType instanceof GoInterfaceType) {
            GoInterfaceType interfaceType = (GoInterfaceType)currentType;
            for (GoTypeReferenceExpression typeReferenceExpression : interfaceType.getBaseTypesReferences()) {
                if (!GoRecursiveTypeInspection.hasRecursiveReference(typeReferenceExpression, targetType, trail, firstFieldInTheCycle, visited, context, allowReference)) continue;
                return true;
            }
            for (GoConstraintElem constraintElem : interfaceType.getConstraintElemList()) {
                for (GoConstraintTerm constraintTerm : constraintElem.getConstraintTermList()) {
                    if (!GoRecursiveTypeInspection.hasRecursiveReference(constraintTerm.getType(), targetType, trail, firstFieldInTheCycle, visited, context, allowReference)) continue;
                    return true;
                }
            }
            return false;
        }
        if (currentType instanceof GoParType) {
            GoParType parType = (GoParType)currentType;
            return GoRecursiveTypeInspection.hasRecursiveReference(parType.getType(), targetType, trail, firstFieldInTheCycle, visited, context, allowReference);
        }
        GoType underlyingType = currentType.getUnderlyingType(context);
        if (currentType instanceof GoArrayOrSliceType && (arrayOrSliceType = (GoArrayOrSliceType)currentType).isArray()) {
            return GoRecursiveTypeInspection.hasRecursiveReference(((GoArrayOrSliceType)underlyingType).getType(), targetType, trail, firstFieldInTheCycle, visited, context, allowReference);
        }
        if (!allowReference && GoRecursiveTypeInspection.hasRecursiveChildren(currentType, targetType, trail, firstFieldInTheCycle, visited, context)) {
            return true;
        }
        return GoRecursiveTypeInspection.hasRecursiveReference(currentType.getTypeReferenceExpression(), targetType, trail, firstFieldInTheCycle, visited, context, allowReference);
    }

    private static boolean isAlias(@NotNull GoSpecType specType) {
        GoTypeSpec typeSpec;
        if (specType == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(10);
        }
        return (typeSpec = specType.getTypeSpec()) != null ? typeSpec.isTypeAlias() : specType.getAssign() != null;
    }

    private static boolean hasRecursiveChildren(@NotNull GoType currentType, @NotNull GoType targetType, @NotNull Stack<String> trail, @NotNull Ref<GoFieldDeclaration> firstFieldInTheCycle, @NotNull Set<GoType> visited, @NotNull ResolveState context) {
        if (currentType == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(11);
        }
        if (targetType == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(12);
        }
        if (trail == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(13);
        }
        if (firstFieldInTheCycle == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(14);
        }
        if (visited == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(16);
        }
        ArrayDeque q = new ArrayDeque(PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)currentType, PsiElement.class));
        while (!q.isEmpty()) {
            GoType type;
            PsiElement element = (PsiElement)q.poll();
            if (element instanceof GoType && GoRecursiveTypeInspection.hasRecursiveReference(type = (GoType)element, targetType, trail, firstFieldInTheCycle, visited, context, false)) {
                return true;
            }
            q.addAll(PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)element, PsiElement.class));
        }
        return false;
    }

    private static boolean pushTypeName(@NotNull Stack<String> stack, @NotNull GoType type) {
        String typeName;
        GoTypeSpec goTypeSpec;
        if (stack == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(17);
        }
        if (type == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(18);
        }
        if (type instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)type;
            goTypeSpec = specType.getTypeSpec();
        } else {
            goTypeSpec = null;
        }
        GoTypeSpec typeSpec = goTypeSpec;
        String string = typeName = typeSpec != null ? typeSpec.getName() : null;
        if (typeName != null) {
            stack.push((Object)typeName);
            return true;
        }
        return false;
    }

    private static boolean hasRecursiveReference(@Nullable GoTypeReferenceExpression typeReferenceExpression, @NotNull GoType targetType, @NotNull Stack<String> trail, @NotNull Ref<GoFieldDeclaration> firstFieldInTheCycle, @NotNull Set<GoType> visited, @NotNull ResolveState context, boolean allowPointer) {
        if (targetType == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(19);
        }
        if (trail == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(20);
        }
        if (firstFieldInTheCycle == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(21);
        }
        if (visited == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(22);
        }
        if (context == null) {
            GoRecursiveTypeInspection.$$$reportNull$$$0(23);
        }
        GoType type = typeReferenceExpression != null ? typeReferenceExpression.resolveType(context) : null;
        return type != null && GoRecursiveTypeInspection.hasRecursiveReference(type, targetType, trail, firstFieldInTheCycle, visited, context, allowPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 9: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 6: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trail";
                break;
            }
            case 7: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstFieldInTheCycle";
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoRecursiveTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeSpec";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkHasRecursiveReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRecursiveReference";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isAlias";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRecursiveChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "pushTypeName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoReplaceFieldTypeWithPointerQuickFix
    extends LocalQuickFixOnPsiElement {
        private GoReplaceFieldTypeWithPointerQuickFix(@NotNull GoFieldDeclaration fieldDeclaration) {
            if (fieldDeclaration == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)fieldDeclaration);
        }

        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.replace.field.type.with.pointer.family.name", (Object[])new Object[0]);
            if (string == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            PsiElement psiElement = this.getStartElement();
            if (psiElement instanceof GoFieldDeclaration) {
                GoFieldDeclaration fieldDeclaration = (GoFieldDeclaration)psiElement;
                List<GoFieldDefinition> fieldDefList = fieldDeclaration.getFieldDefinitionList();
                GoAnonymousFieldDefinition anonFieldDef = fieldDeclaration.getAnonymousFieldDefinition();
                int fieldCount = anonFieldDef != null ? 1 : fieldDefList.size();
                String name = anonFieldDef != null ? StringUtil.notNullize((String)anonFieldDef.getName()) : StringUtil.join(fieldDefList, fieldDef -> StringUtil.notNullize((String)fieldDef.getName()), (String)", ");
                String string = GoBundle.message((String)"go.fix.replace.field.type.with.pointer", (Object[])new Object[]{fieldCount, name});
                if (string == null) {
                    GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.getFamilyName();
            if (string == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            GoType type;
            if (project == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(5);
            }
            if (startElement == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(6);
            }
            if (endElement == null) {
                GoReplaceFieldTypeWithPointerQuickFix.$$$reportNull$$$0(7);
            }
            if (!(startElement instanceof GoFieldDeclaration)) {
                return;
            }
            GoFieldDeclaration fieldDeclaration = (GoFieldDeclaration)startElement;
            GoAnonymousFieldDefinition anonFieldDef = fieldDeclaration.getAnonymousFieldDefinition();
            GoType goType = type = anonFieldDef != null ? anonFieldDef.getType() : fieldDeclaration.getType();
            if (type == null) {
                return;
            }
            type.replace(GoElementFactory.createType(project, "*" + type.getText(), null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldDeclaration";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoRecursiveTypeInspection$GoReplaceFieldTypeWithPointerQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoRecursiveTypeInspection$GoReplaceFieldTypeWithPointerQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

