/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImport;
import com.goide.codeInsight.imports.GoImportPackageQuickFix;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.unresolved.GoCreateParameterQuickFix;
import com.goide.inspections.unresolved.GoIntroduceConstantFix;
import com.goide.inspections.unresolved.GoIntroduceGlobalConstantFix;
import com.goide.inspections.unresolved.GoIntroduceGlobalVariableFix;
import com.goide.inspections.unresolved.GoIntroduceStructTypeFix;
import com.goide.inspections.unresolved.GoIntroduceTypeFix;
import com.goide.inspections.unresolved.GoIntroduceVariableFix;
import com.goide.inspections.unresolved.GoReplaceAssignmentWithDeclarationQuickFix;
import com.goide.inspections.unresolved.introduceFunctionOrMethod.GoIntroduceFunctionOrMethodFix;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.expectedTypes.GoConditionExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedTypes;
import com.goide.psi.impl.expectedTypes.GoIterableExpectedType;
import com.goide.psi.impl.imports.GoImportPathReference;
import com.goide.quickfix.GoIntroduceFieldQuickFix;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoUnresolvedReferenceInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoUnresolvedReferenceInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitFieldName(@NotNull GoFieldName o) {
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(1);
        }
        super.visitFieldName(o);
        if (o.resolve() == null) {
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
            GoType type = GoPsiImplUtil.getUnwrappedTypeOfLiteralValue(o, context);
            if (GoTypeUtil.isCType(type, context)) {
                return;
            }
            PsiElement id = o.getIdentifier();
            LocalQuickFix[] fixes = type instanceof GoStructType && this.myHolder.isOnTheFly() ? GoInspectionProblemUtil.fixes(new LocalQuickFix[]{new GoIntroduceFieldQuickFix(id)}) : null;
            this.myHolder.registerProblem(id, GoInspectionProblemUtil.message("go.inspection.unknown.field.message", GoInspectionProblemUtil.REF), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, fixes);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(2);
        }
        super.visitReferenceExpression(o);
        GoResolvable qualifier = o.getResolvableQualifier();
        if (qualifier != null && qualifier.resolve() == null) {
            return;
        }
        PsiElement id = o.getIdentifier();
        if (o.getReference().multiResolve(false).length > 1) {
            this.myHolder.registerProblem(id, GoInspectionProblemUtil.message("go.inspection.ambiguous.reference.message", GoInspectionProblemUtil.REF), new LocalQuickFix[0]);
            return;
        }
        if (o.resolve() == null) {
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
            LocalQuickFix[] fixes = this.calcQuickFixes(o, context);
            this.myHolder.registerProblem(id, GoInspectionProblemUtil.message("go.inspection.unresolved.reference.message", GoInspectionProblemUtil.REF), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, fixes);
        }
    }

    private LocalQuickFix[] calcQuickFixes(@NotNull GoReferenceExpression o, @NotNull PsiElement context) {
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(4);
        }
        if (GoUnresolvedReferenceInspection.hasDotAfter(o)) {
            return GoUnresolvedReferenceInspection.createImportPackageFixes(o, (PsiReference)o.getReference(), this.myHolder.isOnTheFly());
        }
        if (!this.myHolder.isOnTheFly()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)o, (Class[])new Class[]{GoParenthesesExpr.class});
        if (parent == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiElement id = o.getIdentifier();
        String name = id.getText();
        SmartList fixesList = new SmartList();
        if (!(o.getParent() instanceof GoCallExpr) && GoIntroduceFieldQuickFix.findStructByReferenceExpression(o) != null) {
            fixesList.add(new GoIntroduceFieldQuickFix(id));
            if (GoTypeUtil.getExpectedTypes(o, context).containFunctionType(null)) {
                fixesList.add(new GoIntroduceFunctionOrMethodFix.GoIntroduceMethodFix(o, name));
            }
            return fixesList.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        boolean canCreateFunction = GoUnresolvedReferenceInspection.canCreateFunction(o, name, context);
        if (GoUnresolvedReferenceInspection.canCreateMethod(o)) {
            fixesList.add(new GoIntroduceFunctionOrMethodFix.GoIntroduceMethodFix(o, name));
        } else if (canCreateFunction && GoUnresolvedReferenceInspection.hasPackageQualifier(o)) {
            fixesList.add(new GoIntroduceFunctionOrMethodFix.GoIntroduceOtherPackageFunctionFix(o, name));
        }
        if (o.getQualifier() != null) {
            return fixesList.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        if (canCreateFunction) {
            fixesList.add(new GoIntroduceFunctionOrMethodFix.GoIntroduceSamePackageFunctionFix(o, name));
        }
        fixesList.add(new GoIntroduceGlobalVariableFix(id, name));
        boolean canBeLocal = PsiTreeUtil.getParentOfType((PsiElement)o, GoBlock.class) != null;
        boolean parentIsCall = parent instanceof GoCallExpr;
        if (canBeLocal) {
            fixesList.add(new GoIntroduceVariableFix(id, name));
        }
        if (GoUnresolvedReferenceInspection.expectedTypeCanBeConstant(o, context) && !parentIsCall && o.getReadWriteAccess() == ReadWriteAccessDetector.Access.Read) {
            fixesList.add(new GoIntroduceGlobalConstantFix(id, name));
            if (canBeLocal) {
                fixesList.add(new GoIntroduceConstantFix(id, name));
            }
        } else if (canBeLocal) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof GoAssignmentStatement) {
                fixesList.add(new GoReplaceAssignmentWithDeclarationQuickFix(grandParent));
            } else if (parent instanceof GoRangeClause || parent instanceof GoRecvStatement) {
                fixesList.add(new GoReplaceAssignmentWithDeclarationQuickFix(parent));
            }
        }
        if (GoUnresolvedReferenceInspection.shouldShowCreateParameterQuickFix(o)) {
            fixesList.add(new GoCreateParameterQuickFix(o, o.getText()));
        }
        return fixesList.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static boolean shouldShowCreateParameterQuickFix(@NotNull GoReferenceExpression referenceExpression) {
        GoFunctionOrMethodDeclaration decl;
        PsiElement parent;
        if (referenceExpression == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(5);
        }
        if ((parent = referenceExpression.getParent()) instanceof GoIndexOrSliceExpr) {
            GoIndexOrSliceExpr indexOrSliceExpr = (GoIndexOrSliceExpr)parent;
            if (indexOrSliceExpr.getType() instanceof GoTypeList) {
                return false;
            }
            if (indexOrSliceExpr.isIndexExpression()) {
                GoExpression firstIndex = (GoExpression)indexOrSliceExpr.getIndices().first;
                if (firstIndex == null) {
                    return false;
                }
                GoType type = firstIndex.getGoType(null);
                if (type instanceof GoSpecType || type instanceof GoTypeParameter) {
                    return false;
                }
                return type == null || type.getTypeArguments() == null;
            }
        }
        if ((decl = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, GoFunctionOrMethodDeclaration.class)) == null) {
            return false;
        }
        if (decl.getName() == null) {
            return false;
        }
        return !GoPsiUtil.isMainOrInitFunction(decl);
    }

    private static boolean expectedTypeCanBeConstant(@NotNull GoReferenceExpression o, @NotNull PsiElement context) {
        GoExpectedTypes types;
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(7);
        }
        if ((types = GoTypeUtil.getExpectedTypes(o, context)).areEmpty()) {
            return true;
        }
        for (GoExpectedType type : types.asList()) {
            if (type instanceof GoConditionExpectedType || type instanceof GoIterableExpectedType) {
                return true;
            }
            GoType goType = type.getType();
            if (!(goType instanceof GoInterfaceType) && !GoTypeUtil.isConstantType(goType, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean canCreateMethod(@NotNull GoReferenceExpression o) {
        GoType type;
        PsiElement parent;
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(8);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(parent = o.getParent()), GoConstDeclaration.class) != null) {
            return false;
        }
        GoExpression expression = o.getExpressionQualifier();
        GoType goType = type = expression != null ? GoPsiImplUtil.unwrapPointerIfNeeded(expression.getGoType(null)) : null;
        if (type instanceof GoLightType.LightVoidType) {
            return false;
        }
        return GoTypeUtil.isNamedType(type) && !GoPsiImplUtil.builtin(type.resolve(expression));
    }

    private static boolean canCreateFunction(@NotNull GoReferenceExpression o, @NotNull String name, @NotNull PsiElement context) {
        boolean outsideOfConstDeclaration;
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(9);
        }
        if (name == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(11);
        }
        PsiElement parent = o.getParent();
        boolean parentIsCallExpr = parent instanceof GoCallExpr;
        boolean bl = outsideOfConstDeclaration = PsiTreeUtil.getParentOfType((PsiElement)o, GoConstDeclaration.class) == null;
        if (parentIsCallExpr && outsideOfConstDeclaration && !"init".equals(name)) {
            return true;
        }
        return !(parent instanceof GoLeftHandExprList) && GoTypeUtil.getExpectedTypes(o, context).containFunctionType(null);
    }

    private static boolean hasPackageQualifier(@NotNull GoReferenceExpression expr) {
        if (expr == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(12);
        }
        return GoPsiUtil.getPackageQualifier(expr) != null;
    }

    @Override
    public void visitImportSpec(@NotNull GoImportSpec importSpec) {
        if (importSpec == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(13);
        }
        if (importSpec.isCImport()) {
            return;
        }
        if (importSpec.getTextLength() < 2) {
            return;
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(importSpec);
        Collection<GoPackage> resolvedPackages = importSpec.resolve(GoPsiImplUtil.createContextOnElement(context));
        if (!resolvedPackages.isEmpty()) {
            return;
        }
        PsiReference[] references = importSpec.getReferences();
        for (int i = references.length - 1; i >= 0; --i) {
            PsiReference reference = references[i];
            if (!(reference instanceof GoImportPathReference) || reference.resolve() != null) continue;
            this.reportUnresolvedImportReference(reference);
        }
    }

    private void reportUnresolvedImportReference(@NotNull PsiReference reference) {
        if (reference == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(14);
        }
        ProblemHighlightType type = reference.getRangeInElement().isEmpty() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        String unresolvedReferenceMessage = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
        this.myHolder.registerProblem(reference, unresolvedReferenceMessage, type);
    }

    @Override
    public void visitLabelRef(@NotNull GoLabelRef o) {
        PsiReference reference;
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(15);
        }
        if ((reference = o.getReference()).resolve() == null) {
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.unresolved.label.message", GoInspectionProblemUtil.REF), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression o) {
        PsiElement qualifierResolve;
        if (o == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(16);
        }
        super.visitTypeReferenceExpression(o);
        PsiReference reference = o.getReference();
        GoTypeReferenceExpression qualifier = (GoTypeReferenceExpression)o.getQualifierAs(GoTypeReferenceExpression.class);
        PsiElement psiElement = qualifierResolve = qualifier != null ? qualifier.resolve() : null;
        if (qualifier != null && qualifierResolve == null) {
            return;
        }
        if (reference.resolve() == null) {
            PsiElement id = o.getIdentifier();
            String name = id.getText();
            LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
            if (GoUnresolvedReferenceInspection.hasDotAfter(o)) {
                fixes = GoUnresolvedReferenceInspection.createImportPackageFixes(o, reference, this.myHolder.isOnTheFly());
            } else if (qualifier == null && this.myHolder.isOnTheFly()) {
                fixes = GoInspectionProblemUtil.fixes(new LocalQuickFix[]{o.getParent() instanceof GoCompositeLit ? new GoIntroduceStructTypeFix(id, name) : new GoIntroduceTypeFix(id, name)});
            }
            this.myHolder.registerProblem(id, GoInspectionProblemUtil.message("go.inspection.unresolved.type.message", GoInspectionProblemUtil.REF), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, fixes);
        }
    }

    private static LocalQuickFix @NotNull [] createImportPackageFixes(@NotNull PsiElement target, @NotNull PsiReference reference, boolean onTheFly) {
        if (target == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(17);
        }
        if (reference == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(18);
        }
        if (onTheFly) {
            GoImportPackageQuickFix importFix = new GoImportPackageQuickFix(reference);
            if (importFix.isAvailable(target.getProject(), target.getContainingFile(), target, target)) {
                LocalQuickFix[] localQuickFixArray = GoInspectionProblemUtil.fixes(new LocalQuickFix[]{importFix});
                if (localQuickFixArray == null) {
                    GoUnresolvedReferenceInspection.$$$reportNull$$$0(19);
                }
                return localQuickFixArray;
            }
        } else {
            List<GoImport> packagesToImport = GoImportPackageQuickFix.getImportPathVariantsToImport(reference.getCanonicalText(), target);
            if (!packagesToImport.isEmpty()) {
                ArrayList<GoImportPackageQuickFix> result = new ArrayList<GoImportPackageQuickFix>();
                for (GoImport goImport : packagesToImport) {
                    GoImportPackageQuickFix importFix = new GoImportPackageQuickFix(target, goImport.getImportPath(), goImport.getAlias(), GoImportPackageQuickFix.canChangeFileSilently(target));
                    if (!importFix.isAvailable(target.getProject(), target.getContainingFile(), target, target)) continue;
                    result.add(importFix);
                }
                LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
                if (localQuickFixArray == null) {
                    GoUnresolvedReferenceInspection.$$$reportNull$$$0(20);
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(21);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static boolean hasDotAfter(@NotNull PsiElement element) {
        ASTNode next;
        if (element == null) {
            GoUnresolvedReferenceInspection.$$$reportNull$$$0(22);
        }
        return (next = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)element.getNode())) != null && next.getElementType() == GoTypes.DOT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoUnresolvedReferenceInspection";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoUnresolvedReferenceInspection";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportPackageFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitFieldName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcQuickFixes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowCreateParameterQuickFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expectedTypeCanBeConstant";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canCreateMethod";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFunction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasPackageQualifier";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitImportSpec";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedImportReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitLabelRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeReferenceExpression";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createImportPackageFixes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasDotAfter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

