/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoKey;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

public final class GoDeprecationInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoDeprecationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoDeprecationInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitNamedElement(@NotNull GoNamedElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o.isPublic() && !GoInspectionUtil.isCheapEnoughToSearch(o)) {
                    return;
                }
                PsiElement identifier = o.getIdentifier();
                if (identifier != null && o.isDeprecated() && !1.isUnused(o)) {
                    String elementType = UsageViewUtil.getType((PsiElement)o);
                    GoInspectionMessage message = GoDeprecationInspection.message("go.inspection.problem.deprecated.is.still.used", new Object[]{elementType});
                    holder.registerProblem(identifier, message, new LocalQuickFix[0]);
                }
            }

            private static boolean isUnused(@NotNull GoNamedElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                return o instanceof GoFunctionDeclaration ? GoInspectionUtil.isUnused((GoFunctionDeclaration)o) : GoReferencesSearch.search(o).findFirst() == null;
            }

            @Override
            public void visitKey(@NotNull GoKey o) {
                PsiElement element;
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitKey(o);
                GoFieldName name = o.getFieldName();
                PsiReference reference = name != null ? name.getReference() : null;
                PsiElement psiElement = element = reference != null ? reference.resolve() : null;
                if (element instanceof GoNamedElement && ((GoNamedElement)element).isDeprecated()) {
                    holder.registerProblem((PsiElement)o, GoDeprecationInspection.message("go.inspection.problem.reference.is.deprecated", new Object[]{REF}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.checkReferenceExpression(o);
            }

            @Override
            public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.checkReferenceExpression(o);
            }

            private void checkReferenceExpression(@NotNull GoReferenceExpressionBase o) {
                PsiElement resolve;
                if (o == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((resolve = o.resolve()) instanceof GoNamedElement && ((GoNamedElement)resolve).isDeprecated()) {
                    holder.registerProblem(o.getIdentifier(), GoDeprecationInspection.message("go.inspection.problem.reference.is.deprecated", new Object[]{REF}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/inspections/GoDeprecationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNamedElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUnused";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKey";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeReferenceExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoDeprecationInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

