/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoConstants;
import com.goide.GoFileType;
import com.goide.GoPluginDisposable;
import com.goide.i18n.GoBundle;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoFileTooBigNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    GoFileTooBigNotificationProvider(final @NotNull Project project) {
        if (project == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(0);
        }
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            if (project.isDisposed()) {
                return null;
            }
            HashSet openFiles = ContainerUtil.newHashSet((Object[])FileEditorManager.getInstance((Project)project).getSelectedFiles());
            final HashSet<VirtualFile> filesToUpdate = new HashSet<VirtualFile>();
            for (VFileEvent event : events) {
                ProgressManager.checkCanceled();
                VirtualFile file = event.getFile();
                if (file == null || !openFiles.contains(file)) continue;
                filesToUpdate.add(file);
            }
            return filesToUpdate.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    if (!project.isDisposed()) {
                        for (VirtualFile file : filesToUpdate) {
                            EditorNotifications.getInstance((Project)project).updateNotifications(file);
                        }
                    }
                }
            };
        }, GoPluginDisposable.getInstance(project));
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(2);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)GoFileType.INSTANCE)) {
            return null;
        }
        String codeInsightMessage = GoFileTooBigNotificationProvider.fileLimitErrorMessage(file, GoConstants.GO_FILE_INTELLISENSE_LIMIT, GoBundle.message((String)"go.notification.code.insight.features.are.disabled.text", (Object[])new Object[0]));
        if (codeInsightMessage != null) {
            return fileEditor -> GoFileTooBigNotificationProvider.createNotificationPanel(fileEditor, codeInsightMessage);
        }
        if (GoFileTooBigNotificationProvider.enabledForceHighlighting(file, project)) {
            return null;
        }
        String inspectionsMessage = GoFileTooBigNotificationProvider.fileLimitErrorMessage(file, PersistentFSConstants.getMaxIntellisenseFileSize(), GoBundle.message((String)"go.notification.inspections.are.disabled.text", (Object[])new Object[0]));
        if (inspectionsMessage == null) {
            return null;
        }
        return fileEditor -> GoFileTooBigNotificationProvider.createNotificationPanel(project, fileEditor, file, inspectionsMessage);
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createNotificationPanel(@NotNull FileEditor fileEditor, @NotNull @Nls String message) {
        if (fileEditor == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(3);
        }
        if (message == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(message);
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(5);
        }
        return editorNotificationPanel;
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createNotificationPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull VirtualFile file, @NotNull @Nls String message) {
        if (project == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(6);
        }
        if (fileEditor == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(8);
        }
        if (message == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel2 = GoFileTooBigNotificationProvider.createNotificationPanel(fileEditor, message);
        panel2.createActionLabel(GoBundle.message((String)"go.notification.inspections.are.disabled.enabled.action.text", (Object[])new Object[0]), () -> {
            PsiFile psiFile;
            if (!project.isDisposed() && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)psiFile, (FileHighlightingSetting)FileHighlightingSetting.FORCE_HIGHLIGHTING);
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
            }
        });
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(10);
        }
        return editorNotificationPanel;
    }

    private static boolean enabledForceHighlighting(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(12);
        }
        PsiFile psiFile = !project.isDisposed() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        return psiFile != null && HighlightingSettingsPerFile.getInstance((Project)project).getHighlightingSettingForRoot((PsiElement)psiFile) == FileHighlightingSetting.FORCE_HIGHLIGHTING;
    }

    @Nullable
    @Nls
    private static String fileLimitErrorMessage(@NotNull VirtualFile file, int limit, @NotNull @Nls String message) {
        if (file == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(13);
        }
        if (message == null) {
            GoFileTooBigNotificationProvider.$$$reportNull$$$0(14);
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)limit) ? GoBundle.message((String)"go.notification.file.exceeds.size.limit.text", (Object[])new Object[]{StringUtil.formatFileSize((long)file.getLength()), StringUtil.formatFileSize((long)limit), message}) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 4: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoFileTooBigNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoFileTooBigNotificationProvider";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "enabledForceHighlighting";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fileLimitErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10 -> new IllegalStateException(string);
        };
    }
}

