/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoParType;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoType;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoUnwrapParensQuickFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import java.util.Iterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRedundantParensInspection
extends GoInspectionBase
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoRedundantParensInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoRedundantParensInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(o -> holder.registerProblem((PsiElement)o, GoRedundantParensInspection.message("go.inspection.problem.redundant.parentheses"), new LocalQuickFix[]{new GoUnwrapParensQuickFix((PsiElement)o)}));
    }

    private static boolean parensAreRedundant(@NotNull GoParType parType) {
        boolean isTopmost;
        if (parType == null) {
            GoRedundantParensInspection.$$$reportNull$$$0(2);
        }
        if (parType.getParent() instanceof GoConversionExpr) {
            return false;
        }
        boolean bl = isTopmost = !(parType.getParent() instanceof GoParType) || parType.getParent().getParent() instanceof GoConversionExpr;
        if (!isTopmost) {
            return false;
        }
        GoType actualType = parType.getType();
        if (actualType instanceof GoChannelType) {
            return !(parType.getParent() instanceof GoChannelType);
        }
        return !(actualType instanceof GoPointerType) || !GoPsiUtil.isMethodExpressionQualifier(parType);
    }

    @NotNull
    public static PsiElement stripParens(@NotNull PsiElement element) {
        GoExpression expression;
        if (element == null) {
            GoRedundantParensInspection.$$$reportNull$$$0(3);
        }
        if (element instanceof GoParenthesesExpr && (expression = ((GoParenthesesExpr)element).getExpression()) != null) {
            PsiElement node2;
            boolean strip = true;
            Iterator iterator = ((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)expression)).preOrderDfsTraversal().iterator();
            while (iterator.hasNext() && !((node2 = (PsiElement)iterator.next()) instanceof GoParenthesesExpr)) {
                if (!(node2 instanceof GoCompositeLit)) continue;
                if (((GoCompositeLit)node2).getTypeReferenceExpression() == null && !GoTypeUtil.isNamedType(((GoCompositeLit)node2).getType())) break;
                strip = false;
                break;
            }
            if (strip) {
                return GoRedundantParensInspection.stripParens(expression);
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            GoRedundantParensInspection.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoRedundantParensInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoRedundantParensInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stripParens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parensAreRedundant";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stripParens";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static class Visitor
    extends GoVisitor {
        @NotNull
        private final Consumer<? super PsiElement> problemConsumer;

        public Visitor(@NotNull Consumer<? super PsiElement> problemConsumer) {
            if (problemConsumer == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.problemConsumer = problemConsumer;
        }

        @Override
        public void visitParenthesesExpr(@NotNull GoParenthesesExpr o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (Visitor.expressionParensAreRedundant(o) && !Visitor.expressionParensAreRedundant(o.getParent())) {
                this.problemConsumer.accept(o);
            }
        }

        @Override
        public void visitParType(@NotNull GoParType parType) {
            if (parType == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitParType(parType);
            if (GoRedundantParensInspection.parensAreRedundant(parType)) {
                this.problemConsumer.accept(parType);
            }
        }

        private static boolean expressionParensAreRedundant(@Nullable PsiElement o) {
            if (!(o instanceof GoParenthesesExpr)) {
                return false;
            }
            PsiElement parent = o.getParent();
            if (parent instanceof GoParenthesesExpr) {
                return true;
            }
            if (GoPsiUtil.isMethodExpressionQualifier(o)) {
                GoExpression innerExpr = ((GoParenthesesExpr)o).getExpression();
                return !(innerExpr instanceof GoUnaryExpr) || ((GoUnaryExpr)innerExpr).getMul() == null;
            }
            if (parent instanceof GoExpression) {
                return false;
            }
            if (GoPsiUtil.isInControlElementHeader(o)) {
                return GoRedundantParensInspection.stripParens(o) != o;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemConsumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parType";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/GoRedundantParensInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesesExpr";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

