/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.GoExcludedFunctionsAndMethodsSettings;
import com.goide.inspections.GoMethodDescriptors;
import com.goide.inspections.GoUnusedCallResultInspection;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoExcludeFromUnhandledInspectionQuickFix;
import com.goide.quickfix.GoHandleErrorFix;
import com.goide.quickfix.GoIgnoreExplicitlyQuickFix;
import com.goide.quickfix.GoIgnoreExplicitlyWithClosureQuickFix;
import com.goide.quickfix.GoWrapErrorHandlingInClosureQuickFix;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GoUnhandledErrorResultInspection
extends GoInspectionBase {
    private static final Set<String> DEFAULT_EXCLUDED_FUNCTIONS = Set.of("fmt.Errorf", "fmt.Print", "fmt.Printf", "fmt.Println", "math/rand.Read", "errors.Unwrap", "errors.New", "errors.Join");
    private static final GoMethodDescriptors DEFAULT_EXCLUDED_METHODS = GoUnhandledErrorResultInspection.defaults(Set.of("(*bytes.Buffer).Write", "(*bytes.Buffer).WriteByte", "(*bytes.Buffer).WriteRune", "(*bytes.Buffer).WriteString", "(*math/rand.Rand).Read", "(*strings.Builder).Write", "(*strings.Builder).WriteByte", "(*strings.Builder).WriteRune", "(*strings.Builder).WriteString", "(hash.Hash).Write"));
    private final GoExcludedFunctionsAndMethodsSettings myExcludedSettings = new GoExcludedFunctionsAndMethodsSettings(DEFAULT_EXCLUDED_FUNCTIONS, DEFAULT_EXCLUDED_METHODS);

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr callExpression) {
                GoNamedSignatureOwner signatureOwner;
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(callExpression);
                if (!GoUnusedCallResultInspection.isCallWithUnusedResult(callExpression)) {
                    return;
                }
                List<GoType> resultTypes = GoTypeUtil.getListOfTypesFromTypeList(callExpression.getGoType(null));
                if (!ContainerUtil.or(resultTypes, type -> GoStdlibUtil.implementsError(type, callExpression))) {
                    return;
                }
                GoReferenceExpression ref = GoPsiUtil.getCallReference(callExpression);
                if (ref != null && (signatureOwner = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)ref.resolve(), GoNamedSignatureOwner.class)) != null && GoUnhandledErrorResultInspection.this.myExcludedSettings.isExcluded(callExpression, signatureOwner)) {
                    return;
                }
                holder.registerProblem((PsiElement)callExpression, GoUnhandledErrorResultInspection.message("go.inspection.problem.unhandled.error"), GoUnhandledErrorResultInspection.fixes(callExpression));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/goide/inspections/GoUnhandledErrorResultInspection$1", "visitCallExpr"));
            }
        };
    }

    @NotNull
    private static GoMethodDescriptors defaults(@NotNull Set<String> methodDescriptors) {
        if (methodDescriptors == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(2);
        }
        GoMethodDescriptors specialMethods = new GoMethodDescriptors();
        methodDescriptors.forEach(methodDescriptor -> GoExcludedFunctionsAndMethodsSettings.add(specialMethods, methodDescriptor));
        GoMethodDescriptors goMethodDescriptors = specialMethods;
        if (goMethodDescriptors == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(3);
        }
        return goMethodDescriptors;
    }

    public void exclude(@NotNull GoCallExpr callExpression, @NotNull GoNamedSignatureOwner signatureOwner) {
        if (callExpression == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(4);
        }
        if (signatureOwner == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(5);
        }
        this.myExcludedSettings.exclude(callExpression, signatureOwner);
    }

    public static LocalQuickFix @NotNull [] fixes(@NotNull GoCallExpr callExpression) {
        if (callExpression == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(6);
        }
        if (GoUnusedCallResultInspection.isInsideDeferOrGoStatement(callExpression)) {
            LocalQuickFix[] localQuickFixArray = GoUnhandledErrorResultInspection.fixes(new LocalQuickFix[]{new GoIgnoreExplicitlyWithClosureQuickFix(callExpression), new GoWrapErrorHandlingInClosureQuickFix(callExpression), new GoExcludeFromUnhandledInspectionQuickFix(callExpression)});
            if (localQuickFixArray == null) {
                GoUnhandledErrorResultInspection.$$$reportNull$$$0(7);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = GoUnhandledErrorResultInspection.fixes(new LocalQuickFix[]{new GoHandleErrorFix(callExpression), new GoIgnoreExplicitlyQuickFix(callExpression), new GoExcludeFromUnhandledInspectionQuickFix(callExpression)});
        if (localQuickFixArray == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(8);
        }
        return localQuickFixArray;
    }

    public void readSettings(@NotNull Element node2) throws InvalidDataException {
        if (node2 == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(9);
        }
        this.myExcludedSettings.readSettings(node2);
    }

    public void writeSettings(@NotNull Element node2) throws WriteExternalException {
        if (node2 == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(10);
        }
        this.myExcludedSettings.writeSettings(node2);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = this.myExcludedSettings.getOptionsPane("myExcludedSettings");
        if (optPane == null) {
            GoUnhandledErrorResultInspection.$$$reportNull$$$0(11);
        }
        return optPane;
    }

    @TestOnly
    public void excludeMethods(String ... methods) {
        this.myExcludedSettings.excludeMethods(methods);
    }

    @TestOnly
    public void excludeFunctions(String ... functions) {
        this.myExcludedSettings.excludeFunctions(functions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDescriptors";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoUnhandledErrorResultInspection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoUnhandledErrorResultInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defaults";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fixes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "defaults";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 11 -> new IllegalStateException(string);
        };
    }
}

