/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoLanguage;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoFile;
import com.goide.psi.GoVisitor;
import com.goide.util.GoImportsSorter;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GoUnsortedImportInspection
extends GoInspectionBase
implements CleanupLocalInspectionTool {
    @Override
    protected boolean isEnabledOnFile(@NotNull GoFile file) {
        if (file == null) {
            GoUnsortedImportInspection.$$$reportNull$$$0(0);
        }
        return !(file instanceof GoCodeFragment) && super.isEnabledOnFile(file);
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder problemsHolder, @NotNull LocalInspectionToolSession session) {
        if (problemsHolder == null) {
            GoUnsortedImportInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            GoUnsortedImportInspection.$$$reportNull$$$0(2);
        }
        return new GoVisitor(){

            @Override
            public void visitGoFile(@NotNull GoFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                GoImportsSorter sorter = GoImportsSorter.forFile(file);
                for (PsiElement psiElement : sorter.getUnsortedElements()) {
                    problemsHolder.registerProblem(psiElement, GoUnsortedImportInspection.message("go.inspection.problem.imports.are.not.sorted"), new GoSortImportsQuickFix(), new GoChangeImportSortSettingsQuickFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/goide/inspections/GoUnsortedImportInspection$1", "visitGoFile"));
            }
        };
    }

    public static void openImportCodeStyleSettings(@NotNull Project project) {
        if (project == null) {
            GoUnsortedImportInspection.$$$reportNull$$$0(3);
        }
        String goCodeStyleId = CodeStyleSettings.generateConfigurableIdByLanguage((Language)GoLanguage.INSTANCE);
        ApplicationManager.getApplication().invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(project, it -> {
            CodeStyleConfigurableWrapper wrapper = (CodeStyleConfigurableWrapper)ObjectUtils.tryCast((Object)it, CodeStyleConfigurableWrapper.class);
            return goCodeStyleId.equals(wrapper != null ? wrapper.getId() : null);
        }, configurable -> {
            CodeStyleConfigurableWrapper wrapper = (CodeStyleConfigurableWrapper)ObjectUtils.tryCast((Object)configurable, CodeStyleConfigurableWrapper.class);
            if (wrapper != null) {
                wrapper.selectTab(GoBundle.message((String)"go.fmt.imports.tab.title", (Object[])new Object[0]));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoUnsortedImportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openImportCodeStyleSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoChangeImportSortSettingsQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        private GoChangeImportSortSettingsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.change.import.sorting.settings.name", (Object[])new Object[0]);
            if (string == null) {
                GoChangeImportSortSettingsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                GoChangeImportSortSettingsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoChangeImportSortSettingsQuickFix.$$$reportNull$$$0(2);
            }
            GoUnsortedImportInspection.openImportCodeStyleSettings(project);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                GoChangeImportSortSettingsQuickFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                GoChangeImportSortSettingsQuickFix.$$$reportNull$$$0(4);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                GoChangeImportSortSettingsQuickFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoUnsortedImportInspection$GoChangeImportSortSettingsQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoUnsortedImportInspection$GoChangeImportSortSettingsQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class GoSortImportsQuickFix
    implements LocalQuickFix {
        private GoSortImportsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.sort.imports", (Object[])new Object[0]);
            if (string == null) {
                GoSortImportsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            GoImportsSorter sorter;
            PsiFile file;
            if (project == null) {
                GoSortImportsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoSortImportsQuickFix.$$$reportNull$$$0(2);
            }
            if ((file = descriptor.getStartElement().getContainingFile()) instanceof GoFile && !(sorter = GoImportsSorter.forFile((GoFile)file)).getUnsortedElements().isEmpty()) {
                sorter.sortImports();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoUnsortedImportInspection$GoSortImportsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoUnsortedImportInspection$GoSortImportsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

