/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.godebug;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoPlaceBeforePackageQuickFix;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/goide/inspections/godebug/GoDebugDirectiveInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "isEnabledOnFile", "", "file", "Lcom/goide/psi/GoFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkDefinedInMainOrTestPackage", "", "packageElement", "Lcom/goide/psi/GoPackageClause;", "comment", "Lcom/intellij/psi/PsiComment;", "checkPlacedBeforePackage", "isGoDebugSupportedBySdk", "context", "Lcom/intellij/psi/PsiElement;", "intellij.go.impl"})
public final class GoDebugDirectiveInspection
extends GoInspectionBase {
    @Override
    protected boolean isEnabledOnFile(@NotNull GoFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        return this.isGoDebugSupportedBySdk((PsiElement)file) && super.isEnabledOnFile(file);
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoDebugDirectiveInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitComment(PsiComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                super.visitComment(comment);
                if (GoPsiUtil.isGoDebugDirective((PsiElement)comment)) {
                    PsiFile psiFile = comment.getContainingFile();
                    GoFile goFile = psiFile instanceof GoFile ? (GoFile)psiFile : null;
                    if (goFile == null) {
                        return;
                    }
                    GoFile goFile2 = goFile;
                    GoPackageClause goPackageClause = goFile2.getPackage();
                    if (goPackageClause == null) {
                        return;
                    }
                    GoPackageClause packageElement = goPackageClause;
                    GoDebugDirectiveInspection.access$checkPlacedBeforePackage(this.this$0, comment, packageElement, this.$holder);
                    GoDebugDirectiveInspection.access$checkDefinedInMainOrTestPackage(this.this$0, packageElement, this.$holder, comment);
                }
            }
        };
    }

    private final void checkDefinedInMainOrTestPackage(GoPackageClause packageElement, GoProblemsHolder holder, PsiComment comment) {
        String string = packageElement.getName();
        if (string == null) {
            return;
        }
        String packageName = string;
        if (!Intrinsics.areEqual((Object)packageName, (Object)"main") && !StringsKt.endsWith$default((String)packageName, (String)"_test", (boolean)false, (int)2, null)) {
            holder.registerProblem((PsiElement)comment, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.go.debug.not.in.main.or.test.package"), new LocalQuickFix[0]);
        }
    }

    private final void checkPlacedBeforePackage(PsiComment comment, GoPackageClause packageElement, GoProblemsHolder holder) {
        if (PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)comment)) > PsiTreeUtilKt.getStartOffset((PsiElement)packageElement)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GoPlaceBeforePackageQuickFix((PsiElement)comment, "go:debug")};
            holder.registerProblem((PsiElement)comment, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.go.debug.after.package"), localQuickFixArray);
        }
    }

    private final boolean isGoDebugSupportedBySdk(PsiElement context) {
        return GoSdkService.getInstance(context.getProject()).getSdk(GoUtil.module(context)).supportsGoDebugDirectiveInComments();
    }

    public static final /* synthetic */ void access$checkPlacedBeforePackage(GoDebugDirectiveInspection $this, PsiComment comment, GoPackageClause packageElement, GoProblemsHolder holder) {
        $this.checkPlacedBeforePackage(comment, packageElement, holder);
    }

    public static final /* synthetic */ void access$checkDefinedInMainOrTestPackage(GoDebugDirectiveInspection $this, GoPackageClause packageElement, GoProblemsHolder holder, PsiComment comment) {
        $this.checkDefinedInMainOrTestPackage(packageElement, holder, comment);
    }
}

