/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.godebug;

import com.goide.inspections.godebug.GoDebugLanguage;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/goide/inspections/godebug/GoDebugLanguageInjector;", "Lcom/intellij/psi/LanguageInjector;", "<init>", "()V", "getLanguagesToInject", "", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "injectionPlacesRegistrar", "Lcom/intellij/psi/InjectedLanguagePlaces;", "isCommentBeforeMainOrTestPackage", "", "element", "intellij.go.impl"})
public final class GoDebugLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        String text;
        int startOffset;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)injectionPlacesRegistrar, (String)"injectionPlacesRegistrar");
        if (this.isCommentBeforeMainOrTestPackage(host) && GoPsiUtil.isGoDebugDirective((PsiElement)host) && (startOffset = StringUtil.skipWhitespaceForward((CharSequence)(text = host.getText()), (int)11)) < host.getTextLength()) {
            injectionPlacesRegistrar.addPlace((Language)GoDebugLanguage.INSTANCE, TextRange.create((int)startOffset, (int)host.getTextLength()), "", "");
        }
    }

    private final boolean isCommentBeforeMainOrTestPackage(PsiLanguageInjectionHost element) {
        PsiFile psiFile = element.getContainingFile();
        GoFile goFile = psiFile instanceof GoFile ? (GoFile)psiFile : null;
        if (goFile == null) {
            return false;
        }
        GoFile file = goFile;
        GoPackageClause goPackageClause = file.getPackage();
        if (goPackageClause == null) {
            return false;
        }
        GoPackageClause pkg = goPackageClause;
        String string = pkg.getName();
        if (string == null) {
            return false;
        }
        String pkgName = string;
        return PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)element)) < PsiTreeUtilKt.getStartOffset((PsiElement)pkg) && (Intrinsics.areEqual((Object)pkgName, (Object)"main") || StringsKt.endsWith$default((String)pkgName, (String)"_test", (boolean)false, (int)2, null));
    }
}

