/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.imports;

import com.goide.execution.testing.GoTestFinder;
import com.goide.inspections.imports.GoPackageDependenciesGraph;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPackage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0007\u001a\u00020\bH&J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00120\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/goide/inspections/imports/GoPackageGraphBuilder;", "TImport", "", "<init>", "()V", "getAllImportsOfFile", "", "file", "Lcom/goide/psi/GoFile;", "resolve", "Lcom/goide/psi/impl/GoPackage;", "importSpec", "(Ljava/lang/Object;Lcom/goide/psi/GoFile;)Ljava/util/Collection;", "getKey", "import", "(Ljava/lang/Object;)Ljava/lang/Object;", "getAllImportsOfPackage", "", "Lkotlin/Pair;", "pkg", "isPackageInProject", "", "buildPackageGraph", "Lcom/goide/inspections/imports/GoPackageDependenciesGraph;", "sourcePkg", "getRelativeFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoPackageDependenciesGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoPackageDependenciesGraph.kt\ncom/goide/inspections/imports/GoPackageGraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1761#2,3:247\n*S KotlinDebug\n*F\n+ 1 GoPackageDependenciesGraph.kt\ncom/goide/inspections/imports/GoPackageGraphBuilder\n*L\n69#1:247,3\n*E\n"})
public abstract class GoPackageGraphBuilder<TImport> {
    @NotNull
    public abstract Collection<TImport> getAllImportsOfFile(@NotNull GoFile var1);

    @NotNull
    public abstract Collection<GoPackage> resolve(TImport var1, @NotNull GoFile var2);

    @NotNull
    public abstract Object getKey(TImport var1);

    private final List<Pair<GoFile, Collection<TImport>>> getAllImportsOfPackage(GoPackage pkg) {
        List list;
        List $this$getAllImportsOfPackage_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Processor processor2 = arg_0 -> GoPackageGraphBuilder.getAllImportsOfPackage$lambda$2$lambda$0($this$getAllImportsOfPackage_u24lambda_u242, this, arg_0);
        Predicate<VirtualFile> filter = GoPackageGraphBuilder::getAllImportsOfPackage$lambda$2$lambda$1;
        pkg.processFiles((Processor<? super PsiFile>)processor2, filter);
        return CollectionsKt.build((List)list);
    }

    private final boolean isPackageInProject(GoPackage pkg) {
        boolean bl;
        block3: {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)pkg.getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex index = projectFileIndex;
            Set<VirtualFile> set = pkg.getDirectories();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getDirectories(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!index.isInContent(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final GoPackageDependenciesGraph buildPackageGraph(@NotNull GoPackage sourcePkg) {
        Intrinsics.checkNotNullParameter((Object)sourcePkg, (String)"sourcePkg");
        GoPackageDependenciesGraph graph = new GoPackageDependenciesGraph();
        ArrayDeque queue = new ArrayDeque();
        Set pkgsInQueue = new LinkedHashSet();
        KFunction enqueue2 = (KFunction)new Function1<GoPackage, Unit>((Object)queue){

            public final void invoke(GoPackage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ArrayDeque)this.receiver).addLast((Object)p0);
            }
        };
        KFunction dequeue2 = (KFunction)new Function0<GoPackage>((Object)queue){

            public final GoPackage invoke() {
                return (GoPackage)((ArrayDeque)this.receiver).removeFirst();
            }
        };
        ((Function1)enqueue2).invoke((Object)sourcePkg);
        pkgsInQueue.add(sourcePkg);
        while (!((Collection)queue).isEmpty()) {
            ProgressManager.checkCanceled();
            GoPackage currentPkg = (GoPackage)((Function0)dequeue2).invoke();
            List<Pair<GoFile, Collection<TImport>>> allPkgImports = this.getAllImportsOfPackage(currentPkg);
            Set visitedImports = new LinkedHashSet();
            for (Pair<GoFile, Collection<TImport>> pair : allPkgImports) {
                GoFile file = (GoFile)((Object)pair.component1());
                Collection imports = (Collection)pair.component2();
                ProgressManager.checkCanceled();
                for (Object e : imports) {
                    GoPackage pkg;
                    Object importKey = this.getKey(e);
                    if (visitedImports.contains(importKey)) continue;
                    visitedImports.add(importKey);
                    Collection<GoPackage> pkgs = this.resolve(e, file);
                    if (pkgs.size() != 1 || !this.isPackageInProject(pkg = pkgs.iterator().next())) continue;
                    String string = file.getVirtualFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    graph.addDependency(currentPkg, pkg, string);
                }
            }
            List<GoPackage> pkgDependencies = graph.getDependencies(currentPkg);
            for (GoPackage dep : pkgDependencies) {
                if (pkgsInQueue.contains(dep)) continue;
                ((Function1)enqueue2).invoke((Object)dep);
                pkgsInQueue.add(dep);
            }
        }
        return graph;
    }

    private final String getRelativeFilePath(Project project, VirtualFile file) {
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)projectDir);
        }
        return null;
    }

    private static final boolean getAllImportsOfPackage$lambda$2$lambda$0(List $this_buildList, GoPackageGraphBuilder this$0, PsiFile it) {
        if (!(it instanceof GoFile)) {
            return true;
        }
        $this_buildList.add(TuplesKt.to((Object)it, this$0.getAllImportsOfFile((GoFile)it)));
        return true;
    }

    private static final boolean getAllImportsOfPackage$lambda$2$lambda$1(VirtualFile it) {
        return !GoTestFinder.isTestFile(it);
    }
}

