/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.highlighting.legacyErrorInspections.GoRecursiveTypeInspection;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoAddPointerQuickFix;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoVetCopyLockInspection
extends GoInspectionBase {
    private static final Key<GoInterfaceType> SYNC_LOCKER_INTERFACE = Key.create((String)"GO_SYNC_LOCKER_INTERFACE");
    @NonNls
    private static final String LOCKER_INTERFACE_NAME = "Locker";
    @NonNls
    private static final String SYNC_PACKAGE_NAME = "sync";
    @NonNls
    private static final String LEN_FUNCTION_NAME = "len";
    @NonNls
    private static final String CAP_FUNCTION_NAME = "cap";
    @NonNls
    private static final String SIZE_OF_FUNCTION_NAME = "Sizeof";
    @NonNls
    private static final String OFFSET_OF_FUNCTION_NAME = "Offsetof";
    @NonNls
    private static final String FUNC_TOKEN_TEXT = "func";
    @NonNls
    private static final String BLANK_NAME = "_";

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetCopyLockInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetCopyLockInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitAssignmentStatement(@NotNull GoAssignmentStatement assignment) {
                if (assignment == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitAssignmentStatement(assignment);
                this.checkAssignments(assignment.getLeftHandExprList().getExpressionList(), assignment.getExpressionList(), assignment);
            }

            @Override
            public void visitVarSpec(@NotNull GoVarSpec varSpec) {
                if (varSpec == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitVarSpec(varSpec);
                if (varSpec instanceof GoRangeClause) {
                    return;
                }
                this.checkAssignments(varSpec.getVarDefinitionList(), varSpec.getExpressionList(), varSpec);
            }

            @Override
            public void visitForStatement(@NotNull GoForStatement forStatement) {
                PsiElement operator;
                if (forStatement == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitForStatement(forStatement);
                GoRangeClause rangeClause = forStatement.getRangeClause();
                if (rangeClause == null) {
                    return;
                }
                PsiElement varAssign = rangeClause.getVarAssign();
                PsiElement psiElement = operator = varAssign != null ? varAssign : rangeClause.getAssign();
                if (operator == null) {
                    return;
                }
                List<GoTypeOwner> typeOwners = varAssign != null ? rangeClause.getVarDefinitionList() : rangeClause.getLeftExpressionsList();
                for (GoTypeOwner typeOwner : typeOwners) {
                    List<String> lockPath;
                    if (typeOwner.textMatches(GoVetCopyLockInspection.BLANK_NAME) || (lockPath = this.calculateSyncLockerPath(typeOwner.getGoType(null), typeOwner)).isEmpty()) continue;
                    holder.registerProblem(operator, GoVetCopyLockInspection.message("go.inspection.problem.range.var.copies.lock", new Object[]{GoVetCopyLockInspection.code(typeOwner), 1.buildLockPath(lockPath)}), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitMethodDeclaration(@NotNull GoMethodDeclaration methodDeclaration) {
                if (methodDeclaration == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.visitMethodDeclaration(methodDeclaration);
                GoSignature signature = methodDeclaration.getSignature();
                if (signature == null) {
                    return;
                }
                PsiElement identifier = methodDeclaration.getIdentifier();
                if (identifier == null) {
                    return;
                }
                this.checkSignature(signature, identifier.getText());
                GoReceiver receiver = methodDeclaration.getReceiver();
                if (receiver == null) {
                    return;
                }
                GoType receiverType = methodDeclaration.getReceiverType();
                if (receiverType == null) {
                    return;
                }
                List<String> lockPath = this.calculateSyncLockerPath(receiver.getType(), receiver);
                if (lockPath.isEmpty()) {
                    return;
                }
                GoInspectionMessage message = GoVetCopyLockInspection.message("go.inspection.problem.function.passes.lock.by.value", new Object[]{GoVetCopyLockInspection.code(identifier), 1.buildLockPath(lockPath)});
                holder.registerProblem((PsiElement)receiverType, message, new GoAddPointerQuickFix(receiverType));
            }

            @Override
            public void visitFunctionDeclaration(@NotNull GoFunctionDeclaration functionDeclaration) {
                if (functionDeclaration == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.visitFunctionDeclaration(functionDeclaration);
                GoSignature signature = functionDeclaration.getSignature();
                if (signature == null) {
                    return;
                }
                this.checkSignature(signature, functionDeclaration.getIdentifier().getText());
            }

            @Override
            public void visitFunctionLit(@NotNull GoFunctionLit functionLiteral) {
                if (functionLiteral == null) {
                    1.$$$reportNull$$$0(5);
                }
                super.visitFunctionLit(functionLiteral);
                GoSignature signature = functionLiteral.getSignature();
                if (signature == null) {
                    return;
                }
                this.checkSignature(signature, GoVetCopyLockInspection.FUNC_TOKEN_TEXT);
            }

            @Override
            public void visitReturnStatement(@NotNull GoReturnStatement returnStatement) {
                if (returnStatement == null) {
                    1.$$$reportNull$$$0(6);
                }
                super.visitReturnStatement(returnStatement);
                for (GoExpression returnExpression : returnStatement.getExpressionList()) {
                    List<String> lockPath = this.calculateSyncLockerPath(returnExpression);
                    if (lockPath.isEmpty()) continue;
                    holder.registerProblem((PsiElement)returnExpression, GoVetCopyLockInspection.message("go.inspection.problem.return.copies.lock.value", new Object[]{1.buildLockPath(lockPath)}), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitCallExpr(@NotNull GoCallExpr callExpression) {
                if (callExpression == null) {
                    1.$$$reportNull$$$0(7);
                }
                super.visitCallExpr(callExpression);
                if (GoPsiUtil.isBuiltinFunctionCall(callExpression, GoVetCopyLockInspection.LEN_FUNCTION_NAME, GoVetCopyLockInspection.CAP_FUNCTION_NAME) || GoStdlibUtil.isUnsafeFunctionCall(callExpression, GoVetCopyLockInspection.SIZE_OF_FUNCTION_NAME, GoVetCopyLockInspection.OFFSET_OF_FUNCTION_NAME)) {
                    return;
                }
                for (GoExpression argumentExpression : callExpression.getArgumentList().getExpressionList()) {
                    List<String> lockPath = this.calculateSyncLockerPath(argumentExpression);
                    if (lockPath.isEmpty()) continue;
                    holder.registerProblem((PsiElement)argumentExpression, GoVetCopyLockInspection.message("go.inspection.problem.call.copies.lock.value", new Object[]{GoVetCopyLockInspection.code(callExpression.getExpression()), 1.buildLockPath(lockPath)}), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitCompositeLit(@NotNull GoCompositeLit compositeLiteral) {
                if (compositeLiteral == null) {
                    1.$$$reportNull$$$0(8);
                }
                super.visitCompositeLit(compositeLiteral);
                GoLiteralValue literalValue = compositeLiteral.getLiteralValue();
                if (literalValue == null) {
                    return;
                }
                List<GoElement> elements2 = literalValue.getElementList();
                for (GoElement element : elements2) {
                    GoValue value2 = element.getValue();
                    if (value2 == null) continue;
                    GoExpression expression = value2.getExpression();
                    if (expression == null) {
                        return;
                    }
                    List<String> lockPath = this.calculateSyncLockerPath(expression);
                    if (lockPath.isEmpty()) continue;
                    holder.registerProblem((PsiElement)expression, GoVetCopyLockInspection.message("go.inspection.problem.literal.copies.lock.value", new Object[]{REF, 1.buildLockPath(lockPath)}), new LocalQuickFix[0]);
                }
            }

            private void checkAssignments(@NotNull List<? extends PsiElement> leftElements, @NotNull List<GoExpression> rightExpressions, @NotNull PsiElement sourceElement) {
                if (leftElements == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (rightExpressions == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (sourceElement == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (leftElements.size() != rightExpressions.size()) {
                    return;
                }
                for (int i = 0; i < rightExpressions.size(); ++i) {
                    GoExpression rightExpression = rightExpressions.get(i);
                    List<String> lockPath = this.calculateSyncLockerPath(rightExpression);
                    if (lockPath.isEmpty()) continue;
                    if (sourceElement instanceof GoAssignmentStatement) {
                        holder.registerProblem((PsiElement)rightExpression, GoVetCopyLockInspection.message("go.inspection.problem.assignment.copies.lock.value", new Object[]{GoVetCopyLockInspection.code(leftElements.get(i)), 1.buildLockPath(lockPath)}), new LocalQuickFix[0]);
                        continue;
                    }
                    assert (sourceElement instanceof GoVarSpec);
                    holder.registerProblem((PsiElement)rightExpression, GoVetCopyLockInspection.message("go.inspection.problem.variable.declaration.copies.lock.value", new Object[]{GoVetCopyLockInspection.code(leftElements.get(i)), 1.buildLockPath(lockPath)}), new LocalQuickFix[0]);
                }
            }

            private void checkSignature(@NotNull GoSignature signature, @NotNull String signatureName) {
                if (signature == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (signatureName == null) {
                    1.$$$reportNull$$$0(13);
                }
                for (GoParameterDeclaration parameterDeclaration : signature.getParameters().getParameterDeclarationList()) {
                    List<String> lockPath;
                    GoType parameterType = parameterDeclaration.getType();
                    if (parameterType == null || (lockPath = this.calculateSyncLockerPath(parameterType, parameterDeclaration)).isEmpty()) continue;
                    GoInspectionMessage message = GoVetCopyLockInspection.message("go.inspection.problem.function.passes.lock.by.value", new Object[]{GoVetCopyLockInspection.code(signatureName), 1.buildLockPath(lockPath)});
                    holder.registerProblem((PsiElement)parameterType, message, new GoAddPointerQuickFix(parameterType));
                }
            }

            @NotNull
            private List<String> calculateSyncLockerPath(@NotNull GoExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (expression instanceof GoCompositeLit || expression instanceof GoCallExpr || expression instanceof GoUnaryExpr && ((GoUnaryExpr)expression).getExpression() instanceof GoCallExpr) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    return list;
                }
                return this.calculateSyncLockerPath(expression.getGoType(null), expression);
            }

            @NotNull
            private List<String> calculateSyncLockerPath(@Nullable GoType type, @Nullable PsiElement context) {
                if (type == null) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(16);
                    }
                    return list;
                }
                GoType underlyingType = type.getUnderlyingType(context);
                if (GoRecursiveTypeInspection.hasRecursiveReference(underlyingType, underlyingType, (Stack<String>)new Stack(), (Ref<GoFieldDeclaration>)new Ref(), new HashSet<GoType>(), GoPsiImplUtil.createContextOnElement(underlyingType), true)) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(17);
                    }
                    return list;
                }
                ArrayList<String> reversedLockPath = new ArrayList<String>();
                if (this.calculateSyncLockerPath(type, context, reversedLockPath, new HashSet<GoType>())) {
                    List list = ContainerUtil.reverse(reversedLockPath);
                    if (list == null) {
                        1.$$$reportNull$$$0(18);
                    }
                    return list;
                }
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(19);
                }
                return list;
            }

            private boolean calculateSyncLockerPath(@Nullable GoType type, @Nullable PsiElement context, @NotNull List<String> lockPath, @NotNull Set<GoType> visited) {
                GoArrayOrSliceType arrayOrSliceType;
                if (lockPath == null) {
                    1.$$$reportNull$$$0(20);
                }
                if (visited == null) {
                    1.$$$reportNull$$$0(21);
                }
                if (type == null || !visited.add(type)) {
                    return false;
                }
                while ((arrayOrSliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)type.getUnderlyingType(context), GoArrayOrSliceType.class)) != null && arrayOrSliceType.isArray()) {
                    type = arrayOrSliceType.getType();
                }
                GoStructType structType = (GoStructType)ObjectUtils.tryCast((Object)type.getUnderlyingType(context), GoStructType.class);
                if (structType == null) {
                    return false;
                }
                GoInterfaceType lockerInterface = this.getLockerInterface();
                if (lockerInterface == null) {
                    return false;
                }
                if (!GoTypeUtil.isImplementsInterface(lockerInterface, type, false, true, context) && GoTypeUtil.isImplementsInterface(lockerInterface, type, false, false, context)) {
                    lockPath.add(GoRefactoringUtil.getTypeTextWithImports((GoFile)((GoFile)holder.getFile()), (GoType)type).typeText);
                    return true;
                }
                for (GoNamedElement fieldDefinition : structType.getFieldDefinitions()) {
                    if (!this.calculateSyncLockerPath(fieldDefinition.getGoType(null), fieldDefinition, lockPath, visited)) continue;
                    lockPath.add(GoRefactoringUtil.getTypeTextWithImports((GoFile)((GoFile)holder.getFile()), (GoType)type).typeText);
                    return true;
                }
                return false;
            }

            @Nullable
            private GoInterfaceType getLockerInterface() {
                GoInterfaceType syncLockerInterface = (GoInterfaceType)session.getUserData(SYNC_LOCKER_INTERFACE);
                if (syncLockerInterface == null && (syncLockerInterface = GoStdlibUtil.findInterface((PsiElement)holder.getFile(), GoVetCopyLockInspection.SYNC_PACKAGE_NAME, GoVetCopyLockInspection.LOCKER_INTERFACE_NAME)) != null) {
                    session.putUserData(SYNC_LOCKER_INTERFACE, (Object)syncLockerInterface);
                }
                return syncLockerInterface;
            }

            @NotNull
            private static String buildLockPath(@NotNull List<String> lockPath) {
                if (lockPath == null) {
                    1.$$$reportNull$$$0(22);
                }
                String separator = " " + GoBundle.message((String)"go.inspection.problem.contains", (Object[])new Object[0]) + " ";
                String path = StringUtil.join((Collection)ContainerUtil.map(lockPath, type -> GoVetCopyLockInspection.code(type)), (String)separator);
                String string = lockPath.size() > 1 ? String.format(GoBundle.message((String)"go.inspection.problem.type.which.is.sync.locker", (Object[])new Object[0]), path) : String.format(GoBundle.message((String)"go.inspection.problem.type.is.sync.locker", (Object[])new Object[0]), path);
                if (string == null) {
                    1.$$$reportNull$$$0(23);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 15, 16, 17, 18, 19, 23 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "varSpec";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "forStatement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionDeclaration";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionLiteral";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnStatement";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpression";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "compositeLiteral";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "leftElements";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rightExpressions";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceElement";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signature";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signatureName";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/vet/GoVetCopyLockInspection$1";
                        break;
                    }
                    case 20: 
                    case 22: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lockPath";
                        break;
                    }
                    case 21: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visited";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/vet/GoVetCopyLockInspection$1";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        objectArray = objectArray2;
                        objectArray2[1] = "calculateSyncLockerPath";
                        break;
                    }
                    case 23: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildLockPath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitAssignmentStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitVarSpec";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitForStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMethodDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFunctionDeclaration";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFunctionLit";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitReturnStatement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "visitCallExpr";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "visitCompositeLit";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "checkAssignments";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "checkSignature";
                        break;
                    }
                    case 14: 
                    case 20: 
                    case 21: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSyncLockerPath";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: {
                        break;
                    }
                    case 22: {
                        objectArray = objectArray;
                        objectArray[2] = "buildLockPath";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 15, 16, 17, 18, 19, 23 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoVetCopyLockInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

