/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.actions;

import com.goide.i18n.GoBundle;
import com.goide.playground.managers.GoPlaygroundEditorManager;
import com.goide.playground.ui.GoLoadFileDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class GoLoadToPlaygroundAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GoLoadToPlaygroundAction.class);
    private final GoPlaygroundEditorManager myManager;

    public GoLoadToPlaygroundAction(@NotNull GoPlaygroundEditorManager manager) {
        if (manager == null) {
            GoLoadToPlaygroundAction.$$$reportNull$$$0(0);
        }
        super(GoBundle.message((String)"go.playground.actions.load.text", (Object[])new Object[0]), GoBundle.message((String)"go.playground.actions.load.description", (Object[])new Object[0]), AllIcons.Actions.Download);
        this.myManager = manager;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoLoadToPlaygroundAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoLoadToPlaygroundAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(!this.myManager.isWaitingForResponse());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GoLoadModel model;
        Project project;
        GoLoadFileDialog message;
        if (e == null) {
            GoLoadToPlaygroundAction.$$$reportNull$$$0(3);
        }
        if ((message = new GoLoadFileDialog(project = e.getProject(), model = new GoLoadModel())).showAndGet()) {
            if (model.option == GoLoadOption.URL) {
                this.loadFromUrl(model.url);
            } else if (model.option == GoLoadOption.FILE) {
                this.loadFromFile(model.filepath);
            }
        }
    }

    private void loadFromUrl(@NotNull String url) {
        if (url == null) {
            GoLoadToPlaygroundAction.$$$reportNull$$$0(4);
        }
        if (url.isEmpty()) {
            ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> this.myManager.receiveNewEditorContent(GoBundle.message((String)"go.load.to.playground.could.not.load.message", (Object[])new Object[0])));
            return;
        }
        this.myManager.waitForResponse();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RequestBuilder post = HttpRequests.post((String)String.format("%s.go", url), (String)"text/plain");
            try {
                String content2 = (String)post.connect(request -> {
                    request.write("");
                    return request.readString();
                });
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> this.myManager.receiveNewEditorContent(content2));
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                LOG.warn(ex.getMessage());
                this.showError(GoBundle.message((String)"go.load.to.playground.could.not.load.message", (Object[])new Object[0]));
            }
            catch (IOException ex) {
                LOG.warn(ex.getMessage());
                this.showError(String.format("%s. %s", GoBundle.message((String)"go.load.to.playground.could.not.load.message", (Object[])new Object[0]), GoBundle.message((String)"go.action.playground.connection.failed", (Object[])new Object[0])));
            }
        });
    }

    private void showError(String message) {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> this.myManager.receiveNewEditorContent(message));
    }

    private void loadFromFile(@NotNull String filepath) {
        if (filepath == null) {
            GoLoadToPlaygroundAction.$$$reportNull$$$0(5);
        }
        try {
            String fileContent = Files.readString(Path.of(filepath, new String[0]));
            this.myManager.receiveNewEditorContent(fileContent);
        }
        catch (IOException e) {
            this.myManager.receiveNewEditorContent(GoBundle.message((String)"go.load.to.playground.could.not.load.message", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/playground/actions/GoLoadToPlaygroundAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filepath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/playground/actions/GoLoadToPlaygroundAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class GoLoadModel {
        public String url = "";
        public String filepath = "";
        public GoLoadOption option = GoLoadOption.FILE;
    }

    public static enum GoLoadOption {
        FILE,
        URL;

    }
}

