/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoFileType;
import com.goide.project.GoProjectLibrariesService;
import com.goide.project.GoRootsProvider;
import com.goide.project.GoSyntheticLibrary;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class GoPathLibraryRootProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public @Unmodifiable Collection<VirtualFile> getRootsToWatch(@NotNull Project project) {
        if (project == null) {
            GoPathLibraryRootProvider.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                GoPathLibraryRootProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (!GoProjectLibrariesService.getInstance(project).isIndexEntireGopath()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                GoPathLibraryRootProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (Module module : GoSdkUtil.getGoModules(project)) {
            result.addAll(GoSdkUtil.getGoPathSources(project, module, true));
            result.addAll(GoSdkUtil.getGoPathBins(project, module, true));
        }
        List list = ContainerUtil.filter(result, VirtualFile::isInLocalFileSystem);
        if (list == null) {
            GoPathLibraryRootProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            GoPathLibraryRootProvider.$$$reportNull$$$0(4);
        }
        for (GoRootsProvider provider : GoRootsProvider.EP_NAME.getExtensionList()) {
            if (provider.indexGoPathSources(project) != ThreeState.NO) continue;
            Set<SyntheticLibrary> set = Collections.emptySet();
            if (set == null) {
                GoPathLibraryRootProvider.$$$reportNull$$$0(5);
            }
            return set;
        }
        HashSet<SyntheticLibrary> result = new HashSet<SyntheticLibrary>();
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        for (Module module : GoSdkUtil.getGoModules(project)) {
            result.add(new GoPathLibrary(module.getName(), GoSdkUtil.getGoPathSources(project, module, true), contentRoots));
        }
        HashSet<SyntheticLibrary> hashSet = result;
        if (hashSet == null) {
            GoPathLibraryRootProvider.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoPathLibraryRootProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoPathLibraryRootProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToWatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToWatch";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static final class GoPathLibrary
    extends GoSyntheticLibrary
    implements ItemPresentation {
        @NotNull
        private final String myModuleName;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final Set<VirtualFile> myExclusions;

        private GoPathLibrary(@NotNull String moduleName, @NotNull Collection<VirtualFile> roots, VirtualFile ... contentRoots) {
            if (moduleName == null) {
                GoPathLibrary.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                GoPathLibrary.$$$reportNull$$$0(1);
            }
            if (contentRoots == null) {
                GoPathLibrary.$$$reportNull$$$0(2);
            }
            super("GoPathLibrary::" + moduleName, (isDir, filename, isRoot, isStrictRootChild, hasParentAndGrandparent) -> {
                if (isDir) {
                    return false;
                }
                return GoUtil.fileToIgnore(filename) || FileTypeManager.getInstance().getFileTypeByFileName(filename) != GoFileType.INSTANCE;
            });
            this.myModuleName = moduleName;
            this.myRoots = ContainerUtil.filter(roots, root -> {
                for (VirtualFile contentRoot : contentRoots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)root, (boolean)false)) continue;
                    return false;
                }
                return root.isValid();
            });
            this.myExclusions = Arrays.stream(contentRoots).filter(contentRoot -> ContainerUtil.exists(this.myRoots, libraryRoot -> VfsUtilCore.isAncestor((VirtualFile)libraryRoot, (VirtualFile)contentRoot, (boolean)false))).collect(Collectors.toSet());
            for (VirtualFile root2 : this.myRoots) {
                ContainerUtil.addIfNotNull(this.myExclusions, (Object)root2.findChild("mod"));
            }
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection<VirtualFile> collection = this.myRoots;
            if (collection == null) {
                GoPathLibrary.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getExcludedRoots() {
            Set<VirtualFile> set = this.myExclusions;
            if (set == null) {
                GoPathLibrary.$$$reportNull$$$0(4);
            }
            return set;
        }

        @NotNull
        public String getPresentableText() {
            String string = "GOPATH <" + this.myModuleName + ">";
            if (string == null) {
                GoPathLibrary.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public Icon getIcon(boolean unused) {
            Icon icon = AllIcons.Nodes.PpLib;
            if (icon == null) {
                GoPathLibrary.$$$reportNull$$$0(6);
            }
            return icon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            GoPathLibrary library = (GoPathLibrary)((Object)o);
            if (!this.myModuleName.equals(library.myModuleName)) {
                return false;
            }
            if (!this.myRoots.equals(library.myRoots)) {
                return false;
            }
            return this.myExclusions.equals(library.myExclusions);
        }

        public int hashCode() {
            int result = this.myModuleName.hashCode();
            result = 31 * result + this.myRoots.hashCode();
            result = 31 * result + this.myExclusions.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoots";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/project/GoPathLibraryRootProvider$GoPathLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/project/GoPathLibraryRootProvider$GoPathLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

