/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.properties;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImport;
import com.goide.lexer.GoLexer;
import com.goide.project.GoGeneratedSourcesFilter;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.properties.GoFileProperties;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFilePropertiesParser {
    private final GoLexer myLexer = new GoLexer();
    private final Collection<String> myBuildFlagsList = new LinkedHashSet<String>();
    private final Collection<String> myGoBuildConstraints = new ArrayList<String>();
    private String myPackageName = null;
    private boolean myHasCImport = false;
    private boolean myGenerated = false;
    private boolean myIsFinished = false;
    private boolean myBuildFlagsRegion = true;
    private boolean myGoBuildDirectiveRegion = true;
    private final Collection<String> myPendingBuildFlags = new LinkedHashSet<String>();
    private int offsetSafeToStartWith = -1;

    boolean isFinished() {
        return this.myIsFinished;
    }

    CharSequence getPrefixForNextIteration() {
        if (this.offsetSafeToStartWith == -1) {
            return "";
        }
        return this.myLexer.getBufferSequence().subSequence(this.offsetSafeToStartWith, this.myLexer.getBufferEnd());
    }

    @NotNull
    public GoFileProperties getFileProperties() {
        String buildFlags = this.myBuildFlagsList.isEmpty() ? null : StringUtil.join(this.myBuildFlagsList, (String)"|");
        String goBuildConstraint = (String)ContainerUtil.getOnlyItem(this.myGoBuildConstraints);
        return new GoFileProperties(this.myPackageName, buildFlags, goBuildConstraint, this.myHasCImport, this.myGenerated);
    }

    private void safePoint() {
        if (this.myLexer.getTokenType() != null) {
            this.offsetSafeToStartWith = this.myLexer.getTokenStart();
        }
    }

    @NotNull
    public Set<GoImport> parseImports(@NotNull CharSequence content2) {
        IElementType type;
        if (content2 == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(0);
        }
        HashSet<GoImport> result = new HashSet<GoImport>();
        this.myLexer.start(content2, 0, content2.length());
        while ((type = this.myLexer.getTokenType()) != null) {
            if (type == GoTypes.IMPORT) {
                result.addAll(this.parseImportDeclaration());
                continue;
            }
            if (type == GoTypes.PACKAGE) {
                this.parsePackage();
                continue;
            }
            if (!GoFilePropertiesParser.isWhiteSpace(type) && !GoFilePropertiesParser.isComment(type)) break;
            this.myLexer.advance();
        }
        HashSet<GoImport> hashSet = result;
        if (hashSet == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public GoFileProperties parse(@NotNull CharSequence content2) {
        if (content2 == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(2);
        }
        GoFileProperties goFileProperties = this.partialParse(content2).getFileProperties();
        if (goFileProperties == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(3);
        }
        return goFileProperties;
    }

    @NotNull
    GoFilePropertiesParser partialParse(@NotNull CharSequence contentPart) {
        IElementType type;
        if (contentPart == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(4);
        }
        this.myLexer.start(contentPart, 0, contentPart.length());
        this.safePoint();
        while ((type = this.myLexer.getTokenType()) != null) {
            this.safePoint();
            if (GoFilePropertiesParser.isWhiteSpace(type)) {
                this.flushPendingBuildFlags();
                this.myLexer.advance();
                continue;
            }
            if (GoFilePropertiesParser.isLineComment(type)) {
                this.parseComment();
                this.myLexer.advance();
                continue;
            }
            if (type == GoTypes.PACKAGE) {
                this.closeBuildFlagsRegion(true);
                this.myPackageName = this.parsePackage();
                continue;
            }
            if (type == GoTypes.IMPORT) {
                this.closeBuildFlagsRegion(true);
                if (ContainerUtil.find(this.parseImportDeclaration(), it -> "C".equals(it.getImportPath())) == null) continue;
                this.myHasCImport = true;
                this.myIsFinished = true;
                break;
            }
            if (type == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
                this.closeBuildFlagsRegion(false);
                this.myLexer.advance();
                continue;
            }
            this.myLexer.advance();
            this.myIsFinished = this.myLexer.getTokenType() != null;
            break;
        }
        GoFilePropertiesParser goFilePropertiesParser = this;
        if (goFilePropertiesParser == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(5);
        }
        return goFilePropertiesParser;
    }

    private void parseComment() {
        String buildFlags;
        String commentText = this.myLexer.getTokenText();
        boolean isLastToken = this.myLexer.getTokenEnd() == this.myLexer.getBufferEnd();
        String string = buildFlags = this.myBuildFlagsRegion && !isLastToken ? GoFilePropertiesParser.prepareBuildFlags(commentText) : null;
        if (buildFlags != null) {
            this.myPendingBuildFlags.add(buildFlags);
        } else if (!this.myGenerated && GoFilePropertiesParser.isGeneratedComment(commentText)) {
            this.myGenerated = true;
        } else if (this.myGoBuildDirectiveRegion && !isLastToken && GoPsiUtil.isGoBuildDirective(StringUtil.trimStart((String)commentText, (String)"//"))) {
            this.myGoBuildConstraints.add(commentText.substring("//go:build".length()).trim());
        }
    }

    private void closeBuildFlagsRegion(boolean closeGoBuildDirectiveRegion) {
        this.myBuildFlagsRegion = false;
        this.myPendingBuildFlags.clear();
        if (closeGoBuildDirectiveRegion) {
            this.myGoBuildDirectiveRegion = false;
        }
    }

    private void flushPendingBuildFlags() {
        if (this.myBuildFlagsRegion && StringUtil.countChars((CharSequence)this.myLexer.getTokenText(), (char)'\n') > 1) {
            this.myBuildFlagsList.addAll(this.myPendingBuildFlags);
            this.myPendingBuildFlags.clear();
        }
    }

    @Nullable
    private String parsePackage() {
        if (this.myLexer.getTokenType() != GoTypes.PACKAGE) {
            return null;
        }
        this.myLexer.advance();
        this.skipCommentsWhitespaces();
        String packageName = null;
        if (this.myLexer.getTokenType() == GoTypes.IDENTIFIER) {
            packageName = this.myLexer.getTokenText();
            this.myLexer.advance();
            this.safePoint();
        }
        this.skipCommentsWhitespaces();
        this.skipSemicolonAndWhitespaces();
        return packageName;
    }

    @NotNull
    private Set<GoImport> parseImportDeclaration() {
        if (this.myLexer.getTokenType() != GoTypes.IMPORT) {
            Set<GoImport> set = Collections.emptySet();
            if (set == null) {
                GoFilePropertiesParser.$$$reportNull$$$0(6);
            }
            return set;
        }
        this.myLexer.advance();
        this.skipCommentsWhitespaces();
        HashSet<GoImport> result = new HashSet<GoImport>();
        if (this.myLexer.getTokenType() == GoTypes.LPAREN) {
            this.myLexer.advance();
            this.skipCommentsWhitespaces();
        }
        String alias = null;
        while (this.myLexer.getTokenType() == GoTypes.STRING || this.myLexer.getTokenType() == GoTypes.RAW_STRING || this.myLexer.getTokenType() == GoTypes.IDENTIFIER || this.myLexer.getTokenType() == GoTypes.DOT) {
            if (this.myLexer.getTokenType() == GoTypes.IDENTIFIER || this.myLexer.getTokenType() == GoTypes.DOT) {
                alias = this.myLexer.getTokenText();
                this.myLexer.advance();
                this.skipCommentsWhitespaces();
            }
            if (this.myLexer.getTokenType() != GoTypes.STRING && this.myLexer.getTokenType() != GoTypes.RAW_STRING) break;
            String importPath = StringUtil.unquoteString((String)StringUtil.unquoteString((String)this.myLexer.getTokenText(), (char)'`'), (char)'\"');
            result.add(new GoImport(importPath, alias));
            alias = null;
            this.myLexer.advance();
            this.skipCommentsWhitespaces();
            this.skipSemicolonAndWhitespaces();
            this.skipCommentsWhitespaces();
        }
        if (this.myLexer.getTokenType() == GoTypes.RPAREN) {
            this.myLexer.advance();
            this.safePoint();
        }
        this.skipCommentsWhitespaces();
        this.skipSemicolonAndWhitespaces();
        HashSet<GoImport> hashSet = result;
        if (hashSet == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private void skipWhitespaces() {
        while (GoFilePropertiesParser.isWhiteSpace(this.myLexer.getTokenType())) {
            this.myLexer.advance();
        }
    }

    private void skipCommentsWhitespaces() {
        while (GoFilePropertiesParser.isWhiteSpace(this.myLexer.getTokenType()) || GoFilePropertiesParser.isComment(this.myLexer.getTokenType())) {
            this.myLexer.advance();
        }
    }

    private void skipSemicolonAndWhitespaces() {
        if (GoFilePropertiesParser.isSemicolon(this.myLexer.getTokenType())) {
            this.myLexer.advance();
            this.skipWhitespaces();
        }
    }

    private static boolean isSemicolon(IElementType type) {
        return type == GoTypes.SEMICOLON || type == GoTypes.SEMICOLON_SYNTHETIC;
    }

    private static boolean isLineComment(IElementType type) {
        return type == GoParserDefinition.Lazy.LINE_COMMENT;
    }

    private static boolean isWhiteSpace(IElementType type) {
        return GoParserDefinition.Lazy.WHITESPACES.contains(type);
    }

    private static boolean isComment(IElementType type) {
        return GoParserDefinition.Lazy.COMMENTS.contains(type);
    }

    private static boolean isGeneratedComment(@NotNull String commentText) {
        if (commentText == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(8);
        }
        return GoGeneratedSourcesFilter.GENERATED_PATTERN.matcher(commentText).matches();
    }

    private static String prepareBuildFlags(@NotNull String commentText) {
        String trimmedComment;
        if (commentText == null) {
            GoFilePropertiesParser.$$$reportNull$$$0(9);
        }
        if (!GoPsiUtil.isBuildTagComment(trimmedComment = StringUtil.trimStart((String)commentText, (String)"//").trim())) {
            return null;
        }
        return StringUtil.nullize((String)trimmedComment.substring("+build".length()).trim());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/properties/GoFilePropertiesParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPart";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/properties/GoFilePropertiesParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImports";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "partialParse";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseImports";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "partialParse";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedComment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareBuildFlags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

