/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.completion.GoReturnCompletionContributor;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoExpression;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GoAddMissingReturnValuesQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.add.missing.return.value.name", (Object[])new Object[0]);
        if (string == null) {
            GoAddMissingReturnValuesQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GoAddMissingReturnValuesQuickFix.getQuickFixName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GoType resultType;
        GoReturnStatement returnStatement;
        block8: {
            block7: {
                PsiElement element;
                if (project == null) {
                    GoAddMissingReturnValuesQuickFix.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    GoAddMissingReturnValuesQuickFix.$$$reportNull$$$0(2);
                }
                if (!((element = descriptor.getPsiElement()) instanceof GoReturnStatement)) break block7;
                returnStatement = (GoReturnStatement)element;
                if (element.isValid()) break block8;
            }
            return;
        }
        GoSignatureOwner signatureOwner = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GoSignatureOwner.class);
        GoType goType = resultType = signatureOwner != null ? signatureOwner.getResultType() : null;
        if (resultType == null) {
            return;
        }
        List<GoType> typeList = GoTypeUtil.getListOfTypesFromTypeList(resultType);
        List<GoExpression> expressionList = returnStatement.getExpressionList();
        if (expressionList.size() >= typeList.size()) {
            return;
        }
        List<String> missingExpressions = GoReturnCompletionContributor.getReturnValues(typeList.subList(expressionList.size(), typeList.size()));
        List expressionTextList = ContainerUtil.concat((List)ContainerUtil.map(expressionList, PsiElement::getText), missingExpressions);
        GoFormatterUtil.reformat(returnStatement.replace(GoElementFactory.createReturnStatement(project, StringUtil.join((Collection)expressionTextList, (String)", "))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoAddMissingReturnValuesQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoAddMissingReturnValuesQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

