/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoParType;
import com.goide.psi.GoParenthesesExpr;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoUnwrapParensQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.unwrap.parens.name", (Object[])new Object[0]);
        if (string == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public GoUnwrapParensQuickFix(@NotNull PsiElement element) {
        if (element == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(1);
        }
        super(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable(value="is null when called from inspection") @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(5);
        }
        if (!startElement.isValid()) {
            return;
        }
        if (startElement instanceof GoParenthesesExpr) {
            GoUnwrapParensQuickFix.unwrap(editor, startElement, ((GoParenthesesExpr)startElement).unwrapParentheses());
        } else if (startElement instanceof GoParType) {
            GoUnwrapParensQuickFix.unwrap(editor, startElement, ((GoParType)startElement).getType());
        }
    }

    private static void unwrap(@Nullable Editor editor, @NotNull PsiElement elementInParens, @Nullable PsiElement unwrapped) {
        if (elementInParens == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(6);
        }
        if (editor != null) {
            GoUnwrapParensQuickFix.moveCaretToRightOffset(editor, elementInParens, unwrapped);
        }
        if (unwrapped != null) {
            elementInParens.replace(unwrapped);
        } else {
            elementInParens.delete();
        }
    }

    private static void moveCaretToRightOffset(@NotNull Editor editor, @NotNull PsiElement parensExpression, @Nullable PsiElement expression) {
        if (editor == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(7);
        }
        if (parensExpression == null) {
            GoUnwrapParensQuickFix.$$$reportNull$$$0(8);
        }
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        boolean caretBeforeExpression = expression == null || offset <= expression.getTextRange().getStartOffset();
        int newOffset = parensExpression.getTextRange().getStartOffset() + (caretBeforeExpression ? 0 : expression.getTextLength());
        caretModel.moveToOffset(newOffset);
    }

    @NotNull
    public String getText() {
        return GoUnwrapParensQuickFix.getQuickFixName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return GoUnwrapParensQuickFix.getQuickFixName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoUnwrapParensQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInParens";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parensExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoUnwrapParensQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToRightOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

