/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.go.GoGotoUtil;
import com.goide.go.GoSuperMethodSearch;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeSpec;
import com.goide.refactor.changeSignature.GoChangeSignatureBuilder;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.core.CoreBundle;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoChangeSignatureHandler
implements ChangeSignatureHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null && dataContext != null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        GoChangeSignatureHandler.invokeOnElement(project, editor, element);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, @Nullable DataContext dataContext) {
        if (project == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (elements2 == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (elements2.length != 1) {
            return;
        }
        Editor editor = (Editor)ObjectUtils.doIfNotNull((Object)dataContext, arg_0 -> ((DataKey)CommonDataKeys.EDITOR).getData(arg_0));
        GoChangeSignatureHandler.invokeOnElement(project, editor, elements2[0]);
    }

    private static void invokeOnElement(@NotNull Project project, @Nullable Editor editor, @Nullable PsiElement element) {
        GoNamedSignatureOwner method;
        if (project == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if ((method = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)element, GoNamedSignatureOwner.class)) == null) {
            return;
        }
        if (FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            GoMethodSpec methodSpec = GoChangeSignatureHandler.findMethodSpec(method);
            if (editor != null && methodSpec != null) {
                String action = GoBundle.message((String)"go.refactoring.refactor.action", (Object[])new Object[0]);
                GoChangeSignatureHandler.createPopup(method, methodSpec, action, GoChangeSignatureHandler::showDialog).showInBestPositionFor(editor);
            } else {
                GoChangeSignatureHandler.showDialog(method, false);
            }
        } else {
            String message = RefactoringBundle.getCannotRefactorMessage((String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
        }
    }

    @NotNull
    public static JBPopup createPopup(@NotNull GoNamedSignatureOwner method, @NotNull GoMethodSpec methodSpec, @NotNull @Nls String action, @NotNull BiConsumer<GoNamedSignatureOwner, Boolean> consumer) {
        if (method == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        if (methodSpec == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(7);
        }
        if (action == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(9);
        }
        String implementations = GoBundle.message((String)"go.refactoring.change.signature.method.specification.and.implementations.option", (Object[])new Object[]{action});
        String onlyMethod = GoBundle.message((String)"go.refactoring.change.signature.current.method.option", (Object[])new Object[]{action});
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(List.of(implementations, onlyMethod)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> {
            boolean refactorImplementations = implementations.equals(value2);
            GoNamedSignatureOwner target = refactorImplementations ? methodSpec : method;
            consumer.accept(target, refactorImplementations);
        }).createPopup();
        if (jBPopup == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(10);
        }
        return jBPopup;
    }

    @Nullable
    public static GoMethodSpec findMethodSpec(@Nullable GoNamedSignatureOwner declaration) {
        if (declaration instanceof GoMethodSpec) {
            return (GoMethodSpec)declaration;
        }
        GoMethodDeclaration method = (GoMethodDeclaration)ObjectUtils.tryCast((Object)declaration, GoMethodDeclaration.class);
        if (method == null) {
            return null;
        }
        GoTypeSpec methodType = method.resolveTypeSpec();
        if (methodType == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        GoSuperMethodSearch.GO_SUPER_METHOD_SEARCH.processQuery(GoGotoUtil.param(method), (Processor<? super GoNamedSignatureOwner>)processor2);
        GoNamedSignatureOwner methodSpec = (GoNamedSignatureOwner)processor2.getFoundValue();
        if (!(methodSpec instanceof GoMethodSpec) || !GoChangeSignatureHandler.canBeModified(methodSpec.getContainingFile())) {
            return null;
        }
        GoTypeSpec methodSpecType = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodSpec, GoTypeSpec.class);
        if (methodSpecType == null) {
            return null;
        }
        return (GoMethodSpec)methodSpec;
    }

    public static boolean canBeModified(@NotNull GoFile file) {
        if (file == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(11);
        }
        if (!file.isWritable()) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return ProjectFileIndex.getInstance((Project)file.getProject()).isInContent(virtualFile) || ScratchUtil.isScratch((VirtualFile)virtualFile);
    }

    private static void showDialog(@NotNull GoNamedSignatureOwner method, boolean refactorImplementations) {
        if (method == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(12);
        }
        GoChangeSignatureBuilder.create(method).refactorImplementations(refactorImplementations).show();
    }

    @Nullable
    public GoNamedSignatureOwner findTargetMember(@NotNull PsiElement element) {
        PsiElement resolve;
        GoNamedSignatureOwner method;
        GoNamedSignatureOwner method2;
        PsiElement parent;
        if (element == null) {
            GoChangeSignatureHandler.$$$reportNull$$$0(13);
        }
        if ((parent = element.getParent()) instanceof GoNamedSignatureOwner) {
            GoNamedSignatureOwner method3 = (GoNamedSignatureOwner)parent;
            return method3.getSignature() != null ? method3 : null;
        }
        GoSignature signature = (GoSignature)PsiTreeUtil.getParentOfType((PsiElement)element, GoSignature.class);
        if (signature != null) {
            return (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)signature.getParent(), GoNamedSignatureOwner.class);
        }
        GoReceiver receiver = (GoReceiver)PsiTreeUtil.getParentOfType((PsiElement)element, GoReceiver.class);
        if (receiver != null && (method2 = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)receiver.getParent(), GoNamedSignatureOwner.class)) != null) {
            return method2.getSignature() != null ? method2 : null;
        }
        if (parent instanceof GoArgumentList) {
            parent = parent.getPrevSibling();
        }
        if (parent instanceof GoReferenceExpression && (method = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)(resolve = ((GoReferenceExpression)parent).resolve()), GoNamedSignatureOwner.class)) != null) {
            return method.getSignature() != null ? method : null;
        }
        return null;
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return GoBundle.message((String)"go.refactoring.change.signature.target.not.found.error.message", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSpec";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeModified";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findTargetMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

