/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.extractInterface;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.refactor.extractInterface.GoExtractInterfaceDialog;
import com.goide.refactor.extractInterface.TypeSpecWithSelectedMethods;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoExtractInterfaceHandler
implements RefactoringActionHandler,
ElementsHandler,
ContextAwareActionHandler {
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        return GoExtractInterfaceHandler.findSpecWithMethodAtOffset(editor, file) != null;
    }

    public boolean isEnabledOnElements(PsiElement[] elements2) {
        return GoExtractInterfaceHandler.findSpecWithMethods(elements2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(4);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        GoExtractInterfaceHandler.invoke(GoExtractInterfaceHandler.findSpecWithMethodAtOffset(editor, file), project, editor);
    }

    @VisibleForTesting
    @Nullable
    public static TypeSpecWithSelectedMethods findSpecWithMethodAtOffset(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(6);
        }
        GoTypeSpec spec = GoExtractInterfaceHandler.findElementAtOffset(editor, file, GoExtractInterfaceHandler::getSpec);
        GoNamedSignatureOwner method = GoExtractInterfaceHandler.findElementAtOffset(editor, file, GoExtractInterfaceHandler::getMethod);
        if (spec == null && method instanceof GoMethodDeclaration) {
            spec = ((GoMethodDeclaration)method).resolveTypeSpec();
        }
        return spec != null ? TypeSpecWithSelectedMethods.of(spec, method) : null;
    }

    @Nullable
    private static <T> T findElementAtOffset(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Function<PsiElement, T> mapper) {
        if (editor == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(8);
        }
        if (mapper == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(9);
        }
        int offset = editor.getCaretModel().getOffset();
        for (PsiElement element = file.findElementAt(offset); element != null; element = element.getParent()) {
            int relative;
            PsiReference reference;
            T result = mapper.apply(element);
            if (result != null) {
                return result;
            }
            TextRange range = element.getTextRange();
            if (range == null || (reference = element.findReferenceAt(relative = offset - range.getStartOffset())) == null || (result = mapper.apply(reference.resolve())) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static GoTypeSpec getSpec(@Nullable PsiElement element) {
        List<GoTypeSpec> specs;
        if (element instanceof GoTypeSpec) {
            return (GoTypeSpec)element;
        }
        GoTypeDeclaration declaration = (GoTypeDeclaration)ObjectUtils.tryCast((Object)element, GoTypeDeclaration.class);
        if (declaration != null && (specs = declaration.getTypeSpecList()).size() == 1) {
            return (GoTypeSpec)ContainerUtil.getFirstItem(specs);
        }
        return null;
    }

    @Nullable
    private static GoNamedSignatureOwner getMethod(@Nullable PsiElement element) {
        return element instanceof GoMethodDeclaration || element instanceof GoMethodSpec ? (GoNamedSignatureOwner)element : null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
        if (project == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(10);
        }
        if (elements2 == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(11);
        }
        GoExtractInterfaceHandler.invoke(GoExtractInterfaceHandler.findSpecWithMethods(elements2), project, (Editor)dataContext.getData(CommonDataKeys.EDITOR));
    }

    @VisibleForTesting
    @Nullable
    public static TypeSpecWithSelectedMethods findSpecWithMethods(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(12);
        }
        GoTypeSpec spec = null;
        LinkedHashSet<GoNamedSignatureOwner> methods = new LinkedHashSet<GoNamedSignatureOwner>();
        for (PsiElement element : elements2) {
            GoTypeSpec specForMethod;
            if (element instanceof GoTypeSpec) {
                if (spec == null) {
                    spec = (GoTypeSpec)element;
                    continue;
                }
                if (spec != element) {
                    return null;
                }
            }
            if ((specForMethod = GoExtractInterfaceHandler.getSpecForMethod(element)) == null) {
                return null;
            }
            if (spec == null) {
                spec = specForMethod;
            } else if (spec != specForMethod) {
                return null;
            }
            methods.add((GoNamedSignatureOwner)element);
        }
        return spec != null ? TypeSpecWithSelectedMethods.of(spec, methods) : null;
    }

    @Nullable
    private static GoTypeSpec getSpecForMethod(@Nullable PsiElement element) {
        GoNamedSignatureOwner method = GoExtractInterfaceHandler.getMethod(element);
        return method instanceof GoMethodDeclaration ? ((GoMethodDeclaration)method).resolveTypeSpec() : (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)method, GoTypeSpec.class);
    }

    private static void invoke(@Nullable TypeSpecWithSelectedMethods specWithMethods, @NotNull Project project, @Nullable Editor editor) {
        if (project == null) {
            GoExtractInterfaceHandler.$$$reportNull$$$0(13);
        }
        if (specWithMethods == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GoBundle.message((String)"go.refactoring.extract.interface.caret.should.be.inside.type.error.message", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"extract.interface.title"), null);
            return;
        }
        new GoExtractInterfaceDialog(specWithMethods).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/goide/refactor/extractInterface/GoExtractInterfaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findSpecWithMethodAtOffset";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementAtOffset";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findSpecWithMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

