/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.move;

import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.refactor.move.GoMoveDeclarationDelegate;
import com.goide.refactor.move.GoMoveDeclarationInfoModel;
import com.goide.refactor.move.GoMoveDeclarationProcessor;
import com.goide.refactor.ui.GoDeclarationInfo;
import com.goide.refactor.ui.GoRefactoringDialogWithDeclarations;
import com.goide.refactor.util.GoRefactoringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class GoMoveDeclarationDialog
extends GoRefactoringDialogWithDeclarations<GoMoveDeclarationInfoModel> {
    GoMoveDeclarationDialog(@NotNull Collection<PsiElement> declarations, @NotNull Project project) {
        if (declarations == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(1);
        }
        super(declarations, project);
        this.init();
    }

    @TestOnly
    public GoMoveDeclarationDialog(@NotNull Collection<PsiElement> declarations, @NotNull Project project, @NotNull String protocol) {
        if (declarations == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(3);
        }
        if (protocol == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(4);
        }
        super(declarations, project, protocol);
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = RefactoringBundle.message((String)"move.title");
        if (string == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<GoDeclarationInfo> getDeclarationInfos() {
        GoFile file = Objects.requireNonNull((GoFile)Objects.requireNonNull((PsiElement)ContainerUtil.getFirstItem((Collection)this.myDeclarations)).getContainingFile());
        return GoMoveDeclarationDialog.collectTopLevelDeclarationInfos(file, this.myDeclarations);
    }

    @VisibleForTesting
    @NotNull
    public static List<GoDeclarationInfo> collectTopLevelDeclarationInfos(@NotNull GoFile file, @NotNull Collection<PsiElement> declarations) {
        if (file == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(6);
        }
        if (declarations == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(7);
        }
        ArrayList<GoDeclarationInfo> infos = new ArrayList<GoDeclarationInfo>();
        for (PsiElement child = file.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GoCompositeElement) || !GoMoveDeclarationDelegate.canBeMoved(child)) continue;
            for (GoNamedElement namedElement : GoRefactoringUtil.collectNamedElements((GoCompositeElement)child)) {
                GoDeclarationInfo info = new GoDeclarationInfo(namedElement);
                info.setChecked(ContainerUtil.exists(declarations, declaration -> PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)namedElement, (boolean)false)));
                infos.add(info);
            }
        }
        ArrayList<GoDeclarationInfo> arrayList = infos;
        if (arrayList == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    protected List<String> getFilesInDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(9);
        }
        Set files = StreamEx.of((Collection)this.myDeclarations).map(PsiElement::getContainingFile).toSet();
        boolean inTests = ContainerUtil.or((Iterable)files, GoTestFinder::isTestFile);
        return ((StreamEx)((StreamEx)StreamEx.of((Object[])directory.getFiles()).remove(files::contains)).filter(file -> inTests || !GoTestFinder.isTestFile(file))).select(GoFile.class).map(PsiFileImpl::getName).map(FileUtil::getNameWithoutExtension).toList();
    }

    @Override
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        PsiFile file;
        List<ValidationInfo> infos = super.doValidateAll();
        if (ContainerUtil.exists(infos, info -> info.component == this.myFileTextField)) {
            List<ValidationInfo> list = infos;
            if (list == null) {
                GoMoveDeclarationDialog.$$$reportNull$$$0(10);
            }
            return list;
        }
        PsiDirectory directory = this.findDirectory(this.getDirectoryPath());
        if (directory != null && (file = directory.findFile(this.myFileTextField.getFileName() + ".go")) != null) {
            if (StreamEx.of((Collection)this.myDeclarations).map(PsiElement::getContainingFile).anyMatch(file::equals)) {
                infos.add(new ValidationInfo(GoBundle.message((String)"go.refactoring.move.file.should.differ.validation.message", (Object[])new Object[0]), (JComponent)((Object)this.myFileTextField)));
            }
        }
        List<ValidationInfo> list = infos;
        if (list == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    protected GoMoveDeclarationInfoModel createDeclarationInfoModel(@NotNull List<GoDeclarationInfo> infos) {
        if (infos == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(12);
        }
        return new GoMoveDeclarationInfoModel(infos);
    }

    @Override
    @NotNull
    protected BaseRefactoringProcessor getRefactoringProcessor(@NotNull GoMoveDeclarationInfoModel model) {
        if (model == null) {
            GoMoveDeclarationDialog.$$$reportNull$$$0(13);
        }
        return new GoMoveDeclarationProcessor(this.getProject(), model, this.isOpenInEditor());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getComboBoxEditor((ComboBox<String>)this.myDirectoryComboBox);
    }

    @NotNull
    protected String getRefactoringId() {
        return "GoMoveDeclarationDialog";
    }

    @NotNull
    protected String getHelpId() {
        return "MovetoPackageRefactoring";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/move/GoMoveDeclarationDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/move/GoMoveDeclarationDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTopLevelDeclarationInfos";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectTopLevelDeclarationInfos";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationInfoModel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringProcessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

