/*
 * Decompiled with CFR 0.152.
 */
package com.goide.training.learn.lesson;

import com.goide.training.learn.course.GoLearningCourse;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.learn.course.IftModule;
import training.learn.course.KLesson;
import training.util.DataLoader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"Lcom/goide/training/learn/lesson/GoLesson;", "Ltraining/learn/course/KLesson;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "loadSample", "Ltraining/dsl/LessonSample;", "sampleName", "intellij.go.featuresTrainer"})
public abstract class GoLesson
extends KLesson {
    public GoLesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(id, name);
    }

    @NotNull
    public final LessonSample loadSample(@NotNull String sampleName) {
        Intrinsics.checkNotNullParameter((Object)sampleName, (String)"sampleName");
        IftModule iftModule = this.getModule();
        Intrinsics.checkNotNull((Object)iftModule, (String)"null cannot be cast to non-null type com.goide.training.learn.course.GoLearningCourse.GoLearningModule");
        String path = ((GoLearningCourse.GoLearningModule)iftModule).getLessonsPath() + "/" + sampleName;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)DataLoader.INSTANCE.getResourceAsStream(path, classLoader));
        Charset charset = Charsets.UTF_8;
        String content2 = new String(byArray, charset);
        return LessonSampleKt.parseLessonSample((String)content2);
    }
}

