/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import java.io.RandomAccessFile;
import org.jetbrains.annotations.NotNull;

public final class GoWinUtil {
    private static final int PE_SIGNATURE_OFFSET_LOCATION = 60;
    private static final int PE_SIGNATURE = 17744;
    private static final int MINIDUMP_SIGNATURE = 1347241037;
    private static final int MINIDUMP_VERSION = 42899;

    private GoWinUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWinExecutable(@NotNull String path) {
        if (path == null) {
            GoWinUtil.$$$reportNull$$$0(0);
        }
        try (RandomAccessFile file = new RandomAccessFile(path, "r");){
            file.seek(60L);
            byte[] buf = new byte[4];
            if (file.read(buf) != buf.length) {
                boolean bl = false;
                return bl;
            }
            int offset = GoWinUtil.readLittleEndianUint32(buf);
            file.seek(offset);
            if (file.read(buf) != buf.length) {
                boolean bl = false;
                return bl;
            }
            boolean bl = GoWinUtil.readLittleEndianUint32(buf) == 17744;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMiniDump(@NotNull String path) {
        if (path == null) {
            GoWinUtil.$$$reportNull$$$0(1);
        }
        try (RandomAccessFile file = new RandomAccessFile(path, "r");){
            byte[] buf = new byte[6];
            if (file.read(buf) != buf.length) {
                boolean bl = false;
                return bl;
            }
            boolean bl = GoWinUtil.readLittleEndianUint32(buf) == 1347241037 && GoWinUtil.readLittleEndianUint16(buf, 4) == 42899;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int readLittleEndianUint32(byte[] buf) {
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    private static int readLittleEndianUint16(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "path";
        objectArray2[1] = "com/goide/util/GoWinUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWinExecutable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMiniDump";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

