/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.project.GoActivityKey;
import com.goide.sdk.GoSdkService;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vgo.VgoAsyncModulesAware;
import com.goide.vgo.VgoIntegrationManager;
import com.goide.vgo.VgoModuleInfoProvider;
import com.goide.vgo.VgoModulesAware;
import com.goide.vgo.VgoRootToModule;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.VgoFileType;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.quickfix.VgoModuleDownloader;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.sdk.VgoToolchainService;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.AbstractCrcCalculator;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingQueueUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class VgoStatusTracker
implements Disposable {
    public static final Logger LOG = Logger.getInstance((String)"#com.goide.vgo.go-modules-status");
    final Module myModule;
    private final MergingUpdateQueue myUpdateDependenciesQueue;
    final VgoUpdateProgressManager myUpdateProgressManager;
    private final ModuleCacheUpdatesListener myModuleCacheUpdatesListener;
    private final VgoModuleDownloader myModuleDownloader;
    private VgoModulesAware myVgoModulesAware;
    static final String ALL_MODULES_UPDATE_DEPENDENCIES_TASK = "go.vgo.all.modules.status.task";
    static final ProjectSystemId VGO_MODULES_SYSTEM_ID = new ProjectSystemId("GO MODULES");

    public VgoStatusTracker(@NotNull Module module, @NotNull CoroutineScope cs, @NotNull Disposable parentDisposable) {
        if (module == null) {
            VgoStatusTracker.$$$reportNull$$$0(0);
        }
        if (cs == null) {
            VgoStatusTracker.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            VgoStatusTracker.$$$reportNull$$$0(2);
        }
        this.myVgoModulesAware = null;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myModule = module;
        this.myUpdateDependenciesQueue = new MergingUpdateQueue("Collect Go modules dependencies", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD).setRestartTimerOnAdd(true);
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            this.myUpdateDependenciesQueue.setPassThrough(true);
        }
        this.myUpdateProgressManager = new VgoUpdateProgressManager(this.myModule, this);
        Project project = module.getProject();
        this.myModuleDownloader = new VgoModuleDownloader(project, module, this);
        if (Registry.is((String)"go.modules.enable.legacy.go.list.scheduler")) {
            VgoChangeDetector changeDetector = new VgoChangeDetector();
            PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)changeDetector, (Disposable)this);
            VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)changeDetector, (Disposable)this);
        } else {
            ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
            this.myVgoModulesAware = VgoAsyncModulesAware.createModulesAware(this, cs);
            projectTracker.register((ExternalSystemProjectAware)this.myVgoModulesAware, (Disposable)this);
            projectTracker.activate(this.myVgoModulesAware.getProjectId());
        }
        this.myModuleCacheUpdatesListener = new ModuleCacheUpdatesListener();
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this.myModuleCacheUpdatesListener, (Disposable)this);
    }

    public void scheduleUpdatingDependenciesOfAllModules() {
        this.scheduleUpdatingDependenciesOfAllModules(true);
    }

    public void scheduleUpdatingDependenciesOfAllModules(boolean runDownload) {
        TrackingUtil.trackActivity((Project)this.myModule.getProject(), (ActivityKey)GoActivityKey.INSTANCE, () -> {
            LOG.debug("Schedule dependencies update: all");
            if (Registry.is((String)"go.modules.enable.legacy.go.list.scheduler")) {
                this.scheduleUpdatingDependencies(ALL_MODULES_UPDATE_DEPENDENCIES_TASK, indicator -> this.updateDependenciesOfModules((Promise<Collection<VirtualFile>>)this.nonBlockingReadAction(() -> this.findAllGoModuleSettingsFiles()), vgoModules -> VgoModulesRegistry.getInstance(this.myModule.getProject()).updateAllModules(this.myModule, (Collection<VgoRootToModule>)vgoModules), (ProgressIndicatorEx)indicator, runDownload));
            } else {
                ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)this.myModule.getProject(), (String)"VgoStatusTracker.scheduleUpdatingDependenciesOfAllModules(boolean)");
                ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myModule.getProject());
                if (this.myVgoModulesAware != null) {
                    projectTracker.markDirty(this.myVgoModulesAware.getProjectId());
                }
                projectTracker.scheduleProjectRefresh();
                activityTracker.activityFinished();
            }
        });
    }

    public void scheduleUpdatingDependencies(@NotNull @Unmodifiable Collection<VirtualFile> goModuleSettingsFiles) {
        if (goModuleSettingsFiles == null) {
            VgoStatusTracker.$$$reportNull$$$0(3);
        }
        this.scheduleUpdatingDependencies(goModuleSettingsFiles, true);
    }

    public void scheduleUpdatingDependencies(@NotNull @Unmodifiable Collection<VirtualFile> goModuleSettingsFiles, boolean runDownload) {
        if (goModuleSettingsFiles == null) {
            VgoStatusTracker.$$$reportNull$$$0(4);
        }
        LOG.debug("Schedule dependencies update: " + String.valueOf(goModuleSettingsFiles));
        List filePaths = ContainerUtil.map(goModuleSettingsFiles, VirtualFile::getPath);
        this.scheduleUpdatingDependencies(VgoStatusTracker.getTaskKey(filePaths), indicator -> this.updateDependenciesOfModules((Promise<Collection<VirtualFile>>)Promises.resolvedPromise((Object)goModuleSettingsFiles), vgoModules -> VgoModulesRegistry.getInstance(this.myModule.getProject()).updateModules(this.myModule, (Collection<VgoRootToModule>)vgoModules), (ProgressIndicatorEx)indicator, runDownload));
    }

    private void scheduleUpdatingDependencies(final @NotNull String taskKey, final @NotNull MyUpdater updater2) {
        if (taskKey == null) {
            VgoStatusTracker.$$$reportNull$$$0(5);
        }
        if (updater2 == null) {
            VgoStatusTracker.$$$reportNull$$$0(6);
        }
        final ProgressIndicatorEx indicator = this.myUpdateProgressManager.startUpdate(taskKey);
        MergingQueueUtil.queueTracked((MergingUpdateQueue)this.myUpdateDependenciesQueue, (Update)new Update(taskKey){

            public void run() {
                ExternalSystemRefreshStatus status;
                if (VgoStatusTracker.this.myModule.isDisposed()) {
                    LOG.debug("Module was disposed");
                    status = ExternalSystemRefreshStatus.CANCEL;
                } else if (indicator.isCanceled()) {
                    LOG.debug("Update indicator was canceled");
                    status = ExternalSystemRefreshStatus.CANCEL;
                } else {
                    status = (ExternalSystemRefreshStatus)updater2.apply(indicator);
                }
                VgoStatusTracker.this.myUpdateProgressManager.finishUpdate(taskKey, indicator, status);
            }

            public void setRejected() {
                LOG.debug("Update was rejected");
                VgoStatusTracker.this.myUpdateProgressManager.finishUpdate(taskKey, indicator, ExternalSystemRefreshStatus.CANCEL);
            }
        });
    }

    @NotNull
    ExternalSystemRefreshStatus updateDependenciesOfModules(@NotNull Promise<Collection<VirtualFile>> goModuleSettingsFiles, @NotNull Consumer<Collection<VgoRootToModule>> updateModulesInRegistry, @NotNull ProgressIndicatorEx indicator, boolean runDownload) {
        ExternalSystemRefreshStatus externalSystemRefreshStatus;
        if (goModuleSettingsFiles == null) {
            VgoStatusTracker.$$$reportNull$$$0(7);
        }
        if (updateModulesInRegistry == null) {
            VgoStatusTracker.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            VgoStatusTracker.$$$reportNull$$$0(9);
        }
        Project project = this.myModule.getProject();
        if (this.myModule.isDisposed() || project.isDisposed()) {
            LOG.debug("Module or project was disposed");
            ExternalSystemRefreshStatus externalSystemRefreshStatus2 = ExternalSystemRefreshStatus.CANCEL;
            if (externalSystemRefreshStatus2 == null) {
                VgoStatusTracker.$$$reportNull$$$0(10);
            }
            return externalSystemRefreshStatus2;
        }
        CompletableFuture result = new CompletableFuture();
        goModuleSettingsFiles.thenAsync(files -> VgoModuleInfoProvider.getInstance().getInfos((Collection<VirtualFile>)files, this.myModule, indicator)).onSuccess(vgoModules -> ReadAction.run(() -> {
            if (!project.isDisposed() && !this.myModule.isDisposed()) {
                updateModulesInRegistry.accept((Collection<VgoRootToModule>)vgoModules);
                this.afterDependenciesUpdate((Collection<VgoRootToModule>)vgoModules, runDownload);
                result.complete(ExternalSystemRefreshStatus.SUCCESS);
            } else {
                LOG.debug("Module or project was disposed");
                result.complete(ExternalSystemRefreshStatus.CANCEL);
            }
        })).onError(e -> {
            if (!(e instanceof CancellationException)) {
                LOG.error("Couldn't collect vgo modules info", e);
                result.complete(ExternalSystemRefreshStatus.FAILURE);
            } else {
                LOG.debug("Update was canceled", e);
                result.complete(ExternalSystemRefreshStatus.CANCEL);
            }
        });
        try {
            externalSystemRefreshStatus = (ExternalSystemRefreshStatus)result.get();
        }
        catch (ExecutionException e2) {
            LOG.error("Failed to update Go Module dependencies", (Throwable)e2);
            ExternalSystemRefreshStatus externalSystemRefreshStatus3 = ExternalSystemRefreshStatus.FAILURE;
            if (externalSystemRefreshStatus3 == null) {
                VgoStatusTracker.$$$reportNull$$$0(12);
            }
            return externalSystemRefreshStatus3;
        }
        catch (InterruptedException e3) {
            LOG.debug("Update was interrupted", (Throwable)e3);
            ExternalSystemRefreshStatus externalSystemRefreshStatus4 = ExternalSystemRefreshStatus.CANCEL;
            if (externalSystemRefreshStatus4 == null) {
                VgoStatusTracker.$$$reportNull$$$0(13);
            }
            return externalSystemRefreshStatus4;
        }
        if (externalSystemRefreshStatus == null) {
            VgoStatusTracker.$$$reportNull$$$0(11);
        }
        return externalSystemRefreshStatus;
    }

    void afterDependenciesUpdate(Collection<@NotNull VgoRootToModule> vgoModules, boolean runDownload) {
        if (runDownload) {
            this.myModuleDownloader.launchDownloadAllDependenciesIfEnabled(vgoModules);
        }
        ((VgoToolchainService)this.myModule.getProject().getService(VgoToolchainService.class)).launchToolchainScan(this.myModule);
    }

    @NotNull
    List<VirtualFile> findAllGoModuleSettingsFiles() {
        List list = (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> ((StreamEx)StreamEx.of((Collection)FilenameIndex.getVirtualFilesByName((String)"go.mod", (GlobalSearchScope)this.myModule.getModuleContentScope())).append(this.getEnabledGoWorkFiles()).filter(f -> {
            ProgressManager.checkCanceled();
            return f != null && !GoVendoringUtil.isVendoredFile(f, this.myModule);
        })).toList());
        if (list == null) {
            VgoStatusTracker.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private Collection<VirtualFile> getEnabledGoWorkFiles() {
        Collection<Object> collection = GoSdkService.getInstance(this.myModule.getProject()).getSdk(this.myModule).supportsWorkspaceMode() ? FilenameIndex.getVirtualFilesByName((String)"go.work", (GlobalSearchScope)this.myModule.getModuleContentScope()) : List.of();
        if (collection == null) {
            VgoStatusTracker.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    static String getTaskKey(@NotNull Collection<String> paths) {
        if (paths == null) {
            VgoStatusTracker.$$$reportNull$$$0(16);
        }
        String string = new TreeSet<String>(paths).toString();
        if (string == null) {
            VgoStatusTracker.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    <T> Promise<T> nonBlockingReadAction(@NotNull Computable<T> action) {
        if (action == null) {
            VgoStatusTracker.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.assertTrue(ApplicationManager.getApplication().isHeadlessEnvironment(), (Object)"Long blocking processes are prohibited on EDT in non-headless mode");
            Promise promise = Promises.resolvedPromise((Object)action.compute());
            if (promise == null) {
                VgoStatusTracker.$$$reportNull$$$0(19);
            }
            return promise;
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> action.compute()).expireWith((Disposable)this).submit((Executor)NonUrgentExecutor.getInstance());
        if (cancellablePromise == null) {
            VgoStatusTracker.$$$reportNull$$$0(20);
        }
        return cancellablePromise;
    }

    public void dispose() {
    }

    public static void startExplicitModuleCacheUpdate(@Nullable Module module) {
        VgoStatusTracker tracker;
        VgoStatusTracker vgoStatusTracker = tracker = module != null ? VgoIntegrationManager.getInstance(module.getProject()).getTracker(module) : null;
        if (tracker != null) {
            tracker.myModuleCacheUpdatesListener.myPaused.set(true);
        }
    }

    public static void finishExplicitModuleCacheUpdate(@Nullable Module module) {
        VirtualFileManager.getInstance().asyncRefresh(() -> {
            VgoStatusTracker tracker;
            VgoStatusTracker vgoStatusTracker = tracker = module != null ? VgoIntegrationManager.getInstance(module.getProject()).getTracker(module) : null;
            if (tracker != null) {
                tracker.myModuleCacheUpdatesListener.myPaused.set(false);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 14, 15, 17, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModuleSettingsFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateModulesInRegistry";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/VgoStatusTracker";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/VgoStatusTracker";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDependenciesOfModules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGoModuleSettingsFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledGoWorkFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskKey";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "nonBlockingReadAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdatingDependencies";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOfModules";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTaskKey";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nonBlockingReadAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 14, 15, 17, 19, 20 -> new IllegalStateException(string);
        };
    }

    static class VgoUpdateProgressManager
    implements Disposable {
        private final Module myModule;
        private final ConcurrentMap<String, ProgressIndicatorEx> myProgressIndicators;
        @Topic.ProjectLevel
        static final Topic<VgoModuleUpdateProgressListener> UPDATE_PROGRESS_TOPIC = new Topic(VgoModuleUpdateProgressListener.class, Topic.BroadcastDirection.NONE);

        private VgoUpdateProgressManager(@NotNull Module module, @NotNull Disposable parentDisposable) {
            if (module == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(1);
            }
            this.myProgressIndicators = new ConcurrentHashMap<String, ProgressIndicatorEx>();
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            this.myModule = module;
        }

        @NotNull
        ProgressIndicatorEx startUpdate(@NotNull String taskKey) {
            if (taskKey == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(2);
            }
            if (this.myModule.isDisposed() || this.myModule.getProject().isDisposed()) {
                return new ProgressIndicatorBase();
            }
            ProgressIndicatorEx progressIndicatorEx = this.myProgressIndicators.compute(taskKey, (__, alreadyRunProcess) -> {
                if (alreadyRunProcess != null) {
                    LOG.debug("alreadyRunProcess != null");
                    alreadyRunProcess.cancel();
                    ((VgoModuleUpdateProgressListener)this.myModule.getProject().getMessageBus().syncPublisher(UPDATE_PROGRESS_TOPIC)).afterRefresh(this.myModule, ExternalSystemRefreshStatus.CANCEL);
                }
                ((VgoModuleUpdateProgressListener)this.myModule.getProject().getMessageBus().syncPublisher(UPDATE_PROGRESS_TOPIC)).beforeRefresh(this.myModule);
                return new ProgressIndicatorBase();
            });
            if (progressIndicatorEx == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(3);
            }
            return progressIndicatorEx;
        }

        void finishUpdate(@NotNull String taskKey, @NotNull ProgressIndicatorEx indicator, @NotNull ExternalSystemRefreshStatus status) {
            if (taskKey == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(5);
            }
            if (status == null) {
                VgoUpdateProgressManager.$$$reportNull$$$0(6);
            }
            if (this.myModule.isDisposed() || this.myModule.getProject().isDisposed()) {
                return;
            }
            this.myProgressIndicators.compute(taskKey, (__, existingIndicator) -> {
                if (existingIndicator != indicator) {
                    return existingIndicator;
                }
                if (status != ExternalSystemRefreshStatus.SUCCESS) {
                    LOG.debug("finishUpdate status is ", new Object[]{status});
                }
                if (status != ExternalSystemRefreshStatus.CANCEL) {
                    ((VgoModuleUpdateProgressListener)this.myModule.getProject().getMessageBus().syncPublisher(UPDATE_PROGRESS_TOPIC)).afterRefresh(this.myModule, status);
                } else if (!indicator.isCanceled()) {
                    LOG.debug("Cancellation happened for some external reason");
                    indicator.cancel();
                    ((VgoModuleUpdateProgressListener)this.myModule.getProject().getMessageBus().syncPublisher(UPDATE_PROGRESS_TOPIC)).afterRefresh(this.myModule, ExternalSystemRefreshStatus.CANCEL);
                }
                return null;
            });
        }

        public void dispose() {
            this.myProgressIndicators.values().forEach(ProgressIndicator::cancel);
            this.myProgressIndicators.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/vgo/VgoStatusTracker$VgoUpdateProgressManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/vgo/VgoStatusTracker$VgoUpdateProgressManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "startUpdate";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "finishUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        static interface VgoModuleUpdateProgressListener {
            public void beforeRefresh(@NotNull Module var1);

            public void afterRefresh(@NotNull Module var1, @NotNull ExternalSystemRefreshStatus var2);
        }
    }

    private class VgoChangeDetector
    extends PsiTreeChangeAdapter
    implements AsyncFileListener {
        private final ModuleRootManager myModuleRootManager;
        private final FileDocumentManager myFileDocumentManager;
        private final MergingUpdateQueue mySaveDocumentQueue;

        VgoChangeDetector() {
            this.myModuleRootManager = ModuleRootManager.getInstance((Module)VgoStatusTracker.this.myModule);
            this.myFileDocumentManager = FileDocumentManager.getInstance();
            this.mySaveDocumentQueue = new MergingUpdateQueue("Save files to disk", 2000, true, null, (Disposable)VgoStatusTracker.this, null, Alarm.ThreadToUse.SWING_THREAD).setRestartTimerOnAdd(true);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                VgoChangeDetector.$$$reportNull$$$0(0);
            }
            this.handlePsiEvent(event.getFile());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                VgoChangeDetector.$$$reportNull$$$0(1);
            }
            this.handlePsiEvent(event.getFile());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                VgoChangeDetector.$$$reportNull$$$0(2);
            }
            this.handlePsiEvent(event.getFile());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                VgoChangeDetector.$$$reportNull$$$0(3);
            }
            this.handlePsiEvent(event.getFile());
        }

        private void handlePsiEvent(PsiFile element) {
            if (!(element instanceof VgoFile)) {
                return;
            }
            VirtualFile file = element.getVirtualFile();
            if (file == null || file instanceof LightVirtualFile) {
                return;
            }
            Document document = this.myFileDocumentManager.getDocument(file);
            if (document == null || !this.isFromMyModule(file) || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.mySaveDocumentQueue.queue(Update.create((Object)file.getPath(), () -> this.myFileDocumentManager.saveDocument(document)));
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                VgoChangeDetector.$$$reportNull$$$0(4);
            }
            if (VgoStatusTracker.this.myModule.isDisposed()) {
                return null;
            }
            if (ContainerUtil.or(events, this::affectsMyModule)) {
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        if (!VgoStatusTracker.this.myModule.isDisposed()) {
                            VgoStatusTracker.this.scheduleUpdatingDependenciesOfAllModules();
                        }
                    }
                };
            }
            final Set modifiedGoModFiles = ContainerUtil.map2SetNotNull(events, event -> {
                ProgressManager.checkCanceled();
                return this.isGoModContentChange((VFileEvent)event) ? event.getFile() : null;
            });
            if (!modifiedGoModFiles.isEmpty()) {
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        if (!VgoStatusTracker.this.myModule.isDisposed()) {
                            VgoStatusTracker.this.scheduleUpdatingDependencies(modifiedGoModFiles);
                        }
                    }
                };
            }
            return null;
        }

        private boolean affectsMyModule(@NotNull VFileEvent event) {
            if (event == null) {
                VgoChangeDetector.$$$reportNull$$$0(5);
            }
            return event instanceof VFileDeleteEvent && this.isFromMyModule(((VFileDeleteEvent)event).getFile().getParent()) || event instanceof VFileMoveEvent && (this.isFromMyModule(((VFileMoveEvent)event).getOldParent()) || this.isFromMyModule(((VFileMoveEvent)event).getNewParent())) || event instanceof VFileCopyEvent && this.isFromMyModule(((VFileCopyEvent)event).getNewParent()) || event instanceof VFileCreateEvent && this.isFromMyModule(event.getFile());
        }

        private boolean isFromMyModule(@Nullable VirtualFile virtualFile) {
            return virtualFile != null && this.myModuleRootManager.getFileIndex().isInContent(virtualFile);
        }

        private boolean isGoModContentChange(@NotNull VFileEvent event) {
            if (event == null) {
                VgoChangeDetector.$$$reportNull$$$0(6);
            }
            VirtualFile file = event.getFile();
            return event instanceof VFileContentChangeEvent && VgoUtil.isGoModFile(file) && this.isFromMyModule(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/VgoStatusTracker$VgoChangeDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "affectsMyModule";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isGoModContentChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModuleCacheUpdatesListener
    implements AsyncFileListener {
        private final AtomicBoolean myPaused = new AtomicBoolean(false);

        private ModuleCacheUpdatesListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            Path cacheSubDirectory;
            if (events == null) {
                ModuleCacheUpdatesListener.$$$reportNull$$$0(0);
            }
            if (this.myPaused.get()) {
                LOG.debug("Module cache updates listener is paused");
                return null;
            }
            String moduleCacheRootPath = PathUtil.toSystemIndependentName((String)VgoUtil.getDependenciesRootPath(VgoStatusTracker.this.myModule.getProject(), VgoStatusTracker.this.myModule));
            if (moduleCacheRootPath == null) {
                return null;
            }
            Path moduleCacheRoot = NioFiles.toPath((String)moduleCacheRootPath);
            Path path = cacheSubDirectory = moduleCacheRoot != null ? moduleCacheRoot.resolve("cache") : null;
            if (cacheSubDirectory != null && ContainerUtil.exists(events, event -> {
                ProgressManager.checkCanceled();
                Path path = NioFiles.toPath((String)event.getPath());
                return path != null && path.startsWith(moduleCacheRoot) && !path.startsWith(cacheSubDirectory);
            })) {
                LOG.debug("Module cache update detected: " + String.valueOf(events));
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        if (!VgoStatusTracker.this.myModule.isDisposed()) {
                            VgoStatusTracker.this.scheduleUpdatingDependenciesOfAllModules(false);
                        }
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/goide/vgo/VgoStatusTracker$ModuleCacheUpdatesListener", "prepareChange"));
        }
    }

    static interface MyUpdater
    extends Function<ProgressIndicatorEx, ExternalSystemRefreshStatus> {
    }

    public static final class GoModFileCrcCalculator
    extends AbstractCrcCalculator {
        private static final String INDIRECT_COMMENT = "// indirect";

        public boolean isApplicable(@NotNull ProjectSystemId systemId, @NotNull VirtualFile file) {
            if (systemId == null) {
                GoModFileCrcCalculator.$$$reportNull$$$0(0);
            }
            if (file == null) {
                GoModFileCrcCalculator.$$$reportNull$$$0(1);
            }
            return VGO_MODULES_SYSTEM_ID.equals((Object)systemId) && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)VgoFileType.INSTANCE);
        }

        public boolean isIgnoredToken(@NotNull IElementType tokenType, @NotNull CharSequence tokenText, @NotNull ParserDefinition parserDefinition) {
            if (tokenType == null) {
                GoModFileCrcCalculator.$$$reportNull$$$0(2);
            }
            if (tokenText == null) {
                GoModFileCrcCalculator.$$$reportNull$$$0(3);
            }
            if (parserDefinition == null) {
                GoModFileCrcCalculator.$$$reportNull$$$0(4);
            }
            TokenSet whitespaceTokens = parserDefinition.getWhitespaceTokens();
            TokenSet commentTokens = parserDefinition.getCommentTokens();
            return whitespaceTokens.contains(tokenType) || commentTokens.contains(tokenType) && !INDIRECT_COMMENT.contentEquals(tokenText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "systemId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parserDefinition";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/VgoStatusTracker$GoModFileCrcCalculator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIgnoredToken";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

