/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.inspections;

import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.core.GoProblemsHolderImpl;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.psi.VgoReplaceDirective;
import com.goide.vgo.mod.psi.VgoReplacement;
import com.goide.vgo.mod.psi.VgoVisitor;
import com.goide.vgo.mod.quickfix.VgoAddModuleToWorkspaceFix;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoStandaloneModule;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/goide/vgo/mod/inspections/VgoMigrateFromReplacesToWorkspaceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "unwrappedHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "InspectionTool", "intellij.go.impl"})
public final class VgoMigrateFromReplacesToWorkspaceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder unwrappedHolder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)unwrappedHolder, (String)"unwrappedHolder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        GoProblemsHolderImpl holder = new GoProblemsHolderImpl(unwrappedHolder);
        return new VgoVisitor(holder){
            final /* synthetic */ GoProblemsHolderImpl $holder;
            {
                this.$holder = $holder;
            }

            public void visitFile(PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                super.visitFile(psiFile);
                Module module = GoUtil.module((PsiElement)psiFile);
                if (module == null) {
                    return;
                }
                Module module2 = module;
                PsiDirectory psiDirectory = psiFile.getParent();
                if (psiDirectory == null || (psiDirectory = psiDirectory.getVirtualFile()) == null) {
                    return;
                }
                PsiDirectory vgoModuleDirectory = psiDirectory;
                new InspectionTool(psiFile, this.$holder, module2, (VirtualFile)vgoModuleDirectory).run();
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0002J$\u0010\u001e\u001a\u00020\u00182\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010 \u001a\u00020\tH\u0002J\u001e\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010%\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/goide/vgo/mod/inspections/VgoMigrateFromReplacesToWorkspaceInspection$InspectionTool;", "", "file", "Lcom/intellij/psi/PsiFile;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "module", "Lcom/intellij/openapi/module/Module;", "vgoModuleDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/goide/inspections/core/GoProblemsHolder;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getHolder", "()Lcom/goide/inspections/core/GoProblemsHolder;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getVgoModuleDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "run", "", "calcReplacedPaths", "", "Lcom/intellij/psi/PsiElement;", "contentRoots", "", "registerProblemOnReplaces", "replacedPaths", "commonAncestor", "hasNotReplacedModules", "", "replacedModules", "", "workspaceDir", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nVgoMigrateFromReplacesToWorkspaceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoMigrateFromReplacesToWorkspaceInspection.kt\ncom/goide/vgo/mod/inspections/VgoMigrateFromReplacesToWorkspaceInspection$InspectionTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1761#2,3:93\n*S KotlinDebug\n*F\n+ 1 VgoMigrateFromReplacesToWorkspaceInspection.kt\ncom/goide/vgo/mod/inspections/VgoMigrateFromReplacesToWorkspaceInspection$InspectionTool\n*L\n88#1:93,3\n*E\n"})
    private static final class InspectionTool {
        @NotNull
        private final PsiFile file;
        @NotNull
        private final GoProblemsHolder holder;
        @NotNull
        private final Module module;
        @NotNull
        private final VirtualFile vgoModuleDirectory;
        @NotNull
        private final Project project;

        public InspectionTool(@NotNull PsiFile file, @NotNull GoProblemsHolder holder, @NotNull Module module, @NotNull VirtualFile vgoModuleDirectory) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)vgoModuleDirectory, (String)"vgoModuleDirectory");
            this.file = file;
            this.holder = holder;
            this.module = module;
            this.vgoModuleDirectory = vgoModuleDirectory;
            Project project = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.project = project;
        }

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        @NotNull
        public final GoProblemsHolder getHolder() {
            return this.holder;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final VirtualFile getVgoModuleDirectory() {
            return this.vgoModuleDirectory;
        }

        public final void run() {
            if (!GoSdkService.getInstance(this.project).getSdk(this.module).supportsWorkspaceMode()) {
                return;
            }
            if (VgoModulesRegistry.getInstance(this.project).findVgoModule(this.module, this.vgoModuleDirectory) == null) {
                return;
            }
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)this.project).getContentRoots();
            Set contentRoots = SetsKt.setOf((Object[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            Map<PsiElement, VirtualFile> map = this.calcReplacedPaths(contentRoots);
            if (map == null) {
                return;
            }
            Map<PsiElement, VirtualFile> replacedPaths = map;
            VirtualFile commonAncestor = VfsUtil.getCommonAncestor((Collection)CollectionsKt.plus(replacedPaths.values(), (Object)this.vgoModuleDirectory));
            if (commonAncestor == null || !VfsUtilCore.isUnder((VirtualFile)commonAncestor, (Set)contentRoots)) {
                return;
            }
            this.registerProblemOnReplaces(replacedPaths, commonAncestor);
        }

        private final Map<PsiElement, VirtualFile> calcReplacedPaths(Set<? extends VirtualFile> contentRoots) {
            VgoReplaceDirective[] vgoReplaceDirectiveArray = (VgoReplaceDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)this.file), VgoReplaceDirective.class);
            if (vgoReplaceDirectiveArray == null) {
                return null;
            }
            VgoReplaceDirective[] replaces = vgoReplaceDirectiveArray;
            VgoModulesRegistry modulesRegistry = VgoModulesRegistry.getInstance(this.project);
            Map replacedPaths = new LinkedHashMap();
            for (VgoReplaceDirective replaceDirective : replaces) {
                for (VgoReplacement replacement : replaceDirective.getReplacementList()) {
                    VirtualFile relativeFile;
                    Object replacePath;
                    Object object = replacement.getTarget();
                    if (object == null || (object = object.getIdentifier()) == null) continue;
                    if ((object = object.getText()) == null || !StringsKt.startsWith$default((String)(replacePath = object), (String)".", (boolean)false, (int)2, null) || VfsUtilCore.findRelativeFile((String)replacePath, (VirtualFile)this.vgoModuleDirectory) == null || !VfsUtilCore.isUnder((VirtualFile)relativeFile, contentRoots) || modulesRegistry.findVgoModuleByRoot(this.module, relativeFile) instanceof VgoWorkspaceModule) continue;
                    PsiElement problemElement = replaceDirective.getReplacementList().size() == 1 ? (PsiElement)replaceDirective : (PsiElement)replacement;
                    replacedPaths.put(problemElement, relativeFile);
                }
            }
            return replacedPaths;
        }

        private final void registerProblemOnReplaces(Map<PsiElement, ? extends VirtualFile> replacedPaths, VirtualFile commonAncestor) {
            ProblemHighlightType highlightType;
            boolean hasNotReplaced = this.hasNotReplacedModules(CollectionsKt.plus(replacedPaths.values(), (Object)this.vgoModuleDirectory), commonAncestor);
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.go.inspection.problem.replace.can.be.migrated");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            ProblemHighlightType problemHighlightType = highlightType = hasNotReplaced ? ProblemHighlightType.INFORMATION : ProblemHighlightType.WEAK_WARNING;
            if (highlightType == ProblemHighlightType.INFORMATION && !this.holder.isOnTheFly()) {
                return;
            }
            List mainModule = CollectionsKt.listOf((Object)this.vgoModuleDirectory);
            VgoAddModuleToWorkspaceFix fixAll = new VgoAddModuleToWorkspaceFix(this.module, commonAncestor, replacedPaths.values(), mainModule);
            for (Map.Entry<PsiElement, ? extends VirtualFile> entry : replacedPaths.entrySet()) {
                PsiElement element = entry.getKey();
                VirtualFile moduleRoot = entry.getValue();
                VgoAddModuleToWorkspaceFix fixSingle = new VgoAddModuleToWorkspaceFix(this.module, commonAncestor, CollectionsKt.listOf((Object)moduleRoot), mainModule);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fixAll, fixSingle};
                this.holder.registerProblem(element, (GoInspectionMessage)message, highlightType, localQuickFixArray);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasNotReplacedModules(Collection<? extends VirtualFile> replacedModules, VirtualFile workspaceDir) {
            boolean bl;
            block3: {
                void $this$any$iv;
                Set replacedModulesSet = CollectionsKt.toSet((Iterable)replacedModules);
                Collection<VgoModule> collection = VgoModulesRegistry.getInstance(this.project).getModules(this.module);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getModules(...)");
                Iterable iterable = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VgoModule it = (VgoModule)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof VgoStandaloneModule && VfsUtilCore.isAncestor((VirtualFile)workspaceDir, (VirtualFile)((VgoStandaloneModule)it).getRoot(), (boolean)false) && !replacedModulesSet.contains(((VgoStandaloneModule)it).getRoot()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

